/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.adapter.user.IHussarBaseUserBoAdapter;
import com.jxdinfo.hussar.authorization.organ.dto.SearchOrganUserDto;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.dto.QueryUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.SearchUserDto;
import com.jxdinfo.hussar.authorization.permit.manager.QueryUserManager;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.permit.vo.OrganUserTreeVo;
import com.jxdinfo.hussar.authorization.permit.vo.SearchUserTreeVo;
import com.jxdinfo.hussar.authorization.permit.vo.SearchUserVo;
import com.jxdinfo.hussar.authorization.permit.vo.UserStaffVo;
import com.jxdinfo.hussar.authorization.permit.vo.UserVo;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserService;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.authorization.permit.service.impl.hussarBaseUserBoServiceImpl")
public class HussarBaseUserBoServiceImpl
implements IHussarBaseUserBoService {
    @Resource
    private QueryUserManager queryUserManager;
    @Resource
    private IHussarBaseUserBoAdapter hussarBaseUserBoAdapter;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private ISysUserRoleService sysUserRoleService;
    @Resource
    private ISysStruUserService sysStruUserService;
    @Resource
    private ISysStruService sysStruService;

    public List<UserVo> getUsersByOrganUser(List<Long> organIds, List<Long> userIds) {
        return this.queryUserManager.getUsersByOrganUser(organIds, userIds);
    }

    public List<OrganUserTreeVo> lazyOrganUserTree(List<Long> parentOrganIds, Boolean needParentOrganInfo, Integer resultType) {
        return this.queryUserManager.lazyOrganUserTree(parentOrganIds, needParentOrganInfo, resultType);
    }

    public Page<SearchUserTreeVo> searchUser(PageInfo pageInfo, SearchOrganUserDto searchOrganUserDto) {
        return this.queryUserManager.searchUser(pageInfo, searchOrganUserDto);
    }

    public UserStaffVo getUserAndStaffInfo(Long userId) {
        return this.sysUsersService.getUserAndStaffInfo(userId);
    }

    public Page<SearchUserVo> searchUsers(PageInfo pageInfo, QueryUserDto queryUserDto) {
        return this.queryUserManager.searchUsers(pageInfo, queryUserDto);
    }

    public Map<Long, SysUsers> getUserInfo(List<Long> userIds) {
        return this.hussarBaseUserBoAdapter.getUserInfo(userIds);
    }

    public List<String> getUserIdsByUserIdsAndRolePermission(List<Long> userIds, String rolePermission) {
        return this.hussarBaseUserBoAdapter.getUserIdsByUserIdsAndRolePermission(userIds, rolePermission);
    }

    public List<SysStruUser> getStruUserByStruIds(List<Long> struIds) {
        return this.hussarBaseUserBoAdapter.getStruUserByStruIds(struIds);
    }

    public Page<SearchUserVo> getUserList(PageInfo pageInfo, String userName, String userAccount) {
        return this.queryUserManager.getUserList(pageInfo, userName, userAccount);
    }

    public List<UserVo> getUserInfoByRoleId(List<Long> roleIds) {
        return this.hussarBaseUserBoAdapter.getUserInfoByRoleId(roleIds);
    }

    public List<UserVo> getUsersByPostIds(List<Long> postIds) {
        return this.hussarBaseUserBoAdapter.getUsersByPostIds(postIds);
    }

    public List<OrganUserTreeVo> organUserSearch(String name) {
        return this.hussarBaseUserBoAdapter.organUserSearch(name);
    }

    public List<SysUsers> list() {
        return this.hussarBaseUserBoAdapter.list();
    }

    @HussarDs(value="#connName")
    public SysUsers getUserById(Long userId, String connName) {
        return this.sysUsersService.getById(userId);
    }

    public List<UserVo> getUsersByOrganUserRole(SearchUserDto searchUserDto) {
        return this.queryUserManager.getUsersByOrganUserRole(searchUserDto);
    }

    public List<Long> getUserIdsForSort(List<Long> userIds, String sortSign) {
        return this.queryUserManager.getUserIdsForSort(userIds, sortSign);
    }

    public List<UserStaffVo> getUserAndStaffList(List<Long> userIds) {
        return this.queryUserManager.getUserAndStaffList(userIds);
    }

    public SysUsers getUser(Long userId) {
        return this.sysUsersService.getUser(userId);
    }

    public SysUsers getOneByEmployeeId(Long employeeId) {
        LambdaQueryWrapper sysUsersLambdaQueryWrapper = new LambdaQueryWrapper();
        sysUsersLambdaQueryWrapper.eq(SysUsers::getEmployeeId, (Object)employeeId);
        return (SysUsers)this.sysUsersService.getOne((Wrapper)sysUsersLambdaQueryWrapper);
    }

    public SysUsers getOneByUserAccount(String userAccount) {
        LambdaQueryWrapper sysUsersLambdaQueryWrapper = new LambdaQueryWrapper();
        sysUsersLambdaQueryWrapper.eq(SysUsers::getUserAccount, (Object)userAccount);
        return (SysUsers)this.sysUsersService.getOne((Wrapper)sysUsersLambdaQueryWrapper);
    }

    public List<SysUsers> listByIds(List<Long> ids) {
        LambdaQueryWrapper sysUsersLambdaQueryWrapper = new LambdaQueryWrapper();
        sysUsersLambdaQueryWrapper.in(SysUsers::getId, ids);
        return this.sysUsersService.list((Wrapper)sysUsersLambdaQueryWrapper);
    }

    public void removeByGrantedRoleIdAndUserId(Long grantedRole, Long userId) {
        LambdaQueryWrapper sysUserRoleLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)sysUserRoleLambdaQueryWrapper.eq(SysUserRole::getGrantedRole, (Object)grantedRole)).eq(SysUserRole::getUserId, (Object)userId);
        this.sysUserRoleService.remove((Wrapper)sysUserRoleLambdaQueryWrapper);
    }

    public List<SysUserRole> listUserRolesByUserId(Long userId) {
        LambdaQueryWrapper sysUserRoleLambdaQueryWrapper = new LambdaQueryWrapper();
        sysUserRoleLambdaQueryWrapper.eq(SysUserRole::getUserId, (Object)userId);
        return this.sysUserRoleService.list((Wrapper)sysUserRoleLambdaQueryWrapper);
    }

    public List<SysUserRole> listUserRolesByIds(List<Long> grantedRoles) {
        LambdaQueryWrapper sysUserRoleLambdaQueryWrapper = new LambdaQueryWrapper();
        sysUserRoleLambdaQueryWrapper.in(SysUserRole::getGrantedRole, grantedRoles);
        return this.sysUserRoleService.list((Wrapper)sysUserRoleLambdaQueryWrapper);
    }

    public List<SysStruUser> listStruUserByStruId(List<Long> struIds) {
        LambdaQueryWrapper sysStruUserLambdaQueryWrapper = new LambdaQueryWrapper();
        sysStruUserLambdaQueryWrapper.in(SysStruUser::getStruId, struIds);
        return this.sysStruUserService.list((Wrapper)sysStruUserLambdaQueryWrapper);
    }

    public SysStru getSysStruById(Long id) {
        return (SysStru)this.sysStruService.getById((Serializable)id);
    }

    public List<SysUsers> getUsersByEmployeeIds(List<Long> employeeIds) {
        LambdaQueryWrapper sysUsersLambdaQueryWrapper = new LambdaQueryWrapper();
        sysUsersLambdaQueryWrapper.in(SysUsers::getEmployeeId, employeeIds);
        return this.sysUsersService.list((Wrapper)sysUsersLambdaQueryWrapper);
    }
}

