/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.manager.AddResourceManager;
import com.jxdinfo.hussar.authorization.organ.manager.EditResourceManager;
import com.jxdinfo.hussar.authorization.permit.dto.UpdateResourceDto;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseResourceService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.authorization.permit.service.impl.hussarBaseResourceServiceImpl")
public class HussarBaseResourceServiceImpl
implements IHussarBaseResourceService {
    @Resource
    private ISysResourcesService sysResourcesService;
    @Autowired
    private AddResourceManager addResourceManager;
    @Autowired
    private EditResourceManager editResourceManager;

    public ApiResponse<Boolean> saveResource(SysResources sysResources) {
        if (ToolUtil.isEmpty((Object)sysResources)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ORGAN_RESOURCE_INFO_NOT_NULL.getMessage()));
        }
        if (ToolUtil.isEmpty((Object)sysResources.getId())) {
            this.addResourceManager.addResource(sysResources);
        } else {
            this.editResourceManager.editResource(sysResources);
        }
        return ApiResponse.success((Object)true);
    }

    public Boolean saveBatchResource(List<SysResources> resourcesList) {
        return this.sysResourcesService.saveBatch(resourcesList);
    }

    public SysResources getResourcesByCode(String code) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysResources::getResourceCode, (Object)code);
        return (SysResources)this.sysResourcesService.getOne((Wrapper)queryWrapper);
    }

    public List<SysResources> getResListLikeCode(String code) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().like(SysResources::getResourceCode, (Object)code);
        return this.sysResourcesService.list((Wrapper)queryWrapper);
    }

    public List<SysResources> getResourcesByModuleId(Long moduleId) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysResources::getModuleId, (Object)moduleId);
        return this.sysResourcesService.list((Wrapper)queryWrapper);
    }

    public Boolean updateNameAliasByCode(UpdateResourceDto updateResourceDto) {
        LambdaUpdateWrapper resUpdateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)resUpdateWrapper.eq(SysResources::getResourceCode, (Object)("menu_" + updateResourceDto.getCode()))).set(SysResources::getResourceName, (Object)updateResourceDto.getName())).set(SysResources::getResourceAlias, (Object)updateResourceDto.getAlias())).set(SysResources::getNameLangKey, (Object)updateResourceDto.getLangKey())).set(SysResources::getAliasLangKey, (Object)updateResourceDto.getLangKey());
        return this.sysResourcesService.update((Wrapper)resUpdateWrapper);
    }

    public Boolean updateNameAliasById(Long id, String name, String alias) {
        LambdaUpdateWrapper resUpdateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)resUpdateWrapper.set(SysResources::getResourceName, (Object)alias)).set(SysResources::getResourceAlias, (Object)name)).eq(SysResources::getId, (Object)id);
        return this.sysResourcesService.update((Wrapper)resUpdateWrapper);
    }

    public Boolean deleteOneResourcesById(Long id) {
        return this.sysResourcesService.removeById((Serializable)id);
    }

    public Boolean deleteResourcesByIds(List<Long> ids) {
        return this.sysResourcesService.removeByIds(ids);
    }

    public Boolean saveOneResource(SysResources sysResources) {
        return this.sysResourcesService.save((Object)sysResources);
    }
}

