/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.manager.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.permit.constants.PermitConstants;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleStruRightsMapper;
import com.jxdinfo.hussar.authorization.permit.dto.DataRightsDto;
import com.jxdinfo.hussar.authorization.permit.manager.AddDataRightManager;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleDataRight;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleStruRights;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleDataRightService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleStruRightService;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.ConvertUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.permit.manager.impl.addDataRightManagerImpl")
public class AddDataRightManagerImpl
implements AddDataRightManager {
    @Autowired
    private ISysRoleDataRightService roleDataRightService;
    @Autowired
    private SysRoleStruRightsMapper sysRoleStruRightsMapper;
    @Autowired
    private ISysRoleStruRightService sysRoleStruRightService;

    @Override
    public boolean saveOrUpdateDataRight(List<DataRightsDto> dataRightsDtoList) {
        ArrayList<SysRoleDataRight> roleDataRightSaveList = new ArrayList<SysRoleDataRight>();
        ArrayList<SysRoleStruRights> roleStruRightsList = new ArrayList<SysRoleStruRights>();
        for (DataRightsDto item2 : dataRightsDtoList) {
            SysRoleDataRight roleDataRight = item2.getDataRightInfo();
            Map dynamicParameterValue = item2.getDynamicParameterValue();
            if (HussarUtils.isEmpty((Object)roleDataRight.getDataRightsId())) {
                roleDataRight.setDataRightsId(Long.valueOf(IdWorker.getId((Object)new SysRoleDataRight())));
            }
            if (!HussarUtils.equals((Object)"res_rights", (Object)roleDataRight.getResTypeCode())) {
                roleDataRight.setDataScope(PermitConstants.DATA_SCOPE_EXTEND);
                if (HussarUtils.isNotEmpty((Object)dynamicParameterValue)) {
                    roleDataRight.setCustomDataCondition(JSON.toJSONString((Object)dynamicParameterValue));
                }
            } else {
                if (Integer.parseInt("5") == roleDataRight.getDataScope()) {
                    Long[] deptIds;
                    String departmentId = item2.getDepartmentId();
                    AssertUtil.isNotEmpty((String)departmentId, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_CUSTOM_DEPARTMENT_VISIBLE_NOT_EMPTY.getMessage()));
                    for (Long deptId : deptIds = (Long[])ConvertUtils.convert((String[])departmentId.split(","), Long.class)) {
                        SysRoleStruRights sysRoleStruRights = new SysRoleStruRights();
                        sysRoleStruRights.setRoleDataRightsId(roleDataRight.getDataRightsId());
                        sysRoleStruRights.setRoleId(roleDataRight.getRoleId());
                        sysRoleStruRights.setStruid(deptId);
                        roleStruRightsList.add(sysRoleStruRights);
                    }
                } else if (Integer.parseInt("6") == roleDataRight.getDataScope()) {
                    roleDataRight.setCustomDataCondition(JSON.toJSONString((Object)dynamicParameterValue));
                }
                roleDataRight.setDataScopeLabel(String.valueOf(roleDataRight.getDataScope()));
            }
            roleDataRightSaveList.add(roleDataRight);
        }
        List dataRightIdList = dataRightsDtoList.stream().map(item -> item.getDataRightInfo().getDataRightsId()).collect(Collectors.toList());
        boolean addDataRightFlag = this.roleDataRightService.saveOrUpdateBatch(roleDataRightSaveList);
        AssertUtil.isTrue((boolean)addDataRightFlag, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FAILED_TO_ADD_DATA.getMessage()));
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysRoleStruRights::getRoleDataRightsId, dataRightIdList);
        this.sysRoleStruRightsMapper.delete((Wrapper)queryWrapper);
        return this.sysRoleStruRightService.saveBatch(roleStruRightsList);
    }
}

