/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruRuleMapper;
import com.jxdinfo.hussar.authorization.organ.dto.SysStruRuleDto;
import com.jxdinfo.hussar.authorization.organ.model.SysOrganType;
import com.jxdinfo.hussar.authorization.organ.model.SysStruRule;
import com.jxdinfo.hussar.authorization.organ.model.SysStruRuleAudit;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganTypeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruRuleAuditService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruRuleService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysAuditConfigService;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.messagepush.AbstractPushMsgMatcher;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysStruRuleServiceImpl
extends HussarServiceImpl<SysStruRuleMapper, SysStruRule>
implements ISysStruRuleService {
    @Resource
    private SysStruRuleMapper sysStruRuleMapper;
    @Resource
    private AbstractPushMsgMatcher abstractPushMsgMatcher;
    @Resource
    private ISysOrganTypeService iSysOrganTypeService;
    @Autowired
    private ISysOrganTypeService sysOrganTypeService;
    @Autowired
    private ISysStruRuleAuditService sysStruRuleAuditService;
    @Autowired
    private ISysAuditConfigService sysAuditConfigService;

    public IPage<SysStruRuleDto> getOrganRuleList(Page<SysStruRuleDto> page, SysStruRuleDto sysStruRuleDto) {
        if (ToolUtil.isEmpty(page)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PAGING_EMPTY.getMessage()));
        }
        page.setRecords(this.sysStruRuleMapper.getOrganRuleList(page, sysStruRuleDto));
        return page;
    }

    @HussarTransactional
    public boolean save(SysStruRule sysStruRule) {
        int result;
        if (ToolUtil.isEmpty((Object)sysStruRule)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_RULE_EMPTY.getMessage()));
        }
        String parentOrg = sysStruRule.getSysOrganType();
        String sonOrg = sysStruRule.getOrganType();
        HashMap<String, String> map = new HashMap<String, String>(3);
        map.put("parentOrg", parentOrg);
        map.put("sonOrg", sonOrg);
        List<Map<String, Object>> list = this.getRuleExist(map);
        if (list.size() > 0) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ORGAN_ADD_FAIL_THIS_ORGANIZATION_RULES_EXIST.getMessage()));
        }
        List allType = this.iSysOrganTypeService.list();
        SysOrganType parentSysOrganType = this.iSysOrganTypeService.getSysOrganTypeByTypeCode(parentOrg);
        String pType = "";
        if (parentSysOrganType != null) {
            pType = parentSysOrganType.getOrganType();
        }
        String sType = "";
        SysOrganType sonSysOrganType = this.iSysOrganTypeService.getSysOrganTypeByTypeCode(sonOrg);
        if (sonSysOrganType != null) {
            sType = sonSysOrganType.getOrganType();
        }
        ArrayList<String> resultType = new ArrayList<String>();
        this.recursive(allType, resultType, pType);
        resultType.add(parentOrg);
        if (!resultType.contains(sonOrg)) {
            ArrayList<String> newResultType = new ArrayList<String>();
            this.recursive(allType, newResultType, sType);
            newResultType.add(sonOrg);
            if (newResultType.contains(parentOrg)) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ADD_FAIL_RELATIONSHIP_WRONG.getMessage()));
            }
        }
        if ((result = this.sysStruRuleMapper.insert(sysStruRule)) != 1) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL.getMessage()));
        }
        this.abstractPushMsgMatcher.insertOperation("sysStruRule", "add", (Object)sysStruRule, Constants.NONE_ID);
        return true;
    }

    @HussarTransactional
    public boolean update(SysStruRule sysStruRule) {
        if (ToolUtil.isEmpty((Object)sysStruRule)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_RULE_EMPTY.getMessage()));
        }
        int result = this.sysStruRuleMapper.updateById(sysStruRule);
        if (result != 1) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_FAIL.getMessage()));
        }
        this.abstractPushMsgMatcher.insertOperation("sysStruRule", "update", (Object)sysStruRule, Constants.NONE_ID);
        return true;
    }

    @HussarTransactional
    public boolean delete(String eId) {
        if (ToolUtil.isEmpty((Object)eId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_ID_DEL_RULE_EMPTY.getMessage()));
        }
        String[] ids = eId.split(",");
        ArrayList<String> idList = new ArrayList<String>();
        for (String id : ids) {
            if (this.isInUse(id)) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ORGAN_DELETE_FAIL_EXIST_ORGANIZATION_USING.getMessage()));
            }
            idList.add(id);
        }
        List<Long> cdids = idList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        List sysStruRuleList = ((LambdaQueryChainWrapper)this.lambdaQuery().in(SysStruRule::getId, cdids)).list();
        if (this.sysAuditConfigService.isCriticalOperationsAudit() && this.sysAuditConfigService.isOrganRoleAudit()) {
            this.checkSysStruRuleAuditDataExists("3", cdids);
            this.saveSysStruRuleAudit(sysStruRuleList, "3");
            return true;
        }
        int result = this.sysStruRuleMapper.deleteBatchIds(cdids);
        if (result < 1) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PAGING_EMPTY.getMessage()));
        }
        JSONObject ruleIds = new JSONObject();
        ruleIds.put("idList", idList);
        this.abstractPushMsgMatcher.insertOperation("sysStruRule", "delete", (Object)ruleIds, Constants.NONE_ID);
        return true;
    }

    public List<Map<String, Object>> getRuleExist(Map map) {
        return this.sysStruRuleMapper.getRuleExist(map.get("parentOrg").toString(), map.get("sonOrg").toString());
    }

    public List<String> getBanDelRule() {
        return this.sysStruRuleMapper.getBanDelRule();
    }

    public boolean isInUse(String ruleId) {
        boolean isExist = false;
        List<String> list = this.sysStruRuleMapper.getInUseRule(Long.parseLong(ruleId));
        if (ToolUtil.isNotEmpty(list)) {
            isExist = true;
        }
        return isExist;
    }

    public List<Map<String, Object>> getOrganByTypes(String[] organTypes) {
        return this.sysStruRuleMapper.getOrganByTypes(organTypes);
    }

    public List<String> getAllowStaffOrganType() {
        List<Map<String, Object>> allowStaffList = this.sysStruRuleMapper.getAllowStaff();
        ArrayList<String> list = new ArrayList<String>();
        for (Map<String, Object> map : allowStaffList) {
            list.add(String.valueOf(map.get("sysorgantype")));
        }
        return list;
    }

    public boolean judgeRelationshipOfType(String organTypeCode, String sysOrganTypeCode) {
        String parentTypeCode;
        boolean flag = false;
        QueryWrapper sysOrganTypeQueryWrapper = new QueryWrapper();
        sysOrganTypeQueryWrapper.lambda().eq(SysOrganType::getOrganType, (Object)sysOrganTypeCode);
        List sysOrganTypeList = this.sysOrganTypeService.list((Wrapper)sysOrganTypeQueryWrapper);
        if (ToolUtil.isNotEmpty((Object)sysOrganTypeList) && organTypeCode.equals(parentTypeCode = ((SysOrganType)sysOrganTypeList.get(0)).getParentType())) {
            flag = true;
        }
        return flag;
    }

    public boolean judgeRelationshipOfTypeCascade(String organTypeCode, String sysOrganTypeCode) {
        boolean flag = true;
        boolean flags = true;
        String parentTypeCode = sysOrganTypeCode;
        List sysOrganTypeList = this.sysOrganTypeService.list();
        if (organTypeCode.equals(sysOrganTypeCode)) {
            flags = false;
        }
        while (flags) {
            String finalParentTypeCode = parentTypeCode;
            List sysOrganTypes = sysOrganTypeList.stream().filter(o -> finalParentTypeCode.equals(String.valueOf(o.getOrganType()))).collect(Collectors.toList());
            if (ToolUtil.isNotEmpty(sysOrganTypes)) {
                parentTypeCode = ((SysOrganType)sysOrganTypes.get(0)).getParentType();
                if (!organTypeCode.equals(parentTypeCode)) continue;
                flag = false;
                flags = false;
                continue;
            }
            flags = false;
        }
        return flag;
    }

    private void recursive(List<SysOrganType> allType, List<String> resultType, String pType) {
        for (int i = 0; i < allType.size(); ++i) {
            SysOrganType iType = allType.get(i);
            if (!pType.equals(iType.getParentType())) continue;
            allType.remove(iType);
            --i;
            resultType.add(iType.getOrganType());
            String newpType = iType.getOrganType();
            this.recursive(allType, resultType, newpType);
        }
    }

    public void checkStruRuleInfo(Object object, String type) {
        ArrayList<String> messageList = new ArrayList<String>();
        switch (type) {
            case "add": 
            case "edit": {
                SysStruRule sysStruRule = (SysStruRule)JSONObject.parseObject((String)JSON.toJSONString((Object)object), SysStruRule.class);
                if (ToolUtil.isEmpty((Object)sysStruRule)) {
                    messageList.add(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_RULE_EMPTY.getMessage()));
                }
                if (ToolUtil.isEmpty((Object)sysStruRule.getOrganType())) {
                    messageList.add(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_TYPE_CODE_EMPTY.getMessage()));
                }
                if (ToolUtil.isEmpty((Object)sysStruRule.getSysOrganType())) {
                    messageList.add(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_PARENT_ORGAN_CODE_NOT_FILLED.getMessage()));
                }
                if (sysStruRule.getRuleNote().trim().length() > 100) {
                    messageList.add(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_ENTER_MAXIMUM_OF_100_CHARACTERS_FOR_RULE_DESCRIPTION.getMessage()));
                }
                if (!"edit".equals(type) || !ToolUtil.isEmpty((Object)sysStruRule.getId())) break;
                messageList.add(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_RULE_DEFINITION_ID_NOT_SPECIFIED.getMessage()));
                break;
            }
        }
        if (ToolUtil.isNotEmpty(messageList)) {
            String allMessage = StringUtils.join((Object[])messageList.toArray(), (String)",");
            throw new BaseException(allMessage);
        }
    }

    @HussarDs(value="#connName")
    public void updateById(String connName, SysStruRule sysStruRule) {
        this.updateById((BaseEntity)sysStruRule);
    }

    @HussarDs(value="#connName")
    public void saveOrUpdate(String connName, SysStruRule sysStruRule) {
        this.saveOrUpdate((BaseEntity)sysStruRule);
    }

    @HussarDs(value="#connName")
    public void removeById(String connName, SysStruRule sysStruRule) {
        this.removeById((BaseEntity)sysStruRule);
    }

    @HussarDs(value="#connName")
    public boolean remove(String connName, Wrapper<SysStruRule> wrapper) {
        return super.remove(wrapper);
    }

    @HussarDs(value="#connName")
    public boolean saveBatch(String connName, List<SysStruRule> entityList) {
        return super.saveBatch(entityList);
    }

    public String saveSysStruRuleAudit(List<SysStruRule> sysStruRuleList, String operateType) {
        LocalDateTime now = LocalDateTime.now();
        ArrayList<SysStruRuleAudit> sysStruRuleAuditList = new ArrayList<SysStruRuleAudit>();
        for (SysStruRule sysStruRule : sysStruRuleList) {
            SysStruRuleAudit sysStruRuleAudit = new SysStruRuleAudit();
            sysStruRuleAudit.setRuleId(sysStruRule.getId());
            sysStruRuleAudit.setAuditStatus("0");
            sysStruRuleAudit.setOperateType(operateType);
            sysStruRuleAudit.setOrganType(sysStruRule.getOrganType());
            sysStruRuleAudit.setStruType(sysStruRule.getStruType());
            sysStruRuleAudit.setSysOrganType(sysStruRule.getSysOrganType());
            sysStruRuleAudit.setRuleNote(sysStruRule.getRuleNote());
            sysStruRuleAudit.setCreator(BaseSecurityUtil.getUser().getId());
            sysStruRuleAudit.setCreateTime(now);
            sysStruRuleAudit.setLastEditor(BaseSecurityUtil.getUser().getId());
            sysStruRuleAudit.setLastTime(now);
            sysStruRuleAuditList.add(sysStruRuleAudit);
        }
        this.sysStruRuleAuditService.saveBatch(sysStruRuleAuditList);
        switch (operateType) {
            case "1": {
                return TranslateUtil.getTranslateName((String)TipConstantsEnum.ADD_SUCCESS_WAIT_REVIEW.getMessage());
            }
            case "2": {
                return TranslateUtil.getTranslateName((String)TipConstantsEnum.UPDATE_SUCCESS_WAIT_REVIEW.getMessage());
            }
        }
        return TranslateUtil.getTranslateName((String)TipConstantsEnum.DELETE_SUCCESS_WAIT_REVIEW.getMessage());
    }

    public void checkSysStruRuleAuditDataExists(String operateType, List<Long> sysStruRuleIds) {
        String errorMsg;
        List sysStruRuleAuditList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sysStruRuleAuditService.lambdaQuery().in(SysStruRuleAudit::getRuleId, sysStruRuleIds)).eq(SysStruRuleAudit::getAuditStatus, (Object)"0")).list();
        switch (operateType) {
            case "2": {
                errorMsg = TranslateUtil.getTranslateName((String)TipConstantsEnum.UPDATE_FAIL_EXIST_REVIEW.getMessage());
                break;
            }
            default: {
                errorMsg = TranslateUtil.getTranslateName((String)TipConstantsEnum.DELETE_FAIL_EXIST_REVIEW.getMessage());
            }
        }
        if (HussarUtils.isNotEmpty((Object)sysStruRuleAuditList)) {
            throw new BaseException(errorMsg);
        }
    }
}

