/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.menu.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.menu.dao.SysMenuAuditMapper;
import com.jxdinfo.hussar.authorization.menu.dto.QueryAuditMenuDto;
import com.jxdinfo.hussar.authorization.menu.model.SysMenu;
import com.jxdinfo.hussar.authorization.menu.model.SysMenuAudit;
import com.jxdinfo.hussar.authorization.menu.service.ISysMenuAuditService;
import com.jxdinfo.hussar.authorization.menu.service.ISysMenuManageService;
import com.jxdinfo.hussar.authorization.menu.vo.AuditMenuData;
import com.jxdinfo.hussar.authorization.menu.vo.AuditMenuDetailVo;
import com.jxdinfo.hussar.authorization.menu.vo.AuditMenuListVo;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionModulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsService;
import com.jxdinfo.hussar.common.base.HussarBaseServiceImpl;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class SysMenuAuditServiceImpl
extends HussarBaseServiceImpl<SysMenuAuditMapper, SysMenuAudit>
implements ISysMenuAuditService {
    @Resource
    private ISysFunctionsService sysFunctionsService;
    @Resource
    private ISysFunctionModulesService sysFunctionModulesService;
    @Resource
    private ISysMenuManageService sysMenuManageService;
    @Resource
    private SysMenuAuditMapper sysMenuAuditMapper;
    @Autowired
    protected ISysDicRefService sysDicRefService;

    public String doProcesssysUpdateMenuAudit(SysMenu sysMenu) {
        Long menuId = sysMenu.getId();
        LambdaQueryWrapper sysMenuAuditQr = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)sysMenuAuditQr.eq(SysMenuAudit::getMenuId, (Object)menuId)).eq(SysMenuAudit::getAuditStatus, (Object)"0");
        List list = this.list((Wrapper)sysMenuAuditQr);
        if (HussarUtils.isNotEmpty((Object)list)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MENU_AUDIT_REPEAT.getMessage()));
        }
        SysMenuAudit sysMenuAudit = new SysMenuAudit();
        String menuAlias = sysMenu.getMenuAlias();
        String text = sysMenu.getText();
        if (HussarUtils.isNotEmpty((Object)menuAlias)) {
            sysMenu.setText(menuAlias);
        } else if (HussarUtils.isNotEmpty((Object)text)) {
            sysMenu.setMenuAlias(text);
        }
        BeanUtils.copyProperties((Object)sysMenu, (Object)sysMenuAudit, (String[])new String[]{"id", "delFlag", "createTime", "lastTime", "creator", "lastEditor"});
        sysMenuAudit.setMenuId(menuId);
        sysMenuAudit.setOperateType("2");
        sysMenuAudit.setAuditStatus("0");
        sysMenuAudit.setMenuAlias(sysMenu.getMenuAlias());
        sysMenuAudit.setMenuText(sysMenu.getText());
        sysMenuAudit.setIfDisplay(sysMenu.getIfDisplay());
        this.save((BaseEntity)sysMenuAudit);
        return TranslateUtil.getTranslateName((String)TipConstantsEnum.UPDATE_SUCCESS_WAIT_REVIEW.getMessage());
    }

    public String doProcesssysSaveMenuAudit(SysMenu sysMenu) {
        Long menuId = sysMenu.getId();
        LambdaQueryWrapper sysMenuAuditQr = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)sysMenuAuditQr.eq(SysMenuAudit::getMenuAlias, (Object)sysMenu.getMenuAlias())).eq(SysMenuAudit::getAuditStatus, (Object)"0");
        List list = this.list((Wrapper)sysMenuAuditQr);
        if (HussarUtils.isNotEmpty((Object)list)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MENU_AUDIT_REPEAT.getMessage()));
        }
        SysMenuAudit sysMenuAudit = new SysMenuAudit();
        String menuAlias = sysMenu.getMenuAlias();
        String text = sysMenu.getText();
        if (HussarUtils.isNotEmpty((Object)menuAlias)) {
            sysMenu.setText(menuAlias);
        } else if (HussarUtils.isNotEmpty((Object)text)) {
            sysMenu.setMenuAlias(text);
        }
        BeanUtils.copyProperties((Object)sysMenu, (Object)sysMenuAudit, (String[])new String[]{"id", "delFlag", "createTime", "lastTime", "creator", "lastEditor"});
        sysMenuAudit.setMenuId(menuId);
        sysMenuAudit.setOperateType("1");
        sysMenuAudit.setAuditStatus("0");
        sysMenuAudit.setMenuAlias(sysMenu.getMenuAlias());
        sysMenuAudit.setMenuText(sysMenu.getText());
        sysMenuAudit.setIfDisplay(sysMenu.getIfDisplay());
        sysMenuAudit.setMenuType("1");
        this.save((BaseEntity)sysMenuAudit);
        return TranslateUtil.getTranslateName((String)TipConstantsEnum.ADD_SUCCESS_WAIT_REVIEW.getMessage());
    }

    public AuditMenuDetailVo viewMenuAudit(Long auditId) {
        AuditMenuDetailVo vo = new AuditMenuDetailVo();
        AuditMenuData oldData = vo.getOldData();
        AuditMenuData newData = vo.getNewData();
        SysMenuAudit sysMenuAudit = (SysMenuAudit)this.getById(auditId);
        AssertUtil.isNotNull((Object)sysMenuAudit, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MENU_AUDIT_NOT_FOUND.getMessage()));
        String operateType = sysMenuAudit.getOperateType();
        if ("1".equals(operateType)) {
            HussarUtils.copy((Object)sysMenuAudit, (Object)newData);
            this.initSysMenuAudit(newData);
            vo.setNewData(newData);
        }
        if ("3".equals(operateType)) {
            HussarUtils.copy((Object)sysMenuAudit, (Object)oldData);
            this.initSysMenuAudit(oldData);
            vo.setOldData(oldData);
        }
        if ("2".equals(operateType)) {
            HussarUtils.copy((Object)sysMenuAudit, (Object)newData);
            this.initSysMenuAudit(newData);
            vo.setNewData(newData);
            Long menuId = sysMenuAudit.getMenuId();
            oldData = this.sysMenuAuditMapper.getOldSysMenu(menuId);
            vo.setOldData(oldData);
        }
        return vo;
    }

    public void initSysMenuAudit(AuditMenuData auditMenuData) {
        SysMenu menu;
        SysFunctionModules functionModule;
        SysFunctions function;
        String yesNo;
        Long functionId = auditMenuData.getFunctionId();
        Long functionModuleId = auditMenuData.getFunctionModuleId();
        Long parentId = auditMenuData.getParentId();
        String openMode = auditMenuData.getOpenMode();
        String openType = auditMenuData.getOpenType();
        String menuType = auditMenuData.getMenuType();
        String isLeaf = auditMenuData.getIsLeaf();
        String isSys = auditMenuData.getIsSys();
        String ifDisplay = auditMenuData.getIfDisplay();
        if (HussarUtils.isNotEmpty((Object)auditMenuData.getMenuAlias())) {
            auditMenuData.setMenuText(auditMenuData.getMenuAlias());
        }
        if (HussarUtils.isNotEmpty((Object)openType)) {
            if ("inside".equals(openType)) {
                auditMenuData.setOpenTypeName("\u7cfb\u7edf\u5185\u6253\u5f00");
            } else if ("outside".equals(openType)) {
                auditMenuData.setOpenTypeName("\u7cfb\u7edf\u5916\u6253\u5f00");
            }
        }
        if (HussarUtils.isNotEmpty((Object)openMode)) {
            if ("0".equals(openMode)) {
                auditMenuData.setOpenModeName("\u7cfb\u7edf\u5185\u6253\u5f00");
            } else if ("1".equals(openMode)) {
                auditMenuData.setOpenModeName("\u7cfb\u7edf\u5916\u6253\u5f00");
            }
        }
        if (HussarUtils.isNotEmpty((Object)menuType)) {
            if ("1".equals(menuType)) {
                auditMenuData.setMenuTypeName("\u95e8\u6237\u7aef\u5c55\u793a");
            } else if ("0".equals(menuType)) {
                auditMenuData.setMenuTypeName("console\u7aef\u5c55\u793a");
            }
        }
        if (HussarUtils.isNotEmpty((Object)isLeaf)) {
            yesNo = this.sysDicRefService.getDictLabel("yes_no", isLeaf);
            auditMenuData.setIsLeafName(yesNo);
        }
        if (HussarUtils.isNotEmpty((Object)isSys)) {
            yesNo = this.sysDicRefService.getDictLabel("yes_no", isLeaf);
            auditMenuData.setIsSysName(yesNo);
        }
        if (HussarUtils.isNotEmpty((Object)ifDisplay)) {
            if ("1".equals(ifDisplay)) {
                auditMenuData.setIfDisplayName("\u663e\u793a");
            }
            if ("0".equals(ifDisplay)) {
                auditMenuData.setIfDisplayName("\u4e0d\u663e\u793a");
            }
        }
        if (HussarUtils.isNotEmpty((Object)(function = (SysFunctions)this.sysFunctionsService.getById((Serializable)functionId)))) {
            TranslateUtil.translate((Object)function, SysFunctions::getNameLangKey, SysFunctions::setFunctionName);
            auditMenuData.setFunctionName(function.getFunctionName());
        }
        if (HussarUtils.isNotEmpty((Object)(functionModule = (SysFunctionModules)this.sysFunctionModulesService.getById((Serializable)functionModuleId)))) {
            TranslateUtil.translate((Object)functionModule, SysFunctionModules::getNameLangKey, SysFunctionModules::setFunctionModuleName);
            auditMenuData.setFunctionName(functionModule.getFunctionModuleName());
        }
        if (HussarUtils.isNotEmpty((Object)(menu = (SysMenu)this.sysMenuManageService.getById((Serializable)parentId)))) {
            TranslateUtil.translate((Object)menu, SysMenu::getAliasLangKey, SysMenu::setMenuAlias);
            auditMenuData.setParentName(menu.getMenuAlias());
        }
    }

    public String doProcesssysDelMenuAudit(SysMenu sysMenu) {
        Long menuId = sysMenu.getId();
        LambdaQueryWrapper sysMenuAuditQr = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)sysMenuAuditQr.eq(SysMenuAudit::getMenuId, (Object)menuId)).eq(SysMenuAudit::getAuditStatus, (Object)"0");
        List list = this.list((Wrapper)sysMenuAuditQr);
        if (HussarUtils.isNotEmpty((Object)list)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.DELETE_FAIL_EXIST_REVIEW.getMessage()));
        }
        SysMenuAudit sysMenuAudit = new SysMenuAudit();
        String menuAlias = sysMenu.getMenuAlias();
        String text = sysMenu.getText();
        if (HussarUtils.isNotEmpty((Object)menuAlias)) {
            sysMenu.setText(menuAlias);
        } else if (HussarUtils.isNotEmpty((Object)text)) {
            sysMenu.setMenuAlias(text);
        }
        BeanUtils.copyProperties((Object)sysMenu, (Object)sysMenuAudit, (String[])new String[]{"id", "delFlag", "createTime", "lastTime", "creator", "lastEditor"});
        sysMenuAudit.setMenuId(menuId);
        sysMenuAudit.setOperateType("3");
        sysMenuAudit.setAuditStatus("0");
        sysMenuAudit.setMenuAlias(sysMenu.getMenuAlias());
        sysMenuAudit.setMenuText(sysMenu.getText());
        this.save((BaseEntity)sysMenuAudit);
        return TranslateUtil.getTranslateName((String)TipConstantsEnum.DELETE_SUCCESS_WAIT_REVIEW.getMessage());
    }

    public ApiResponse<Page<AuditMenuListVo>> listMenuAudit(PageInfo pageInfo, QueryAuditMenuDto queryAuditMenuDto) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("menuName", queryAuditMenuDto.getMenuText());
        queryParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        queryParams.put("type", queryAuditMenuDto.getAuditStatus());
        List<AuditMenuListVo> auditMenuListVos = this.sysMenuAuditMapper.listMenuAudit((Page<AuditMenuListVo>)page, queryParams);
        page.setRecords(auditMenuListVos);
        return ApiResponse.success((Object)page);
    }

    @HussarTransactional
    public ApiResponse<String> reject(Long auditId) {
        SysMenuAudit sysMenuAudit = (SysMenuAudit)this.getById(auditId);
        sysMenuAudit.setAuditStatus("2");
        boolean res = this.updateById((BaseEntity)sysMenuAudit);
        AssertUtil.isTrue((boolean)res, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_REJECT_FAIL.getMessage()));
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MENU_AUDIT_REJECT_SUCCESS.getMessage()));
    }

    public ApiResponse<String> approved(Long auditId) {
        SysMenuAudit sysMenuAudit = (SysMenuAudit)this.getById(auditId);
        SysMenu sysMenu = new SysMenu();
        HussarUtils.copy((Object)sysMenuAudit, (Object)sysMenu);
        sysMenu.setId(sysMenuAudit.getMenuId());
        String menuAlias = sysMenuAudit.getMenuAlias();
        String text = sysMenuAudit.getMenuText();
        if (HussarUtils.isNotEmpty((Object)menuAlias)) {
            sysMenu.setText(menuAlias);
        } else if (HussarUtils.isNotEmpty((Object)text)) {
            sysMenu.setMenuAlias(text);
        }
        String operateType = sysMenuAudit.getOperateType();
        String msg = "";
        if ("1".equals(operateType)) {
            this.sysMenuManageService.setPathFromResource(sysMenu);
            Integer max = this.sysMenuManageService.getMaxOrderByParentId(sysMenu.getParentId());
            if (ToolUtil.isNotEmpty((Object)max)) {
                sysMenu.setSeq(Integer.valueOf(max + 1));
            } else {
                sysMenu.setSeq(Integer.valueOf(1));
            }
            sysMenu.setMenuType("1");
            this.sysMenuManageService.menuInterLangText(sysMenu);
            this.sysMenuManageService.save((Object)sysMenu);
            msg = TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MENU_AUDIT_ADD_SUCCESS.getMessage());
            LambdaUpdateWrapper up = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)up.eq(SysMenuAudit::getId, (Object)auditId)).set(SysMenuAudit::getAuditStatus, (Object)"1");
            this.update((Wrapper)up);
        } else if ("3".equals(operateType)) {
            LambdaQueryWrapper sysMenuLambdaQueryWrapper = new LambdaQueryWrapper();
            sysMenuLambdaQueryWrapper.eq(SysMenu::getParentId, (Object)sysMenuAudit.getMenuId());
            List list = this.sysMenuManageService.list((Wrapper)sysMenuLambdaQueryWrapper);
            if (HussarUtils.isNotEmpty((Object)list)) {
                String chileMenu = "";
                for (int i = 0; i < list.size(); ++i) {
                    SysMenu child = (SysMenu)list.get(i);
                    String menualias = child.getMenuAlias();
                    if (!HussarUtils.isNotEmpty((Object)menualias)) continue;
                    chileMenu = chileMenu + menualias + "\uff0c";
                }
                if (HussarUtils.isNotEmpty((Object)chileMenu) && chileMenu.length() > 0) {
                    chileMenu = chileMenu.substring(0, chileMenu.length() - 1);
                }
                msg = TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MENU_AUDIT_HAS_CHILD.getMessage()) + chileMenu;
            } else {
                this.sysMenuManageService.delMenuById(String.valueOf(sysMenuAudit.getMenuId()));
                msg = TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_OPERATE_DEL_SUCCESS.getMessage());
                LambdaUpdateWrapper up = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)up.eq(SysMenuAudit::getId, (Object)auditId)).set(SysMenuAudit::getAuditStatus, (Object)"1");
                this.update((Wrapper)up);
            }
        }
        if ("2".equals(operateType)) {
            if (!"inside".equals(sysMenu.getOpenType())) {
                sysMenu.setOpenMode("1");
            } else {
                sysMenu.setOpenMode("0");
            }
            this.sysMenuManageService.setPathFromResource(sysMenu);
            this.sysMenuManageService.menuInterLangText(sysMenu);
            this.sysMenuManageService.updateById((Object)sysMenu);
            msg = TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MENU_AUDIT_UPDATE_SUCCESS.getMessage());
            LambdaUpdateWrapper up = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)up.eq(SysMenuAudit::getId, (Object)auditId)).set(SysMenuAudit::getAuditStatus, (Object)"1");
            this.update((Wrapper)up);
        }
        return ApiResponse.success((String)msg);
    }
}

