/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.common.constant.factory;

import com.jxdinfo.hussar.authorization.enums.MenuStatus;
import com.jxdinfo.hussar.authorization.menu.dao.SysMenuMapper;
import com.jxdinfo.hussar.authorization.menu.model.SysMenu;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.vo.SysOrganVo;
import com.jxdinfo.hussar.authorization.permit.dao.SysResourcesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRolesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysStruRoleMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserRoleMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.constant.factory.IConstantFactory;
import com.jxdinfo.hussar.common.constant.state.ManagerStatus;
import com.jxdinfo.hussar.common.datasource.service.IDynamicDataSourceService;
import com.jxdinfo.hussar.common.handler.LogObjectHolder;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.config.HussarConfig;
import com.jxdinfo.hussar.core.support.StrKit;
import com.jxdinfo.hussar.core.util.Convert;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;

@Component
public class ConstantFactory
implements IConstantFactory {
    @Resource
    private SysRolesMapper roleMapper;
    @Resource
    private SysStruMapper struMapper;
    @Resource
    private SysUsersMapper userMapper;
    @Resource
    private SysMenuMapper menuMapper;
    @Resource
    private SysUserRoleMapper userRoleMapper;
    @Resource
    private SysRolesMapper RolesMapper;
    @Resource
    private SysResourcesMapper resourcesMapper;
    @Resource
    private SysStruRoleMapper struRoleMapper;
    @Resource
    private HussarConfig hussarConfig;
    @Resource
    private IDynamicDataSourceService dynamicDataSourceService;
    @Resource
    private ISysUserRoleService sysUserRoleService;
    @Resource
    private ISysResourcesService sysResourcesService;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private ISysStruRoleService sysStruRoleService;

    public static IConstantFactory me() {
        return (IConstantFactory)SpringContextHolder.getBean((String)"constantFactory");
    }

    public Map<String, List<String>> getAuthInfo(SecurityUser shiroUser) {
        List permissionList = (List)HussarCacheUtil.get((String)"authorization_info", (Object)("hussar_authInfo:" + shiroUser.getId() + ":" + this.dynamicDataSourceService.currentDsName()));
        if (ToolUtil.isEmpty((Object)permissionList)) {
            List<Long> roleIdList = this.getRolesIdByShiroUser(shiroUser);
            permissionList = this.sysResourcesService.queryPermissionsByRoleIds(roleIdList);
            HussarCacheUtil.put((String)"authorization_info", (Object)("hussar_authInfo:" + shiroUser.getId() + ":" + this.dynamicDataSourceService.currentDsName()), (Object)permissionList);
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("userPermission", permissionList);
        return map;
    }

    public List<Long> getRolesIdByUserId(Long userId) {
        List<Long> rolesList = this.userRoleMapper.getRolesByUserId(userId);
        return rolesList;
    }

    public String getRoleNameByRoleId(String roleId) {
        SysRoles sysRoles = (SysRoles)this.RolesMapper.selectById((Serializable)((Object)roleId));
        if (ToolUtil.isNotEmpty((Object)sysRoles) && ToolUtil.isNotEmpty((Object)sysRoles.getRoleName())) {
            return sysRoles.getRoleName();
        }
        return null;
    }

    public String getUserNameById(Integer userId) {
        SysUsers user = (SysUsers)this.userMapper.selectById(userId);
        if (user != null) {
            return user.getUserName();
        }
        return "--";
    }

    public String getUserAccountById(Integer userId) {
        SysUsers user = (SysUsers)this.userMapper.selectById(userId);
        if (user != null) {
            return user.getUserAccount();
        }
        return "--";
    }

    @Cacheable(value={"CONSTANT"}, key="'roles_name_'+#roleIds")
    public String getRoleName(String roleIds) {
        Integer[] roles = Convert.toIntArray((String)roleIds);
        StringBuilder sb = new StringBuilder();
        Integer[] integerArray = roles;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int role = integerArray[i];
            SysRoles roleObj = (SysRoles)this.roleMapper.selectById(Integer.valueOf(role));
            if (!ToolUtil.isNotEmpty((Object)roleObj) || !ToolUtil.isNotEmpty((Object)roleObj.getRoleName())) continue;
            sb.append(roleObj.getRoleName()).append(",");
        }
        return StrKit.removeSuffix((String)sb.toString(), (String)",");
    }

    @Cacheable(value={"CONSTANT"}, key="'single_role_name_'+#roleId")
    public String getSingleRoleName(Integer roleId) {
        if (0 == roleId) {
            return "--";
        }
        SysRoles roleObj = (SysRoles)this.roleMapper.selectById(roleId);
        if (ToolUtil.isNotEmpty((Object)roleObj) && ToolUtil.isNotEmpty((Object)roleObj.getRoleName())) {
            return roleObj.getRoleName();
        }
        return "";
    }

    @Cacheable(value={"CONSTANT"}, key="'single_role_tip_'+#roleId")
    public String getSingleRoleTip(String roleId) {
        SysRoles roleObj = (SysRoles)this.roleMapper.selectById((Serializable)((Object)roleId));
        if (ToolUtil.isNotEmpty((Object)roleObj) && ToolUtil.isNotEmpty((Object)roleObj.getRoleName())) {
            return roleObj.getRoleAlias();
        }
        return "";
    }

    public String getDeptName(Long deptId) {
        SysOrganVo dept = this.struMapper.getOrgInfoByOrgId(deptId);
        if (ToolUtil.isNotEmpty((Object)dept) && ToolUtil.isNotEmpty((Object)dept.getOrganName())) {
            return dept.getOrganName();
        }
        return "";
    }

    public String getMenuNames(String menuIds) {
        Integer[] menus = Convert.toIntArray((String)menuIds);
        StringBuilder sb = new StringBuilder();
        Integer[] integerArray = menus;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int menu = integerArray[i];
            SysMenu menuObj = (SysMenu)this.menuMapper.selectById(Integer.valueOf(menu));
            if (!ToolUtil.isNotEmpty((Object)menuObj) || !ToolUtil.isNotEmpty((Object)menuObj.getText())) continue;
            sb.append(menuObj.getText()).append(",");
        }
        return StrKit.removeSuffix((String)sb.toString(), (String)",");
    }

    public String getMenuName(Long menuId) {
        if (ToolUtil.isEmpty((Object)menuId)) {
            return "";
        }
        SysMenu menu = (SysMenu)this.menuMapper.selectById(menuId);
        if (menu == null) {
            return "";
        }
        return menu.getText();
    }

    public String getMenuNameByCode(String code) {
        if (ToolUtil.isEmpty((Object)code)) {
            return "";
        }
        SysMenu menu = (SysMenu)this.menuMapper.selectById((Serializable)((Object)code));
        if (menu == null) {
            return "";
        }
        return menu.getText();
    }

    public String getStatusName(Integer status) {
        return ManagerStatus.valueOf((Integer)status);
    }

    public String getMenuStatusName(Integer status) {
        return MenuStatus.valueOf((Integer)status);
    }

    public String getCacheObject(String para) {
        return LogObjectHolder.me().get().toString();
    }

    @Deprecated
    public List<String> getIsRepeatAuthenticateId(String userId) {
        List<String> list = this.resourcesMapper.getIsRepeatAuthenticateId(userId);
        return list;
    }

    public List<Long> getRolesIdByStruId(Long struId) {
        List<Long> roleList = this.struRoleMapper.getRolesByStruId(struId);
        return roleList;
    }

    public List<Long> getRolesIdByShiroUser(SecurityUser shiroUser) {
        List<Long> roleIds = new ArrayList<Long>();
        if (Objects.isNull(shiroUser)) {
            return roleIds;
        }
        SysUsers sysUsers = this.sysUsersService.getById(shiroUser.getUserId());
        if (Objects.isNull(sysUsers)) {
            return roleIds;
        }
        roleIds = this.sysUserRoleService.getRolesByUserId(sysUsers.getId());
        if (Boolean.TRUE.equals(this.hussarConfig.getUseSeparation()) && ToolUtil.isNotEmpty((Object)sysUsers.getEmployeeId()) && ToolUtil.isNotEmpty((Object)sysUsers.getDepartmentId())) {
            List roleList = this.sysStruRoleService.getRolesByStruId(sysUsers.getDepartmentId());
            roleIds.addAll(roleList);
        }
        return roleIds;
    }
}

