/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.authorization.adapter.resource.IHussarBaseResourceAdapter;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleResourceMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserRoleMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserroleAuditMapper;
import com.jxdinfo.hussar.authorization.permit.dto.RoleResourceRelationDto;
import com.jxdinfo.hussar.authorization.permit.dto.RoleUserRelationDto;
import com.jxdinfo.hussar.authorization.permit.model.SysConfRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResourceAudit;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUserroleAudit;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysConfRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleResourceAuditService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserroleAuditService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.permit.service.impl.RoleUserAuthorizationChangeReporter;
import com.jxdinfo.hussar.authorization.permit.vo.SysRoleResourceVo;
import com.jxdinfo.hussar.base.config.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysAuditConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.common.base.HussarBaseServiceImpl;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.constant.enums.Whether;
import com.jxdinfo.hussar.common.constant.state.UserRoleStatus;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.common.utils.TreeModelUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.rolemanager.RoleResourceChangeNotify;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysRoleResourceServiceImpl
extends HussarBaseServiceImpl<SysRoleResourceMapper, SysRoleResource>
implements ISysRoleResourceService {
    private static Logger logger = LoggerFactory.getLogger(SysRoleResourceServiceImpl.class);
    @Resource
    private SysRoleResourceMapper sysRoleResourceMapper;
    @Resource
    private ISysUserroleAuditService sysUserroleAuditService;
    @Resource
    private SysUserroleAuditMapper sysUserroleAuditMapper;
    @Resource
    private ISysUserRoleService sysUserRoleService;
    @Resource
    private ISysRolesService sysRolesService;
    @Resource
    private SysUserRoleMapper sysUserRoleMapper;
    @Resource
    private ISysAuditConfigService sysAuditConfig;
    private static final String ADD = "1";
    private static final String DELETE = "2";
    @Resource
    @Lazy
    private ISysConfRolesService isConfRolesService;
    @Resource
    @Lazy
    private ISysUsersService sysUsersService;
    @Resource
    private IHussarBaseResourceAdapter hussarBaseResourceAdapter;
    @Resource
    private RoleResourceChangeNotify roleResourceChangeNotify;
    @Resource
    @Lazy
    private RoleUserAuthorizationChangeReporter userAuthorizationChangeReporter;
    @Autowired
    private ISysBaseConfigService sysBaseConfigService;
    @Autowired
    private ISysResourcesService resourcesService;
    @Resource
    private ISysAuditConfigService sysAuditConfigService;
    @Resource
    private ISysRoleResourceAuditService sysRoleResourceAuditService;

    @HussarTransactional
    @Deprecated
    public void saveRoleResource(String resourceIds, Long roleId) {
        RoleResourceRelationDto roleResourceDto = new RoleResourceRelationDto();
        roleResourceDto.setResourceIds(resourceIds);
        roleResourceDto.setRoleId(roleId);
        this.saveRoleResource(roleResourceDto);
    }

    @HussarTransactional
    public void saveRoleResource(RoleResourceRelationDto roleResourceDto) {
        Long roleId = roleResourceDto.getRoleId();
        String resourceIds = roleResourceDto.getResourceIds();
        this.sysRoleResourceMapper.deleteById(roleId);
        String[] id = resourceIds.split(",");
        ArrayList<SysRoleResource> sysRoleResourceList = new ArrayList<SysRoleResource>();
        for (String reId : id) {
            if (ToolUtil.isEmpty((Object)reId)) continue;
            SysRoleResource sysRoleResource = new SysRoleResource();
            sysRoleResource.setRoleId(roleId);
            sysRoleResource.setResourceId(Long.valueOf(reId));
            sysRoleResourceList.add(sysRoleResource);
        }
        if (ToolUtil.isNotEmpty(sysRoleResourceList)) {
            super.saveBatch(sysRoleResourceList, sysRoleResourceList.size());
        }
        List userIds = this.sysRolesService.delCacheAuthInfo(roleId);
        for (Long userId : userIds) {
            this.sysRolesService.delAuthCacheInfo(userId);
        }
    }

    @HussarTransactional
    public void saveRoleResourceAndRelation(String resourceIds, Long roleId) {
        List sysResIds = null;
        SysBaseConfig protectStatus = this.sysBaseConfigService.getSysBaseConfig("protection_status");
        logger.info("\u89d2\u8272\u5173\u8054\u8d44\u6e90--\u5f53\u524d\u72b6\u6001\uff08configValue=3\u4e3a\u5206\u4fdd\uff09: {}", (Object)protectStatus);
        if (null != protectStatus && "3".equals(protectStatus.getConfigValue())) {
            List resourcesList;
            List sysRoleResourceList = this.sysRoleResourceMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(SysRoleResource::getRoleId, (Object)roleId));
            if (HussarUtils.isNotEmpty((Object)sysRoleResourceList) && CollectionUtils.isNotEmpty((Collection)(resourcesList = this.resourcesService.listByIds((Collection)sysRoleResourceList.stream().map(SysRoleResource::getResourceId).collect(Collectors.toList()))))) {
                sysResIds = resourcesList.stream().filter(s -> ADD.equals(s.getIsSys())).map(SysResources::getId).collect(Collectors.toList());
            }
            if (HussarUtils.isNotEmpty(sysResIds)) {
                logger.info("\u89d2\u8272\u5173\u8054\u8d44\u6e90--\u5206\u4fdd\u6a21\u5f0f\u4e0b\uff0c\u4fdd\u7559\u7684\u5173\u8054\u5173\u7cfb\u4e2d\uff0c\u8d44\u6e90ID\u96c6\u5408\uff0c\u5171\u8ba1{}\u4e2a: {}", (Object)sysResIds.size(), (Object)sysResIds);
            } else {
                logger.info("\u89d2\u8272\u5173\u8054\u8d44\u6e90--\u5206\u4fdd\u6a21\u5f0f\u4e0b\uff0c\u4fdd\u7559\u7684\u5173\u8054\u5173\u7cfb\u4e2d\uff0c\u8d44\u6e90ID\u96c6\u5408\uff0c\u5171\u8ba1{}\u4e2a: {}", (Object)0, (Object)sysResIds);
            }
        }
        if (this.sysAuditConfigService.isCriticalOperationsAudit() && this.sysAuditConfigService.isResourceAudit()) {
            SysRoleResourceAudit sysRoleResourceAudit;
            List sysRoleResoourcesAudits = this.sysRoleResourceAuditService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRoleResourceAudit::getRoleId, (Object)roleId)).eq(SysRoleResourceAudit::getAuditStatus, (Object)"0"));
            if (HussarUtils.isNotEmpty((Object)sysRoleResoourcesAudits)) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_RESOURCE_AUDIT_SAVE_FAIL.getMessage()));
            }
            List<Object> newResourceIds = new ArrayList();
            if (HussarUtils.isNotEmpty((Object)resourceIds)) {
                String[] ids = resourceIds.split(",");
                Long[] idl = (Long[])ConvertUtils.convert((String[])ids, Long.class);
                newResourceIds = Arrays.asList(idl);
            }
            List<Object> oldResourceIds = new ArrayList();
            ArrayList<Long> addRoleResourceIds = new ArrayList<Long>();
            ArrayList<Long> deleteRoleResourceIds = new ArrayList<Long>();
            ArrayList<Object> allResourceIds = new ArrayList<Object>();
            List oldSysRoleResourceList = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRoleResource::getRoleId, (Object)roleId)).eq(SysRoleResource::getRelationSource, (Object)DELETE));
            List oldResourcesList = new ArrayList();
            if (HussarUtils.isNotEmpty((Object)oldSysRoleResourceList)) {
                oldResourcesList = this.resourcesService.listByIds((Collection)oldSysRoleResourceList.stream().map(SysRoleResource::getResourceId).collect(Collectors.toList()));
            }
            if (HussarUtils.isNotEmpty(oldResourcesList)) {
                oldResourceIds = oldResourcesList.stream().map(SysResources::getId).collect(Collectors.toList());
                if (HussarUtils.isNotEmpty(sysResIds)) {
                    oldResourceIds.removeAll(sysResIds);
                }
            }
            allResourceIds.addAll(newResourceIds);
            allResourceIds.addAll(oldResourceIds);
            for (Long l : allResourceIds) {
                if (!oldResourceIds.contains(l)) {
                    addRoleResourceIds.add(l);
                }
                if (newResourceIds.contains(l)) continue;
                deleteRoleResourceIds.add(l);
            }
            ArrayList<SysRoleResourceAudit> sysRoleResourceAuditList = new ArrayList<SysRoleResourceAudit>();
            for (Long resId : deleteRoleResourceIds) {
                sysRoleResourceAudit = new SysRoleResourceAudit();
                sysRoleResourceAudit.setRoleId(roleId);
                sysRoleResourceAudit.setAuditStatus("0");
                sysRoleResourceAudit.setResourceId(resId);
                sysRoleResourceAudit.setOperateType("3");
                sysRoleResourceAudit.setRelationSource(DELETE);
                sysRoleResourceAuditList.add(sysRoleResourceAudit);
            }
            for (Long resId : addRoleResourceIds) {
                sysRoleResourceAudit = new SysRoleResourceAudit();
                sysRoleResourceAudit.setRoleId(roleId);
                sysRoleResourceAudit.setAuditStatus("0");
                sysRoleResourceAudit.setResourceId(resId);
                sysRoleResourceAudit.setOperateType(ADD);
                sysRoleResourceAudit.setRelationSource(DELETE);
                sysRoleResourceAuditList.add(sysRoleResourceAudit);
            }
            if (HussarUtils.isNotEmpty(sysRoleResourceAuditList)) {
                this.sysRoleResourceAuditService.saveBatch(sysRoleResourceAuditList);
            }
        } else {
            this.sysRoleResourceMapper.deleteRoleResourceOfRelation(roleId, DELETE, sysResIds);
            String[] id = resourceIds.split(",");
            ArrayList<SysRoleResource> sysRoleResourceList = new ArrayList<SysRoleResource>();
            for (String reId : id) {
                if (ToolUtil.isEmpty((Object)reId)) continue;
                SysRoleResource sysRoleResource = new SysRoleResource();
                sysRoleResource.setRoleId(roleId);
                sysRoleResource.setResourceId(Long.valueOf(reId));
                sysRoleResource.setRelationSource(DELETE);
                sysRoleResourceList.add(sysRoleResource);
            }
            if (ToolUtil.isNotEmpty(sysRoleResourceList)) {
                List resIds = sysRoleResourceList.stream().map(SysRoleResource::getResourceId).collect(Collectors.toList());
                logger.info("\u89d2\u8272\u5173\u8054\u8d44\u6e90--\u65b0\u589e\u7684\u5173\u8054\u5173\u7cfb\u4e2d\uff0c\u8d44\u6e90ID\u96c6\u5408\uff0c\u5171\u8ba1{}\u4e2a\uff1a{}", (Object)resIds.size(), resIds);
                super.saveBatch(sysRoleResourceList, sysRoleResourceList.size());
            }
            List userIds = this.sysRolesService.delCacheAuthInfo(roleId);
            for (Long userId : userIds) {
                this.sysRolesService.delAuthCacheInfo(userId);
            }
            SysRoles role = (SysRoles)this.sysRolesService.getById((Serializable)roleId);
            if (HussarUtils.isNotEmpty((Object)role.getAppId()) && role.getAppId() != 1L) {
                this.roleResourceChangeNotify.notify(DataChangeType.RELATE, new Object[]{roleId, null});
            }
            if (HussarUtils.isEmpty((Object)role.getAppId()) || role.getAppId() == 1L) {
                this.userAuthorizationChangeReporter.report(new Object[]{"resource", roleId});
            }
        }
    }

    @HussarTransactional
    public void reclaimPerm(Long id) {
        this.sysRoleResourceMapper.deleteById(id);
        List userIds = this.sysRolesService.delCacheAuthInfo(id);
        for (Long userId : userIds) {
            this.sysRolesService.delAuthCacheInfo(userId);
        }
    }

    public List<SysRoleResource> queryPerm(String id) {
        if (ToolUtil.isEmpty((Object)id)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_ID_EMPTY.getMessage()));
        }
        return this.sysRoleResourceMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysRoleResource::getRoleId, (Object)id));
    }

    @HussarTransactional
    @Deprecated
    public void saveRoleUserAdd(String userIds, Long roleId) {
        RoleUserRelationDto roleUserRelationDto = new RoleUserRelationDto();
        roleUserRelationDto.setUserIds(userIds);
        roleUserRelationDto.setRoleId(roleId);
        this.saveRoleUserAdd(roleUserRelationDto);
    }

    @HussarTransactional
    public void saveRoleUserAdd(RoleUserRelationDto roleUserRelationDto) {
        String userIds = roleUserRelationDto.getUserIds();
        Long roleId = roleUserRelationDto.getRoleId();
        List<Object> ids = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)userIds)) {
            ids = Arrays.asList(userIds.split(","));
        }
        if (this.sysAuditConfig.isRoleAudit()) {
            ArrayList<SysUserroleAudit> sysUserroleAuditList = new ArrayList<SysUserroleAudit>();
            for (String string : ids) {
                SysUserroleAudit sysUserroleAudit = new SysUserroleAudit();
                sysUserroleAudit.setUserId(Long.valueOf(string));
                sysUserroleAudit.setRoleId(roleId);
                sysUserroleAudit.setStatus(UserStatus.LOCKED.getCode());
                sysUserroleAudit.setOperationType(ADD);
                sysUserroleAuditList.add(sysUserroleAudit);
            }
            if (ToolUtil.isNotEmpty(sysUserroleAuditList)) {
                this.sysUserroleAuditService.saveBatch(sysUserroleAuditList, sysUserroleAuditList.size());
            }
        } else {
            ArrayList<SysUserRole> userRoleList = new ArrayList<SysUserRole>();
            for (String string : ids) {
                SysUserRole sysUserRole = new SysUserRole();
                sysUserRole.setUserId(Long.valueOf(string));
                sysUserRole.setGrantedRole(roleId);
                sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
                userRoleList.add(sysUserRole);
                this.sysRolesService.delAuthCacheInfo(Long.valueOf(string));
            }
            if (ToolUtil.isNotEmpty(userRoleList)) {
                this.sysUserRoleService.saveBatch(userRoleList, userRoleList.size());
            }
        }
    }

    @HussarTransactional
    @Deprecated
    public void updateRoleUserEdit(String userIds, Long roleId) {
        RoleUserRelationDto roleUserRelationDto = new RoleUserRelationDto();
        roleUserRelationDto.setUserIds(userIds);
        roleUserRelationDto.setRoleId(roleId);
        this.updateRoleUserEdit(roleUserRelationDto);
    }

    @HussarTransactional
    public void updateRoleUserEdit(RoleUserRelationDto roleUserRelationDto) {
        boolean exist;
        List confRolesList;
        String userIds = roleUserRelationDto.getUserIds();
        Long roleId = roleUserRelationDto.getRoleId();
        List<Object> ids = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)userIds)) {
            ids = Arrays.asList(userIds.split(","));
        }
        if (ToolUtil.isNotEmpty((Object)(confRolesList = this.isConfRolesService.list((Wrapper)new LambdaQueryWrapper().eq(SysConfRoles::getRoleId, (Object)roleId))))) {
            for (String string : ids) {
                List rolesList = this.sysUserRoleService.getRolesByUserId(Long.valueOf(string));
                if (!rolesList.contains(roleId)) {
                    rolesList.add(roleId);
                }
                if (!this.isConfRolesService.isIncludeConfRole(rolesList.toArray(new Long[rolesList.size()]))) continue;
                SysUsers user = (SysUsers)this.sysUsersService.getById((Serializable)((Object)string));
                throw new BaseException(String.format(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MODIFICATION_FAILED.getMessage()), user.getUserName()));
            }
        }
        List userRoleList = this.sysUserRoleMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getGrantedRole, (Object)roleId)).eq(SysUserRole::getAdminOption, (Object)Whether.YES.getValue()));
        List list = this.sysUserroleAuditMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysUserroleAudit::getRoleId, (Object)roleId));
        ArrayList<Long> addList = new ArrayList<Long>();
        ArrayList<Long> delList = new ArrayList<Long>();
        for (SysUserRole sysUserRole : userRoleList) {
            exist = false;
            for (String string : ids) {
                if (ToolUtil.isEmpty((Object)string) || !string.equals(sysUserRole.getUserId())) continue;
                exist = true;
                break;
            }
            if (exist) continue;
            delList.add(sysUserRole.getUserId());
        }
        for (String string : ids) {
            if (ToolUtil.isEmpty((Object)string)) continue;
            exist = false;
            for (SysUserRole sysUserRole : userRoleList) {
                if (!sysUserRole.getUserId().equals(string)) continue;
                exist = true;
                break;
            }
            if (exist) continue;
            addList.add(Long.valueOf(string));
        }
        if (this.sysAuditConfig.isRoleAudit()) {
            SysUserroleAudit sysUserroleAudit;
            if (ToolUtil.isNotEmpty(addList)) {
                for (Long l : addList) {
                    exist = false;
                    for (SysUserroleAudit sysUserroleAudit2 : list) {
                        if (!l.equals(sysUserroleAudit2.getUserId())) continue;
                        exist = true;
                        sysUserroleAudit2.setOperationType(ADD);
                        sysUserroleAudit2.setStatus(UserRoleStatus.LOCKED.getCode());
                        this.sysUserroleAuditService.update((Object)sysUserroleAudit2, (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserroleAudit::getUserId, (Object)l)).eq(SysUserroleAudit::getRoleId, (Object)sysUserroleAudit2.getRoleId()));
                    }
                    if (exist) continue;
                    sysUserroleAudit = new SysUserroleAudit();
                    sysUserroleAudit.setUserId(l);
                    sysUserroleAudit.setRoleId(roleId);
                    sysUserroleAudit.setStatus(UserRoleStatus.LOCKED.getCode());
                    sysUserroleAudit.setOperationType(ADD);
                    this.sysUserroleAuditService.save((Object)sysUserroleAudit);
                }
            }
            if (ToolUtil.isNotEmpty(delList)) {
                for (Long l : delList) {
                    exist = false;
                    for (SysUserroleAudit sysUserroleAudit3 : list) {
                        if (!l.equals(sysUserroleAudit3.getUserId())) continue;
                        exist = true;
                        sysUserroleAudit3.setOperationType(DELETE);
                        sysUserroleAudit3.setStatus(UserRoleStatus.LOCKED.getCode());
                        this.sysUserroleAuditService.update((Object)sysUserroleAudit3, (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserroleAudit::getUserId, (Object)l)).eq(SysUserroleAudit::getRoleId, (Object)sysUserroleAudit3.getRoleId()));
                    }
                    if (exist) continue;
                    sysUserroleAudit = new SysUserroleAudit();
                    sysUserroleAudit.setUserId(l);
                    sysUserroleAudit.setRoleId(roleId);
                    sysUserroleAudit.setStatus(UserRoleStatus.LOCKED.getCode());
                    sysUserroleAudit.setOperationType(DELETE);
                    this.sysUserroleAuditService.save((Object)sysUserroleAudit);
                }
            }
        } else {
            if (ToolUtil.isNotEmpty(delList)) {
                this.sysUserRoleMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getGrantedRole, (Object)roleId)).in(SysUserRole::getUserId, delList));
            }
            for (Long l : delList) {
                this.sysRolesService.delAuthCacheInfo(l);
            }
            ArrayList<SysUserRole> userRoleList2 = new ArrayList<SysUserRole>();
            for (Long userId : addList) {
                SysUserRole sysUserRole = new SysUserRole();
                sysUserRole.setUserId(userId);
                sysUserRole.setGrantedRole(roleId);
                sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
                userRoleList2.add(sysUserRole);
                this.sysRolesService.delAuthCacheInfo(userId);
            }
            if (ToolUtil.isNotEmpty(userRoleList2)) {
                this.sysUserRoleService.saveBatch(userRoleList2, userRoleList2.size());
            }
        }
    }

    @Deprecated
    public List<SysRoleResourceVo> selectResource(Long roleId, String ids) {
        if (StringUtils.isBlank((CharSequence)ids)) {
            return new ArrayList<SysRoleResourceVo>();
        }
        String[] resourceIds = ids == null ? "".split(",") : ids.split(",");
        ArrayList<Long> resourceIdList = new ArrayList<Long>();
        for (String resourceId : resourceIds) {
            if (!ToolUtil.isNotEmpty((Object)resourceId)) continue;
            resourceIdList.add(Long.valueOf(resourceId));
        }
        ArrayList<SysRoleResourceVo> voList = new ArrayList<SysRoleResourceVo>();
        return voList;
    }

    public List<SysRoleResource> getRealResource(String roleId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"ROLE_ID", (Object)Long.parseLong(roleId));
        List list = super.list((Wrapper)queryWrapper);
        HashMap<Long, SysRoleResource> map = new HashMap<Long, SysRoleResource>();
        for (SysRoleResource roleResource : list) {
            Long resourceId = roleResource.getResourceId();
            if (!map.containsKey(resourceId)) {
                map.put(resourceId, roleResource);
            }
            System.out.println("resourceId::: " + resourceId);
            if (!map.containsKey(resourceId) || StringUtils.equals((CharSequence)((SysRoleResource)map.get(resourceId)).getRelationSource(), (CharSequence)roleResource.getRelationSource()) || !ADD.equals(roleResource.getRelationSource())) continue;
            map.put(resourceId, roleResource);
        }
        logger.info("\u89d2\u8272\u5173\u8054\u8d44\u6e90--/getRealResource\u63a5\u53e3\uff0c\u67e5\u8be2\u5f53\u524d\u89d2\u8272\u5173\u8054\u7684\u6240\u6709\u8d44\u6e90ID\uff0c\u5171\u8ba1{}\u4e2a\uff1a{}", (Object)map.keySet().size(), map.keySet());
        return HussarUtils.isNotEmpty(map) ? new ArrayList(map.values()) : new ArrayList();
    }

    public List<JSTreeModel> selfResourceTree(String resourceIds) {
        String[] resourceIdArr = ToolUtil.isEmpty((Object)resourceIds) ? "".split(",") : resourceIds.trim().split(",");
        Long[] resourceIdLongArr = new Long[resourceIdArr.length];
        if (ToolUtil.isNotEmpty((Object)resourceIds)) {
            for (int i = 0; i < resourceIdArr.length; ++i) {
                resourceIdLongArr[i] = Long.valueOf(resourceIdArr[i]);
            }
        }
        List splitIdList = LambdaQueryUtil.getSplitList(Arrays.asList(resourceIdLongArr));
        SysBaseConfig sysBaseConfig = this.sysBaseConfigService.getSysBaseConfig("protection_status");
        List<Object> resourceTreeData = new ArrayList();
        resourceTreeData = HussarUtils.isNotEmpty((Object)sysBaseConfig) && "3".equals(sysBaseConfig.getConfigValue()) ? this.sysRoleResourceMapper.selfResourceTreeFb(splitIdList) : this.sysRoleResourceMapper.selfResourceTree(splitIdList);
        return TreeModelUtils.merge(this.doRecursive(resourceTreeData));
    }

    private List<JSTreeModel> doRecursive(List<JSTreeModel> list) {
        ArrayList childList = new ArrayList();
        ArrayList<JSTreeModel> otherList = new ArrayList<JSTreeModel>();
        ArrayList<Long> parentIdList = new ArrayList<Long>();
        list.forEach(m -> {
            if (ADD.equals(m.getIsRes())) {
                childList.add(m);
                parentIdList.add(m.getParent());
            } else {
                otherList.add((JSTreeModel)m);
            }
        });
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>(childList);
        if (ToolUtil.isNotEmpty(otherList)) {
            this.recursive(otherList, result, parentIdList);
        }
        if (result.size() == 0) {
            for (JSTreeModel map : list) {
                if (!Constants.ROOT_NODE_PARENT.equals(map.getParent())) continue;
                result.add(map);
            }
        }
        JSTreeModel model = new JSTreeModel();
        model.setParent(Constants.ROOT_NODE_PARENT);
        model.setCode("GROUP");
        model.setText(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MODULE_RESOURCE_LIST.getMessage()));
        model.setId(Constants.RES_NODE_ID);
        model.setType("isRoot");
        model.setState(true, true, true);
        result.add(model);
        return result;
    }

    private void recursive(List<JSTreeModel> list, List<JSTreeModel> result, List<Long> idList) {
        ArrayList currentList = new ArrayList();
        ArrayList<Long> parentIdList = new ArrayList<Long>();
        ArrayList<JSTreeModel> otherList = new ArrayList<JSTreeModel>();
        list.forEach(model -> {
            if (idList.contains(model.getId())) {
                currentList.add(model);
                parentIdList.add(model.getParent());
            } else {
                otherList.add((JSTreeModel)model);
            }
        });
        if (ToolUtil.isNotEmpty(currentList)) {
            result.addAll(currentList);
            this.recursive(otherList, result, parentIdList);
        }
    }

    public List<SysRoleResource> getResourceRoles(Long resourceId) {
        if (ToolUtil.isEmpty((Object)resourceId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_RESOURCE_ID_NOT_NULL.getMessage()));
        }
        List list = this.list((Wrapper)new LambdaQueryWrapper().eq(SysRoleResource::getResourceId, (Object)resourceId));
        HashMap<Long, SysRoleResource> map = new HashMap<Long, SysRoleResource>();
        for (SysRoleResource roleResource : list) {
            Long roleId = roleResource.getRoleId();
            if (!map.containsKey(roleId)) {
                map.put(roleId, roleResource);
            }
            if (!map.containsKey(roleId) || ((SysRoleResource)map.get(roleId)).getRelationSource().equals(roleResource.getRelationSource()) || !ADD.equals(roleResource.getRelationSource())) continue;
            map.put(roleId, roleResource);
        }
        return HussarUtils.isNotEmpty(map) ? new ArrayList(map.values()) : new ArrayList();
    }

    public List<SysRoleResource> getResourceRoles(String resourceId) {
        return this.getResourceRoles(Long.parseLong(resourceId));
    }

    public void insertOrUpdateRoleResource(List<SysRoleResource> roleResourceList) {
        if (ToolUtil.isEmpty(roleResourceList)) {
            logger.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_RESOURCE_ADD_DATA.getMessage()), (Object)roleResourceList.size());
            return;
        }
        List<SysRoleResource> existData = this.selectExistList(roleResourceList);
        List<SysRoleResource> addList = roleResourceList;
        if (ToolUtil.isNotEmpty(existData)) {
            addList = this.getAddList(roleResourceList, existData);
        }
        if (ToolUtil.isNotEmpty(addList)) {
            this.saveBatch(addList);
        }
        logger.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_RESOURCE_ADD_DATA.getMessage()), (Object)addList.size());
    }

    public List<SysRoleResource> selectRoleResByDobuleId(List<SysRoleResource> roleResourceList) {
        ArrayList<SysRoleResource> retunList = new ArrayList<SysRoleResource>();
        LambdaQueryWrapper roleResourceLambdaQueryWrapper = new LambdaQueryWrapper();
        for (int i = 0; i < roleResourceList.size(); i += 699) {
            List<SysRoleResource> temp;
            if (i + 699 >= roleResourceList.size()) {
                temp = roleResourceList.subList(i, roleResourceList.size());
                roleResourceLambdaQueryWrapper.clear();
                for (SysRoleResource roleRes : temp) {
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)roleResourceLambdaQueryWrapper.or()).eq(SysRoleResource::getResourceId, (Object)roleRes.getResourceId())).eq(SysRoleResource::getRoleId, (Object)roleRes.getRoleId())).eq(SysRoleResource::getRelationSource, (Object)roleRes.getRelationSource());
                }
                retunList.addAll(this.sysRoleResourceMapper.selectList((Wrapper)roleResourceLambdaQueryWrapper));
                continue;
            }
            temp = roleResourceList.subList(i, i + 699);
            roleResourceLambdaQueryWrapper.clear();
            for (SysRoleResource roleRes : temp) {
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)roleResourceLambdaQueryWrapper.or()).eq(SysRoleResource::getResourceId, (Object)roleRes.getResourceId())).eq(SysRoleResource::getRoleId, (Object)roleRes.getRoleId())).eq(SysRoleResource::getRelationSource, (Object)roleRes.getRelationSource());
            }
            retunList.addAll(this.sysRoleResourceMapper.selectList((Wrapper)roleResourceLambdaQueryWrapper));
        }
        return retunList;
    }

    public void delRoleResByDoubleId(List<SysRoleResource> roleResourceList) {
        LambdaQueryWrapper roleResourceLambdaQueryWrapper = new LambdaQueryWrapper();
        for (int i = 0; i < roleResourceList.size(); i += 699) {
            List<SysRoleResource> temp;
            if (i + 699 >= roleResourceList.size()) {
                temp = roleResourceList.subList(i, roleResourceList.size());
                roleResourceLambdaQueryWrapper.clear();
                for (SysRoleResource roleRes : temp) {
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)roleResourceLambdaQueryWrapper.or()).eq(SysRoleResource::getResourceId, (Object)roleRes.getResourceId())).eq(SysRoleResource::getRoleId, (Object)roleRes.getRoleId())).eq(SysRoleResource::getRelationSource, (Object)roleRes.getRelationSource());
                }
                this.sysRoleResourceMapper.delete((Wrapper)roleResourceLambdaQueryWrapper);
                continue;
            }
            temp = roleResourceList.subList(i, i + 699);
            roleResourceLambdaQueryWrapper.clear();
            for (SysRoleResource roleRes : temp) {
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)roleResourceLambdaQueryWrapper.or()).eq(SysRoleResource::getResourceId, (Object)roleRes.getResourceId())).eq(SysRoleResource::getRoleId, (Object)roleRes.getRoleId())).eq(SysRoleResource::getRelationSource, (Object)roleRes.getRelationSource());
            }
            this.sysRoleResourceMapper.delete((Wrapper)roleResourceLambdaQueryWrapper);
        }
    }

    public List<SysRoleResource> selectRoleResByDobuleIdNoRelation(List<SysRoleResource> roleResourceList) {
        ArrayList<SysRoleResource> returnList = new ArrayList<SysRoleResource>();
        LambdaQueryWrapper roleResourceLambdaQueryWrapper = new LambdaQueryWrapper();
        for (int i = 0; i < roleResourceList.size(); i += 699) {
            List<SysRoleResource> temp;
            if (i + 699 >= roleResourceList.size()) {
                temp = roleResourceList.subList(i, roleResourceList.size());
                roleResourceLambdaQueryWrapper.clear();
                for (SysRoleResource roleRes : temp) {
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)roleResourceLambdaQueryWrapper.or()).eq(SysRoleResource::getResourceId, (Object)roleRes.getResourceId())).eq(SysRoleResource::getRoleId, (Object)roleRes.getRoleId());
                }
                returnList.addAll(this.sysRoleResourceMapper.selectList((Wrapper)roleResourceLambdaQueryWrapper));
                continue;
            }
            temp = roleResourceList.subList(i, i + 699);
            roleResourceLambdaQueryWrapper.clear();
            for (SysRoleResource roleRes : temp) {
                ((LambdaQueryWrapper)((LambdaQueryWrapper)roleResourceLambdaQueryWrapper.or()).eq(SysRoleResource::getResourceId, (Object)roleRes.getResourceId())).eq(SysRoleResource::getRoleId, (Object)roleRes.getRoleId());
            }
            returnList.addAll(this.sysRoleResourceMapper.selectList((Wrapper)roleResourceLambdaQueryWrapper));
        }
        return returnList;
    }

    public List<SysRoleResource> selectRoleResByResIds(List<Long> resIds) {
        ArrayList<SysRoleResource> returnList = new ArrayList<SysRoleResource>();
        LambdaQueryWrapper roleResourceLambdaQueryWrapper = new LambdaQueryWrapper();
        for (int i = 0; i < resIds.size(); i += 699) {
            List<Long> temp;
            if (i + 699 >= resIds.size()) {
                temp = resIds.subList(i, resIds.size());
                roleResourceLambdaQueryWrapper.clear();
                for (Long resId : temp) {
                    ((LambdaQueryWrapper)roleResourceLambdaQueryWrapper.or()).eq(SysRoleResource::getResourceId, (Object)resId);
                }
                returnList.addAll(this.sysRoleResourceMapper.selectList((Wrapper)roleResourceLambdaQueryWrapper));
                continue;
            }
            temp = resIds.subList(i, i + 699);
            roleResourceLambdaQueryWrapper.clear();
            for (Long resId : temp) {
                ((LambdaQueryWrapper)roleResourceLambdaQueryWrapper.or()).eq(SysRoleResource::getResourceId, (Object)resId);
            }
            returnList.addAll(this.sysRoleResourceMapper.selectList((Wrapper)roleResourceLambdaQueryWrapper));
        }
        return returnList;
    }

    private List<SysRoleResource> selectExistList(List<SysRoleResource> sysRoleResources) {
        List<Object> returnList = new ArrayList<SysRoleResource>();
        ArrayList roleIds = new ArrayList();
        ArrayList resourceIds = new ArrayList();
        sysRoleResources.forEach(rr -> {
            roleIds.add(rr.getRoleId());
            resourceIds.add(rr.getResourceId());
        });
        if (ToolUtil.isNotEmpty(resourceIds) && ToolUtil.isNotEmpty(roleIds)) {
            List distRoleIds = roleIds.stream().distinct().collect(Collectors.toList());
            List distResIds = resourceIds.stream().distinct().collect(Collectors.toList());
            LambdaQueryWrapper roleResQueryWrapper = LambdaQueryUtil.getMultiQueryWrapper(SysRoleResource::getRoleId, distRoleIds);
            LambdaQueryUtil.wrapperWithMultiQuery((LambdaQueryWrapper)roleResQueryWrapper, SysRoleResource::getResourceId, distResIds);
            returnList = this.sysRoleResourceMapper.selectList((Wrapper)roleResQueryWrapper);
        }
        return returnList;
    }

    private List<SysRoleResource> getAddList(List<SysRoleResource> roleResourceList, List<SysRoleResource> existList) {
        ArrayList<SysRoleResource> addList = new ArrayList<SysRoleResource>();
        HashMap existMap = new HashMap();
        existList.forEach(rr -> existMap.put(rr.getRoleId() + "-" + rr.getResourceId() + "-" + rr.getRelationSource(), ADD));
        for (SysRoleResource roleResource : roleResourceList) {
            String idStr = roleResource.getRoleId() + "-" + roleResource.getResourceId() + "-" + roleResource.getRelationSource();
            if (!ToolUtil.isEmpty(existMap.get(idStr))) continue;
            addList.add(roleResource);
        }
        return addList;
    }

    public boolean saveBatch(Collection<SysRoleResource> entityList) {
        return this.hussarBaseResourceAdapter.saveBatchRoleRes((List)entityList);
    }

    public List<SysRoleResource> listByRoleIds(List<Long> roleIds) {
        return this.hussarBaseResourceAdapter.listByRoleIds(roleIds);
    }

    public List<SysRoleResource> listByResIdAndRelationSource(Long resourceId, String relationSource) {
        return this.hussarBaseResourceAdapter.listByResIdAndRelationSource(resourceId, relationSource);
    }
}

