/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.dto.OrganTreeDto;
import com.jxdinfo.hussar.authorization.organ.dto.StaffSaveDto;
import com.jxdinfo.hussar.authorization.organ.dto.StruChangeDto;
import com.jxdinfo.hussar.authorization.organ.dto.StruOrganRelationDto;
import com.jxdinfo.hussar.authorization.organ.dto.SysOrganDto;
import com.jxdinfo.hussar.authorization.organ.dto.SysStaffDto;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysEmployeeService;
import com.jxdinfo.hussar.authorization.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.authorization.organ.vo.SysOrganVo;
import com.jxdinfo.hussar.authorization.organ.vo.SysStaffVO;
import com.jxdinfo.hussar.authorization.permit.model.SysStruAssistOrgan;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruAssistOrganService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.mp.base.controller.HussarBaseController;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import com.jxdinfo.hussar.support.security.core.annotation.CheckSafe;
import com.jxdinfo.hussar.utils.TranslateUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/employeeFront"})
public class SysEmployeeFrontController
extends HussarBaseController<SysStru, ISysEmployeeService> {
    @Resource
    private ISysEmployeeService sysEmployeeService;
    @Resource
    private SysOrgManageService orgMaintenanceService;
    @Resource
    ISysStruAssistOrganService iSysStruAssistOrganService;

    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u6811", notes="\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u6811")
    @CheckPermission(value={"employeeFront:employeeTree"})
    @GetMapping(value={"/employeeTree"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u7ba1\u7406", eventDesc="\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> employeeTree(@ApiParam(value="\u7ec4\u7ec7\u6811dto") OrganTreeDto organTreeDto) {
        return ApiResponse.success((Object)this.sysEmployeeService.getEmployeeTreeVue(organTreeDto));
    }

    @ApiOperation(value="\u61d2\u52a0\u8f7d\u4eba\u5458\u90e8\u95e8\u7684\u4e0b\u7ea7\u90e8\u95e8", notes="\u61d2\u52a0\u8f7d\u4eba\u5458\u90e8\u95e8\u7684\u4e0b\u7ea7\u90e8\u95e8")
    @CheckPermission(value={"employeeFront:employeeTree"})
    @GetMapping(value={"/employeeDepTree"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u7ba1\u7406", eventDesc="\u61d2\u52a0\u8f7d\u4eba\u5458\u90e8\u95e8\u7684\u4e0b\u7ea7\u90e8\u95e8", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> employeeDepTree(@ApiParam(value="\u4eba\u5458\u90e8\u95e8id") @RequestParam Long parentId) {
        return ApiResponse.success((Object)this.sysEmployeeService.getEmployeeDepTreeVue(parentId));
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u5458\u5de5\u4fe1\u606f\u5217\u8868", notes="\u83b7\u53d6\u5f53\u524d\u5458\u5de5\u4fe1\u606f\u5217\u8868")
    @CheckPermission(value={"employeeFront:employeeInfo"})
    @GetMapping(value={"/employeeInfoList"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u7ba1\u7406", eventDesc="\u83b7\u53d6\u5f53\u524d\u5458\u5de5\u4fe1\u606f\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @ApiOperationSupport(ignoreParameters={"records", "orders", "total", "optimizeCountSql", "searchCount", "optimizeJoinOfCountSql", "countId", "maxLimit", "pages"})
    public ApiResponse<IPage<SysStaffVO>> employeeInfoList(@ApiParam(value="\u5206\u9875\u4fe1\u606f") Page page, @ApiParam(value="\u4eba\u5458dto") SysStaffDto sysStaffDto) {
        sysStaffDto.setName(sysStaffDto.getName().replace("%", "\\%").replace("_", "\\_"));
        sysStaffDto.setOrganCode(sysStaffDto.getOrganCode().replace("%", "\\%").replace("_", "\\_"));
        return ApiResponse.success((Object)this.sysEmployeeService.getStaffInfoByParentStruId(page, sysStaffDto));
    }

    @Deprecated
    @ApiOperation(value="\u4eba\u5458\u65b0\u589e", notes="\u4eba\u5458\u65b0\u589e")
    @GetMapping(value={"/employeeAdd"})
    @CheckPermission(value={"employeeFront:employeeAdd"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u7ba1\u7406", eventDesc="\u4eba\u5458\u65b0\u589e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<String> orgInfoAdd(@ApiParam(value="organ\u7ec4\u7ec7dto") SysOrganDto sysOrganDto) {
        return ApiResponse.success((String)this.sysEmployeeService.getCurrentCode(sysOrganDto));
    }

    @ApiOperation(value="\u67e5\u770b\u4eba\u5458\u4fe1\u606f", notes="\u67e5\u770b\u4eba\u5458\u4fe1\u606f")
    @CheckPermission(value={"employeeFront:employeeInfo"})
    @GetMapping(value={"/employeeInfo"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u7ba1\u7406", eventDesc="\u67e5\u770b\u4eba\u5458\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<SysOrganVo> employeeInfo(@ApiParam(value="\u4eba\u5458\u7ec4\u7ec7id") @RequestParam Long struId) {
        return ApiResponse.success((Object)this.sysEmployeeService.getEmployeeInfo(struId));
    }

    @ApiOperation(value="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u65b0\u589e\u4fdd\u5b58", notes="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u65b0\u589e\u4fdd\u5b58")
    @CheckPermission(value={"employeeFront:employeeAdd"})
    @PostMapping(value={"/emplInfoSave"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u7ba1\u7406", eventDesc="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u65b0\u589e\u4fdd\u5b58", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse emplInfoSave(@ApiParam(value="\u4eba\u5458\u4fdd\u5b58\u4fee\u6539dto") @RequestBody StaffSaveDto staffSaveDto) {
        this.sysEmployeeService.checkUserInfo((Object)staffSaveDto, "add");
        return this.sysEmployeeService.saveEmployee(staffSaveDto);
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u673a\u6784\u89c4\u5219\u5224\u65ad\u8be5\u7ec4\u7ec7\u673a\u6784\u4e0b\u80fd\u5426\u65b0\u589e\u4eba\u5458", notes="\u6839\u636e\u7ec4\u7ec7\u673a\u6784\u89c4\u5219\u5224\u65ad\u8be5\u7ec4\u7ec7\u673a\u6784\u4e0b\u80fd\u5426\u65b0\u589e\u4eba\u5458")
    @GetMapping(value={"/judgeAddRules"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u7ba1\u7406", eventDesc="\u6839\u636e\u7ec4\u7ec7\u673a\u6784\u89c4\u5219\u5224\u65ad\u8be5\u7ec4\u7ec7\u673a\u6784\u4e0b\u80fd\u5426\u65b0\u589e\u4eba\u5458", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Boolean> judgeAddRules(@ApiParam(value="\u7ec4\u7ec7id") @RequestParam Long struId) {
        return ApiResponse.success((Object)this.sysEmployeeService.judgeAddRules(struId));
    }

    @ApiOperation(value="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u4fee\u6539\u4fdd\u5b58", notes="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u4fee\u6539\u4fdd\u5b58")
    @CheckPermission(value={"employeeFront:emplInfoEditSave"})
    @PostMapping(value={"/emplInfoEditSave"})
    @AuditLog(moduleName="\u4eba\u5458\u7ba1\u7406", eventDesc="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u4fee\u6539\u4fdd\u5b58", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse emplInfoEditSave(@ApiParam(value="\u4eba\u5458\u4fdd\u5b58\u4fee\u6539dto") @RequestBody StaffSaveDto staffSaveDto) {
        this.sysEmployeeService.checkUserInfo((Object)staffSaveDto, "edit");
        return this.sysEmployeeService.updateEmployee(staffSaveDto);
    }

    @ApiOperation(value="\u4eba\u5458\u5220\u9664", notes="\u4eba\u5458\u5220\u9664")
    @CheckPermission(value={"employeeFront:delEmployeeById"})
    @PostMapping(value={"/delEmployeeById"})
    @CheckSafe
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u7ba1\u7406", eventDesc="\u4eba\u5458\u5220\u9664", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse delEmployeeById(@ApiParam(value="\u4eba\u5458id") @RequestBody Long orgId) {
        return this.sysEmployeeService.deleteEmployee(orgId);
    }

    @ApiOperation(value="\u4eba\u5458\u8f6c\u79fb", notes="\u4eba\u5458\u8f6c\u79fb")
    @PostMapping(value={"/staffTransfer"})
    @CheckPermission(value={"employeeFront:staffTransfer"})
    @CacheEvict(value={"data_scope_list", "data_scope_type"}, allEntries=true)
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u7ba1\u7406", eventDesc="\u4eba\u5458\u8f6c\u79fb", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse orgTreeChange(@ApiParam(value="\u4eba\u5458\u8f6c\u79fbdto") @RequestBody StruChangeDto struChangeDto) {
        this.sysEmployeeService.checkUserInfo((Object)struChangeDto, "transfer");
        return this.orgMaintenanceService.orgTreeChangeVue(struChangeDto);
    }

    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u7ec4\u7ec7\u673a\u6784\u4e0b\u7684\u4eba\u5458\u6811", notes="\u83b7\u53d6\u6307\u5b9a\u7ec4\u7ec7\u673a\u6784\u4e0b\u7684\u4eba\u5458\u6811")
    @CheckPermission(value={"employeeFront:employeeTreeById"})
    @GetMapping(value={"/employeeTreeById"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u7ba1\u7406", eventDesc="\u83b7\u53d6\u6307\u5b9a\u7ec4\u7ec7\u673a\u6784\u4e0b\u7684\u4eba\u5458\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> employeeTreeById(@ApiParam(value="\u7ec4\u7ec7\u673a\u6784id") @RequestParam String orgId) {
        return ApiResponse.success((Object)this.sysEmployeeService.getEmployeeTreeById(orgId));
    }

    @ApiOperation(value="\u4eba\u5458\u6570\u636e\u5bfc\u51fa", notes="\u4eba\u5458\u6570\u636e\u5bfc\u51fa")
    @PostMapping(value={"/exportData"})
    @CheckPermission(value={"employeeFront:exportData"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u7ba1\u7406", eventDesc="\u4eba\u5458\u6570\u636e\u5bfc\u51fa", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public void exportData(@ApiParam(value="\u5bfc\u51fa\u4eba\u5458id\u5b57\u7b26\u4e32") @RequestBody String ids, HttpServletResponse response) {
        if (ToolUtil.isEmpty((Object)ids)) {
            throw new BaseException("\u5bfc\u51fa\u4eba\u5458id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<String> idList = Arrays.asList(ids.split(","));
        this.sysEmployeeService.exportDataVue(idList, response);
    }

    @ApiOperation(value="\u4fdd\u5b58\u517c\u804c\u5c97\u4f4d", notes="\u4fdd\u5b58\u517c\u804c\u5c97\u4f4d")
    @PostMapping(path={"/saveOrgan"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u7ba1\u7406", eventDesc="\u4fdd\u5b58\u517c\u804c\u5c97\u4f4d", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse saveOrgan(@ApiParam(value="\u517c\u804c\u5c97\u4f4d\u5173\u7cfb\u5b9e\u4f53") @RequestBody StruOrganRelationDto struOrganRelationDto) {
        this.iSysStruAssistOrganService.saveAssistOrgan(struOrganRelationDto);
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.SAVE_SUCCESS.getMessage()));
    }

    @ApiOperation(value="\u83b7\u53d6\u517c\u4efb\u5c97\u4f4d\u9009\u62e9\u6811", notes="\u83b7\u53d6\u517c\u4efb\u5c97\u4f4d\u9009\u62e9\u6811")
    @GetMapping(path={"/initOrgTree"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u7ba1\u7406", eventDesc="\u83b7\u53d6\u517c\u4efb\u5c97\u4f4d\u9009\u62e9\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> getOrgTree(@ApiParam(value="\u7ec4\u7ec7\u6811dto") OrganTreeDto organTreeDto) {
        return ApiResponse.success((Object)this.iSysStruAssistOrganService.getOrgMergeTree(organTreeDto));
    }

    @ApiOperation(value="\u52a0\u8f7d\u517c\u5bb9\u5c97\u4f4d\u8be6\u60c5\u7684\u89d2\u8272\u6811", notes="\u52a0\u8f7d\u517c\u5bb9\u5c97\u4f4d\u8be6\u60c5\u7684\u89d2\u8272\u6811")
    @GetMapping(value={"/getAssistOrganTree"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u7ba1\u7406", eventDesc="\u52a0\u8f7d\u517c\u5bb9\u5c97\u4f4d\u8be6\u60c5\u7684\u89d2\u8272\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> getAssistOrganTree(@ApiParam(value="\u517c\u4efb\u5c97\u4f4dids") @RequestParam String assistOrganIds, @ApiParam(value="\u7ec4\u7ec7\u6811dto") OrganTreeDto organTreeDto) {
        String[] ids = assistOrganIds == null ? "".split(",") : assistOrganIds.split(",");
        return ApiResponse.success((Object)this.iSysStruAssistOrganService.getAssistOrganTree(ids, organTreeDto));
    }

    @ApiOperation(value="\u83b7\u53d6\u4eba\u5458\u7684\u5173\u8054\u5c97\u4f4d", notes="\u83b7\u53d6\u4eba\u5458\u7684\u5173\u8054\u5c97\u4f4d")
    @GetMapping(value={"/getAssistOrgan"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u7ba1\u7406", eventDesc="\u83b7\u53d6\u4eba\u5458\u7684\u5173\u8054\u5c97\u4f4d", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysStruAssistOrgan>> assistOrgan(@ApiParam(value="\u4eba\u5458\u7ec4\u7ec7id") @RequestParam String struId) {
        return ApiResponse.success((Object)this.iSysStruAssistOrganService.getAssistOrgan(Long.valueOf(Long.parseLong(struId))));
    }
}

