/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.bspinterface.service.ISysRoleEventService;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysLoginUserIdentityMapper;
import com.jxdinfo.hussar.authorization.permit.factory.UserRoleExpandFactory;
import com.jxdinfo.hussar.authorization.permit.manager.UserIdentityManager;
import com.jxdinfo.hussar.authorization.permit.model.SysLoginUserIdentity;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserRoleExcludeService;
import com.jxdinfo.hussar.authorization.permit.service.ISysConfRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.util.GradeAdminUtil;
import com.jxdinfo.hussar.authorization.permit.vo.UserOrganPostVo;
import com.jxdinfo.hussar.authorization.post.dao.SysPostMapper;
import com.jxdinfo.hussar.base.cloud.dto.ResourceGrantedAuthority;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.security.core.dto.LoginUserAuthorizationDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.permit.manager.impl.userIdentityManagerImpl")
public class UserIdentityManagerImpl
implements UserIdentityManager {
    @Resource
    private SysLoginUserIdentityMapper sysLoginUserIdentityMapper;
    @Resource
    private SysPostMapper sysPostMapper;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private ISysRoleEventService sysRoleEventService;
    @Resource
    private ISysRolesService sysRolesService;
    @Resource
    private ISysUserRoleService sysUserRoleService;
    @Resource
    private IHussarBaseUserRoleExcludeService hussarBaseUserRoleExcludeService;
    @Resource
    private ISysConfRolesService sysConfRolesService;
    @Resource
    private ISysResourcesService sysResourcesService;

    @Override
    public LoginUserAuthorizationDTO generateUserLatestAuthorization(Long userId, Long appId) {
        LoginUserAuthorizationDTO loginUserAuthorizationDTO = new LoginUserAuthorizationDTO();
        loginUserAuthorizationDTO.setUserId(userId);
        SysLoginUserIdentity loginUserIdentity = (SysLoginUserIdentity)this.sysLoginUserIdentityMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysLoginUserIdentity::getUserId, (Object)userId));
        if (HussarUtils.isEmpty((Object)loginUserIdentity)) {
            return loginUserAuthorizationDTO;
        }
        List<Long> roleIds = this.getRoleIds(userId, appId, loginUserIdentity);
        loginUserAuthorizationDTO.setRoleIds(roleIds);
        if (HussarUtils.isNotEmpty(roleIds)) {
            ResourceGrantedAuthority resourceGrantedAuthority = this.sysResourcesService.getPermissionByRoleIds(roleIds);
            List grantAuthorityList = resourceGrantedAuthority.getGrantAuthorityList();
            loginUserAuthorizationDTO.setPermissions(grantAuthorityList);
        }
        HashMap<String, Boolean> extendMap = new HashMap<String, Boolean>();
        extendMap.put("gradeAdmin", GradeAdminUtil.judgeGradeAdminByRoles(roleIds).getGradeAdmin());
        loginUserAuthorizationDTO.setExtendMap(extendMap);
        return loginUserAuthorizationDTO;
    }

    @Override
    public Set<String> getPermissionByUserId(Long userId) {
        SysLoginUserIdentity loginUserIdentity = (SysLoginUserIdentity)this.sysLoginUserIdentityMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysLoginUserIdentity::getUserId, (Object)userId));
        if (HussarUtils.isEmpty((Object)loginUserIdentity)) {
            return new HashSet<String>();
        }
        List<Long> roleIds = this.getRoleIds(userId, 1L, loginUserIdentity);
        if (HussarUtils.isEmpty(roleIds)) {
            return new HashSet<String>();
        }
        ResourceGrantedAuthority resourceGrantedAuthority = this.sysResourcesService.getPermissionByRoleIds(roleIds);
        List grantAuthorityList = resourceGrantedAuthority.getGrantAuthorityList();
        return new HashSet<String>(grantAuthorityList);
    }

    private List<Long> getRoleIds(Long userId, Long appId, SysLoginUserIdentity loginUserIdentity) {
        Long postId = loginUserIdentity.getPostId();
        Long deptId = loginUserIdentity.getStruId();
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(userId);
        List<UserOrganPostVo> struList = this.sysStruMapper.getStruIdByUserIds(userIds);
        List<UserOrganPostVo> postList = this.sysPostMapper.getPostIdByUserIds(userIds);
        List struIds = struList.stream().map(UserOrganPostVo::getStruId).collect(Collectors.toList());
        List postIds = postList.stream().map(UserOrganPostVo::getPostId).collect(Collectors.toList());
        List directRelateRoles = this.sysUserRoleService.getRolesByUserIdAndAppId(userId, appId);
        ArrayList<Long> newStruIds = new ArrayList<Long>();
        if (HussarUtils.isNotEmpty((Object)deptId) && struIds.contains(deptId)) {
            newStruIds.add(deptId);
        }
        ArrayList<Long> newPostIds = new ArrayList<Long>();
        if (HussarUtils.isNotEmpty((Object)postId) && postIds.contains(postId)) {
            newPostIds.add(postId);
        }
        List<Long> businessRoles = this.getBusinessRoles(userId, newStruIds, newPostIds, appId);
        directRelateRoles.addAll(businessRoles);
        this.hussarBaseUserRoleExcludeService.getFilteredRoleIds(userId, directRelateRoles);
        List roleIds = this.sysConfRolesService.getNoConfRoles(userId, directRelateRoles);
        return roleIds.stream().distinct().collect(Collectors.toList());
    }

    private List<Long> getBusinessRoles(Long userId, List<Long> struIds, List<Long> postIds, Long appId) {
        List roles;
        List sourceRoles;
        HashMap<String, List<Long>> map = new HashMap<String, List<Long>>();
        if (HussarUtils.isNotEmpty(struIds)) {
            map.put("stru", struIds);
        }
        if (HussarUtils.isNotEmpty(postIds)) {
            map.put("post", postIds);
        }
        this.fillOtherBusiness(userId, map);
        if (HussarUtils.isNotEmpty(map) && HussarUtils.isNotEmpty((Object)(sourceRoles = UserRoleExpandFactory.getRolesByBusiness(map))) && HussarUtils.isNotEmpty((Object)(roles = this.sysRolesService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysRoles::getId, (Collection)sourceRoles)).eq(SysRoles::getAppId, (Object)appId))))) {
            return roles.stream().map(SysRoles::getId).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private void fillOtherBusiness(Long userId, Map<String, List<Long>> map) {
        this.sysRoleEventService.fillMapByUserId(userId, map);
    }
}

