/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.manager.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.permit.dao.SysResourcesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleResourceAuditMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRolesMapper;
import com.jxdinfo.hussar.authorization.permit.dto.QueryAuditResDto;
import com.jxdinfo.hussar.authorization.permit.manager.QueryResourceRoleAuditManager;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.vo.ResourceRoleAuditVo;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.permit.manager.impl.queryResourceRoleAuditManagerImpl")
public class QueryResourceRoleAuditManagerImpl
implements QueryResourceRoleAuditManager {
    @Resource
    private SysResourcesMapper sysResourcesMapper;
    @Resource
    private SysRolesMapper sysRolesMapper;
    @Resource
    private SysRoleResourceAuditMapper sysRoleResourceAuditMapper;

    @Override
    public Page<ResourceRoleAuditVo> queryResourceRoleAuditList(PageInfo pageInfo, QueryAuditResDto queryAuditResDto) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        queryParams.put("roleName", SqlQueryUtil.transferSpecialChar((String)queryAuditResDto.getRoleName()));
        queryParams.put("resourceName", SqlQueryUtil.transferSpecialChar((String)queryAuditResDto.getResourceName()));
        if (HussarUtils.isNotEmpty((Object)queryAuditResDto.getAuditStatus())) {
            queryParams.put("auditStatus", queryAuditResDto.getAuditStatus());
        }
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        List list = this.sysResourcesMapper.selectList(null);
        List rolesList = this.sysRolesMapper.selectList(null);
        if (HussarUtils.isEmpty((Object)list) || HussarUtils.isEmpty((Object)rolesList)) {
            return page;
        }
        List resIds = list.stream().map(SysResources::getId).collect(Collectors.toList());
        List roleIds = rolesList.stream().map(SysRoles::getId).collect(Collectors.toList());
        queryParams.put("resourceIds", resIds);
        queryParams.put("roleIds", roleIds);
        List<ResourceRoleAuditVo> auditVoList = this.sysRoleResourceAuditMapper.queryResRoleAuditList((Page<ResourceRoleAuditVo>)page, queryParams);
        page.setRecords(auditVoList);
        return page;
    }
}

