/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.jxdinfo.hussar.authorization.permit.dto.DataRightsDto;
import com.jxdinfo.hussar.authorization.permit.dto.DeleteDataRightDto;
import com.jxdinfo.hussar.authorization.permit.manager.AddDataRightManager;
import com.jxdinfo.hussar.authorization.permit.manager.DeleteDataRightManager;
import com.jxdinfo.hussar.authorization.permit.manager.DeleteRoleStruRightManager;
import com.jxdinfo.hussar.authorization.permit.manager.QueryDataRightManager;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseDataRightsService;
import com.jxdinfo.hussar.authorization.permit.service.impl.RoleUserAuthorizationChangeReporter;
import com.jxdinfo.hussar.authorization.permit.vo.DataScopeTypeVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.authorization.permit.service.impl.hussarBaseDataRightServiceImpl")
public class HussarBaseDataRightServiceImpl
implements IHussarBaseDataRightsService {
    @Autowired
    private AddDataRightManager addDataRightManager;
    @Autowired
    private QueryDataRightManager queryDataRightManager;
    @Autowired
    private DeleteDataRightManager deleteDataRightManager;
    @Autowired
    private DeleteRoleStruRightManager deleteRoleStruRightManager;
    @Autowired
    private RoleUserAuthorizationChangeReporter userAuthorizationChangeReporter;

    @HussarTransactional
    public ApiResponse saveOrUpdateDataRight(List<DataRightsDto> dataRightsDtoList) {
        if (HussarUtils.isEmpty(dataRightsDtoList)) {
            return ApiResponse.success();
        }
        boolean saveDataRight = this.addDataRightManager.saveOrUpdateDataRight(dataRightsDtoList);
        ArrayList<Long> roleIdList = new ArrayList<Long>();
        roleIdList.add(dataRightsDtoList.get(0).getDataRightInfo().getRoleId());
        this.queryDataRightManager.saveDataRightCacheByRoleIds(roleIdList);
        this.userAuthorizationChangeReporter.report(new Object[]{"roleBatch", roleIdList});
        return ApiResponse.success((Object)saveDataRight);
    }

    public ApiResponse deleteDataRight(DeleteDataRightDto deleteDataRightDto) {
        if (HussarUtils.isEmpty((Object)deleteDataRightDto.getDataRightId())) {
            return ApiResponse.success();
        }
        this.deleteDataRightManager.deleteDataRightByidList(deleteDataRightDto.getDataRightId());
        this.deleteRoleStruRightManager.deleteCustomStruBatch(deleteDataRightDto.getDataRightId());
        ArrayList<Long> roleIdList = new ArrayList<Long>();
        roleIdList.add(deleteDataRightDto.getRoleId());
        this.queryDataRightManager.saveDataRightCacheByRoleIds(roleIdList);
        this.userAuthorizationChangeReporter.report(new Object[]{"roleBatch", roleIdList});
        return ApiResponse.success();
    }

    public List<DataScopeTypeVo> getScopeTypeList(String resTypeCode) {
        return this.queryDataRightManager.getScopeTypeList(resTypeCode);
    }
}

