/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.manager.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.permit.dao.SysResourceExpandAuditMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysResourceExpandMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysResourceTypeExpandMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysResourceTypeMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysResourcesAuditMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysResourcesMapper;
import com.jxdinfo.hussar.authorization.permit.dto.QueryAuditResDto;
import com.jxdinfo.hussar.authorization.permit.manager.QueryResourceAuditManager;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceExpand;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceExpandAudit;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceType;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceTypeExpand;
import com.jxdinfo.hussar.authorization.permit.model.SysResourcesAudit;
import com.jxdinfo.hussar.authorization.permit.vo.AuditResourceData;
import com.jxdinfo.hussar.authorization.permit.vo.AuditResourceDetailVo;
import com.jxdinfo.hussar.authorization.permit.vo.OptionVo;
import com.jxdinfo.hussar.authorization.permit.vo.ResTypeExpandVo;
import com.jxdinfo.hussar.authorization.permit.vo.ResourceAuditVo;
import com.jxdinfo.hussar.authorization.permit.vo.ResourceExpandVo;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.permit.manager.impl.queryResourceAuditManagerImpl")
public class QueryResourceAuditManagerImpl
implements QueryResourceAuditManager {
    @Resource
    private SysResourcesMapper sysResourcesMapper;
    @Resource
    private SysResourcesAuditMapper sysResourcesAuditMapper;
    @Resource
    private SysResourceTypeMapper sysResourceTypeMapper;
    @Resource
    private SysResourceTypeExpandMapper sysResourceTypeExpandMapper;
    @Resource
    private SysResourceExpandMapper sysResourceExpandMapper;
    @Resource
    private SysResourceExpandAuditMapper sysResourceExpandAuditMapper;

    @Override
    public Page<ResourceAuditVo> resourceAuditList(PageInfo pageInfo, QueryAuditResDto queryAuditResDto) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        queryParams.put("resourceName", SqlQueryUtil.transferSpecialChar((String)queryAuditResDto.getResourceName()));
        if (HussarUtils.isNotEmpty((Object)queryAuditResDto.getAuditStatus())) {
            queryParams.put("auditStatus", queryAuditResDto.getAuditStatus());
        }
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        List<ResourceAuditVo> auditPostVos = this.sysResourcesAuditMapper.queryResAuditList((Page<ResourceAuditVo>)page, queryParams);
        page.setRecords(auditPostVos);
        return page;
    }

    @Override
    public AuditResourceDetailVo getResourceAuditDetail(Long auditId) {
        AuditResourceDetailVo detailVo = new AuditResourceDetailVo();
        AuditResourceData newData = detailVo.getNewData();
        AuditResourceData oldData = detailVo.getOldData();
        SysResourcesAudit sysResourcesAudit = (SysResourcesAudit)this.sysResourcesAuditMapper.selectById(auditId);
        AssertUtil.isNotNull((Object)sysResourcesAudit, (String)"\u672a\u67e5\u8be2\u5230\u8d44\u6e90\u5ba1\u6838\u4fe1\u606f");
        String operateType = sysResourcesAudit.getOperateType();
        if ("1".equals(operateType)) {
            newData = this.sysResourcesAuditMapper.getResourceAuditDetail(auditId);
            ArrayList<ResourceExpandVo> resourceExpandVos = new ArrayList<ResourceExpandVo>();
            this.initResExtendAuditData(newData.getResTypeId(), sysResourcesAudit.getResourceId(), resourceExpandVos);
            newData.setResourceExpands(resourceExpandVos);
        } else if ("2".equals(operateType)) {
            newData = this.sysResourcesAuditMapper.getResourceAuditDetail(auditId);
            ArrayList<ResourceExpandVo> resourceExpandAuditVos = new ArrayList<ResourceExpandVo>();
            this.initResExtendAuditData(newData.getResTypeId(), sysResourcesAudit.getResourceId(), resourceExpandAuditVos);
            newData.setResourceExpands(resourceExpandAuditVos);
            oldData = this.sysResourcesMapper.getResourceDataById(sysResourcesAudit.getResourceId());
            ArrayList<ResourceExpandVo> resourceExpandVos = new ArrayList<ResourceExpandVo>();
            this.initResExtendData(oldData.getResTypeId(), sysResourcesAudit.getResourceId(), resourceExpandVos);
            oldData.setResourceExpands(resourceExpandVos);
        } else if ("3".equals(operateType)) {
            oldData = this.sysResourcesMapper.getResourceDataById(sysResourcesAudit.getResourceId());
            ArrayList<ResourceExpandVo> resourceExpandVos = new ArrayList<ResourceExpandVo>();
            this.initResExtendData(oldData.getResTypeId(), sysResourcesAudit.getResourceId(), resourceExpandVos);
            oldData.setResourceExpands(resourceExpandVos);
        }
        detailVo.setNewData(newData);
        detailVo.setOldData(oldData);
        return detailVo;
    }

    private void initResExtendAuditData(String resTypeId, Long resourceId, List<ResourceExpandVo> resourceExpandVos) {
        SysResourceType resourceType = (SysResourceType)this.sysResourceTypeMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysResourceType::getResourceTypeCode, (Object)resTypeId));
        if (HussarUtils.isNotEmpty((Object)resourceType) && !HussarUtils.equals((Object)1, (Object)resourceType.getIsSys())) {
            List<ResTypeExpandVo> resTypeExpandVos = this.getExpandListByResTypeId(resourceType.getId());
            List resourceExpands = this.sysResourceExpandAuditMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysResourceExpandAudit::getResourceId, (Object)resourceId)).eq(SysResourceExpandAudit::getAuditStatus, (Object)"0"));
            List<Object> expandIds = new ArrayList();
            if (HussarUtils.isNotEmpty((Object)resourceExpands)) {
                for (SysResourceExpandAudit resourceExpand : resourceExpands) {
                    ResourceExpandVo vo = new ResourceExpandVo();
                    BeanUtils.copyProperties((Object)resourceExpand, (Object)vo);
                    vo.setExpandId(null);
                    resourceExpandVos.add(vo);
                }
                expandIds = resourceExpands.stream().map(SysResourceExpandAudit::getResourceTypeExpandId).collect(Collectors.toList());
            }
            ArrayList finalExpandIds = expandIds;
            List notRelateExpands = resTypeExpandVos.stream().filter(r -> !finalExpandIds.contains(Long.parseLong(r.getId()))).collect(Collectors.toList());
            if (HussarUtils.isNotEmpty(notRelateExpands) && HussarUtils.isNotEmpty(resourceExpandVos)) {
                for (ResTypeExpandVo vo : notRelateExpands) {
                    ResourceExpandVo expandVo = new ResourceExpandVo();
                    expandVo.setResourceId(resourceId);
                    expandVo.setResourceTypeExpandCode(vo.getExpandCode());
                    expandVo.setResourceTypeExpandName(vo.getExpandName());
                    expandVo.setResourceTypeExpandId(Long.valueOf(Long.parseLong(vo.getId())));
                    resourceExpandVos.add(expandVo);
                }
            }
        }
    }

    private void initResExtendData(String resTypeId, Long resourceId, List<ResourceExpandVo> resourceExpandVos) {
        SysResourceType resourceType = (SysResourceType)this.sysResourceTypeMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysResourceType::getResourceTypeCode, (Object)resTypeId));
        if (HussarUtils.isNotEmpty((Object)resourceType) && !HussarUtils.equals((Object)1, (Object)resourceType.getIsSys())) {
            List<ResTypeExpandVo> resTypeExpandVos = this.getExpandListByResTypeId(resourceType.getId());
            List resourceExpands = this.sysResourceExpandMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysResourceExpand::getResourceId, (Object)resourceId));
            List<Object> expandIds = new ArrayList();
            if (HussarUtils.isNotEmpty((Object)resourceExpands)) {
                for (SysResourceExpand resourceExpand : resourceExpands) {
                    ResourceExpandVo vo = new ResourceExpandVo();
                    BeanUtils.copyProperties((Object)resourceExpand, (Object)vo);
                    vo.setExpandId(null);
                    resourceExpandVos.add(vo);
                }
                expandIds = resourceExpands.stream().map(SysResourceExpand::getResourceTypeExpandId).collect(Collectors.toList());
            }
            ArrayList finalExpandIds = expandIds;
            List notRelateExpands = resTypeExpandVos.stream().filter(r -> !finalExpandIds.contains(Long.parseLong(r.getId()))).collect(Collectors.toList());
            if (HussarUtils.isNotEmpty(notRelateExpands) && HussarUtils.isNotEmpty(resourceExpandVos)) {
                for (ResTypeExpandVo vo : notRelateExpands) {
                    ResourceExpandVo expandVo = new ResourceExpandVo();
                    expandVo.setResourceId(resourceId);
                    expandVo.setResourceTypeExpandCode(vo.getExpandCode());
                    expandVo.setResourceTypeExpandName(vo.getExpandName());
                    expandVo.setResourceTypeExpandId(Long.valueOf(Long.parseLong(vo.getId())));
                    resourceExpandVos.add(expandVo);
                }
            }
        }
    }

    private List<ResTypeExpandVo> getExpandListByResTypeId(Long id) {
        List resourceTypeExpands = this.sysResourceTypeExpandMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysResourceTypeExpand::getResourceTypeId, (Object)id));
        if (HussarUtils.isEmpty((Object)resourceTypeExpands)) {
            return Collections.emptyList();
        }
        ArrayList<ResTypeExpandVo> expandVos = new ArrayList<ResTypeExpandVo>();
        for (SysResourceTypeExpand resourceTypeExpand : resourceTypeExpands) {
            ResTypeExpandVo vo = new ResTypeExpandVo();
            BeanUtils.copyProperties((Object)resourceTypeExpand, (Object)vo);
            vo.setId(resourceTypeExpand.getId().toString());
            String options = resourceTypeExpand.getExpandOptions();
            if (HussarUtils.isNotBlank((CharSequence)options)) {
                List optionVos = JSON.parseArray((String)options, OptionVo.class);
                vo.setExpandOptions(optionVos);
            }
            vo.setResourceTypeId(String.valueOf(id));
            expandVos.add(vo);
        }
        return expandVos;
    }
}

