/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.controller;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.authorization.menu.service.ISysMenuManageBoService;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganTypeBoService;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganizationBoService;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseStaffBoService;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseSysStruBoService;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseResourceService;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysConfRoleSetBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionModulesBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourceMosulesBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourceTypeBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleGroupBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesExternalService;
import com.jxdinfo.hussar.authorization.post.service.IHussarBasePostBoService;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.platform.cloud.support.transdict.feign.RemoteTransDictService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.map.MapUtil;
import io.swagger.annotations.Api;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5b57\u5178\u7ffb\u8bd1feign\u5b9e\u73b0"})
@ConditionalOnExpression(value="${hussar.core.enable-micro-service:false}")
public class RemoteHussarTransController
implements RemoteTransDictService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteHussarTransController.class);
    @Resource
    private IHussarBaseOrganizationBoService organizationBoService;
    @Resource
    private IHussarBaseSysStruBoService hussarBaseSysStruBoService;
    @Resource
    private IHussarBaseStaffBoService staffBoService;
    @Resource
    private IHussarBaseUserBoService userBoService;
    @Resource
    private ISysDicRefService dicRefService;
    @Resource
    private ISysMenuManageBoService sysMenuManageBoService;
    @Resource
    private ISysFunctionsBoService sysFunctionsBoService;
    @Resource
    private IHussarBasePostBoService postBoService;
    @Resource
    private ISysResourceTypeBoService resourceTypeBoService;
    @Resource
    private ISysRolesExternalService sysRolesExternalService;
    @Resource
    private IHussarBaseOrganTypeBoService hussarBaseOrganTypeBoService;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private ISysFunctionModulesBoService sysFunctionModulesBoService;
    @Resource
    private ISysRoleGroupBoService sysRoleGroupBoService;
    @Resource
    private ISysResourceMosulesBoService sysResourceMosulesBoService;
    @Resource
    private IHussarBaseResourceService resourceService;
    @Resource
    private ISysConfRoleSetBoService sysConfRoleSetBoServic;
    private static String TRANSLATE_ORGANIZATION = "TranslateOrganization";
    private static String TRANSLATE_STAFF = "TranslateStaff";
    private static String TRANSLATE_STRU = "TranslateStru";
    private static String TRANSLATE_USER = "TranslateUser";
    private static String TRANSLATE_DICT = "TranslateDict";
    private static String TRANSLATE_FUNCTION = "TranslateFunction";
    private static String TRANSLATE_FUNCTION_MODULE = "TranslateFunctionModule";
    private static String TRANSLATE_MENU = "TranslateMenu";
    private static String TRANSLATE_POST = "TranslatePost";
    private static String TRANSLATE_RESOURCE_TYPE = "TranslateResourceType";
    private static String TRANSLATE_DICT_SINGLE = "TranslateDictSingle";
    private static String TRANSLATE_ORGAN_STRU = "TranslateOrganStru";
    private static String TRANSLATE_ROLE = "TranslateRole";
    private static String TRANSLATE_ORGAN_TYPE = "TranslateOrganType";
    private static String TRANSLATE_RESOURCE_MODULE = "TranslateResourceModule";
    private static String TRANSLATE_RESOURCES = "TranslateResources";
    private static String TRANSLATE_ROLE_GROUP = "TranslateRoleGroup";
    private static String TRANSLATE_CONF_ROLE_SET = "TranslateConfRoleSet";

    public Object getById(Map<String, Object> map) {
        LOGGER.info("getById\uff1a{}", (Object)JSON.toJSONString(map));
        String namespace = (String)map.get("namespace");
        Long id = HussarUtils.toLong((Object)map.get("id"));
        if (TRANSLATE_ORGANIZATION.equals(namespace)) {
            return this.organizationBoService.findOrganizationById(id);
        }
        if (TRANSLATE_USER.equals(namespace)) {
            return this.userBoService.getUserAndStaffInfo(id);
        }
        if (TRANSLATE_STAFF.equals(namespace)) {
            return this.staffBoService.findStaffByStaffId(id);
        }
        if (TRANSLATE_STRU.equals(namespace)) {
            return this.hussarBaseSysStruBoService.findStruById(id);
        }
        if (TRANSLATE_FUNCTION.equals(namespace)) {
            return this.sysFunctionsBoService.getOneById(id);
        }
        if (TRANSLATE_MENU.equals(namespace)) {
            return this.sysMenuManageBoService.getMenuById(id);
        }
        if (TRANSLATE_POST.equals(namespace)) {
            return this.postBoService.findPostById(id);
        }
        if (TRANSLATE_RESOURCE_TYPE.equals(namespace)) {
            return this.resourceTypeBoService.getResourceTypeById(id);
        }
        if (TRANSLATE_ORGAN_STRU.equals(namespace)) {
            return this.hussarBaseSysStruBoService.findOrganByStruId(id);
        }
        if (TRANSLATE_ROLE.equals(namespace)) {
            return this.sysRolesExternalService.getById(id);
        }
        if (TRANSLATE_ORGAN_TYPE.equals(namespace)) {
            return this.hussarBaseOrganTypeBoService.findOrganizationTypeByOrganType(id.toString());
        }
        if (TRANSLATE_DICT_SINGLE.equals(namespace)) {
            return this.sysDicRefService.getDicSingleById(id);
        }
        if (TRANSLATE_FUNCTION_MODULE.equals(namespace)) {
            return this.sysFunctionModulesBoService.getOneById(id);
        }
        if (TRANSLATE_RESOURCE_MODULE.equals(namespace)) {
            return this.sysResourceMosulesBoService.getResourceModulesById(id);
        }
        if (TRANSLATE_RESOURCES.equals(namespace)) {
            return this.resourceService.getResourcesById(id);
        }
        if (TRANSLATE_ROLE_GROUP.equals(namespace)) {
            return this.sysRoleGroupBoService.getRoleGroupInfoById(id);
        }
        if (TRANSLATE_CONF_ROLE_SET.equals(namespace)) {
            return this.sysConfRoleSetBoServic.getSysConfRolesById(id);
        }
        LOGGER.info("getById\u672a\u627e\u5230\u547d\u540d\u7a7a\u95f4\uff0c{}", (Object)namespace);
        return null;
    }

    public <T> List<T> listByMap(Map<String, Object> map) {
        LOGGER.info("listByMap\uff1a{}", (Object)JSON.toJSONString(map));
        String namespace = (String)map.get("namespace");
        if (TRANSLATE_DICT.equals(namespace)) {
            String label = this.dicRefService.getDictLabel((String)map.get("type"), (String)map.get("value"));
            if (label != null) {
                return Collections.singletonList(MapUtil.of((Object)"label", (Object)label));
            }
            return null;
        }
        LOGGER.info("listByMap\u672a\u627e\u5230\u547d\u540d\u7a7a\u95f4\uff0c{}", (Object)namespace);
        return null;
    }
}

