/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.adapter.organ.IHussarBaseOrganizationAdapter;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.dto.QueryAssistPostDto;
import com.jxdinfo.hussar.authorization.organ.dto.QueryStaffDto;
import com.jxdinfo.hussar.authorization.organ.manager.QueryOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.QueryStaffManager;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonQueryOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysOrganType;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.model.SysStruRule;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.authorization.organ.vo.AssistPost;
import com.jxdinfo.hussar.authorization.organ.vo.OrganTreeInitVo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganVo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationTreeVo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationVo;
import com.jxdinfo.hussar.authorization.organ.vo.SimpleOrganVo;
import com.jxdinfo.hussar.authorization.organ.vo.SimpleStaffVo;
import com.jxdinfo.hussar.authorization.organ.vo.StaffInfoVo;
import com.jxdinfo.hussar.authorization.organ.vo.StaffListVo;
import com.jxdinfo.hussar.authorization.organ.vo.StaffPartialVo;
import com.jxdinfo.hussar.authorization.organ.vo.StaffTreeVo;
import com.jxdinfo.hussar.authorization.organ.vo.StaffVo;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaff;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.HussarTreeParser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.transdict.extend.formdesign.TransUtil;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.organ.manager.impl.queryStaffManagerImpl")
public class QueryStaffManagerImpl
extends CommonQueryOrganizationManager
implements QueryStaffManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryStaffManagerImpl.class);
    @Autowired
    private QueryOrganizationManager queryOrganizationManager;
    @Autowired
    private ISysDicRefService dicRefService;
    @Resource
    private IHussarBaseOrganizationAdapter hussarBaseOrganizationAdapter;

    @Override
    public List<StaffTreeVo> lazyLoadingStaffTree(Long parentId) {
        ArrayList<StaffTreeVo> result = new ArrayList<StaffTreeVo>();
        List<StaffTreeVo> data = this.getStaffTree(parentId);
        this.fillStaffPermissions(data);
        result.addAll(data);
        return HussarTreeParser.getTreeList(result);
    }

    @Override
    public Page<StaffListVo> queryStaff(PageInfo pageInfo, QueryStaffDto queryStaffDto) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryOrgParams = new HashMap<String, Object>();
        queryOrgParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        String struFid = "/";
        Long parentStruId = queryStaffDto.getParentId();
        AssertUtil.isNotNull((Object)parentStruId, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_SUP_PARAM.getMessage()));
        boolean isRoot = Objects.equals(Constants.ROOT_NODE_ID, parentStruId);
        if (!isRoot) {
            SysStru pSysStru = (SysStru)Optional.ofNullable(this.sysStruMapper.selectById(parentStruId)).orElse(new SysStru());
            struFid = pSysStru.getStruFid();
        }
        queryOrgParams.put("struLevel", OrganUtil.getSubordinateLevel((String)OrganUtil.convert((String)struFid)));
        queryOrgParams.put("staffName", SqlQueryUtil.transferSpecialChar((String)queryStaffDto.getStaffName()));
        queryOrgParams.put("staffCode", SqlQueryUtil.transferSpecialChar((String)queryStaffDto.getStaffCode()));
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        int gradePLevel = 0;
        if (currentUser.isGradeadmin()) {
            Long deptId = currentUser.getDeptId();
            SysStru gradePSysStru = (SysStru)this.sysStruMapper.selectById(deptId);
            gradePLevel = gradePSysStru.getStruLevel();
            int gradeDepStruLevel = gradePLevel + 1;
            int searchStruLevel = 0;
            if (!isRoot) {
                searchStruLevel = this.sysStruMapper.selectStruLevel(parentStruId);
            }
            if (searchStruLevel < gradeDepStruLevel) {
                struFid = ((SysStru)this.sysStruMapper.selectById(deptId)).getStruFid();
                queryOrgParams.put("struLevel", OrganUtil.getSubordinateLevel((String)OrganUtil.convert((String)struFid)));
            }
        }
        queryOrgParams.put("struFid", OrganUtil.convert((String)struFid));
        List<StaffListVo> data = this.sysStruMapper.queryStaff((Page<StaffListVo>)page, queryOrgParams);
        page.setRecords(data);
        return page;
    }

    @Override
    public List<StaffTreeVo> getOrderStaffTree(Long parentId) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("parentId", parentId);
        ArrayList<StaffTreeVo> result = new ArrayList<StaffTreeVo>();
        List<StaffTreeVo> data = this.sysStruMapper.getStaffByParentId(queryParams);
        StaffTreeVo root = new StaffTreeVo();
        OrganizationTreeVo organizationTreeVo = this.queryOrganizationManager.lazyOrganizationById(parentId);
        root.setStruType(organizationTreeVo.getStruType());
        root.setId(organizationTreeVo.getId());
        root.setHasChildren(organizationTreeVo.getHasChildren());
        root.setLabel(organizationTreeVo.getLabel());
        root.setDisabled(Boolean.valueOf(true));
        root.setIcon(organizationTreeVo.getIcon());
        root.setChildren(data);
        result.add(root);
        return result;
    }

    @Override
    public List<StaffTreeVo> backStaffTree(Long id) {
        List<OrganizationTreeVo> organizations = this.queryOrganizationManager.backOrganizationTree(id);
        return this.convert(organizations);
    }

    private List<StaffTreeVo> convert(List<OrganizationTreeVo> children) {
        ArrayList<StaffTreeVo> list = new ArrayList<StaffTreeVo>();
        if (HussarUtils.isNotEmpty(children)) {
            List<SysStruRule> staffRuleList = this.searchWithStaffRuleList();
            for (OrganizationTreeVo vo : children) {
                StaffTreeVo temp = new StaffTreeVo();
                temp.setDisabled(vo.getDisabled());
                temp.setStruType(vo.getStruType());
                if (HussarUtils.isNotEmpty((Object)vo.getChildren())) {
                    temp.setChildren(this.convert(vo.getChildren()));
                }
                temp.setId(vo.getId());
                temp.setHasChildren(vo.getHasChildren());
                temp.setIcon(vo.getIcon());
                temp.setLabel(vo.getLabel());
                temp.setParentId(vo.getParentId());
                this.fillSingleStaffPermissions(temp, staffRuleList);
                list.add(temp);
            }
        }
        return list;
    }

    @Override
    public StaffPartialVo viewStaff(Long id) {
        StaffPartialVo partialVo = new StaffPartialVo();
        SysStru sysStru = (SysStru)this.sysStruMapper.selectById(id);
        AssertUtil.isNotNull((Object)sysStru, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_SYSSTRU.getMessage()));
        SysOrgan sysOrgan = (SysOrgan)this.sysOrganMapper.selectById(sysStru.getOrganId());
        AssertUtil.isNotNull((Object)sysOrgan, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_SYSORGAN.getMessage()));
        partialVo.setId(sysStru.getId());
        partialVo.setStaffCode(sysOrgan.getOrganCode());
        partialVo.setStaffName(sysOrgan.getOrganName());
        String organFname = sysOrgan.getOrganFname();
        partialVo.setParentName(OrganUtil.getShortParentName((String)organFname));
        String staffPosition = sysStru.getStaffPosition();
        String staffPositionName = this.dicRefService.getDictLabel("staff_position", staffPosition);
        partialVo.setStaffPositionName(staffPositionName);
        SysStaff sysStaff = (SysStaff)this.sysStaffMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysStaff::getStruId, (Object)partialVo.getId()));
        AssertUtil.isNotNull((Object)sysStaff, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_PERSONNEL_INFO.getMessage()));
        partialVo.setAddress(sysStaff.getAddress());
        String sex = sysStaff.getSex();
        String sexName = this.dicRefService.getDictLabel("sex", sex);
        partialVo.setSexName(sexName);
        partialVo.setBirthday(sysStaff.getBirthday());
        partialVo.setIdcard(sysStaff.getIdcard());
        partialVo.setWorkId(sysStaff.getWorkId());
        partialVo.setWorkDate(sysStaff.getWorkDate());
        partialVo.setGraduateDate(sysStaff.getGraduateDate());
        partialVo.setGraduateSchool(sysStaff.getGraduateSchool());
        partialVo.setAssistPosts(this.getAssistPosts(partialVo.getId()));
        return partialVo;
    }

    private List<AssistPost> getAssistPosts(Long id) {
        List<AssistPost> collect = this.sysStruAssistOrganMapper.getAssistPosts(id);
        ArrayList<AssistPost> posts = new ArrayList<AssistPost>();
        if (HussarUtils.isNotEmpty(collect)) {
            for (AssistPost ap : collect) {
                AssistPost temp = new AssistPost();
                temp.setAssistPostId(ap.getAssistPostId());
                temp.setAssistPostName(OrganUtil.getPostName((String)ap.getAssistPostName()));
                posts.add(temp);
            }
        }
        return posts;
    }

    @Override
    public StaffInfoVo loadStaff(Long id) {
        StaffInfoVo infoVo = new StaffInfoVo();
        SysStaff staff = (SysStaff)this.sysStaffMapper.selectById(id);
        AssertUtil.isNotNull((Object)staff, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_PERSONNEL_INFO.getMessage()));
        infoVo.setId(staff.getId());
        infoVo.setStaffCode(staff.getStaffCode());
        infoVo.setStaffName(staff.getName());
        infoVo.setStaffPosition(staff.getStaffPosition());
        String staffPositionName = this.dicRefService.getDictLabel("staff_position", staff.getStaffPosition());
        infoVo.setStaffPositionName(staffPositionName);
        infoVo.setAddress(staff.getAddress());
        infoVo.setSex(staff.getSex());
        String sexName = this.dicRefService.getDictLabel("sex", staff.getSex());
        infoVo.setSexName(sexName);
        infoVo.setBirthday(staff.getBirthday());
        infoVo.setIdcard(staff.getIdcard());
        infoVo.setWorkId(staff.getWorkId());
        infoVo.setWorkDate(staff.getWorkDate());
        infoVo.setGraduateDate(staff.getGraduateDate());
        infoVo.setGraduateSchool(staff.getGraduateSchool());
        List struStaffs = this.sysStruStaffService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruStaff::getStaffId, (Object)id)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
        AssertUtil.isNotEmpty((Collection)struStaffs, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_SYSSTRU.getMessage()));
        List<Long> struIds = struStaffs.stream().map(SysStruStaff::getStruId).collect(Collectors.toList());
        List<OrganVo> organVos = this.sysStruMapper.getOrgansByStruIds(struIds);
        infoVo.setOrganList(organVos);
        return infoVo;
    }

    public List<StaffTreeVo> convertStaff(List<OrganizationTreeVo> organizations) {
        ArrayList<StaffTreeVo> list = new ArrayList<StaffTreeVo>();
        StaffTreeVo temp = null;
        List<SysStruRule> staffRuleList = this.searchWithStaffRuleList();
        for (OrganizationTreeVo vo : organizations) {
            temp = new StaffTreeVo();
            temp.setDisabled(vo.getDisabled());
            temp.setStruType(vo.getStruType());
            List children = vo.getChildren();
            temp.setChildren(this.convertStaff(children));
            temp.setId(vo.getId());
            temp.setHasChildren(vo.getHasChildren());
            temp.setIcon(vo.getIcon());
            temp.setLabel(vo.getLabel());
            temp.setParentId(vo.getParentId());
            this.fillSingleStaffPermissions(temp, staffRuleList);
            list.add(temp);
        }
        return list;
    }

    private List<StaffTreeVo> searchStaffTree(Map<String, Object> queryParams) {
        return this.sysStruMapper.searchStaffTree(queryParams);
    }

    @Override
    public Page<OrganizationVo> loadAssistPostByStaffId(PageInfo pageInfo, QueryAssistPostDto queryAssistPostDto) {
        Long postId;
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryOrgParams = new HashMap<String, Object>();
        queryOrgParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        String struFid = "/";
        Long parentStruId = queryAssistPostDto.getParentId();
        AssertUtil.isNotNull((Object)parentStruId, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_SUP_PARAM.getMessage()));
        boolean isRoot = Objects.equals(Constants.ROOT_NODE_ID, parentStruId);
        if (!isRoot) {
            SysStru pSysStru = (SysStru)Optional.ofNullable(this.sysStruMapper.selectById(parentStruId)).orElse(new SysStru());
            struFid = pSysStru.getStruFid();
        }
        ArrayList<String> organTypesList = new ArrayList<String>();
        organTypesList.add("3");
        queryOrgParams.put("organTypes", organTypesList);
        int level = OrganUtil.getSubordinateLevel((String)OrganUtil.convert((String)struFid));
        queryOrgParams.put("parentStruId", OrganUtil.convert((Long)parentStruId));
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        int gradePLevel = 0;
        if (currentUser.isGradeadmin()) {
            Long deptId = currentUser.getDeptId();
            SysStru gradePSysStru = (SysStru)this.sysStruMapper.selectById(deptId);
            gradePLevel = gradePSysStru.getStruLevel();
            int gradeDepStruLevel = gradePLevel + 1;
            int searchStruLevel = 0;
            if (!isRoot) {
                searchStruLevel = this.sysStruMapper.selectStruLevel(parentStruId);
            }
            if (searchStruLevel < gradeDepStruLevel) {
                struFid = ((SysStru)this.sysStruMapper.selectById(deptId)).getStruFid();
                level = OrganUtil.getSubordinateLevel((String)OrganUtil.convert((String)struFid));
            }
        }
        queryOrgParams.put("struFid", OrganUtil.convert((String)struFid));
        if (HussarUtils.isNotEmpty((Object)queryAssistPostDto.getId())) {
            postId = this.sysStruMapper.getPostByStaffId(queryAssistPostDto.getId());
            if (HussarUtils.isNotEmpty((Object)postId)) {
                ArrayList<Long> excludeIds = new ArrayList<Long>();
                excludeIds.add(postId);
                queryOrgParams.put("excludeIds", excludeIds);
            }
        } else {
            SysStru postStru;
            postId = queryAssistPostDto.getPostId();
            if (HussarUtils.isNotEmpty((Object)postId) && HussarUtils.isNotEmpty((Object)(postStru = (SysStru)this.sysStruMapper.selectById(postId))) && postStru.getStruType().equals("3")) {
                ArrayList<Long> excludeIds = new ArrayList<Long>();
                excludeIds.add(postId);
                queryOrgParams.put("excludeIds", excludeIds);
            }
        }
        queryOrgParams.put("struLevel", level);
        queryOrgParams.put("organCode", StringUtils.trimToEmpty((String)queryAssistPostDto.getOrganCode()));
        queryOrgParams.put("organName", StringUtils.trimToEmpty((String)queryAssistPostDto.getOrganName()));
        List<OrganizationVo> data = this.sysStruMapper.queryOrganization((Page<OrganizationVo>)page, queryOrgParams);
        page.setRecords(data);
        return page;
    }

    @Override
    public List<StaffTreeVo> selectStaffTree(Long parentId) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("parentId", parentId);
        ArrayList<StaffTreeVo> result = new ArrayList<StaffTreeVo>();
        boolean flag = this.createUserConfigService.isUserOnOneEmp();
        if (flag) {
            queryParams.put("userOnOneEmp", "true");
        }
        List<StaffTreeVo> data = this.sysStruMapper.selectStaffTree(queryParams);
        StaffTreeVo root = new StaffTreeVo();
        OrganizationTreeVo organizationTreeVo = this.queryOrganizationManager.lazyOrganizationById(parentId);
        root.setStruType(organizationTreeVo.getStruType());
        root.setId(organizationTreeVo.getId());
        root.setHasChildren(organizationTreeVo.getHasChildren());
        root.setLabel(organizationTreeVo.getLabel());
        root.setDisabled(Boolean.valueOf(true));
        root.setIcon(organizationTreeVo.getIcon());
        root.setChildren(data);
        result.add(root);
        return result;
    }

    @Override
    public List<SysStaff> selectStaffByStruIds(List<Long> struIds) {
        if (HussarUtils.isEmpty(struIds)) {
            return Collections.emptyList();
        }
        return this.sysStaffMapper.selectList((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysStaff::getStruId, struIds));
    }

    @Override
    public Page<SimpleStaffVo> unRelateUserStaffList(PageInfo pageInfo, Long organId, String staffName, Long userId) {
        Page simpleStaffVoPage = HussarPageUtils.convert((PageInfo)pageInfo);
        Long employeeId = null;
        HashMap<String, Object> nameMap = new HashMap<String, Object>();
        nameMap.put("staffName", SqlQueryUtil.transferSpecialChar((String)staffName));
        nameMap.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        if (HussarUtils.isNotEmpty((Object)userId)) {
            SysUsers user = this.sysUsersService.getById(userId);
            employeeId = user.getEmployeeId();
        }
        if (HussarUtils.isNotEmpty((Object)organId)) {
            if (Objects.equals(11L, organId)) {
                return simpleStaffVoPage;
            }
            if (Objects.equals(12L, organId)) {
                return simpleStaffVoPage;
            }
            List<Long> staffIds = this.sysStaffMapper.selectOrganStaffId(organId);
            if (HussarUtils.isNotEmpty(staffIds)) {
                List<SimpleStaffVo> simpleStaffVos = this.sysStaffMapper.unRelateUserStaffList((Page<SimpleStaffVo>)simpleStaffVoPage, staffIds, nameMap, employeeId);
                simpleStaffVoPage.setRecords(simpleStaffVos);
            }
            return simpleStaffVoPage;
        }
        return simpleStaffVoPage;
    }

    @Override
    public Page<StaffVo> list(PageInfo pageInfo, Long organId, String staffName, String staffCode) {
        Page staffVoPage = HussarPageUtils.convert((PageInfo)pageInfo);
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        if (HussarUtils.isNotEmpty((Object)currentUser) && (HussarUtils.equals((Object)Constants.ROOT_NODE_ID, (Object)organId) || HussarUtils.equals((Object)Constants.OUT_STRU_NODE_ID, (Object)organId))) {
            String organProperty = HussarUtils.equals((Object)Constants.ROOT_NODE_ID, (Object)organId) ? "0" : "1";
            if (HussarUtils.isEmpty((Object)(organId = this.queryOrganizationManager.getGradeOrganType(organId, currentUser)))) {
                staffVoPage.setRecords(Collections.emptyList());
                return staffVoPage;
            }
            OrganizationTreeVo organ = this.sysStruMapper.lazyOrganizationById(organId);
            if (HussarUtils.isNotEmpty((Object)organ) && !HussarUtils.equals((Object)organProperty, (Object)organ.getOrganProperty())) {
                staffVoPage.setRecords(Collections.emptyList());
                return staffVoPage;
            }
        }
        if (HussarUtils.isNotEmpty((Object)organId)) {
            String struPath;
            if (Objects.equals(11L, organId)) {
                struPath = "0";
            } else if (Objects.equals(12L, organId)) {
                struPath = "1";
            } else {
                SysStru sysStru = (SysStru)this.sysStruMapper.selectById(organId);
                struPath = sysStru.getStruFid();
            }
            HashMap<String, Object> queryMap = new HashMap<String, Object>();
            queryMap.put("staffName", SqlQueryUtil.transferSpecialChar((String)staffName));
            queryMap.put("staffCode", SqlQueryUtil.transferSpecialChar((String)staffCode));
            queryMap.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
            List<StaffVo> staffVos = this.sysStaffMapper.listNew((Page<StaffVo>)staffVoPage, struPath, queryMap);
            staffVoPage.setRecords(TransUtil.trans(staffVos));
            return staffVoPage;
        }
        throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_ID_EMPTY.getMessage()));
    }

    @Override
    public StaffVo detail(Long staffId) {
        StaffVo staffVo = new StaffVo();
        SysStaff sysStaff = (SysStaff)this.sysStaffService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysStaff::getId, (Object)staffId));
        if (HussarUtils.isNotEmpty((Object)sysStaff)) {
            BeanUtil.copy((Object)sysStaff, (Object)staffVo);
            List<Long> organIds = this.sysStaffMapper.selectStaffOrganById(staffId);
            if (HussarUtils.isNotEmpty(organIds)) {
                List<OrganizationVo> organIdAndName = this.sysStaffMapper.getOrganIdAndName(organIds);
                staffVo.setOrganization(organIdAndName);
            }
            return (StaffVo)TransUtil.trans((Object)staffVo);
        }
        return (StaffVo)TransUtil.trans((Object)staffVo);
    }

    @Override
    public List<SimpleOrganVo> getSimpleOrgan(List<Long> struId) {
        return this.hussarBaseOrganizationAdapter.getSimpleOrgan(struId);
    }

    @Override
    public List<SimpleStaffVo> getByStaffId(List<Long> staffIds) {
        return this.sysStaffMapper.getByStaffId(staffIds);
    }

    @Override
    public Page<StaffVo> organDataAuthorityStaff(PageInfo pageInfo, String staffName, String workId) {
        Page staffVoPage = HussarPageUtils.convert((PageInfo)pageInfo);
        List<StaffVo> staffVos = this.sysStaffMapper.selectPageStaffByNameAndCode((Page<StaffVo>)staffVoPage, staffName, workId, "");
        if (HussarUtils.isNotEmpty(staffVos)) {
            for (StaffVo staffVo : staffVos) {
                List<Long> struId = this.sysStaffMapper.selectStaffOrganById(staffVo.getId());
                if (!HussarUtils.isNotEmpty(struId)) continue;
                List<OrganizationVo> organizationVos = this.sysStaffMapper.getOrganIdAndName(struId);
                staffVo.setOrganization(organizationVos);
            }
        }
        staffVoPage.setRecords(staffVos);
        return staffVoPage;
    }

    @Override
    public SimpleOrganVo getOrderUnifyStaffTree(Long struId) {
        if (HussarUtils.isNotEmpty((Object)struId)) {
            List<Long> staffIds;
            SysOrganType sysOrganType;
            ArrayList<Long> struIds = new ArrayList<Long>();
            struIds.add(struId);
            List simpleOrganVos = this.hussarBaseOrganizationAdapter.getSimpleOrgan(struIds);
            if (HussarUtils.isNotEmpty((Object)simpleOrganVos) && HussarUtils.isNotEmpty((Object)(sysOrganType = (SysOrganType)this.organTypeService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysOrganType::getOrganType, (Object)((SimpleOrganVo)simpleOrganVos.get(0)).getOrganType()))))) {
                ((SimpleOrganVo)simpleOrganVos.get(0)).setIcon(sysOrganType.getImgUrl());
            }
            if (HussarUtils.isNotEmpty(staffIds = this.sysStaffMapper.selectOrganStaffId(struId))) {
                List<SimpleStaffVo> simpleStaffVos = this.sysStaffMapper.getByStaffIdAndStaffName(staffIds, "");
                ((SimpleOrganVo)simpleOrganVos.get(0)).setSimpleStaffVos(simpleStaffVos);
            }
            return (SimpleOrganVo)simpleOrganVos.get(0);
        }
        return new SimpleOrganVo();
    }

    @Override
    public List<OrganTreeInitVo> getStaffsByOrganIdS(List<Long> organIds) {
        List<OrganTreeInitVo> staffs = this.sysStaffMapper.queryStaffsByOrganIds(organIds);
        return staffs;
    }

    @Override
    public List<OrganTreeInitVo> getChildrenStaffsByParentId(Long parentId) {
        return this.sysStaffMapper.queryChildrenStaffsByParentId(parentId);
    }

    @Override
    public List<OrganTreeInitVo> getStaffsLikeName(String searchValue) {
        return this.sysStaffMapper.queryStaffsLikeName(searchValue);
    }

    @Override
    public List<OrganTreeInitVo> getStaffInfoByStaffId(Long staffId) {
        return this.sysStaffMapper.queryStaffInfoByStaffId(staffId);
    }

    @Override
    public List<OrganTreeInitVo> queryUpStaffsByFidAndLevel(String fid, int defaultLevelNum) {
        return this.sysStaffMapper.queryUpStaffsByFidAndLevel(fid, defaultLevelNum);
    }

    @Override
    public List<OrganTreeInitVo> queryBrotherStaffsByParentId(Long parentId) {
        return this.sysStaffMapper.queryBrotherStaffsByParentId(parentId);
    }
}

