/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.relational.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.impl.RoleUserAuthorizationChangeReporter;
import com.jxdinfo.hussar.authorization.post.model.SysPost;
import com.jxdinfo.hussar.authorization.post.service.IHussarBasePostService;
import com.jxdinfo.hussar.authorization.relational.dao.SysPostRoleAuditMapper;
import com.jxdinfo.hussar.authorization.relational.manager.AuditPostRoleManager;
import com.jxdinfo.hussar.authorization.relational.model.SysPostRole;
import com.jxdinfo.hussar.authorization.relational.model.SysPostRoleAudit;
import com.jxdinfo.hussar.authorization.relational.service.ISysPostRoleService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.rolemanager.RolePostChangeNotify;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.relational.manager.impl.auditPostRoleManagerImpl")
public class AuditPostRoleManagerImpl
implements AuditPostRoleManager {
    @Resource
    private SysPostRoleAuditMapper sysPostRoleAuditMapper;
    @Autowired
    private ISysPostRoleService sysPostRoleService;
    @Autowired
    private ISysRolesService sysRolesService;
    @Autowired
    private IHussarBasePostService hussarBasePostService;
    @Autowired
    private RolePostChangeNotify rolePostChangeNotify;
    @Resource
    private RoleUserAuthorizationChangeReporter userAuthorizationChangeReporter;

    @Override
    public Boolean pass(Long auditId) {
        boolean result;
        SysPostRoleAudit postRoleAudit = (SysPostRoleAudit)this.sysPostRoleAuditMapper.selectById(auditId);
        String operateType = postRoleAudit.getOperateType();
        if ("1".equals(operateType)) {
            result = this.doAuditAdd(postRoleAudit);
        } else if ("2".equals(operateType)) {
            result = this.doAuditDelete(postRoleAudit);
        } else {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UNSUPPORTED_OPERATION_TYPE.getMessage()));
        }
        return result;
    }

    @Override
    public Boolean reject(Long auditId) {
        SysPostRoleAudit postRoleAudit = (SysPostRoleAudit)this.sysPostRoleAuditMapper.selectById(auditId);
        postRoleAudit.setAuditStatus("2");
        return this.sysPostRoleAuditMapper.updateById(postRoleAudit) > 0;
    }

    private boolean doAuditDelete(SysPostRoleAudit postRoleAudit) {
        List postRoles = this.sysPostRoleService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysPostRole::getPostId, (Object)postRoleAudit.getPostId())).eq(SysPostRole::getRoleId, (Object)postRoleAudit.getRoleId())).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
        if (HussarUtils.isEmpty((Object)postRoles)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_FAIL_NO_EXIST_POST_ROLE_RELATION.getMessage()));
        }
        boolean remove = this.sysPostRoleService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysPostRole::getPostId, (Object)postRoleAudit.getPostId())).eq(SysPostRole::getRoleId, (Object)postRoleAudit.getRoleId()));
        postRoleAudit.setAuditStatus("1");
        boolean updateFlag = this.sysPostRoleAuditMapper.updateById(postRoleAudit) > 0;
        Long roleId = postRoleAudit.getRoleId();
        SysRoles role = (SysRoles)this.sysRolesService.getById((Serializable)roleId);
        if (HussarUtils.isNotEmpty((Object)role.getAppId()) && role.getAppId() != 1L) {
            this.rolePostChangeNotify.notify(DataChangeType.RELATE, new Object[]{roleId, null});
        }
        if (HussarUtils.isEmpty((Object)role.getAppId()) || role.getAppId() == 1L) {
            ArrayList<Long> postIdList = new ArrayList<Long>();
            postIdList.add(postRoleAudit.getPostId());
            this.userAuthorizationChangeReporter.report(new Object[]{"post", postIdList});
        }
        return remove && updateFlag;
    }

    private boolean doAuditAdd(SysPostRoleAudit postRoleAudit) {
        List postList = this.hussarBasePostService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysPost::getId, (Object)postRoleAudit.getPostId())).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
        if (HussarUtils.isEmpty((Object)postList)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL_NO_EXIST_POST.getMessage()));
        }
        List rolesList = this.sysRolesService.list((Wrapper)new LambdaQueryWrapper().eq(SysRoles::getId, (Object)postRoleAudit.getRoleId()));
        if (HussarUtils.isEmpty((Object)rolesList)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL_ROLE_NOT_EXIST.getMessage()));
        }
        List postRoles = this.sysPostRoleService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysPostRole::getPostId, (Object)postRoleAudit.getPostId())).eq(SysPostRole::getRoleId, (Object)postRoleAudit.getRoleId())).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
        if (HussarUtils.isNotEmpty((Object)postRoles)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL_EXIST_POST_ROLE_RELATION.getMessage()));
        }
        SysPostRole postRole = new SysPostRole();
        postRole.setPostId(postRoleAudit.getPostId());
        postRole.setRoleId(postRoleAudit.getRoleId());
        boolean saveFlag = this.sysPostRoleService.save((Object)postRole);
        postRoleAudit.setAuditStatus("1");
        boolean updateFlag = this.sysPostRoleAuditMapper.updateById(postRoleAudit) > 0;
        Long roleId = postRoleAudit.getRoleId();
        SysRoles role = (SysRoles)this.sysRolesService.getById((Serializable)roleId);
        if (HussarUtils.isNotEmpty((Object)role.getAppId()) && role.getAppId() != 1L) {
            this.rolePostChangeNotify.notify(DataChangeType.RELATE, new Object[]{roleId, null});
        }
        if (HussarUtils.isEmpty((Object)role.getAppId()) || role.getAppId() == 1L) {
            ArrayList<Long> postIdList = new ArrayList<Long>();
            postIdList.add(postRoleAudit.getPostId());
            this.userAuthorizationChangeReporter.report(new Object[]{"post", postIdList});
        }
        return saveFlag && updateFlag;
    }
}

