/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.permit.dao.SysResourceModulesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysResourcesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleResourceMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceModules;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.service.ILocalResourceAdapterService;
import com.jxdinfo.hussar.authorization.permit.service.ILocalResourceModuleAdapterService;
import com.jxdinfo.hussar.authorization.permit.service.ILocalRoleResourceAdapterService;
import com.jxdinfo.hussar.authorization.permit.vo.ElementResourceVo;
import com.jxdinfo.hussar.common.base.HussarBaseServiceImpl;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class LocalResourceAdapterServiceImpl
extends HussarBaseServiceImpl<SysResourcesMapper, SysResources>
implements ILocalResourceAdapterService {
    @Resource
    private SysResourcesMapper sysResourcesMapper;
    @Resource
    private ILocalResourceModuleAdapterService localResourceModuleAdapterService;
    @Resource
    private SysResourceModulesMapper sysResourceModulesMapper;
    @Resource
    private SysRoleResourceMapper sysRoleResourceMapper;
    @Resource
    private ILocalRoleResourceAdapterService localRoleResourceAdapterService;

    public List<String> queryPermissionsByRoleIds(List<Long> roleIds) {
        if (ToolUtil.isNotEmpty(roleIds)) {
            return this.sysResourcesMapper.getPermissionsByRoleIds(roleIds);
        }
        return new ArrayList<String>();
    }

    public Integer getMaxOrderByParentId(Long moduleId) {
        return this.sysResourcesMapper.getMaxOrderByParentId(moduleId);
    }

    public List<SysResourceModules> moduleList(String moduleName, Long parentModuleId, Long appId) {
        if (HussarUtils.isEmpty((Object)appId)) {
            appId = 1L;
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(HussarUtils.isNotBlank((CharSequence)moduleName), SysResourceModules::getModuleName, (Object)moduleName);
        lambdaQueryWrapper.eq(SysResourceModules::getParentModuleId, (Object)parentModuleId);
        lambdaQueryWrapper.eq(SysResourceModules::getApplicationId, (Object)appId);
        lambdaQueryWrapper.orderByAsc(SysResourceModules::getSeq);
        return this.localResourceModuleAdapterService.list((Wrapper)lambdaQueryWrapper);
    }

    public Integer getMaxOrderByParentIdAndAppId(Long moduleId, Long appId) {
        return this.sysResourceModulesMapper.getMaxOrderByParentIdAndAppId(moduleId, appId);
    }

    public List<SysResources> getResourcesByIds(List<Long> roleIdList, String type) {
        return this.sysResourcesMapper.getResourcesByIds(roleIdList, type);
    }

    public List<SysResources> getPageAndElementResources(Long moduleId) {
        if (HussarUtils.isEmpty((Object)moduleId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MODULE_ID_NO_PASSED.getMessage()));
        }
        String[] resTypes = new String[]{"res_menu", "res_element"};
        List<String> typeList = Arrays.asList(resTypes);
        List resources = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysResources::getModuleId, (Object)moduleId)).in(SysResources::getResTypeId, typeList));
        if (HussarUtils.isEmpty((Object)resources)) {
            return Collections.emptyList();
        }
        TranslateUtil.translate((List)resources, SysResources::getNameLangKey, SysResources::setResourceName);
        TranslateUtil.translate((List)resources, SysResources::getAliasLangKey, SysResources::setResourceAlias);
        return resources;
    }

    public List<ElementResourceVo> elementResources(String pagePath, List<Long> roleIds) {
        if (HussarUtils.isBlank((CharSequence)pagePath)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PAGE_ROUTE_NO_PASSED.getMessage()));
        }
        if (HussarUtils.isEmpty(roleIds)) {
            return Collections.emptyList();
        }
        List<SysResources> sysResources = this.sysResourcesMapper.getResourcesByRoleIds(roleIds);
        List resourceIds = sysResources.stream().map(SysResources::getId).distinct().collect(Collectors.toList());
        SysResources resource = null;
        for (SysResources res : sysResources) {
            String serviceName = StringUtil.trimToEmpty((CharSequence)res.getServiceName());
            if (HussarUtils.isNotBlank((CharSequence)serviceName)) {
                serviceName = "/" + serviceName;
            }
            String path = StringUtil.trimToEmpty((CharSequence)res.getPath());
            if (!HussarUtils.equals((Object)pagePath, (Object)(serviceName + path))) continue;
            resource = res;
            break;
        }
        if (HussarUtils.isEmpty(resource)) {
            return Collections.emptyList();
        }
        Long moduleId = resource.getModuleId();
        List<SysResources> resourcesList = this.getPageAndElementResources(moduleId);
        ArrayList<SysResources> resources = new ArrayList<SysResources>();
        resources.add(resource);
        resources = resourcesList.stream().filter(item -> resourceIds.contains(item.getId())).collect(Collectors.toList());
        return this.getElementResourceTree(resources, resource.getId());
    }

    public String getFullModuleNameById(Long moduleId, Long appId) {
        if (HussarUtils.isEmpty((Object)appId)) {
            appId = 1L;
        }
        List allModules = this.sysResourceModulesMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysResourceModules::getApplicationId, (Object)appId));
        Map<Long, SysResourceModules> moduleMap = allModules.stream().collect(Collectors.toMap(SysResourceModules::getId, Function.identity()));
        SysResourceModules module = (SysResourceModules)this.sysResourceModulesMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysResourceModules::getId, (Object)moduleId)).eq(SysResourceModules::getApplicationId, (Object)appId));
        StringBuilder fullName = new StringBuilder();
        this.getFullName(moduleMap, module, fullName);
        return this.toReverseFullName(fullName.toString());
    }

    private String toReverseFullName(String fullName) {
        String[] parts = fullName.split("/");
        List<String> partList = Arrays.asList(parts);
        Collections.reverse(partList);
        return partList.stream().collect(Collectors.joining("/", "/", ""));
    }

    public Map<Long, String> getFullModuleNameMapByName(String moduleName, Long appId) {
        if (HussarUtils.isEmpty((Object)appId)) {
            appId = 1L;
        }
        List allModules = this.sysResourceModulesMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysResourceModules::getApplicationId, (Object)appId));
        Map<Long, SysResourceModules> moduleMap = allModules.stream().collect(Collectors.toMap(SysResourceModules::getId, Function.identity()));
        List modules = this.sysResourceModulesMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysResourceModules::getModuleName, (Object)moduleName)).eq(SysResourceModules::getApplicationId, (Object)appId)).orderByAsc(SysResourceModules::getSeq));
        LinkedHashMap<Long, String> result = new LinkedHashMap<Long, String>();
        for (SysResourceModules module : modules) {
            StringBuilder fullName = new StringBuilder();
            this.getFullName(moduleMap, module, fullName);
            result.put(module.getId(), this.toReverseFullName(fullName.toString()));
        }
        return result;
    }

    private void getFullName(Map<Long, SysResourceModules> moduleMap, SysResourceModules module, StringBuilder fullName) {
        fullName.append(module.getModuleName()).append("/");
        Long parentModuleId = module.getParentModuleId();
        if (!HussarUtils.equals((Object)parentModuleId, (Object)1L)) {
            SysResourceModules parentModule = moduleMap.get(parentModuleId);
            this.getFullName(moduleMap, parentModule, fullName);
        }
    }

    private List<ElementResourceVo> getElementResourceTree(List<SysResources> resourcesList, Long id) {
        LinkedHashMap<Long, ElementResourceVo> map = new LinkedHashMap<Long, ElementResourceVo>();
        ArrayList<ElementResourceVo> resourceVos = new ArrayList<ElementResourceVo>();
        for (SysResources resource : resourcesList) {
            ElementResourceVo vo = new ElementResourceVo();
            if (HussarUtils.equals((Object)"res_menu", (Object)resource.getResTypeId())) {
                String serviceName = resource.getServiceName();
                if (HussarUtils.isNotEmpty((Object)serviceName)) {
                    serviceName = "/" + serviceName;
                    vo.setPageRoleKey(serviceName + resource.getPath());
                } else {
                    vo.setPageRoleKey(resource.getPath());
                }
            } else {
                vo.setPageRoleKey(resource.getPermissions());
            }
            vo.setId(resource.getId());
            vo.setParentId(resource.getParentResourceId());
            map.put(resource.getId(), vo);
            resourceVos.add(vo);
        }
        for (ElementResourceVo item : resourceVos) {
            String permission;
            ElementResourceVo temp = (ElementResourceVo)map.get(HussarUtils.isEmpty((Object)item.getParentId()) ? -1L : item.getParentId());
            if (temp == null) continue;
            if (!this.getIsLastResource(item.getId(), resourceVos)) {
                temp.getChildren().add(item);
                temp.setHasChildren(Boolean.valueOf(true));
            }
            if (HussarUtils.isNotBlank((CharSequence)(permission = StringUtil.trimToEmpty((CharSequence)temp.getPermission())))) {
                permission = permission + ",";
            }
            temp.setPermission(permission + item.getPageRoleKey());
        }
        ArrayList<ElementResourceVo> result = new ArrayList<ElementResourceVo>();
        result.add((ElementResourceVo)map.get(id));
        return result;
    }

    private boolean getIsLastResource(Long id, List<ElementResourceVo> elementResourceVos) {
        for (ElementResourceVo vo : elementResourceVos) {
            if (!HussarUtils.equals((Object)vo.getParentId(), (Object)id)) continue;
            return false;
        }
        return true;
    }

    public List<SysResources> getResourcesByType(String resTypeId, Long appId) {
        return this.sysResourcesMapper.getResourcesByType(resTypeId, appId);
    }
}

