/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.bspinterface.service.ISysRoleEventService;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.dao.SysLoginUserIdentityMapper;
import com.jxdinfo.hussar.authorization.permit.dto.SwitchIdentityDto;
import com.jxdinfo.hussar.authorization.permit.factory.UserRoleExpandFactory;
import com.jxdinfo.hussar.authorization.permit.model.SysLoginUserIdentity;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserRoleExcludeService;
import com.jxdinfo.hussar.authorization.permit.service.ILocalHussarBaseUserIdentityService;
import com.jxdinfo.hussar.authorization.permit.service.ISysConfRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.util.GradeAdminUtil;
import com.jxdinfo.hussar.authorization.permit.vo.SysLoginUserIdentityVo;
import com.jxdinfo.hussar.authorization.permit.vo.UserOrganPostVo;
import com.jxdinfo.hussar.authorization.post.model.SysPost;
import com.jxdinfo.hussar.authorization.post.service.IHussarBasePostService;
import com.jxdinfo.hussar.authorization.relational.dao.SysStruUserMapper;
import com.jxdinfo.hussar.authorization.relational.dao.SysUserPostMapper;
import com.jxdinfo.hussar.authorization.relational.model.SysStruPost;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPost;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruPostService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserService;
import com.jxdinfo.hussar.authorization.relational.service.ISysUserPostService;
import com.jxdinfo.hussar.base.cloud.dto.ResourceGrantedAuthority;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.datasource.properties.HussarDynamicProperties;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import com.jxdinfo.hussar.tenant.common.model.DefaultTenant;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.service.IHussarTenantCommonService;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.authorization.permit.service.impl.localHussarBaseUserIdentityServiceImpl")
public class LocalHussarBaseUserIdentityServiceImpl
extends HussarServiceImpl<SysLoginUserIdentityMapper, SysLoginUserIdentity>
implements ILocalHussarBaseUserIdentityService {
    private static Logger logger = LoggerFactory.getLogger(LocalHussarBaseUserIdentityServiceImpl.class);
    @Resource
    private IHussarBasePostService postService;
    @Resource
    private ISysOrganService organService;
    @Resource
    private ISysConfRolesService sysConfRolesService;
    @Resource
    private ISysStruService sysStruService;
    @Resource
    private ISysUserRoleService sysUserRoleService;
    @Resource
    private SysStruUserMapper sysStruUserMapper;
    @Resource
    private SysUserPostMapper sysUserPostMapper;
    @Autowired
    private ISysUserPostService sysUserPostService;
    @Autowired
    private ISysStruUserService sysStruUserService;
    @Resource
    private ISysRoleEventService sysRoleEventService;
    @Resource
    private IHussarBaseUserRoleExcludeService hussarBaseUserRoleExcludeService;
    @Resource
    private ISysResourcesService sysResourcesService;
    @Autowired
    private ISysStruPostService sysStruPostService;
    @Resource
    private HussarTenantProperties hussarTenantProperties;
    @Autowired(required=false)
    private IHussarTenantCommonService tenantCommonService;
    @Resource
    private HussarDynamicProperties hussarDynamicProperties;
    @Resource
    private ISysRolesService sysRolesService;
    private final String USER_IDENTITY = "user_Identity";

    public UserDetails switchUserIdentity(SwitchIdentityDto switchIdentityDto) {
        Long struId = switchIdentityDto.getStruId();
        Long postId = switchIdentityDto.getPostId();
        if (HussarUtils.isEmpty((Object)struId) && HussarUtils.isEmpty((Object)postId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_AND_POST_ID_NOT_EMPTY_SAME_TIME.getMessage()));
        }
        UserDetails userDetails = switchIdentityDto.getUserDetails();
        HussarCacheUtil.evict((String)"user_Identity", (Object)userDetails.getUserId());
        HussarCacheUtil.evict((String)"hussar_user_cache", (Object)("user_id_" + userDetails.getUserId()));
        if (HussarUtils.isEmpty((Object)userDetails)) {
            userDetails = HussarSecurityUtils.getLoginUserDetails();
        }
        SysLoginUserIdentity userIdentity = (SysLoginUserIdentity)this.getOne((Wrapper)new LambdaQueryWrapper().eq(SysLoginUserIdentity::getUserId, (Object)userDetails.getUserId()));
        if (HussarUtils.isNotEmpty((Object)struId)) {
            userIdentity.setStruId(struId);
        }
        userIdentity.setPostId(postId);
        this.updateById((BaseEntity)userIdentity);
        userDetails = this.handleUserIdentity(userDetails, switchIdentityDto.getAppId());
        HussarCacheUtil.evictKeysLike((String)"menu_info", (String)("hussar_menus:" + userDetails.getUserId()));
        HussarCacheUtil.evictKeysLike((String)"resource_info", (String)("hussar_resource:" + userDetails.getUserId()));
        return userDetails;
    }

    public List<UserOrganPostVo> getUserOrganPost(Long userId) {
        List<UserOrganPostVo> postVos = this.sysUserPostMapper.getPostByUserId(userId);
        List<UserOrganPostVo> organVos = this.sysStruUserMapper.getOrganByUserId(userId);
        if (HussarUtils.isEmpty(postVos)) {
            return organVos;
        }
        if (HussarUtils.isEmpty(organVos)) {
            return postVos;
        }
        List struIds = organVos.stream().map(UserOrganPostVo::getStruId).collect(Collectors.toList());
        List postIds = postVos.stream().map(UserOrganPostVo::getPostId).collect(Collectors.toList());
        List struPosts = this.sysStruPostService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStruPost::getStruId, struIds)).in(SysStruPost::getPostId, postIds));
        Map<Object, Object> map = new HashMap();
        if (HussarUtils.isNotEmpty((Object)struPosts)) {
            map = struPosts.stream().collect(Collectors.groupingBy(SysStruPost::getPostId, Collectors.mapping(SysStruPost::getStruId, Collectors.toList())));
        }
        ArrayList<UserOrganPostVo> result = new ArrayList<UserOrganPostVo>();
        boolean hasCommonPost = false;
        for (UserOrganPostVo postVo : postVos) {
            List<Object> struVos;
            if (HussarUtils.isEmpty((Object)postVo.getOrganTypeCode())) {
                hasCommonPost = true;
                struVos = organVos;
            } else {
                if (HussarUtils.isEmpty(map) || HussarUtils.isEmpty((Object)map.get(postVo.getPostId()))) continue;
                List relateOrganIds = (List)map.get(postVo.getPostId());
                struVos = organVos.stream().filter(o -> relateOrganIds.contains(o.getStruId())).collect(Collectors.toList());
            }
            for (UserOrganPostVo organVo : struVos) {
                UserOrganPostVo vo = new UserOrganPostVo();
                vo.setUserId(userId);
                vo.setStruId(organVo.getStruId());
                vo.setOrganName(organVo.getOrganName());
                vo.setOrganFname(organVo.getOrganFname());
                vo.setPostId(postVo.getPostId());
                vo.setPostName(postVo.getPostName());
                result.add(vo);
            }
        }
        if (!hasCommonPost) {
            Set<Object> struIdSet = new HashSet();
            if (HussarUtils.isNotEmpty((Object)struPosts)) {
                struIdSet = struPosts.stream().map(SysStruPost::getStruId).collect(Collectors.toSet());
            }
            for (UserOrganPostVo organVo : organVos) {
                if (!HussarUtils.isEmpty(struIdSet) && struIdSet.contains(organVo.getStruId())) continue;
                UserOrganPostVo vo = new UserOrganPostVo();
                vo.setUserId(userId);
                vo.setStruId(organVo.getStruId());
                vo.setOrganName(organVo.getOrganName());
                vo.setOrganFname(organVo.getOrganFname());
                result.add(vo);
            }
        }
        return result;
    }

    public UserDetails handleUserIdentity(UserDetails userDetails, Long appId) {
        Long postId;
        Long deptId;
        Long userId = userDetails.getUserId();
        SysLoginUserIdentityVo loginUserIdentityVo = (SysLoginUserIdentityVo)HussarCacheUtil.get((String)"user_Identity", (Object)userDetails.getUserId());
        if (HussarUtils.isEmpty((Object)loginUserIdentityVo) && HussarUtils.isNotEmpty((Object)(loginUserIdentityVo = ((SysLoginUserIdentityMapper)this.baseMapper).getUserIdentityByUserId(userId)))) {
            HussarCacheUtil.put((String)"user_Identity", (Object)userDetails.getUserId(), (Object)loginUserIdentityVo);
        }
        if (HussarUtils.isEmpty((Object)loginUserIdentityVo)) {
            SysLoginUserIdentity userIdentity = this.getFirstLoginUserIdentity(userDetails);
            deptId = userIdentity.getStruId();
            postId = userIdentity.getPostId();
            this.save((BaseEntity)userIdentity);
        } else {
            deptId = loginUserIdentityVo.getStruId();
            boolean flag = this.getIsChange(userId, deptId, postId = loginUserIdentityVo.getPostId());
            if (flag) {
                SysLoginUserIdentity userIdentity = this.getFirstLoginUserIdentity(userDetails);
                deptId = userIdentity.getStruId();
                postId = userIdentity.getPostId();
                loginUserIdentityVo.setStruId(deptId);
                loginUserIdentityVo.setPostId(postId);
                loginUserIdentityVo.setOrganName((String)userDetails.getExtendUserMap("deptName"));
                loginUserIdentityVo.setOrganCode((String)userDetails.getExtendUserMap("deptCode"));
                loginUserIdentityVo.setOrganIcon((String)userDetails.getExtendUserMap("deptIcon"));
                loginUserIdentityVo.setPostName((String)userDetails.getExtendUserMap("postName"));
                this.updateById((BaseEntity)loginUserIdentityVo);
                HussarCacheUtil.evict((String)"user_Identity", (Object)userDetails.getUserId());
            }
            userDetails.setDeptId(deptId);
            userDetails.addExtendUserMap("deptId", (Object)deptId);
            userDetails.addExtendUserMap("postId", (Object)postId);
            if (HussarUtils.isNotEmpty((Object)deptId)) {
                userDetails.addExtendUserMap("deptName", (Object)loginUserIdentityVo.getOrganName());
                userDetails.addExtendUserMap("deptCode", (Object)loginUserIdentityVo.getOrganCode());
                userDetails.addExtendUserMap("deptIcon", (Object)loginUserIdentityVo.getOrganIcon());
            } else {
                userDetails.addExtendUserMap("deptName", (Object)"");
                userDetails.addExtendUserMap("deptCode", (Object)"");
                userDetails.addExtendUserMap("deptIcon", (Object)"");
            }
            if (HussarUtils.isNotEmpty((Object)postId)) {
                userDetails.addExtendUserMap("postName", (Object)loginUserIdentityVo.getPostName());
            } else {
                userDetails.addExtendUserMap("postName", (Object)"");
            }
        }
        Object tcode = userDetails.getExtendUserMap("tcode");
        Object connName = userDetails.getExtendUserMap("connName");
        List directRelateRoles = this.sysUserRoleService.getRolesByUserIdAndAppId(userId, appId);
        logger.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_CONSTANT_1.getMessage()), new Object[]{tcode, connName, userDetails.getUserName(), JsonUtil.toJson((Object)directRelateRoles)});
        directRelateRoles.addAll(this.getBusinessRoles(deptId, postId, appId, userDetails));
        logger.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_CONSTANT_2.getMessage()), new Object[]{tcode, connName, userDetails.getUserName(), JsonUtil.toJson((Object)directRelateRoles)});
        List<Long> roleIds = this.sysConfRolesService.getNoConfRoles(userId, directRelateRoles);
        roleIds = roleIds.stream().distinct().collect(Collectors.toList());
        logger.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_CONSTANT_3.getMessage()), new Object[]{tcode, connName, userDetails.getUserName(), JsonUtil.toJson(roleIds)});
        userDetails.addExtendUserMap("rolesList", roleIds);
        userDetails.addExtendUserMap("gradeAdmin", (Object)GradeAdminUtil.judgeGradeAdminByRoles(roleIds).getGradeAdmin());
        ResourceGrantedAuthority resourceGrantedAuthority = this.sysResourcesService.getPermissionByRoleIds(roleIds);
        userDetails.addExtendUserMap("permissions", (Object)resourceGrantedAuthority.getGrantAuthorityList());
        return userDetails;
    }

    private SysLoginUserIdentity getFirstLoginUserIdentity(UserDetails userDetails) {
        Long userId = userDetails.getUserId();
        SysLoginUserIdentity userIdentity = new SysLoginUserIdentity();
        userIdentity.setUserId(userId);
        List userPosts = this.sysUserPostService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserPost::getUserId, (Object)userId)).orderByAsc(HussarBaseEntity::getCreateTime));
        List struUsers = this.sysStruUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruUser::getUserId, (Object)userId)).orderByAsc(HussarBaseEntity::getCreateTime));
        Long postId = null;
        Long deptId = null;
        if (HussarUtils.isNotEmpty((Object)userPosts)) {
            List mainUserPosts = userPosts.stream().filter(staffPost -> HussarUtils.equals((Object)"0", (Object)staffPost.getRelateType())).collect(Collectors.toList());
            postId = HussarUtils.isNotEmpty(mainUserPosts) ? ((SysUserPost)mainUserPosts.get(0)).getPostId() : ((SysUserPost)userPosts.get(0)).getPostId();
            userIdentity.setPostId(postId);
            SysPost post = (SysPost)this.postService.getById((Serializable)postId);
            userDetails.addExtendUserMap("postId", (Object)postId);
            userDetails.addExtendUserMap("postName", (Object)post.getPostName());
        }
        if (HussarUtils.isNotEmpty((Object)struUsers)) {
            deptId = HussarUtils.isNotEmpty(postId) ? this.getDeptIdByPostId(postId, struUsers) : ((SysStruUser)struUsers.get(0)).getStruId();
            userIdentity.setStruId(deptId);
            SysStru stru = (SysStru)this.sysStruService.getById((Serializable)deptId);
            SysOrgan organ = (SysOrgan)this.organService.getById((Serializable)stru.getOrganId());
            userDetails.addExtendUserMap("deptId", (Object)deptId);
            userDetails.addExtendUserMap("deptName", (Object)organ.getOrganName());
            userDetails.addExtendUserMap("deptCode", (Object)organ.getOrganCode());
        }
        return userIdentity;
    }

    private Long getDeptIdByPostId(Long postId, List<SysStruUser> struUsers) {
        Long deptId = struUsers.get(0).getStruId();
        SysPost post = (SysPost)this.postService.getById((Serializable)postId);
        if (HussarUtils.isEmpty((Object)post.getOrganTypeCode())) {
            return deptId;
        }
        String organTypeCode = post.getOrganTypeCode();
        List struIds = struUsers.stream().map(SysStruUser::getStruId).collect(Collectors.toList());
        List strus = this.sysStruService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStru::getStruType, (Object)organTypeCode)).in(SysStru::getId, struIds));
        if (HussarUtils.isEmpty((Object)strus)) {
            return deptId;
        }
        boolean flag = false;
        for (SysStruUser struUser : struUsers) {
            for (SysStru stru : strus) {
                flag = HussarUtils.equals((Object)struUser.getStruId(), (Object)stru.getId()) && HussarUtils.equals((Object)organTypeCode, (Object)stru.getStruType());
                if (!flag) continue;
                deptId = stru.getId();
                break;
            }
            if (!flag) continue;
            break;
        }
        return deptId;
    }

    public void updateSecurityUser(UserDetails userDetails) {
        SecurityUser securityUser = new SecurityUser();
        Map extendUserMap = userDetails.getExtendUserMap();
        BeanUtil.copy((Object)userDetails, (Object)securityUser);
        securityUser.setId(userDetails.getUserId());
        securityUser.setAccount((String)extendUserMap.get("account"));
        securityUser.addExtendUserMap("bpmTenantId", extendUserMap.get("bpmTenantId"));
        securityUser.addExtendUserMap("bpmTenantCipher", extendUserMap.get("bpmTenantId"));
        securityUser.setDeptId(BaseSecurityUtil.formatToLong(extendUserMap.get("deptId")));
        securityUser.setEmployeeId(BaseSecurityUtil.formatToLong(extendUserMap.get("employeeId")));
        securityUser.setDeptName((String)extendUserMap.get("deptName"));
        securityUser.setDeptCode((String)extendUserMap.get("deptCode"));
        securityUser.setSecurityLevel(BaseSecurityUtil.formatToInteger(extendUserMap.get("securityLevel")));
        securityUser.setAccountStatus((String)extendUserMap.get("accountStatus"));
        securityUser.addExtendUserMap("showTenant", extendUserMap.get("showTenant"));
        securityUser.addExtendUserMap("gradeAdmin", extendUserMap.get("gradeAdmin"));
        securityUser.setRolesList(BaseSecurityUtil.formatToLongList(extendUserMap.get("rolesList")));
        securityUser.addExtendUserMap("theme", extendUserMap.get("theme"));
        securityUser.addExtendUserMap("welcomeUrl", extendUserMap.get("welcomeUrl"));
        securityUser.addExtendUserMap("permissions", extendUserMap.get("permissions"));
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = ToolUtil.isNotEmpty((Object)requestAttributes) ? requestAttributes.getRequest() : null;
        boolean tenantOpen = this.hussarTenantProperties.isEnabled() && this.tenantCommonService != null;
        DefaultTenant tenantInfo = new DefaultTenant();
        if (ToolUtil.isNotEmpty((Object)request) && tenantOpen) {
            tenantInfo = this.tenantCommonService.parse();
            Optional.ofNullable(tenantInfo).ifPresent(this::checkTeant);
        }
        if (tenantOpen && HussarUtils.isNotEmpty((Object)tenantInfo)) {
            userDetails.addExtendUserMap(this.hussarDynamicProperties.getDatasourceKeyByHeader(), (Object)tenantInfo.getConnName());
            userDetails.setTenantId(tenantInfo.getTenantId());
            userDetails.setTenantCode(tenantInfo.getTenantCode());
            userDetails.addExtendUserMap("tenantName", (Object)tenantInfo.getTenantName());
            userDetails.addExtendUserMap("tcode", (Object)tenantInfo.getTenantCode());
            userDetails.addExtendUserMap("connName", (Object)tenantInfo.getConnName());
            userDetails.setTenantCode(tenantInfo.getTenantCode());
        }
        securityUser.setConnName((String)extendUserMap.get("connName"));
        securityUser.setTenantCode((String)extendUserMap.get("tcode"));
        securityUser.setTenantId(userDetails.getTenantId());
        securityUser.setTenantName((String)extendUserMap.get("tenantName"));
        securityUser.setTenantCipher((String)extendUserMap.get("tenantCipher"));
        HussarSecurityUtils.updateUserDetails((UserDetails)userDetails);
    }

    private boolean getIsChange(Long userId, Long struId, Long postId) {
        List<Long> struIdPrPostIds = ((SysLoginUserIdentityMapper)this.baseMapper).getUserRelatePostAndOrganIds(userId);
        if (!(HussarUtils.isEmpty(struIdPrPostIds) && HussarUtils.isEmpty((Object)struId) || struIdPrPostIds.contains(struId))) {
            return true;
        }
        return (!HussarUtils.isEmpty(struIdPrPostIds) || !HussarUtils.isEmpty((Object)postId)) && !struIdPrPostIds.contains(postId);
    }

    private void fillOtherBusiness(UserDetails userDetails, Map<String, List<Long>> map) {
        this.sysRoleEventService.fillMap(userDetails, map);
    }

    private void checkTeant(HussarTenantDefinition tenantInfo) {
        if (StringUtils.isNotBlank((CharSequence)tenantInfo.getTenantCode()) && !tenantInfo.getConnName().equals("master")) {
            Boolean timeLimit = tenantInfo.getTimeLimit();
            LocalDateTime startTime = tenantInfo.getStartTime();
            LocalDateTime endTime = tenantInfo.getEndTime();
            String tenantStatus = tenantInfo.getTenantStatus();
            AssertUtil.isFalse((boolean)tenantStatus.equalsIgnoreCase("0"), (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_TENANT_DELETE.getMessage()));
            AssertUtil.isFalse((boolean)tenantStatus.equalsIgnoreCase("2"), (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_TENANT_EXPIRED.getMessage()));
            AssertUtil.isFalse((tenantStatus.equalsIgnoreCase("3") || tenantStatus.equalsIgnoreCase("4") ? 1 : 0) != 0, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_TENANT_UNAVAILABLE.getMessage()));
            AssertUtil.isFalse((timeLimit != false && endTime.isBefore(Java8DateUtils.currentLocalDateTime()) ? 1 : 0) != 0, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_TENANT_EXPIRED.getMessage()));
            AssertUtil.isFalse((timeLimit != false && startTime.isAfter(Java8DateUtils.currentLocalDateTime()) ? 1 : 0) != 0, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_TENANT_NOT_EFFECTIVE.getMessage()));
        }
    }

    private List<Long> getBusinessRoles(Long deptId, Long postId, Long appId, UserDetails userDetails) {
        List roles;
        List sourceRoles;
        HashMap<String, List<Long>> map = new HashMap<String, List<Long>>();
        if (HussarUtils.isNotEmpty((Object)deptId)) {
            ArrayList<Long> struIds = new ArrayList<Long>();
            struIds.add(deptId);
            map.put("stru", struIds);
        }
        if (HussarUtils.isNotEmpty((Object)postId)) {
            ArrayList<Long> postIds = new ArrayList<Long>();
            postIds.add(postId);
            map.put("post", postIds);
        }
        this.fillOtherBusiness(userDetails, map);
        if (HussarUtils.isNotEmpty(map) && HussarUtils.isNotEmpty((Object)(sourceRoles = UserRoleExpandFactory.getRolesByBusiness(map))) && HussarUtils.isNotEmpty((Object)(roles = this.sysRolesService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysRoles::getId, (Collection)sourceRoles)).eq(SysRoles::getAppId, (Object)appId))))) {
            return roles.stream().map(SysRoles::getId).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

