/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.permit.dao.SysRolesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysStruRoleMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserRoleMapper;
import com.jxdinfo.hussar.authorization.permit.dto.DeleteAppRoleRelateDto;
import com.jxdinfo.hussar.authorization.permit.manager.DeleteRoleManager;
import com.jxdinfo.hussar.authorization.permit.model.SysStruRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.service.impl.RoleUserAuthorizationChangeReporter;
import com.jxdinfo.hussar.authorization.relational.dao.SysPostRoleMapper;
import com.jxdinfo.hussar.authorization.relational.model.SysPostRole;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.permit.manager.impl.deleteRoleManagerImpl")
public class DeleteRoleManagerImpl
implements DeleteRoleManager {
    @Resource
    private SysRolesMapper sysRolesMapper;
    @Resource
    private SysStruRoleMapper sysStruRoleMapper;
    @Resource
    private SysUserRoleMapper sysUserRoleMapper;
    @Resource
    private SysPostRoleMapper sysPostRoleMapper;
    @Resource
    private RoleUserAuthorizationChangeReporter userAuthorizationChangeReporter;

    @Override
    @HussarTransactional
    public Boolean delAppRole(Long roleId) {
        if (ToolUtil.isEmpty((Object)roleId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_ID_EMPTY.getMessage()));
        }
        this.sysRolesMapper.deleteById(roleId);
        this.sysStruRoleMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysStruRole::getGrantedRole, (Object)roleId));
        this.sysPostRoleMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysPostRole::getRoleId, (Object)roleId));
        this.sysUserRoleMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysUserRole::getGrantedRole, (Object)roleId));
        this.userAuthorizationChangeReporter.report(new Object[]{"role", roleId});
        return Boolean.TRUE;
    }

    @Override
    @HussarTransactional
    public Boolean deleteAppRoleRelate(DeleteAppRoleRelateDto deleteAppRoleRelateDto) {
        Long roleId = deleteAppRoleRelateDto.getRoleId();
        if (ToolUtil.isEmpty((Object)roleId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_ID_EMPTY.getMessage()));
        }
        List delStrus = deleteAppRoleRelateDto.getDelStrus();
        List delPosts = deleteAppRoleRelateDto.getDelPosts();
        List delUsers = deleteAppRoleRelateDto.getDelUsers();
        if (HussarUtils.isNotEmpty((Object)delStrus)) {
            this.sysStruRoleMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruRole::getGrantedRole, (Object)roleId)).in(SysStruRole::getStruId, (Collection)delStrus));
            this.userAuthorizationChangeReporter.report(new Object[]{"organ", delStrus});
        }
        if (HussarUtils.isNotEmpty((Object)delPosts)) {
            this.sysPostRoleMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysPostRole::getRoleId, (Object)roleId)).in(SysPostRole::getPostId, (Collection)delPosts));
            this.userAuthorizationChangeReporter.report(new Object[]{"post", delPosts});
        }
        if (HussarUtils.isNotEmpty((Object)delUsers)) {
            this.sysUserRoleMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getGrantedRole, (Object)roleId)).in(SysUserRole::getUserId, (Collection)delUsers));
            this.userAuthorizationChangeReporter.report(new Object[]{"user", delUsers});
        }
        return Boolean.TRUE;
    }
}

