/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.constants.OrganConstants;
import com.jxdinfo.hussar.authorization.organ.dao.SysOrganTypeMapper;
import com.jxdinfo.hussar.authorization.organ.dto.QueryOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.dto.QueryTransferOrganizationListDto;
import com.jxdinfo.hussar.authorization.organ.dto.QueryTransferOrganizationTreeDto;
import com.jxdinfo.hussar.authorization.organ.dto.SearchOrganUserDto;
import com.jxdinfo.hussar.authorization.organ.manager.QueryOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonQueryOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.model.SysOffice;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysOrganType;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.model.SysStruRule;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.authorization.organ.vo.CustomOrgTreeVo;
import com.jxdinfo.hussar.authorization.organ.vo.InstitutionVo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganTreeInitVo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganVo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationInfoVo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationPartialVo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationTreeVo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationVo;
import com.jxdinfo.hussar.authorization.organ.vo.ReadOnlyOrganizationTreeVo;
import com.jxdinfo.hussar.authorization.organ.vo.SearchOrganVo;
import com.jxdinfo.hussar.authorization.organ.vo.SearchOrganizationVo;
import com.jxdinfo.hussar.authorization.organ.vo.SysStruRuleVo;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleStruRightsMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleStruRights;
import com.jxdinfo.hussar.authorization.permit.model.SysStruRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.util.GradeAdminUtil;
import com.jxdinfo.hussar.authorization.permit.vo.JudgeGradeAdminVo;
import com.jxdinfo.hussar.authorization.permit.vo.RoleBasicVo;
import com.jxdinfo.hussar.authorization.permit.vo.SelectCustomOrgTreeVo;
import com.jxdinfo.hussar.authorization.post.vo.PostBasicVo;
import com.jxdinfo.hussar.authorization.relational.model.SysStruPost;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.base.config.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.HussarTreeParser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.ConditionUtils;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.ibatis.session.ResultHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.organ.manager.impl.queryOrganizationManagerImpl")
public class QueryOrganizationManagerImpl
extends CommonQueryOrganizationManager
implements QueryOrganizationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryOrganizationManagerImpl.class);
    @Resource
    private SysRoleStruRightsMapper sysRoleStruRightsMapper;
    @Resource
    private SysOrganTypeMapper sysOrganTypeMapper;
    @Resource
    private ISysBaseConfigService sysBaseConfigService;

    @Override
    public List<OrganizationTreeVo> lazyLoadOrganizationTree(Long parentId) {
        ArrayList<OrganizationTreeVo> result = new ArrayList<OrganizationTreeVo>();
        List<OrganizationTreeVo> data = this.getOrganizationTree(parentId);
        this.fillOrganizationPermissions(data);
        result.addAll(data);
        return HussarTreeParser.getTreeList(result);
    }

    @Override
    public List<OrganizationTreeVo> lazyLoadOrganizationTree(Long parentId, String organProperty) {
        List<OrganizationTreeVo> data;
        ArrayList<OrganizationTreeVo> result = new ArrayList<OrganizationTreeVo>();
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        if (HussarUtils.isEmpty((Object)currentUser)) {
            data = this.getOrganizationTree(parentId, organProperty);
        } else {
            Long gradeRootId = null;
            if (HussarUtils.equals((Object)OrganConstants.ROOT_ORGAN_ID, (Object)parentId) || HussarUtils.equals((Object)Constants.OUT_STRU_NODE_ID, (Object)parentId)) {
                if (HussarUtils.isEmpty((Object)(parentId = this.getGradeOrganType(parentId, currentUser)))) {
                    return result;
                }
                if (!HussarUtils.equals((Object)OrganConstants.ROOT_ORGAN_ID, (Object)parentId) && !HussarUtils.equals((Object)Constants.OUT_STRU_NODE_ID, (Object)parentId)) {
                    gradeRootId = parentId;
                }
            }
            data = this.getGradeOrganizationTree(parentId, organProperty, gradeRootId);
        }
        this.fillOrganizationPermissions(data);
        result.addAll(data);
        return HussarTreeParser.getTreeList(result);
    }

    @Override
    public List<ReadOnlyOrganizationTreeVo> lazyLoadOrganizationTreeNoPermissions(Long parentId, String organProperty) {
        List<OrganizationTreeVo> data;
        ArrayList<ReadOnlyOrganizationTreeVo> result = new ArrayList<ReadOnlyOrganizationTreeVo>();
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        if (currentUser == null) {
            data = this.getOrganizationTree(parentId);
        } else {
            Long gradeRootId = null;
            if (HussarUtils.equals((Object)OrganConstants.ROOT_ORGAN_ID, (Object)parentId) || HussarUtils.equals((Object)Constants.OUT_STRU_NODE_ID, (Object)parentId)) {
                if (HussarUtils.isEmpty((Object)(parentId = this.getGradeOrganType(parentId, currentUser)))) {
                    return result;
                }
                if (!HussarUtils.equals((Object)OrganConstants.ROOT_ORGAN_ID, (Object)parentId) && !HussarUtils.equals((Object)Constants.OUT_STRU_NODE_ID, (Object)parentId)) {
                    gradeRootId = parentId;
                }
            }
            data = this.getGradeOrganizationTree(parentId, organProperty, gradeRootId);
        }
        ReadOnlyOrganizationTreeVo readOnlyOrganizationTreeVo = null;
        if (HussarUtils.isNotEmpty(data)) {
            for (OrganizationTreeVo vo : data) {
                readOnlyOrganizationTreeVo = new ReadOnlyOrganizationTreeVo();
                readOnlyOrganizationTreeVo.setId(vo.getId());
                readOnlyOrganizationTreeVo.setLabel(vo.getLabel());
                readOnlyOrganizationTreeVo.setHasChildren(vo.getHasChildren());
                readOnlyOrganizationTreeVo.setChildren(vo.getChildren());
                readOnlyOrganizationTreeVo.setIcon(vo.getIcon());
                readOnlyOrganizationTreeVo.setStruType(vo.getStruType());
                readOnlyOrganizationTreeVo.setStruLevel(vo.getStruLevel());
                readOnlyOrganizationTreeVo.setParentId(vo.getParentId());
                readOnlyOrganizationTreeVo.setOrganProperty(vo.getOrganProperty());
                result.add(readOnlyOrganizationTreeVo);
            }
        }
        return HussarTreeParser.getTreeList(result);
    }

    @Override
    public OrganizationPartialVo viewOrganization(Long id) {
        SysUsers sysUsers;
        Long principalId;
        List roleIds;
        List<List<Long>> roleIdList;
        List<RoleBasicVo> roleBasicVos;
        List organRoles;
        List postIds;
        List<List<Long>> postIdList;
        List<PostBasicVo> postBasicVos;
        SysStru sysStru = (SysStru)this.sysStruMapper.selectById(id);
        AssertUtil.isNotNull((Object)sysStru, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_SYSSTRU.getMessage()));
        SysOrgan sysOrgan = (SysOrgan)this.sysOrganMapper.selectById(sysStru.getOrganId());
        AssertUtil.isNotNull((Object)sysOrgan, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_SYSORGAN.getMessage()));
        LambdaQueryWrapper officeWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysOffice::getStruId, (Object)id);
        SysOffice sysOffice = (SysOffice)this.sysOfficeMapper.selectOne((Wrapper)officeWrapper);
        AssertUtil.isNotNull((Object)sysOffice, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_EXTENSION.getMessage()));
        LambdaQueryWrapper organtypeWrapper = new LambdaQueryWrapper();
        organtypeWrapper.eq(SysOrganType::getOrganType, (Object)sysStru.getStruType());
        SysOrganType organType = (SysOrganType)this.organTypeService.getOne((Wrapper)organtypeWrapper);
        AssertUtil.isNotNull((Object)sysOffice, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_ORG_TYPE.getMessage()));
        OrganizationPartialVo vo = new OrganizationPartialVo();
        vo.setId(sysStru.getId());
        vo.setParentName(OrganUtil.getShortParentName((String)sysOrgan.getOrganFname()));
        vo.setOrganCode(sysOrgan.getOrganCode());
        vo.setTypeName(organType.getTypeName());
        vo.setOrganName(sysOrgan.getOrganName());
        vo.setOrganAlias(sysStru.getOrganAlias());
        vo.setShortName(sysOrgan.getShortName());
        vo.setOfficeAddress(sysOffice.getOfficeAddress());
        vo.setOfficeAlias(sysOffice.getOfficeAlias());
        vo.setOrganProperty(sysOrgan.getOrganProperty());
        vo.setValidTimeLimitType(sysOrgan.getValidTimeLimitType());
        List organPosts = this.sysStruPostMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysStruPost::getStruId, (Object)id));
        if (HussarUtils.isNotEmpty((Object)organPosts) && HussarUtils.isNotEmpty(postBasicVos = this.sysPostMapper.getPostInfoByBigIds(postIdList = QueryOrganizationManagerImpl.getSplitList(postIds = organPosts.stream().map(SysStruPost::getPostId).collect(Collectors.toList()))))) {
            vo.setPostList(postBasicVos);
        }
        if (HussarUtils.isNotEmpty((Object)(organRoles = this.sysStruRoleMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysStruRole::getStruId, (Object)id)))) && HussarUtils.isNotEmpty(roleBasicVos = this.sysRolesMapper.getRoleInfoByBigIds(roleIdList = QueryOrganizationManagerImpl.getSplitList(roleIds = organRoles.stream().map(SysStruRole::getGrantedRole).collect(Collectors.toList()))))) {
            vo.setRoleList(roleBasicVos);
        }
        if (HussarUtils.isNotEmpty((Object)(principalId = sysStru.getPrincipalId())) && HussarUtils.isNotEmpty((Object)(sysUsers = (SysUsers)this.sysUsersMapper.selectById(principalId)))) {
            vo.setUserName(sysUsers.getUserName());
        }
        return vo;
    }

    @Override
    public OrganizationInfoVo loadOrganizationById(Long id) {
        SysUsers sysUsers;
        Long principalId;
        List roleIds;
        List<List<Long>> roleIdList;
        List<RoleBasicVo> roleBasicVos;
        List organRoles;
        List postIds;
        List<List<Long>> postIdList;
        List<PostBasicVo> postBasicVos;
        AssertUtil.isNotNull((Object)id, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_PARAM.getMessage()));
        SysStru sysStru = (SysStru)this.sysStruMapper.selectById(id);
        AssertUtil.isNotNull((Object)sysStru, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_SYSSTRU.getMessage()));
        SysOrgan sysOrgan = (SysOrgan)this.sysOrganMapper.selectById(sysStru.getOrganId());
        AssertUtil.isNotNull((Object)sysOrgan, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_SYSORGAN.getMessage()));
        LambdaQueryWrapper officeWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysOffice::getStruId, (Object)id);
        SysOffice sysOffice = (SysOffice)this.sysOfficeMapper.selectOne((Wrapper)officeWrapper);
        AssertUtil.isNotNull((Object)sysOffice, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_EXTENSION.getMessage()));
        LambdaQueryWrapper organtypeWrapper = new LambdaQueryWrapper();
        organtypeWrapper.eq(SysOrganType::getOrganType, (Object)sysStru.getStruType());
        Map organTypeMap = this.organTypeService.queryOrganTypeMap();
        SysStru parentSysStru = null;
        OrganizationInfoVo vo = new OrganizationInfoVo();
        List organPosts = this.sysStruPostMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysStruPost::getStruId, (Object)id));
        if (HussarUtils.isNotEmpty((Object)organPosts) && HussarUtils.isNotEmpty(postBasicVos = this.sysPostMapper.getPostInfoByBigIds(postIdList = QueryOrganizationManagerImpl.getSplitList(postIds = organPosts.stream().map(SysStruPost::getPostId).collect(Collectors.toList()))))) {
            vo.setPostList(postBasicVos);
        }
        if (HussarUtils.isNotEmpty((Object)(organRoles = this.sysStruRoleMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysStruRole::getStruId, (Object)id)))) && HussarUtils.isNotEmpty(roleBasicVos = this.sysRolesMapper.getRoleInfoByBigIds(roleIdList = QueryOrganizationManagerImpl.getSplitList(roleIds = organRoles.stream().map(SysStruRole::getGrantedRole).collect(Collectors.toList()))))) {
            vo.setRoleList(roleBasicVos);
        }
        vo.setId(sysStru.getId());
        vo.setParentId(sysStru.getParentId());
        vo.setStruType(sysStru.getStruType());
        vo.setBeginDate(sysOrgan.getBeginDate());
        vo.setEndDate(sysOrgan.getEndDate());
        vo.setOrganFName(sysOrgan.getOrganFname());
        vo.setOrganCode(sysOrgan.getOrganCode());
        vo.setTypeName(((SysOrganType)organTypeMap.get(sysStru.getStruType())).getTypeName());
        vo.setOrganName(sysOrgan.getOrganName());
        vo.setOrganAlias(sysStru.getOrganAlias());
        vo.setShortName(sysOrgan.getShortName());
        vo.setOfficeAddress(sysOffice.getOfficeAddress());
        vo.setOfficeAlias(sysOffice.getOfficeAlias());
        vo.setOrganId(sysOrgan.getId());
        vo.setOrganProperty(sysOrgan.getOrganProperty());
        vo.setValidTimeLimitType(sysOrgan.getValidTimeLimitType());
        vo.setOfficeId(sysOffice.getId());
        if (HussarUtils.isNotEmpty((Object)sysStru.getParentId()) && HussarUtils.isNotEmpty((Object)(parentSysStru = (SysStru)this.sysStruMapper.selectById(sysStru.getParentId())))) {
            vo.setParentName(OrganUtil.getShortParentName((String)sysOrgan.getOrganFname()));
            vo.setParentOrganCode(OrganUtil.getShortParentName((String)sysOrgan.getOrganFcode()));
            vo.setParentStruType(parentSysStru.getStruType());
            vo.setParentTypeName(((SysOrganType)organTypeMap.get(parentSysStru.getStruType())).getTypeName());
        }
        if (HussarUtils.isNotEmpty((Object)(principalId = sysStru.getPrincipalId())) && HussarUtils.isNotEmpty((Object)(sysUsers = (SysUsers)this.sysUsersMapper.selectById(principalId)))) {
            vo.setPrincipalId(sysUsers.getId());
            vo.setUserName(sysUsers.getUserName());
            vo.setUserAccount(sysUsers.getUserAccount());
        }
        return vo;
    }

    @Override
    public Page<SearchOrganizationVo> searchOrganization(PageInfo pageInfo, String name) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryOrgParams = new HashMap<String, Object>();
        queryOrgParams.put("name", SqlQueryUtil.transferSpecialChar((String)name));
        queryOrgParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        if (HussarUtils.isNotEmpty((Object)currentUser) && currentUser.isGradeadmin()) {
            Long deptId = currentUser.getDeptId();
            String struFid = ((SysStru)this.sysStruMapper.selectById(deptId)).getStruFid();
            queryOrgParams.put("struFid", struFid);
            String[] split = struFid.split("/");
            ArrayList<Long> parentIds = new ArrayList<Long>();
            for (String str : split) {
                if (!HussarUtils.isNotBlank((CharSequence)str) || deptId.toString().equals(str)) continue;
                parentIds.add(Long.parseLong(str));
            }
            queryOrgParams.put("parentIds", parentIds);
        }
        page.setRecords(this.sysStruMapper.searchOrganization(page, queryOrgParams));
        return page;
    }

    private boolean getGradeFlag(String fid, String currentStruFid, int level, Map<Integer, String> mapStruFid) {
        boolean flag = false;
        if (fid.startsWith(currentStruFid)) {
            if (level == 1) {
                flag = true;
            } else {
                String reduceStruFidByLevel = mapStruFid.get(level - 1);
                if (fid.startsWith(reduceStruFidByLevel)) {
                    flag = true;
                }
            }
        }
        return flag;
    }

    private boolean getFlag(String fid, int level, Map<Integer, String> mapStruFid) {
        boolean flag = false;
        if (level == 1) {
            flag = true;
        } else {
            String reduceStruFidByLevel = mapStruFid.get(level - 1);
            if (fid.startsWith(reduceStruFidByLevel)) {
                flag = true;
            }
        }
        return flag;
    }

    @Override
    public List<OrganizationTreeVo> backOrganizationTree(Long id) {
        ArrayList<OrganizationTreeVo> result = new ArrayList<OrganizationTreeVo>();
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        boolean isGradeAdmin = currentUser.isGradeadmin();
        AtomicReference<String> currentStruFidT = new AtomicReference<String>("");
        Long deptId = currentUser.getDeptId();
        ConditionUtils.isTrue((boolean)isGradeAdmin).handle(() -> currentStruFidT.set(((SysStru)this.sysStruMapper.selectById(deptId)).getStruFid()));
        String currentStruFid = currentStruFidT.get();
        AtomicReference<String> paramStruFid = new AtomicReference<String>("/%");
        AtomicInteger parentLevel = new AtomicInteger(1);
        HashMap mapStruFid = new HashMap();
        ConditionUtils.isTrue((!Objects.equals(id, Constants.ROOT_NODE_ID) ? 1 : 0) != 0).handle(() -> {
            SysStru sysStru = (SysStru)this.sysStruMapper.selectById(id);
            parentLevel.set(sysStru.getStruLevel());
            String struFid = sysStru.getStruFid();
            for (int i = 1; i <= parentLevel.get(); ++i) {
                mapStruFid.put(i, OrganUtil.convert((String)OrganUtil.getStruFidByLevel((String)struFid, (int)i)));
            }
            paramStruFid.set((String)mapStruFid.get(1) + "%");
        });
        this.sysStruMapper.findInstitution(paramStruFid.get(), parentLevel.get(), (ResultHandler<InstitutionVo>)((ResultHandler)resultContext -> {
            InstitutionVo t = (InstitutionVo)resultContext.getResultObject();
            int level = t.getStruLevel();
            Long idT = t.getId();
            String fid = t.getStruFid();
            String label = t.getLabel();
            Long parentId = t.getParentId();
            String struType = t.getStruType();
            Boolean hasChild = t.getHasChildren();
            AtomicBoolean flag = new AtomicBoolean(false);
            ConditionUtils.isTureOrFalse((boolean)isGradeAdmin).trueOrFalseHandle(() -> flag.set(this.getGradeFlag(fid, currentStruFid, level, mapStruFid)), () -> flag.set(this.getFlag(fid, level, mapStruFid)));
            if (flag.get()) {
                OrganizationTreeVo organizationTreeVo = new OrganizationTreeVo();
                organizationTreeVo.setId((Serializable)idT);
                organizationTreeVo.setLabel(label);
                organizationTreeVo.setParentId((Serializable)parentId);
                organizationTreeVo.setStruType(struType);
                organizationTreeVo.setStruLevel(level);
                organizationTreeVo.setHasChildren(hasChild);
                result.add(organizationTreeVo);
            }
        }));
        this.fillOrganizationPermissions(result);
        return HussarTreeParser.getTreeList(result);
    }

    @Override
    public Page<OrganizationVo> queryOrganization(PageInfo pageInfo, QueryOrganizationDto queryOrganizationDto) {
        String organTypes;
        boolean isRoot;
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryOrgParams = new HashMap<String, Object>();
        queryOrgParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        String struFid = "/";
        Long parentStruId = queryOrganizationDto.getParentId();
        AssertUtil.isNotNull((Object)parentStruId, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_SUP_PARAM.getMessage()));
        String organProperty = queryOrganizationDto.getOrganProperty();
        AssertUtil.isNotNull((Object)organProperty, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGNA_PROPERTY_PARAM.getMessage()));
        boolean bl = isRoot = Objects.equals(Constants.ROOT_NODE_ID, parentStruId) || Objects.equals(Constants.OUT_STRU_NODE_ID, parentStruId);
        if (!isRoot) {
            SysStru pSysStru = (SysStru)Optional.ofNullable(this.sysStruMapper.selectById(parentStruId)).orElse(new SysStru());
            struFid = pSysStru.getStruFid();
        }
        if (HussarUtils.isNotBlank((CharSequence)(organTypes = queryOrganizationDto.getOrganTypes()))) {
            List<String> organTypesList = Arrays.asList(organTypes.split(","));
            queryOrgParams.put("organTypes", organTypesList);
        }
        int level = OrganUtil.getSubordinateLevel((String)OrganUtil.convert((String)struFid));
        queryOrgParams.put("parentStruId", OrganUtil.convert((Long)parentStruId));
        queryOrgParams.put("organName", SqlQueryUtil.transferSpecialChar((String)queryOrganizationDto.getOrganName()));
        queryOrgParams.put("organCode", SqlQueryUtil.transferSpecialChar((String)queryOrganizationDto.getOrganCode()));
        queryOrgParams.put("organProperty", queryOrganizationDto.getOrganProperty());
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        int gradePLevel = 0;
        if (currentUser.isGradeadmin()) {
            Long deptId = currentUser.getDeptId();
            SysStru gradePSysStru = (SysStru)this.sysStruMapper.selectById(deptId);
            gradePLevel = gradePSysStru.getStruLevel();
            int gradeDepStruLevel = gradePLevel + 1;
            int searchStruLevel = 0;
            if (!isRoot) {
                searchStruLevel = this.sysStruMapper.selectStruLevel(parentStruId);
            }
            if (searchStruLevel < gradeDepStruLevel) {
                struFid = ((SysStru)this.sysStruMapper.selectById(deptId)).getStruFid();
                level = OrganUtil.getSubordinateLevel((String)OrganUtil.convert((String)struFid));
            }
        }
        queryOrgParams.put("struFid", OrganUtil.convert((String)struFid));
        if (queryOrganizationDto instanceof QueryTransferOrganizationListDto) {
            QueryTransferOrganizationListDto dto = (QueryTransferOrganizationListDto)queryOrganizationDto;
            Long transferId = dto.getTransferId();
            SysStru struTemp = (SysStru)this.sysStruMapper.selectById(transferId);
            AssertUtil.isNotNull((Object)struTemp, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_ORGAN_TO_TRANSFER.getMessage()));
            List<Long> excludeIds = this.getTransferExcludeIds(struTemp);
            queryOrgParams.put("excludeIds", excludeIds);
            --level;
        }
        queryOrgParams.put("struLevel", level);
        List<OrganizationVo> organizationVos = this.sysStruMapper.queryOrganization((Page<OrganizationVo>)page, queryOrgParams);
        page.setRecords(organizationVos);
        return page;
    }

    private List<Long> getTransferExcludeIds(SysStru stru) {
        ArrayList<Long> list = new ArrayList<Long>();
        Long id = stru.getId();
        String struType = stru.getStruType();
        if (!struType.equals("9")) {
            list.add(id);
        }
        return list;
    }

    @Override
    public List<OrganizationTreeVo> getTransferOrganizationTree(QueryTransferOrganizationTreeDto queryTransferOrganizationDto) {
        ArrayList result = new ArrayList();
        Long parentId = queryTransferOrganizationDto.getParentId();
        String transferId = queryTransferOrganizationDto.getTransferId().toString();
        List<OrganizationTreeVo> list = this.getOrganizationTree(parentId);
        ConditionUtils.isTrue((boolean)HussarUtils.isNotEmpty(list)).handle(() -> {
            for (OrganizationTreeVo vo : list) {
                if (Objects.equals(vo.getId(), transferId)) continue;
                result.add(vo);
            }
        });
        return HussarTreeParser.getTreeList(result);
    }

    @Override
    public List<SysStruRuleVo> getOrganizationTypeByParentId(Long parentId) {
        ArrayList<SysStruRuleVo> list = new ArrayList<SysStruRuleVo>();
        SysStru stru = (SysStru)this.sysStruMapper.selectById(parentId);
        SysStruRuleVo rule = null;
        if (HussarUtils.isEmpty((Object)parentId) || HussarUtils.isEmpty((Object)stru)) {
            List types = this.sysOrganTypeMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysOrganType::getParentType, (Object)"0"));
            for (SysOrganType type : types) {
                rule = new SysStruRuleVo();
                rule.setOrganType(type.getOrganType());
                rule.setOrganTypeName(type.getTypeName());
                rule.setSysOrganType(type.getParentType());
                rule.setSysOrganTypeName(type.getTypeName());
                list.add(rule);
            }
        } else {
            String parentType = stru.getStruType();
            Map typeMap = this.organTypeService.queryOrganTypeMap();
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(SysStruRule::getSysOrganType, (Object)parentType);
            wrapper.orderByAsc(SysStruRule::getOrganType);
            List sysStruRules = this.sysStruRuleMapper.selectList((Wrapper)wrapper);
            for (SysStruRule temp : sysStruRules) {
                rule = new SysStruRuleVo();
                rule.setOrganType(temp.getOrganType());
                rule.setOrganTypeName(((SysOrganType)typeMap.get(rule.getOrganType())).getTypeName());
                rule.setSysOrganType(temp.getSysOrganType());
                rule.setSysOrganTypeName(((SysOrganType)typeMap.get(rule.getSysOrganType())).getTypeName());
                list.add(rule);
            }
        }
        return list;
    }

    @Override
    public List<OrganizationTreeVo> getOrderOrganizationTree(Long parentId) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("parentId", parentId);
        ArrayList<OrganizationTreeVo> result = new ArrayList<OrganizationTreeVo>();
        List<OrganizationTreeVo> data = this.searchOrganizationTree(queryParams);
        OrganizationTreeVo root = null;
        parentId = HussarUtils.isEmpty((Object)parentId) ? Constants.ROOT_NODE_ID : parentId;
        SysBaseConfig orgInName = this.sysBaseConfigService.getSysBaseConfig("org_in_name");
        SysBaseConfig orgOutName = this.sysBaseConfigService.getSysBaseConfig("org_out_name");
        if (Objects.equals(Constants.ROOT_NODE_ID, parentId) || Objects.equals(Constants.OUT_STRU_NODE_ID, parentId)) {
            root = new OrganizationTreeVo();
            root.setId((Serializable)parentId);
            root.setHasChildren(Boolean.valueOf(true));
            root.setLabel(Objects.equals(Constants.ROOT_NODE_ID, parentId) ? TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_INTER_ORGAN.getMessage()) : TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXTER_ORGAN.getMessage()));
            root.setDisabled(Boolean.valueOf(true));
            root.setStruLevel(0);
            root.setStruType("isRoot");
            root.setIcon("tree-com");
        } else {
            root = this.lazyOrganizationById(parentId);
        }
        root.setChildren(data);
        result.add(root);
        return result;
    }

    @Override
    public OrganizationTreeVo lazyOrganizationById(Long id) {
        OrganizationTreeVo organizationTreeVo = this.sysStruMapper.lazyOrganizationById(id);
        AssertUtil.isNotNull((Object)organizationTreeVo, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_SYSSTRU.getMessage()));
        List<SysStruRule> list = this.searchWithoutStaffRuleList();
        this.fillSingleOrganizationPermissions(organizationTreeVo, list);
        return organizationTreeVo;
    }

    @Override
    public Page<OrganizationVo> transferOrganizationList(PageInfo pageInfo, QueryTransferOrganizationListDto queryOrganizationDto) {
        return this.queryOrganizationAllowPinyin(pageInfo, (QueryOrganizationDto)queryOrganizationDto);
    }

    @Override
    public String getOrganFname(Long struId) {
        return this.sysStruMapper.getOrganFname(struId);
    }

    @Override
    public SelectCustomOrgTreeVo getCustomOrgTree(Long dataRightId) {
        ArrayList<CustomOrgTreeVo> customOrgTreeVoList = new ArrayList<CustomOrgTreeVo>();
        CustomOrgTreeVo customOrgTreeVo = new CustomOrgTreeVo();
        customOrgTreeVo.setId((Serializable)OrganConstants.ROOT_ORGAN_ID);
        customOrgTreeVo.setHasChildren(Boolean.valueOf(true));
        customOrgTreeVo.setLabel(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_INTER_ORGAN.getMessage()));
        customOrgTreeVoList.add(customOrgTreeVo);
        CustomOrgTreeVo customOutOrgTreeVo = new CustomOrgTreeVo();
        customOutOrgTreeVo.setId((Serializable)Constants.OUT_STRU_NODE_ID);
        customOutOrgTreeVo.setHasChildren(Boolean.valueOf(true));
        customOutOrgTreeVo.setLabel(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXTER_ORGAN.getMessage()));
        customOrgTreeVoList.add(customOutOrgTreeVo);
        customOrgTreeVoList.addAll(this.sysStruMapper.getCustomOrgTree());
        SelectCustomOrgTreeVo selectCustomOrgTreeVo = new SelectCustomOrgTreeVo();
        selectCustomOrgTreeVo.setStruTree(HussarTreeParser.getTreeList(customOrgTreeVoList));
        if (dataRightId != null) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysRoleStruRights::getRoleDataRightsId, (Object)dataRightId);
            List roleStruRightsList = this.sysRoleStruRightsMapper.selectList((Wrapper)queryWrapper);
            List customDeptIdList = roleStruRightsList.stream().map(SysRoleStruRights::getStruid).collect(Collectors.toList());
            selectCustomOrgTreeVo.setSelectedStru(customDeptIdList);
        }
        return selectCustomOrgTreeVo;
    }

    @Override
    public List<SysOrgan> getOrganByIds(List<Long> ids) {
        if (HussarUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        return this.sysOrganMapper.selectList((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysOrgan::getId, ids));
    }

    @Override
    public Page<SearchOrganVo> searchOrgan(PageInfo pageInfo, SearchOrganUserDto searchOrganUserDto) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryOrgParams = new HashMap<String, Object>();
        String resultType = searchOrganUserDto.getResultType();
        List organIds = searchOrganUserDto.getOrganIds();
        if ("0".equals(resultType) || "3".equals(resultType)) {
            queryOrgParams.put("struIds", organIds);
            if (HussarUtils.isEmpty((Object)organIds)) {
                return page;
            }
        } else if ("1".equals(resultType)) {
            List list = this.sysStruMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStru::getId, (Collection)organIds)).eq(HussarDelflagEntity::getDelFlag, (Object)Character.valueOf('0')));
            List seqList = list.stream().map(SysStru::getStruSeq).distinct().collect(Collectors.toList());
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            for (String seq : seqList) {
                ((LambdaQueryWrapper)wrapper.or()).likeRight(SysStru::getStruSeq, (Object)seq);
            }
            List sysStrus = this.sysStruMapper.selectList((Wrapper)wrapper.eq(HussarDelflagEntity::getDelFlag, (Object)Character.valueOf('0')));
            List struIdList = sysStrus.stream().map(SysStru::getId).distinct().collect(Collectors.toList());
            queryOrgParams.put("struIds", struIdList);
            if (HussarUtils.isEmpty(struIdList)) {
                return page;
            }
        } else if ("2".equals(resultType)) {
            queryOrgParams.put("struIds", null);
        }
        queryOrgParams.put("name", SqlQueryUtil.transferSpecialChar((String)searchOrganUserDto.getName()));
        queryOrgParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        List<SearchOrganVo> searchOrganVos = this.sysStruMapper.searchOrgan(page, queryOrgParams);
        List<Long> struIds = searchOrganVos.stream().map(SearchOrganVo::getId).distinct().collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(struIds)) {
            Map<Long, Integer> userCounts = this.getUserCountByOrganId(struIds);
            for (SearchOrganVo organVo : searchOrganVos) {
                organVo.setUserCount(userCounts.get(organVo.getId()));
            }
        }
        page.setRecords(searchOrganVos);
        return page;
    }

    @Override
    public List<OrganVo> getAllSubOrgan(Long organId) {
        List<OrganVo> organNameAndId = new ArrayList<OrganVo>();
        ArrayList<Long> organIds = new ArrayList<Long>(Collections.singletonList(organId));
        List<Long> struIdList = this.getSubOrganByIds(organIds);
        if (HussarUtils.isNotEmpty(struIdList)) {
            organNameAndId = this.sysStruMapper.getOrganBaseInfo(struIdList);
        }
        return organNameAndId;
    }

    @Override
    public List<Long> getSubOrgans(List<Long> organIdList) {
        return this.getSubOrganByIds(organIdList);
    }

    @Override
    public Page<OrganizationTreeVo> getOrganListByType(PageInfo pageInfo, String organType, String organName) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        if (HussarUtils.isBlank((CharSequence)organType)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_TYPE_PARAM.getMessage()));
        }
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("organName", StringUtil.trimToEmpty((CharSequence)organName));
        queryParams.put("organType", organType);
        queryParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        List<OrganizationTreeVo> result = this.sysStruMapper.getOrganListByType((Page<OrganizationTreeVo>)page, queryParams);
        if (HussarUtils.isEmpty(result)) {
            page.setRecords(Collections.emptyList());
        }
        page.setRecords(result);
        return page;
    }

    @Override
    public List<OrganVo> getRoleOrgan(String roleId) {
        List<OrganVo> result = new ArrayList<OrganVo>();
        String[] idStr = roleId == null ? "".split(",") : roleId.split(",");
        Long[] idStrl = new Long[idStr.length];
        for (int i = 0; i < idStr.length; ++i) {
            idStrl[i] = Long.parseLong(idStr[i]);
        }
        List sysOrganRoleList = this.sysStruRoleService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStruRole::getGrantedRole, Arrays.asList(idStrl))).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
        List<Long> struIds = sysOrganRoleList.stream().map(SysStruRole::getStruId).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(struIds)) {
            result = this.sysStruMapper.getOrganNameAndId(struIds);
        }
        return result;
    }

    @Override
    public List<OrganTreeInitVo> getOrgansByParentIdAndLevel(Long parentId, int defaultLevelNum, boolean withStaff, boolean whetherHaveUser) {
        String fid = "";
        int parentLevel = 0;
        if (!parentId.equals(OrganConstants.ROOT_ORGAN_ID)) {
            fid = this.sysStruMapper.getStruFidByOrganId(parentId);
            parentLevel = this.sysStruMapper.getStruLevelByStruId(parentId);
            if (defaultLevelNum != 0) {
                defaultLevelNum += parentLevel;
            }
        }
        List<Object> organs = new ArrayList();
        organs = !withStaff ? (whetherHaveUser ? this.sysStruMapper.queryOrgansByFidAndLevelForUserTree(fid, defaultLevelNum, withStaff, whetherHaveUser) : this.sysStruMapper.queryOrgansByFidAndLevel(fid, defaultLevelNum, withStaff, whetherHaveUser)) : this.sysStruMapper.queryOrgansAndStaffsByFidAndLevel(fid, defaultLevelNum, withStaff, whetherHaveUser);
        for (OrganTreeInitVo organ : organs) {
            organ.setChangedLevel(organ.getStruLevel() - parentLevel + 1);
        }
        return organs;
    }

    @Override
    public List<OrganTreeInitVo> getOrganTree(List<OrganTreeInitVo> organs) {
        HashMap<Serializable, OrganTreeInitVo> idAndItem = new HashMap<Serializable, OrganTreeInitVo>();
        for (OrganTreeInitVo organTreeInitVo : organs) {
            idAndItem.put(organTreeInitVo.getId(), organTreeInitVo);
        }
        ArrayList<Serializable> highestIdList = new ArrayList<Serializable>();
        for (OrganTreeInitVo organ : organs) {
            OrganTreeInitVo organTreeInitVo = (OrganTreeInitVo)idAndItem.get(organ.getParentId());
            if (ToolUtil.isNotEmpty((Object)organTreeInitVo)) {
                organTreeInitVo.getChildren().add(organ);
                organ.setChangedLevel(organTreeInitVo.getChangedLevel() + 1);
                organTreeInitVo.setHasChildren(Boolean.valueOf(true));
                continue;
            }
            highestIdList.add(organ.getId());
        }
        if (highestIdList.size() > 1 && highestIdList.contains(OrganConstants.ROOT_ORGAN_ID)) {
            OrganTreeInitVo organTreeInitVo = (OrganTreeInitVo)idAndItem.get(OrganConstants.ROOT_ORGAN_ID);
            ArrayList<Long> removeList = new ArrayList<Long>();
            for (Long l : highestIdList) {
                if (l == OrganConstants.ROOT_ORGAN_ID) continue;
                removeList.add(l);
                OrganTreeInitVo organTreeInitVo2 = (OrganTreeInitVo)idAndItem.get(l);
                organTreeInitVo.getChildren().add(organTreeInitVo2);
                organTreeInitVo.setHasChildren(Boolean.valueOf(true));
            }
            highestIdList.removeAll(removeList);
        }
        ArrayList<OrganTreeInitVo> arrayList = new ArrayList<OrganTreeInitVo>();
        for (Long l : highestIdList) {
            arrayList.add((OrganTreeInitVo)idAndItem.get(l));
        }
        return arrayList;
    }

    @Override
    public Long getParentOrganId(Long id) {
        return this.sysStruMapper.getParentOrganId(id);
    }

    @Override
    public Integer getOrganLevelByOrganId(Long id) {
        return this.sysStruMapper.getOrganLevelByOrganId(id);
    }

    @Override
    public List<OrganTreeInitVo> getChildrenOrgan(Long parentId, boolean withStaff, boolean whetherHaveUser) {
        if (whetherHaveUser) {
            return this.sysStruMapper.queryChildrenOrganForUserTree(parentId, withStaff, whetherHaveUser);
        }
        if (!withStaff) {
            return this.sysStruMapper.queryChildrenOrgan(parentId, withStaff, whetherHaveUser);
        }
        return this.sysStruMapper.queryChildrenOrganAndStaff(parentId, withStaff, whetherHaveUser);
    }

    @Override
    public List<OrganTreeInitVo> getOrgansLikeName(String searchValue) {
        return this.sysStruMapper.queryOrgansLikeName(searchValue);
    }

    @Override
    public OrganTreeInitVo getOrganInfoById(Long struId) {
        return this.sysStruMapper.queryOrganInfoById(struId);
    }

    @Override
    public List<Long> getSubOrganByUser(Long userId) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruUser::getUserId, (Object)userId)).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        List struUsers = this.sysStruUserService.list((Wrapper)wrapper);
        List<Long> struIds = struUsers.stream().map(SysStruUser::getStruId).collect(Collectors.toList());
        return this.getSubOrganByIds(struIds);
    }

    @Override
    public List<Long> getParentStruByIds(List<Long> struIds) {
        return this.getParentByIds(struIds);
    }

    @Override
    public List<OrganizationTreeVo> lazyLoadOrganTreeSearch(QueryOrganizationDto queryOrganizationDto) {
        ArrayList<OrganizationTreeVo> result = new ArrayList<OrganizationTreeVo>();
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("parentId", queryOrganizationDto.getParentId());
        queryParams.put("organProperty", queryOrganizationDto.getOrganProperty());
        queryParams.put("organName", SqlQueryUtil.transferSpecialChar((String)queryOrganizationDto.getOrganName()));
        queryParams.put("organType", queryOrganizationDto.getOrganTypes());
        queryParams.put("organCode", SqlQueryUtil.transferSpecialChar((String)queryOrganizationDto.getOrganCode()));
        queryParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        List<OrganizationTreeVo> data = this.sysStruMapper.lazyLoadOrganTreeSearch(queryParams);
        this.fillOrganizationPermissions(data);
        result.addAll(data);
        return HussarTreeParser.getTreeList(result);
    }

    @Override
    public Boolean checkSameOrganName(String organName, Long parentId, Long id) {
        HashMap<String, Object> queryOrgParams = new HashMap<String, Object>();
        queryOrgParams.put("organName", organName);
        queryOrgParams.put("parentId", parentId);
        queryOrgParams.put("id", id);
        int count = this.sysStruMapper.getSameOrganName(queryOrgParams);
        return count <= 0;
    }

    @Override
    public Long getGradeOrganType(Long rootId, SecurityUser currentUser) {
        List roleIdList = currentUser.getRolesList();
        JudgeGradeAdminVo judgeGradeAdminVo = GradeAdminUtil.judgeGradeAdminByRoles(roleIdList);
        if (!judgeGradeAdminVo.getGradeAdmin().booleanValue()) {
            return rootId;
        }
        if (currentUser.getDeptId() == null) {
            return rootId;
        }
        List organTypes = judgeGradeAdminVo.getOrganTypes();
        SysStru stru = (SysStru)this.sysStruMapper.selectById(currentUser.getDeptId());
        String type = this.sysOrgManageService.getTopTypeByTypeInList(stru.getStruType(), organTypes);
        return this.sysOrgManageService.getParentOrganByType(currentUser.getDeptId(), type);
    }

    @Override
    public Page<OrganizationVo> queryOrganizationAllowPinyin(PageInfo pageInfo, QueryOrganizationDto queryOrganizationDto) {
        String organTypes;
        boolean isRoot;
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryOrgParams = new HashMap<String, Object>();
        queryOrgParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        String struFid = "/";
        Long parentStruId = queryOrganizationDto.getParentId();
        AssertUtil.isNotNull((Object)parentStruId, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_SUP_PARAM.getMessage()));
        String organProperty = queryOrganizationDto.getOrganProperty();
        AssertUtil.isNotNull((Object)organProperty, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGNA_PROPERTY_PARAM.getMessage()));
        boolean bl = isRoot = Objects.equals(Constants.ROOT_NODE_ID, parentStruId) || Objects.equals(Constants.OUT_STRU_NODE_ID, parentStruId);
        if (!isRoot) {
            SysStru pSysStru = (SysStru)Optional.ofNullable(this.sysStruMapper.selectById(parentStruId)).orElse(new SysStru());
            struFid = pSysStru.getStruFid();
        }
        if (HussarUtils.isNotBlank((CharSequence)(organTypes = queryOrganizationDto.getOrganTypes()))) {
            List<String> organTypesList = Arrays.asList(organTypes.split(","));
            queryOrgParams.put("organTypes", organTypesList);
        }
        int level = OrganUtil.getSubordinateLevel((String)OrganUtil.convert((String)struFid));
        queryOrgParams.put("parentStruId", OrganUtil.convert((Long)parentStruId));
        queryOrgParams.put("organName", SqlQueryUtil.transferSpecialChar((String)queryOrganizationDto.getOrganName()));
        queryOrgParams.put("organCode", SqlQueryUtil.transferSpecialChar((String)queryOrganizationDto.getOrganCode()));
        queryOrgParams.put("organProperty", queryOrganizationDto.getOrganProperty());
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        int gradePLevel = 0;
        if (currentUser.isGradeadmin()) {
            Long deptId = currentUser.getDeptId();
            SysStru gradePSysStru = (SysStru)this.sysStruMapper.selectById(deptId);
            gradePLevel = gradePSysStru.getStruLevel();
            int gradeDepStruLevel = gradePLevel + 1;
            int searchStruLevel = 0;
            if (!isRoot) {
                searchStruLevel = this.sysStruMapper.selectStruLevel(parentStruId);
            }
            if (searchStruLevel < gradeDepStruLevel) {
                struFid = ((SysStru)this.sysStruMapper.selectById(deptId)).getStruFid();
                level = OrganUtil.getSubordinateLevel((String)OrganUtil.convert((String)struFid));
            }
        }
        queryOrgParams.put("struFid", OrganUtil.convert((String)struFid));
        if (queryOrganizationDto instanceof QueryTransferOrganizationListDto) {
            QueryTransferOrganizationListDto dto = (QueryTransferOrganizationListDto)queryOrganizationDto;
            Long transferId = dto.getTransferId();
            SysStru struTemp = (SysStru)this.sysStruMapper.selectById(transferId);
            AssertUtil.isNotNull((Object)struTemp, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_ORGAN_TO_TRANSFER.getMessage()));
            List<Long> excludeIds = this.getTransferExcludeIds(struTemp);
            queryOrgParams.put("excludeIds", excludeIds);
            --level;
        }
        queryOrgParams.put("struLevel", level);
        List<OrganizationVo> organizationVos = this.sysStruMapper.queryOrganizationAllowPinyin((Page<OrganizationVo>)page, queryOrgParams);
        page.setRecords(organizationVos);
        return page;
    }

    @Override
    public Page<SearchOrganVo> searchOrganAllowPinyin(PageInfo pageInfo, SearchOrganUserDto searchOrganUserDto) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryOrgParams = new HashMap<String, Object>();
        String resultType = searchOrganUserDto.getResultType();
        List organIds = searchOrganUserDto.getOrganIds();
        List organTypes = searchOrganUserDto.getOrganTypes();
        if ("0".equals(resultType) || "3".equals(resultType)) {
            queryOrgParams.put("struIds", organIds);
            if (HussarUtils.isEmpty((Object)organIds)) {
                return page;
            }
        } else if ("1".equals(resultType)) {
            List list = this.sysStruMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStru::getId, (Collection)organIds)).eq(HussarDelflagEntity::getDelFlag, (Object)Character.valueOf('0')));
            List seqList = list.stream().map(SysStru::getStruSeq).distinct().collect(Collectors.toList());
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            for (String seq : seqList) {
                ((LambdaQueryWrapper)wrapper.or()).likeRight(SysStru::getStruSeq, (Object)seq);
            }
            List sysStrus = this.sysStruMapper.selectList((Wrapper)wrapper.eq(HussarDelflagEntity::getDelFlag, (Object)Character.valueOf('0')));
            List struIdList = sysStrus.stream().map(SysStru::getId).distinct().collect(Collectors.toList());
            queryOrgParams.put("struIds", struIdList);
            if (HussarUtils.isEmpty(struIdList)) {
                return page;
            }
        } else if ("2".equals(resultType)) {
            queryOrgParams.put("struIds", null);
        }
        queryOrgParams.put("organTypes", organTypes);
        queryOrgParams.put("organName", SqlQueryUtil.transferSpecialChar((String)searchOrganUserDto.getName()));
        queryOrgParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        List<SearchOrganVo> searchOrganVos = this.sysStruMapper.searchOrganAllowPinyin(page, queryOrgParams);
        List<Long> struIds = searchOrganVos.stream().map(SearchOrganVo::getId).distinct().collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(struIds)) {
            Map<Long, Integer> userCounts = this.getUserCountByOrganId(struIds);
            for (SearchOrganVo organVo : searchOrganVos) {
                organVo.setUserCount(userCounts.get(organVo.getId()));
            }
        }
        page.setRecords(searchOrganVos);
        return page;
    }
}

