/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.fasterxml.jackson.core.type.TypeReference;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.authorization.adapter.function.IHussarBaseFunctionAdapter;
import com.jxdinfo.hussar.authorization.config.CascadeProductionProperties;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.menu.dao.SysMenuMapper;
import com.jxdinfo.hussar.authorization.menu.model.SysMenu;
import com.jxdinfo.hussar.authorization.menu.service.ISysMenuManageService;
import com.jxdinfo.hussar.authorization.menu.vo.SysMenuVo;
import com.jxdinfo.hussar.authorization.permit.constants.PermitConstants;
import com.jxdinfo.hussar.authorization.permit.dao.SysFunctionResourcesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysFunctionsMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysResourceModulesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysResourcesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleFunctionsMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleGroupMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleResourceMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRolesMapper;
import com.jxdinfo.hussar.authorization.permit.dto.FuncDumpDto;
import com.jxdinfo.hussar.authorization.permit.dto.FuncInfoDto;
import com.jxdinfo.hussar.authorization.permit.dto.FuncOrderDto;
import com.jxdinfo.hussar.authorization.permit.dto.FunctionExportDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResTreeDto;
import com.jxdinfo.hussar.authorization.permit.enums.MigrateFuncResMenuEnum;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceModules;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleGroup;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseChangeFunctionService;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionModulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResManageService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourceMosulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleGroupService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.impl.FunctionRoleUserAuthorizationChangeReporter;
import com.jxdinfo.hussar.authorization.permit.vo.FuncDumpTreeVo;
import com.jxdinfo.hussar.authorization.permit.vo.FuncResMenuCheckTreeVo;
import com.jxdinfo.hussar.authorization.permit.vo.FuncResVo;
import com.jxdinfo.hussar.authorization.permit.vo.ImportVueFuncVo;
import com.jxdinfo.hussar.authorization.permit.vo.ResourceDetailVo;
import com.jxdinfo.hussar.authorization.permit.vo.SysModuleFunctionsVo;
import com.jxdinfo.hussar.base.config.shortcutconfig.model.ShortCutConfig;
import com.jxdinfo.hussar.common.base.HussarBaseServiceImpl;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.constant.tenant.TenantConstant;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.exception.ResourceWithFunctionException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.HussarTreeParser;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.common.utils.IdempotentJsonUtils;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.common.utils.SerializeUtils;
import com.jxdinfo.hussar.common.utils.TreeModelUtils;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.idtable.model.SysIdtable;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.functionmanager.FunctionChangeNotify;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.cache.util.HussarFixedCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.utils.TranslateUtil;
import com.jxdinfo.hussar.validator.service.IHussarValidateService;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.multipart.MultipartFile;

@HussarTokenDs
@Service
public class SysFunctionsServiceImpl
extends HussarBaseServiceImpl<SysFunctionsMapper, SysFunctions>
implements ISysFunctionsService {
    private static Logger logger = LoggerFactory.getLogger(SysFunctionsServiceImpl.class);
    @Resource
    private SysFunctionsMapper sysFunctionsMapper;
    @Resource
    private ISysIdtableService sysIdtableService;
    @Resource
    @Lazy
    private ISysResManageService sysResManageService;
    @Resource
    private ISysFunctionResourcesService sysFunctionResourcesService;
    @Resource
    private SysFunctionResourcesMapper sysFunctionResourcesMapper;
    @Resource
    private SysRoleFunctionsMapper sysRoleFunctionsMapper;
    @Resource
    private SysMenuMapper sysMenuMapper;
    @Resource
    private ISysFunctionModulesService sysFunctionModulesService;
    @Resource
    private SysResourcesMapper sysResourcesMapper;
    @Resource
    private SysResourceModulesMapper sysResourceModulesMapper;
    @Resource
    private ISysResourceMosulesService sysResourceMosulesService;
    @Resource
    private SysRolesMapper sysRolesMapper;
    @Resource
    private SysRoleResourceMapper sysRoleResourceMapper;
    @Resource
    private SysRoleGroupMapper sysRoleGroupMapper;
    @Resource
    private ISysMenuManageService sysMenuManageService;
    @Resource
    private ISysRolesService sysRolesService;
    @Resource
    private ISysRoleFunctionsService sysRoleFunctionsService;
    @Resource
    private ISysRoleGroupService sysRoleGroupService;
    @Resource
    private ISysRoleResourceService sysRoleResourceService;
    @Resource
    private ISysResourcesService sysResourcesService;
    @Resource
    private HussarTenantProperties hussarTenantProperties;
    @Autowired
    private IHussarBaseChangeFunctionService changeFunctionService;
    @Autowired
    protected IHussarValidateService validateService;
    @Autowired
    private ISysApplicationService sysApplicationService;
    @Resource
    private IHussarBaseFunctionAdapter hussarBaseFunctionAdapter;
    @Resource
    private FunctionChangeNotify functionChangeNotify;
    @Resource
    private HussarTenantProperties tenantProperties;
    @Resource
    private HussarThreadPoolConfiguration hussarThreadPoolConfiguration;
    @Resource
    private FunctionRoleUserAuthorizationChangeReporter functionRoleUserAuthorizationChangeReporter;
    @Resource
    private IHussarBaseRoleService hussarBaseRoleServiceImpl;
    @Resource
    private CascadeProductionProperties cascadeProductionProperties;

    public void insertOrUpdateFunctionList(List<SysFunctions> sysFunctionsList) {
        if (CollectionUtils.isEmpty(sysFunctionsList)) {
            logger.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FUNCTION_ADD_DATA.getMessage()), (Object)sysFunctionsList.size());
            logger.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FUNCTION_EDIT_DATA.getMessage()), (Object)sysFunctionsList.size());
            return;
        }
        List allFunctions = this.list();
        List allFunctionIds = allFunctions.stream().map(SysFunctions::getId).collect(Collectors.toList());
        ArrayList<SysFunctions> insertFunctions = new ArrayList<SysFunctions>();
        ArrayList<SysFunctions> updateFunctions = new ArrayList<SysFunctions>();
        Integer maxOrder = this.sysFunctionsMapper.getMaxOrder();
        SysIdtable sysIdtable = this.sysIdtableService.getIdtableByQuery("FUNCTION_CODE", "SYS_FUNCTIONS");
        Integer maxCode = sysIdtable.getIdValue();
        List allFunctionModules = this.sysFunctionModulesService.list();
        HashMap<Long, String> idAndModuleCode = new HashMap<Long, String>();
        for (SysFunctionModules sysFunctionModule : allFunctionModules) {
            idAndModuleCode.put(sysFunctionModule.getId(), sysFunctionModule.getFunctionModuleCode());
        }
        for (SysFunctions sysFunction : sysFunctionsList) {
            if (allFunctionIds.contains(sysFunction.getId())) {
                updateFunctions.add(sysFunction);
                continue;
            }
            Integer n = maxOrder;
            Integer n2 = maxOrder = Integer.valueOf(maxOrder + 1);
            n = maxCode;
            n2 = maxCode = Integer.valueOf(maxCode + 1);
            StringBuilder currentCode = new StringBuilder();
            int zeroLength = sysIdtable.getIdLength() - maxCode.toString().length();
            if (zeroLength < 0) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ENCODING_EXCEEDS_LENGTH.getMessage()));
            }
            currentCode.append((String)idAndModuleCode.get(sysFunction.getFunctionModuleId()));
            for (int i = 0; i < zeroLength; ++i) {
                currentCode.append("0");
            }
            currentCode.append(maxCode);
            sysFunction.setSeq(maxOrder);
            sysFunction.setFunctionCode(currentCode.toString());
            insertFunctions.add(sysFunction);
        }
        if (ToolUtil.isNotEmpty(insertFunctions)) {
            this.saveBatch(insertFunctions);
            sysIdtable.setIdValue(maxCode);
            this.sysIdtableService.updateIdtable(sysIdtable);
        }
        if (ToolUtil.isNotEmpty(updateFunctions)) {
            this.updateBatchById(updateFunctions);
        }
        logger.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FUNCTION_ADD_DATA.getMessage()), (Object)insertFunctions.size());
        logger.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FUNCTION_EDIT_DATA.getMessage()), (Object)updateFunctions.size());
    }

    public SysModuleFunctionsVo getFunctionDetail(Long functionId) {
        return this.hussarBaseFunctionAdapter.getFunctionDetail(functionId);
    }

    @HussarTransactional
    public boolean saveOrUpdateFunction(FuncInfoDto funcInfoDto) {
        boolean flag;
        String validateMsg = this.validateService.validate((Object)funcInfoDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        Long functionId = funcInfoDto.getFunctionId();
        List oldRoleIds = this.hussarBaseRoleServiceImpl.getRoleIdsByFunctionId(functionId);
        if (ToolUtil.isNotEmpty((Object)functionId)) {
            SysFunctions functions = (SysFunctions)this.sysFunctionsMapper.selectById(functionId);
            if (ToolUtil.isNotEmpty((Object)functions)) {
                boolean flag2;
                functions.setFunctionName(funcInfoDto.getFunctionName());
                functions.setDefaultResourceId(funcInfoDto.getDefaultResourceId());
                functions.setNameLangKey(funcInfoDto.getNameLangKey());
                if (HussarUtils.isEmpty((Object)funcInfoDto.getDefaultResourceId())) {
                    this.checkMenuReferences(functionId);
                }
                if (this.hussarTenantProperties.isEnabled() && ((DynamicDatasourceService)SpringContextHolder.getBean(DynamicDatasourceService.class)).getCurrentDatasourceName().equals("master")) {
                    Executor hussarBaseAuthorizationExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
                    hussarBaseAuthorizationExecutor.execute(() -> {
                        String cacheName = "tenant_info";
                        List cacheKeys = HussarFixedCacheUtil.getKeysLike((String)cacheName, (String)"?");
                        for (String cacheKey : cacheKeys) {
                            HussarTenantDefinition definition = (HussarTenantDefinition)HussarFixedCacheUtil.get((String)cacheName, (Object)cacheKey);
                            if (!HussarUtils.isNotEmpty((Object)definition)) continue;
                            HussarContextHolder.setTenant((String)definition.getConnName(), (String)definition.getTenantCode());
                            this.changeFunctionService.updateFunction(definition.getConnName(), funcInfoDto);
                            HussarCacheUtil.evictKeysLike((String)"resource_info", (String)"hussar_resource:");
                            HussarCacheUtil.evictKeysLike((String)"menu_info", (String)"hussar_menus:");
                        }
                    });
                }
                boolean bl = flag2 = this.sysResManageService.functionSave(functions, "1") > 0 && this.sysFunctionResourcesService.saveFunctionRes(functionId, funcInfoDto.getResources());
                if (!HussarUtils.equals((Object)1L, (Object)functions.getApplicationId())) {
                    this.functionChangeNotify.notify(DataChangeType.UPDATE, new Object[]{functions});
                }
                List newRoleIds = this.hussarBaseRoleServiceImpl.getRoleIdsByFunctionId(functionId);
                oldRoleIds.addAll(newRoleIds);
                if (HussarUtils.isEmpty((Object)functions.getApplicationId()) || functions.getApplicationId() == 1L) {
                    this.functionRoleUserAuthorizationChangeReporter.report(new Object[]{"role", oldRoleIds.stream().distinct().collect(Collectors.toList())});
                }
                return flag2;
            }
            return false;
        }
        SysFunctions functions = new SysFunctions();
        Long id = IdWorker.getId((Object)new SysFunctions());
        functions.setId(id);
        String functionCode = this.sysIdtableService.getCurrentCode("FUNCTION_CODE", "SYS_FUNCTIONS");
        functions.setFunctionCode(functionCode);
        functions.setFunctionModuleId(funcInfoDto.getParentModuleId());
        functions.setFunctionName(funcInfoDto.getFunctionName());
        functions.setDefaultResourceId(funcInfoDto.getDefaultResourceId());
        functions.setNameLangKey(funcInfoDto.getNameLangKey());
        functions.setIsSys("0");
        functions.setApplicationId(funcInfoDto.getApplicationId());
        boolean bl = flag = this.sysResManageService.functionSave(functions, "0") > 0 && this.sysFunctionResourcesService.saveFunctionRes(functions.getId(), funcInfoDto.getResources());
        if (!HussarUtils.equals((Object)1L, (Object)functions.getApplicationId())) {
            this.functionChangeNotify.notify(DataChangeType.INSERT, new Object[]{functions});
        }
        List newRoleIds = this.hussarBaseRoleServiceImpl.getRoleIdsByFunctionId(id);
        oldRoleIds.addAll(newRoleIds);
        if (HussarUtils.isEmpty((Object)functions.getApplicationId()) || functions.getApplicationId() == 1L) {
            this.functionRoleUserAuthorizationChangeReporter.report(new Object[]{"role", oldRoleIds.stream().distinct().collect(Collectors.toList())});
        }
        return flag;
    }

    private void checkMenuReferences(Long functionId) {
        long count = this.sysMenuMapper.selectCount((Wrapper)new LambdaQueryWrapper().eq(SysMenu::getFunctionId, (Object)functionId));
        if (count > 0L) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXIST_MENU_FUNCTION_DELETE_FAIL_DEFAULT_RES.getMessage()));
        }
    }

    @HussarTransactional
    public boolean deleteFunction(Long functionId) {
        boolean flag;
        if (ToolUtil.isEmpty((Object)functionId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ORGAN_FUNCTION_ID_NOT_NULL.getMessage()));
        }
        List resourceIds = this.sysFunctionResourcesMapper.getFunctionResourceList(functionId).stream().map(FuncResVo::getResourceId).collect(Collectors.toList());
        List menuList = this.sysMenuMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysMenu::getFunctionId, (Object)functionId));
        if (menuList.size() > 0) {
            throw new ResourceWithFunctionException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_FUNCTION_FAIL_WITH_MENU.getMessage()));
        }
        ArrayList<Long> ingoreRoleIds = new ArrayList<Long>();
        Long adminRoleId = SysUserAndRole.SUPERADMIN_ROLE.getValue();
        if (this.tenantProperties.isEnabled() && !((DynamicDatasourceService)SpringContextHolder.getBean(DynamicDatasourceService.class)).getCurrentDatasourceName().equals("master")) {
            adminRoleId = TenantConstant.ADMIN_ROLE;
        }
        ingoreRoleIds.add(adminRoleId);
        ingoreRoleIds.add(SysUserAndRole.DEVELOP_ROLE.getValue());
        List roleFunctionList = this.sysRoleFunctionsMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRoleFunctions::getFunctionId, (Object)functionId)).notIn(SysRoleFunctions::getRoleId, ingoreRoleIds));
        if (roleFunctionList.size() > 0) {
            throw new ResourceWithFunctionException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_FUNCTION_FAIL_WITH_ROLE.getMessage()));
        }
        SysFunctions functions = (SysFunctions)this.sysFunctionsMapper.selectById(functionId);
        List roleResourceList = this.sysRoleResourceService.selectRoleResByResIds(resourceIds);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("roleIds", ingoreRoleIds);
        queryParams.put("functionIds", Collections.singletonList(functionId));
        queryParams.put("relationSource", "1");
        boolean bl = flag = this.sysRoleFunctionsMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysRoleFunctions::getFunctionId, (Object)functionId)) >= 0 && this.sysRoleResourceMapper.deleteRelationForFuncId(queryParams) >= 0 && this.sysFunctionsMapper.deleteById(functionId) >= 0 && this.sysFunctionResourcesMapper.delete((Wrapper)new LambdaUpdateWrapper().eq(SysFunctionResources::getFunctionId, (Object)functionId)) >= 0;
        if (!HussarUtils.equals((Object)1L, (Object)functions.getApplicationId())) {
            this.functionChangeNotify.notify(DataChangeType.DELETE, new Object[]{functions});
        }
        if ((HussarUtils.isEmpty((Object)functions.getApplicationId()) || functions.getApplicationId() == 1L) && !resourceIds.isEmpty()) {
            ArrayList roleIds = new ArrayList();
            roleIds.addAll(roleResourceList.stream().map(SysRoleResource::getRoleId).collect(Collectors.toList()));
            this.functionRoleUserAuthorizationChangeReporter.report(new Object[]{"role", roleIds.stream().distinct().collect(Collectors.toList())});
        }
        return flag;
    }

    @HussarTransactional
    public boolean deleteFunction(String functionId) {
        return this.deleteFunction(Long.parseLong(functionId));
    }

    public ApiResponse updateMoveNode(FuncOrderDto funcOrderDto) {
        SysFunctions thatFunction;
        Long functionId = funcOrderDto.getFunctionId();
        Boolean isUp = funcOrderDto.getIsUp();
        if (ToolUtil.isEmpty((Object)functionId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ORGAN_FUNCTION_ID_NOT_NULL.getMessage()));
        }
        SysFunctions thisFunction = (SysFunctions)this.sysFunctionsMapper.selectById(functionId);
        List<SysFunctions> thatFunctions = isUp != false ? this.sysFunctionsMapper.seletListLt(thisFunction.getFunctionModuleId(), thisFunction.getSeq()) : this.sysFunctionsMapper.seletListGt(thisFunction.getFunctionModuleId(), thisFunction.getSeq());
        if (thatFunctions.size() > 0 && (thatFunction = thatFunctions.get(0)) != null) {
            Integer temp = thisFunction.getSeq();
            thisFunction.setSeq(thatFunction.getSeq());
            thatFunction.setSeq(temp);
            this.sysFunctionsMapper.updateById(thisFunction);
            this.sysFunctionsMapper.updateById(thatFunction);
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_OPERATE_SUCCESS.getMessage()));
    }

    public void exportFunction(FunctionExportDto functionExportDto, HttpServletResponse response) {
        List roleIds;
        if (HussarUtils.isBlank((CharSequence)functionExportDto.getFunctionIds())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ENTER_FUNCTION_ID_EMPTY.getMessage()));
        }
        List<String> funcAndModuleIds = Arrays.asList(functionExportDto.getFunctionIds().split(","));
        List funcAndModuleIdsLong = funcAndModuleIds.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        List sysFunctions = this.list((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysFunctions::getId, funcAndModuleIdsLong));
        List sysFunctionModules = this.sysFunctionModulesService.list((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysFunctionModules::getId, funcAndModuleIdsLong));
        List menuList = new ArrayList();
        if (Boolean.TRUE.equals(functionExportDto.getHasMenu())) {
            menuList = this.sysMenuMapper.selectList((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysMenu::getFunctionId, funcAndModuleIdsLong));
            List allMenus = this.sysMenuManageService.list();
            menuList = this.sysMenuManageService.getMenus(allMenus, menuList, menuList);
            menuList = menuList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<SysMenu>(Comparator.comparing(SysMenu::getId))), ArrayList::new));
        }
        List resourcesList = new ArrayList();
        List<SysResourceModules> resourceModulesList = new ArrayList<SysResourceModules>();
        List functionResourcesList = new ArrayList();
        List<Object> resourcesIds = new ArrayList();
        if (Boolean.TRUE.equals(functionExportDto.getHasResources()) && ToolUtil.isNotEmpty(resourcesIds = (functionResourcesList = this.sysFunctionResourcesMapper.selectList((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysFunctionResources::getFunctionId, funcAndModuleIdsLong))).stream().map(SysFunctionResources::getResourceId).distinct().collect(Collectors.toList()))) {
            resourcesList = this.sysResourcesMapper.selectList((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysResources::getId, resourcesIds));
            List allResourceModules = this.sysResourceMosulesService.list();
            List resourcesModuleIds = resourcesList.stream().map(SysResources::getModuleId).collect(Collectors.toList());
            resourceModulesList.addAll(this.sysResourceModulesMapper.selectList((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysResourceModules::getId, resourcesModuleIds)));
            resourceModulesList = this.getResourceModules(resourceModulesList, resourceModulesList, allResourceModules);
            resourceModulesList = resourceModulesList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<SysResourceModules>(Comparator.comparing(SysResourceModules::getId))), ArrayList::new));
        }
        List rolesList = new ArrayList();
        List roleFunctionsList = new ArrayList();
        List roleResourceList = new ArrayList();
        List roleGroupsList = new ArrayList();
        if (Boolean.TRUE.equals(functionExportDto.getHasRole()) && ToolUtil.isNotEmpty(roleIds = (roleFunctionsList = this.sysRoleFunctionsMapper.selectList((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysRoleFunctions::getFunctionId, funcAndModuleIdsLong))).stream().map(SysRoleFunctions::getRoleId).distinct().collect(Collectors.toList()))) {
            List roleGroupIds;
            rolesList = this.sysRolesMapper.selectList((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysRoles::getId, roleIds));
            if (Boolean.TRUE.equals(functionExportDto.getHasResources()) && ToolUtil.isNotEmpty(resourcesIds)) {
                LambdaQueryWrapper queryRoleRes = LambdaQueryUtil.getMultiQueryWrapper(SysRoleResource::getRoleId, roleIds);
                LambdaQueryUtil.wrapperWithMultiQuery((LambdaQueryWrapper)queryRoleRes, SysRoleResource::getResourceId, resourcesIds);
                queryRoleRes.eq(SysRoleResource::getRelationSource, (Object)"1");
                roleResourceList = this.sysRoleResourceMapper.selectList((Wrapper)queryRoleRes);
            }
            if (ToolUtil.isNotEmpty(roleGroupIds = rolesList.stream().map(SysRoles::getGroupId).collect(Collectors.toList()))) {
                roleGroupsList = this.sysRoleGroupMapper.selectList((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysRoleGroup::getId, roleGroupIds));
            }
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("functions", sysFunctions);
        data.put("functionModules", sysFunctionModules);
        data.put("menu", menuList);
        data.put("resources", resourcesList);
        data.put("resourceModules", resourceModulesList);
        data.put("functionResources", functionResourcesList);
        data.put("roles", rolesList);
        data.put("roleFunction", roleFunctionsList);
        data.put("roleResource", roleResourceList);
        data.put("roleGroups", roleGroupsList);
        data.put("export_type", "function");
        String fileName = "function_" + DateUtil.format((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)"yyyyMMdd_HHmmss") + ".hussar";
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
        response.setContentType("application/octet-stream");
        try {
            JsonUtil.getInstance().writeValue((OutputStream)response.getOutputStream(), data);
        }
        catch (IOException e) {
            logger.error(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXPORT_ERROR.getMessage()), (Throwable)e);
        }
    }

    @CacheEvict(value={"resource_info"}, allEntries=true)
    public ImportVueFuncVo importFunction(MultipartFile hussarFile) {
        Map data;
        if (ToolUtil.isEmpty((Object)hussarFile)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_IMPORT_FUNCTION_FILE_EMPTY.getMessage()));
        }
        ImportVueFuncVo importVueFuncVo = new ImportVueFuncVo();
        try {
            data = (Map)JsonUtil.getInstance().readValue(hussarFile.getInputStream(), Object.class);
        }
        catch (IOException e) {
            try {
                byte[] content = hussarFile.getBytes();
                data = (Map)SerializeUtils.deserialize((byte[])content);
            }
            catch (Exception ex) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_IMPORT_FAILED_PLATFORM.getMessage()));
            }
        }
        String exportType = (String)data.get("export_type");
        if (!"function".equals(exportType)) {
            importVueFuncVo.setErrorImport(exportType);
            importVueFuncVo.setSuccess("false");
            importVueFuncVo.setImportType("function");
            return importVueFuncVo;
        }
        List sysFunctionModules = (List)IdempotentJsonUtils.parse((String)IdempotentJsonUtils.toString(data.get("functionModules")), (TypeReference)new TypeReference<List<SysFunctionModules>>(){});
        this.sysFunctionModulesService.insertOrUpdateFunctionModuleList(sysFunctionModules);
        List sysFunctions = (List)IdempotentJsonUtils.parse((String)IdempotentJsonUtils.toString(data.get("functions")), (TypeReference)new TypeReference<List<SysFunctions>>(){});
        this.insertOrUpdateFunctionList(sysFunctions);
        List sysMenus = (List)IdempotentJsonUtils.parse((String)IdempotentJsonUtils.toString(data.get("menu")), (TypeReference)new TypeReference<List<SysMenu>>(){});
        this.sysMenuManageService.insertOrUpdateMenuList(sysMenus);
        List sysResourceModules = (List)IdempotentJsonUtils.parse((String)IdempotentJsonUtils.toString(data.get("resourceModules")), (TypeReference)new TypeReference<List<SysResourceModules>>(){});
        this.sysResourceMosulesService.insertOrUpdateResourcesModuleList(sysResourceModules);
        List sysResources = (List)IdempotentJsonUtils.parse((String)IdempotentJsonUtils.toString(data.get("resources")), (TypeReference)new TypeReference<List<SysResources>>(){});
        this.sysResManageService.insertOrUpdateResourcesList(sysResources);
        List sysFunctionResources = (List)IdempotentJsonUtils.parse((String)IdempotentJsonUtils.toString(data.get("functionResources")), (TypeReference)new TypeReference<List<SysFunctionResources>>(){});
        this.sysFunctionResourcesService.insertOrUpdateFunctionResource(sysFunctionResources);
        List sysRoles = (List)IdempotentJsonUtils.parse((String)IdempotentJsonUtils.toString(data.get("roles")), (TypeReference)new TypeReference<List<SysRoles>>(){});
        this.sysRolesService.insertOrUpdateRoleList(sysRoles);
        List sysRoleFunctions = (List)IdempotentJsonUtils.parse((String)IdempotentJsonUtils.toString(data.get("roleFunction")), (TypeReference)new TypeReference<List<SysRoleFunctions>>(){});
        this.sysRoleFunctionsService.insertOrUpdateRoleFunction(sysRoleFunctions);
        List sysRoleResources = (List)IdempotentJsonUtils.parse((String)IdempotentJsonUtils.toString(data.get("roleResource")), (TypeReference)new TypeReference<List<SysRoleResource>>(){});
        this.sysRoleResourceService.insertOrUpdateRoleResource(sysRoleResources);
        if (ToolUtil.isNotEmpty((Object)sysRoleFunctions)) {
            this.sysRoleFunctionsService.dataSyncByRoleFunc(sysRoleFunctions);
        }
        List sysRoleGroups = (List)IdempotentJsonUtils.parse((String)IdempotentJsonUtils.toString(data.get("roleGroups")), (TypeReference)new TypeReference<List<SysRoleGroup>>(){});
        this.sysRoleGroupService.insertOrUpdateRoleGroupList(sysRoleGroups);
        return importVueFuncVo;
    }

    public List<FuncDumpTreeVo> getFuncDumpGuideTree() {
        LambdaQueryWrapper functionsLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)functionsLambdaQueryWrapper.ne(SysFunctions::getIsSys, (Object)"1")).or()).isNull(SysFunctions::getIsSys);
        List allFuncions = this.list((Wrapper)functionsLambdaQueryWrapper);
        if (HussarUtils.isEmpty((Object)allFuncions)) {
            return Collections.emptyList();
        }
        List<Long> allFunctionIdList = allFuncions.stream().map(SysFunctions::getId).collect(Collectors.toList());
        Map<String, Object> allData = this.getDirectData(allFunctionIdList);
        allData.put("function", allFuncions);
        this.buildAssociations(allData);
        List<SysFunctionModules> functionModulesList = this.getFuncHeigherLevel(allFuncions);
        allData.put("functionModule", functionModulesList);
        List<FuncDumpTreeVo> result = this.createFuncDumpTreeVo(allData);
        return HussarTreeParser.getTreeList(result);
    }

    public Map<String, Object> getFuncResMenuDumpData(List<FuncDumpDto> funcDumpDtoList) {
        HashSet<Long> funcIdList = new HashSet<Long>();
        HashSet menuIdList = new HashSet();
        HashSet resIdList = new HashSet();
        List<Object> functionResourcesList = new ArrayList<SysFunctionResources>();
        for (FuncDumpDto item : funcDumpDtoList) {
            List itemResIdList;
            if (HussarUtils.isNotEmpty((Object)item.getFuncId())) {
                funcIdList.add(item.getFuncId());
            }
            if (HussarUtils.isNotEmpty((Object)item.getMenuIdList())) {
                menuIdList.addAll(item.getMenuIdList());
            }
            if (!HussarUtils.isNotEmpty((Object)(itemResIdList = item.getResIdList()))) continue;
            for (Long resId : itemResIdList) {
                SysFunctionResources sysFunctionResources = new SysFunctionResources();
                sysFunctionResources.setFunctionId(item.getFuncId());
                sysFunctionResources.setResourceId(resId);
                functionResourcesList.add(sysFunctionResources);
            }
            resIdList.addAll(itemResIdList);
        }
        HashMap<String, Object> allData = new HashMap<String, Object>();
        if (!HussarUtils.isNotEmpty(funcIdList)) {
            return allData;
        }
        List<SysFunctions> functionsList = this.listByIds(funcIdList);
        allData.put("function", functionsList);
        if (HussarUtils.isNotEmpty(menuIdList)) {
            List menuList = this.sysMenuManageService.getMenusByMenuIds(new ArrayList(menuIdList));
            allData.put("leafMenu", menuList);
        }
        List resourcesList = new ArrayList();
        if (HussarUtils.isNotEmpty(resIdList)) {
            resourcesList = this.sysResourcesService.selectResourcesByResIdsAddDtl(new ArrayList(resIdList));
            allData.put("resources", resourcesList);
            functionResourcesList = this.sysFunctionResourcesService.selectListByDoubleIds(functionResourcesList);
            allData.put("functionResources", functionResourcesList);
        }
        long total = (long)functionsList.size() + (long)resourcesList.size() + (long)functionResourcesList.size();
        allData.put("total", total);
        this.buildAssociations(allData);
        this.getHeigherLevel(allData);
        return allData;
    }

    public List<FuncDumpTreeVo> getFuncResMenuDumpTree(Map<String, Object> allData) {
        return HussarTreeParser.getTreeList(this.createFuncDumpTreeVo(allData));
    }

    public List<FuncResMenuCheckTreeVo> getFuncResMenuCheckTree(Map<String, Object> importData) {
        List menuList = (List)IdempotentJsonUtils.parse((String)IdempotentJsonUtils.toString((Object)importData.get("menu")), (TypeReference)new TypeReference<List<SysMenu>>(){});
        List leafMenuList = menuList.stream().filter(menu -> "1".equals(menu.getIsLeaf())).collect(Collectors.toList());
        importData.put("leafMenu", leafMenuList);
        this.buildAssociations(importData);
        return HussarTreeParser.getTreeList(this.creatFuncResMenuCheckTree(importData));
    }

    public List<FuncResMenuCheckTreeVo> creatFuncResMenuCheckTree(Map<String, Object> importData) {
        List importFunctionModuleList = (List)IdempotentJsonUtils.convert((Object)importData.get("functionModule"), (TypeReference)new TypeReference<List<SysFunctionModules>>(){});
        ArrayList<FuncResMenuCheckTreeVo> funcResMenuCheckTreeVoList = new ArrayList<FuncResMenuCheckTreeVo>(this.funcModuleToCheckTreeVo(importFunctionModuleList));
        funcResMenuCheckTreeVoList.addAll(this.funcToCheckTreeVo(importData));
        FuncResMenuCheckTreeVo root = new FuncResMenuCheckTreeVo();
        root.setId((Serializable)((Object)"1"));
        root.setParentId((Serializable)((Object)"0"));
        root.setLabel(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FUNCTION.getMessage()));
        root.setHasChildren(Boolean.valueOf(true));
        root.setIcon("module");
        root.setRowId("1");
        root.setTypeName(MigrateFuncResMenuEnum.FUNCTION_MODULE.getType());
        funcResMenuCheckTreeVoList.add(root);
        return funcResMenuCheckTreeVoList;
    }

    private Map<String, Object> getDirectData(List<Long> functionIdList) {
        HashMap<String, Object> allData = new HashMap<String, Object>();
        if (HussarUtils.isNotEmpty(functionIdList)) {
            List functionResourcesList = this.sysFunctionResourcesService.selectFunctionResByFuncIds(functionIdList);
            allData.put("functionResources", functionResourcesList);
            List resourceIdList = functionResourcesList.stream().map(SysFunctionResources::getResourceId).distinct().collect(Collectors.toList());
            if (HussarUtils.isNotEmpty(resourceIdList)) {
                List resourcesList = this.sysResourcesService.selectResourcesByResIds(resourceIdList);
                allData.put("resources", resourcesList);
            }
            List menuList = this.sysMenuManageService.getMenusByFunctionIds(functionIdList);
            allData.put("leafMenu", menuList);
        }
        return allData;
    }

    private void buildAssociations(Map<String, Object> allData) {
        List menuList;
        List functionResourcesList = (List)IdempotentJsonUtils.convert((Object)allData.get("functionResources"), (TypeReference)new TypeReference<List<SysFunctionResources>>(){});
        List resourceModulesList = (List)IdempotentJsonUtils.convert((Object)allData.get("resourceModule"), (TypeReference)new TypeReference<List<SysResourceModules>>(){});
        List resourcesList = (List)IdempotentJsonUtils.convert((Object)allData.get("resources"), (TypeReference)new TypeReference<List<ResourceDetailVo>>(){});
        if (HussarUtils.isNotEmpty((Object)functionResourcesList) && HussarUtils.isNotEmpty((Object)resourcesList)) {
            Map<Long, List<ResourceDetailVo>> funcResAssociation = this.buildFuncResAssociation(functionResourcesList, resourcesList);
            allData.put("funcResAssociation", funcResAssociation);
            if (HussarUtils.isEmpty((Object)resourceModulesList)) {
                resourceModulesList = this.sysResourceMosulesService.list();
            }
            Map<Long, List<SysResourceModules>> resAndResModuleAssociation = this.buildResAndModuleAssociation(resourcesList, resourceModulesList);
            allData.put("resModuleAssociation", resAndResModuleAssociation);
        }
        if (HussarUtils.isNotEmpty((Object)(menuList = (List)IdempotentJsonUtils.convert((Object)allData.get("leafMenu"), (TypeReference)new TypeReference<List<SysMenu>>(){})))) {
            this.buildMenuAssociation(menuList, allData);
        }
    }

    private void getHeigherLevel(Map<String, Object> allData) {
        long total;
        List sysFunctionsList = (List)IdempotentJsonUtils.convert((Object)allData.get("function"), (TypeReference)new TypeReference<List<SysFunctions>>(){});
        List<SysFunctionModules> sysFunctionModulesList = this.getFuncHeigherLevel(sysFunctionsList);
        allData.put("functionModule", sysFunctionModulesList);
        Map resourceModuleAssociation = (Map)IdempotentJsonUtils.convert((Object)allData.get("resModuleAssociation"), (TypeReference)new TypeReference<Map<Long, List<SysResourceModules>>>(){});
        Map heigherMenuAssociation = (Map)IdempotentJsonUtils.convert((Object)allData.get("leafMenuAndMenuAssociation"), (TypeReference)new TypeReference<Map<Long, List<SysMenu>>>(){});
        HashSet resourceModulesSet = new HashSet();
        HashSet menuSet = new HashSet();
        if (HussarUtils.isNotEmpty((Object)resourceModuleAssociation)) {
            Set resourceModuleKey = resourceModuleAssociation.keySet();
            for (Long resId : resourceModuleKey) {
                List resourceModulesList = (List)resourceModuleAssociation.get(resId);
                if (!HussarUtils.isNotEmpty((Object)resourceModulesList)) continue;
                resourceModulesSet.addAll(resourceModulesList);
            }
        }
        if (HussarUtils.isNotEmpty((Object)heigherMenuAssociation)) {
            Set menuKey = heigherMenuAssociation.keySet();
            for (Long menuId : menuKey) {
                List menuList = (List)heigherMenuAssociation.get(menuId);
                if (!HussarUtils.isNotEmpty((Object)menuList)) continue;
                menuSet.addAll(menuList);
            }
        }
        if (HussarUtils.isNotEmpty((Object)(total = ((Long)allData.get("total")).longValue()))) {
            total = total + (long)menuSet.size() + (long)sysFunctionModulesList.size() + (long)resourceModulesSet.size();
            allData.put("total", total);
        }
        allData.put("resourceModule", new ArrayList(resourceModulesSet));
        allData.put("menu", new ArrayList(menuSet));
    }

    private List<SysFunctionModules> getFuncHeigherLevel(List<SysFunctions> functionsList) {
        List<Object> functionModulesList = new ArrayList();
        if (HussarUtils.isNotEmpty(functionsList)) {
            List lastFuncModulIdList = functionsList.stream().map(SysFunctions::getFunctionModuleId).distinct().collect(Collectors.toList());
            List allFunctionModule = this.sysFunctionModulesService.list();
            functionModulesList = new ArrayList(this.sysFunctionModulesService.recursiveGetFuncModule(lastFuncModulIdList, (Collection)allFunctionModule, new HashSet()));
        }
        functionModulesList = functionModulesList.stream().sorted(Comparator.comparing(SysFunctionModules::getSeq)).collect(Collectors.toList());
        return functionModulesList;
    }

    private List<SysResourceModules> getResourceModules(List<SysResourceModules> result, List<SysResourceModules> children, List<SysResourceModules> allModules) {
        if (ToolUtil.isEmpty(children)) {
            return result;
        }
        List parentIds = children.stream().map(SysResourceModules::getParentModuleId).collect(Collectors.toList());
        if (ToolUtil.isEmpty(parentIds)) {
            return result;
        }
        ArrayList<SysResourceModules> parentModules = new ArrayList<SysResourceModules>();
        ArrayList<SysResourceModules> tempModules = new ArrayList<SysResourceModules>();
        for (SysResourceModules resourceModule : allModules) {
            if (parentIds.contains(resourceModule.getId())) {
                parentModules.add(resourceModule);
                continue;
            }
            tempModules.add(resourceModule);
        }
        result.addAll(parentModules);
        return this.getResourceModules(result, parentModules, tempModules);
    }

    private Map<Long, List<ResourceDetailVo>> buildFuncResAssociation(List<SysFunctionResources> functionResourcesList, List<ResourceDetailVo> resourcesList) {
        HashMap<Long, ResourceDetailVo> idResMap = new HashMap<Long, ResourceDetailVo>();
        for (ResourceDetailVo res : resourcesList) {
            idResMap.put(res.getId(), res);
        }
        LinkedMultiValueMap funcResAssociationMap = new LinkedMultiValueMap();
        for (SysFunctionResources funcRes : functionResourcesList) {
            ResourceDetailVo resource = (ResourceDetailVo)idResMap.get(funcRes.getResourceId());
            if (!HussarUtils.isNotEmpty((Object)resource)) continue;
            funcResAssociationMap.add((Object)funcRes.getFunctionId(), (Object)resource);
        }
        return funcResAssociationMap;
    }

    private void buildMenuAssociation(List<SysMenu> menuList, Map<String, Object> allData) {
        LinkedMultiValueMap menuAssocation = new LinkedMultiValueMap();
        LinkedMultiValueMap funcMenuAssocation = new LinkedMultiValueMap();
        List allMenuList = this.sysMenuManageService.list();
        List packageMenuList = (List)IdempotentJsonUtils.convert((Object)allData.get("menu"), (TypeReference)new TypeReference<List<SysMenu>>(){});
        if (HussarUtils.isNotEmpty((Object)packageMenuList)) {
            allMenuList.addAll(packageMenuList);
            allMenuList = allMenuList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<SysMenu>(Comparator.comparing(SysMenu::getId))), ArrayList::new));
        }
        for (SysMenu item : menuList) {
            ArrayList<SysMenu> branchMenu = new ArrayList<SysMenu>();
            branchMenu.add(item);
            menuAssocation.put((Object)item.getId(), this.sysMenuManageService.getMenuBranch(allMenuList, item, branchMenu));
            funcMenuAssocation.add((Object)item.getFunctionId(), (Object)item);
        }
        allData.put("funcMenuAssociation", funcMenuAssocation);
        allData.put("leafMenuAndMenuAssociation", menuAssocation);
    }

    private Map<Long, List<SysResourceModules>> buildResAndModuleAssociation(List<ResourceDetailVo> resourcesList, List<SysResourceModules> allResourceModules) {
        HashMap<Long, List<SysResourceModules>> resAndResModuleAssociation = new HashMap<Long, List<SysResourceModules>>();
        List resModuleIdList = resourcesList.stream().map(SysResources::getModuleId).distinct().collect(Collectors.toList());
        ArrayList<SysResourceModules> resourceModulesList = new ArrayList<SysResourceModules>();
        for (SysResourceModules item : allResourceModules) {
            if (!resModuleIdList.contains(item.getId())) continue;
            resourceModulesList.add(item);
        }
        HashMap<Long, SysResourceModules> resourceModulesMap = new HashMap<Long, SysResourceModules>();
        for (SysResourceModules item : resourceModulesList) {
            resourceModulesMap.put(item.getId(), item);
        }
        for (ResourceDetailVo resource : resourcesList) {
            SysResourceModules resourceModule = (SysResourceModules)resourceModulesMap.get(resource.getModuleId());
            if (!HussarUtils.isNotEmpty((Object)resourceModule)) continue;
            ArrayList<SysResourceModules> modulesList = new ArrayList<SysResourceModules>();
            modulesList.add(resourceModule);
            resAndResModuleAssociation.put(resource.getId(), this.sysResourceMosulesService.getResourceModulesByOneRes(modulesList, resourceModule, allResourceModules));
        }
        return resAndResModuleAssociation;
    }

    private List<FuncDumpTreeVo> createFuncDumpTreeVo(Map<String, Object> allData) {
        List functionModulesList = (List)IdempotentJsonUtils.convert((Object)allData.get("functionModule"), (TypeReference)new TypeReference<List<SysFunctionModules>>(){});
        ArrayList<FuncDumpTreeVo> funcDumpTreeVoList = new ArrayList<FuncDumpTreeVo>(this.funcModuleToDumpTreeVo(functionModulesList));
        funcDumpTreeVoList.addAll(this.functionToDumpTreeVo(allData));
        return funcDumpTreeVoList;
    }

    private List<FuncDumpTreeVo> funcModuleToDumpTreeVo(List<SysFunctionModules> functionModulesList) {
        ArrayList<FuncDumpTreeVo> funcDumpTreeVoList = new ArrayList<FuncDumpTreeVo>();
        FuncDumpTreeVo root = new FuncDumpTreeVo();
        root.setId((Serializable)((Object)"1"));
        root.setLabel(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FUNCTION.getMessage()));
        root.setHasChildren(Boolean.valueOf(true));
        root.setIcon("module");
        root.setRowId("1");
        root.setTypeName(MigrateFuncResMenuEnum.FUNCTION_MODULE.getType());
        funcDumpTreeVoList.add(root);
        for (SysFunctionModules item : functionModulesList) {
            FuncDumpTreeVo funcDumpTreeVo = new FuncDumpTreeVo();
            funcDumpTreeVo.setId((Serializable)((Object)item.getId().toString()));
            funcDumpTreeVo.setLabel(item.getFunctionModuleName());
            funcDumpTreeVo.setParentId((Serializable)((Object)item.getParentModuleId().toString()));
            funcDumpTreeVo.setHasChildren(Boolean.valueOf(true));
            funcDumpTreeVo.setIcon("module");
            funcDumpTreeVo.setRowId(item.getId().toString());
            funcDumpTreeVo.setTypeName(MigrateFuncResMenuEnum.FUNCTION_MODULE.getType());
            funcDumpTreeVoList.add(funcDumpTreeVo);
        }
        return funcDumpTreeVoList;
    }

    private List<FuncResMenuCheckTreeVo> funcModuleToCheckTreeVo(List<SysFunctionModules> functionModulesList) {
        ArrayList<FuncResMenuCheckTreeVo> funcResMenuCheckTreeVoList = new ArrayList<FuncResMenuCheckTreeVo>();
        for (SysFunctionModules item : functionModulesList) {
            FuncResMenuCheckTreeVo funcResMenuCheckTreeVo = new FuncResMenuCheckTreeVo();
            funcResMenuCheckTreeVo.setId((Serializable)((Object)(item.getId() + "")));
            funcResMenuCheckTreeVo.setLabel(item.getFunctionModuleName());
            funcResMenuCheckTreeVo.setParentId((Serializable)((Object)(item.getParentModuleId() + "")));
            funcResMenuCheckTreeVo.setHasChildren(Boolean.valueOf(true));
            funcResMenuCheckTreeVo.setIcon("module");
            funcResMenuCheckTreeVo.setRowId(item.getId().toString());
            funcResMenuCheckTreeVo.setTypeName(MigrateFuncResMenuEnum.FUNCTION_MODULE.getType());
            funcResMenuCheckTreeVoList.add(funcResMenuCheckTreeVo);
        }
        return funcResMenuCheckTreeVoList;
    }

    private List<FuncResMenuCheckTreeVo> funcToCheckTreeVo(Map<String, Object> importData) {
        ArrayList<FuncResMenuCheckTreeVo> result = new ArrayList<FuncResMenuCheckTreeVo>();
        List functionsList = (List)IdempotentJsonUtils.convert((Object)importData.get("function"), (TypeReference)new TypeReference<List<SysFunctions>>(){});
        if (HussarUtils.isEmpty((Object)functionsList)) {
            return Collections.emptyList();
        }
        List importResDataList = (List)IdempotentJsonUtils.convert((Object)importData.get("resources"), (TypeReference)new TypeReference<List<ResourceDetailVo>>(){});
        List importMenuDataList = (List)IdempotentJsonUtils.convert((Object)importData.get("menu"), (TypeReference)new TypeReference<List<SysMenu>>(){});
        List importFuncModuleList = (List)IdempotentJsonUtils.convert((Object)importData.get("functionModule"), (TypeReference)new TypeReference<List<SysFunctionModules>>(){});
        Map menuAssociation = (Map)IdempotentJsonUtils.convert((Object)importData.get("funcMenuAssociation"), (TypeReference)new TypeReference<Map<Long, List<SysMenu>>>(){});
        Map funcResAsscationMap = (Map)IdempotentJsonUtils.convert((Object)importData.get("funcResAssociation"), (TypeReference)new TypeReference<Map<Long, List<ResourceDetailVo>>>(){});
        Map resAndResModuleMap = (Map)IdempotentJsonUtils.convert((Object)importData.get("resModuleAssociation"), (TypeReference)new TypeReference<Map<Long, List<SysResourceModules>>>(){});
        Map leafMenuAndMenuAssociation = (Map)IdempotentJsonUtils.convert((Object)importData.get("leafMenuAndMenuAssociation"), (TypeReference)new TypeReference<Map<Long, List<SysMenu>>>(){});
        HashMap<Long, SysFunctions> localFuncMap = new HashMap<Long, SysFunctions>();
        HashMap<Long, ResourceDetailVo> localResMap = new HashMap<Long, ResourceDetailVo>();
        HashMap<Long, ResourceDetailVo> importResMap = new HashMap<Long, ResourceDetailVo>();
        HashMap<Long, SysFunctionModules> importFuncModuleMap = new HashMap<Long, SysFunctionModules>();
        HashMap<Long, SysMenu> localMenuMap = new HashMap<Long, SysMenu>();
        List functionidList = functionsList.stream().map(SysFunctions::getId).collect(Collectors.toList());
        List<SysFunctions> localFuncList = this.listByIds(functionidList);
        for (SysFunctions localFunc : localFuncList) {
            localFuncMap.put(localFunc.getId(), localFunc);
        }
        for (SysFunctionModules importFuncModule : importFuncModuleList) {
            importFuncModuleMap.put(importFuncModule.getId(), importFuncModule);
        }
        if (HussarUtils.isNotEmpty((Object)importMenuDataList)) {
            List menuIdList = importMenuDataList.stream().map(SysMenu::getId).collect(Collectors.toList());
            List localMenuList = this.sysMenuManageService.getMenusByMenuIds(menuIdList);
            for (SysMenu localMenu : localMenuList) {
                localMenuMap.put(localMenu.getId(), localMenu);
            }
        }
        if (HussarUtils.isNotEmpty((Object)importResDataList)) {
            List resIdList = importResDataList.stream().map(SysResources::getId).collect(Collectors.toList());
            List localResList = this.sysResourcesService.selectResourcesByResIdsAddDtl(resIdList);
            for (ResourceDetailVo localRes : localResList) {
                localResMap.put(localRes.getId(), localRes);
            }
            for (ResourceDetailVo importRes : importResDataList) {
                importResMap.put(importRes.getId(), importRes);
            }
        }
        for (SysFunctions function : functionsList) {
            List resourcesList;
            List menuList;
            ArrayList<FuncResMenuCheckTreeVo> funcResMenuCheckTreeVoList = new ArrayList<FuncResMenuCheckTreeVo>();
            FuncResMenuCheckTreeVo funcResMenuCheckTreeVo = new FuncResMenuCheckTreeVo();
            funcResMenuCheckTreeVo.setId((Serializable)((Object)(function.getId() + "")));
            funcResMenuCheckTreeVo.setTypeName(MigrateFuncResMenuEnum.FUNCTION.getType());
            funcResMenuCheckTreeVo.setLabel(function.getFunctionName());
            funcResMenuCheckTreeVo.setParentId((Serializable)((Object)(function.getFunctionModuleId() + "")));
            funcResMenuCheckTreeVo.setIcon("function");
            funcResMenuCheckTreeVo.setRowId(function.getId().toString());
            funcResMenuCheckTreeVo.setImportData((Object)this.migrationGetFunctionDetail(function, importFuncModuleMap, importResMap));
            SysFunctions localFunc = (SysFunctions)localFuncMap.get(function.getId());
            if (HussarUtils.isNotEmpty((Object)localFunc)) {
                if (localFunc.equals((Object)function)) {
                    funcResMenuCheckTreeVo.setSelfChange(PermitConstants.NO_CHANGE);
                } else {
                    funcResMenuCheckTreeVo.setSelfChange(PermitConstants.MODIFY);
                }
            } else {
                funcResMenuCheckTreeVo.setSelfChange(PermitConstants.ADD);
            }
            int menuChagneType = 0;
            if (HussarUtils.isNotEmpty((Object)menuAssociation) && HussarUtils.isNotEmpty((Object)(menuList = (List)menuAssociation.get(function.getId())))) {
                Map<String, Object> menuCheckTreeMap = this.menuToCheckTreeVo(menuList, function, leafMenuAndMenuAssociation, localMenuMap);
                List menuCheckTreeVoList = (List)IdempotentJsonUtils.convert((Object)menuCheckTreeMap.get("menuCheckTree"), (TypeReference)new TypeReference<List<FuncResMenuCheckTreeVo>>(){});
                funcResMenuCheckTreeVoList.addAll(menuCheckTreeVoList);
                menuChagneType = (Integer)menuCheckTreeMap.get("changType");
            }
            int resChangeType = 0;
            if (HussarUtils.isNotEmpty((Object)funcResAsscationMap) && HussarUtils.isNotEmpty((Object)(resourcesList = (List)funcResAsscationMap.get(function.getId())))) {
                Map<String, Object> resCheckTreeMap = this.resToCheckTreeVo(resourcesList, function.getId(), function.getDefaultResourceId(), resAndResModuleMap, localResMap);
                List checkTreeVoList = (List)IdempotentJsonUtils.convert((Object)resCheckTreeMap.get("funcCheckTree"), (TypeReference)new TypeReference<List<FuncResMenuCheckTreeVo>>(){});
                funcResMenuCheckTreeVoList.addAll(checkTreeVoList);
                resChangeType = (Integer)resCheckTreeMap.get("changType");
            }
            funcResMenuCheckTreeVo.setHasChildren(Boolean.valueOf(HussarUtils.isNotEmpty(funcResMenuCheckTreeVoList)));
            int childrenChangeType = Math.max(menuChagneType, resChangeType);
            funcResMenuCheckTreeVo.setChildrenChange(Integer.valueOf(childrenChangeType));
            funcResMenuCheckTreeVoList.add(funcResMenuCheckTreeVo);
            result.addAll(funcResMenuCheckTreeVoList);
        }
        return result;
    }

    private List<FuncDumpTreeVo> functionToDumpTreeVo(Map<String, Object> allData) {
        List functionsList = (List)IdempotentJsonUtils.parse((String)IdempotentJsonUtils.toString((Object)allData.get("function")), (TypeReference)new TypeReference<List<SysFunctions>>(){});
        if (HussarUtils.isEmpty((Object)functionsList)) {
            return Collections.emptyList();
        }
        ArrayList<FuncDumpTreeVo> result = new ArrayList<FuncDumpTreeVo>();
        Map menuAssociation = (Map)IdempotentJsonUtils.convert((Object)allData.get("funcMenuAssociation"), (TypeReference)new TypeReference<Map<Long, List<SysMenu>>>(){});
        menuAssociation = menuAssociation == null ? new HashMap() : menuAssociation;
        Map funcResAsscationMap = (Map)IdempotentJsonUtils.convert((Object)allData.get("funcResAssociation"), (TypeReference)new TypeReference<Map<Long, List<SysResources>>>(){});
        funcResAsscationMap = funcResAsscationMap == null ? new HashMap() : funcResAsscationMap;
        Map resAndResModuleMap = (Map)IdempotentJsonUtils.convert((Object)allData.get("resModuleAssociation"), (TypeReference)new TypeReference<Map<Long, List<SysResourceModules>>>(){});
        resAndResModuleMap = resAndResModuleMap == null ? new HashMap() : resAndResModuleMap;
        Map leafMenuAndMenuAssociation = (Map)IdempotentJsonUtils.convert((Object)allData.get("leafMenuAndMenuAssociation"), (TypeReference)new TypeReference<Map<Long, List<SysMenu>>>(){});
        leafMenuAndMenuAssociation = leafMenuAndMenuAssociation == null ? new HashMap() : leafMenuAndMenuAssociation;
        HashMap<Long, String> errorResMap = new HashMap<Long, String>();
        for (SysFunctions function : functionsList) {
            List resourcesList;
            ArrayList<FuncDumpTreeVo> funcDumpTreeVoList = new ArrayList<FuncDumpTreeVo>();
            FuncDumpTreeVo funcDumpTreeVo = new FuncDumpTreeVo();
            funcDumpTreeVo.setId((Serializable)((Object)function.getId().toString()));
            funcDumpTreeVo.setTypeName(MigrateFuncResMenuEnum.FUNCTION.getType());
            funcDumpTreeVo.setLabel(function.getFunctionName());
            funcDumpTreeVo.setParentId((Serializable)((Object)function.getFunctionModuleId().toString()));
            funcDumpTreeVo.setIcon("function");
            funcDumpTreeVo.setRowId(function.getId().toString());
            List menuList = (List)menuAssociation.get(function.getId());
            if (HussarUtils.isNotEmpty((Object)menuList)) {
                funcDumpTreeVoList.addAll(this.menuToDumpTreeVo(menuList, function.getId(), leafMenuAndMenuAssociation));
            }
            if (HussarUtils.isNotEmpty((Object)(resourcesList = (List)funcResAsscationMap.get(function.getId())))) {
                funcDumpTreeVoList.addAll(this.resToDumpTreeVo(resourcesList, function.getId(), function.getDefaultResourceId(), resAndResModuleMap, errorResMap));
            }
            funcDumpTreeVo.setHasChildren(Boolean.valueOf(HussarUtils.isNotEmpty(funcDumpTreeVoList)));
            funcDumpTreeVoList.add(funcDumpTreeVo);
            result.addAll(funcDumpTreeVoList);
        }
        if (!errorResMap.isEmpty()) {
            StringBuilder prompt = new StringBuilder();
            for (Map.Entry errorRes : errorResMap.entrySet()) {
                if (HussarUtils.isNotEmpty((Object)prompt)) {
                    prompt.append("\uff1b");
                }
                prompt.append((String)errorRes.getValue());
                prompt.append("\uff08");
                prompt.append(errorRes.getKey());
                prompt.append("\uff09");
            }
            throw new BaseException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8d44\u6e90\u6a21\u5757\uff0c\u8d44\u6e90\u5982\u4e0b\uff1a" + prompt);
        }
        return result;
    }

    private Map<String, Object> menuToCheckTreeVo(List<SysMenu> menuList, SysFunctions function, Map<Long, List<SysMenu>> leafMenuAndMenu, Map<Long, SysMenu> menuMap) {
        ArrayList<FuncResMenuCheckTreeVo> result = new ArrayList<FuncResMenuCheckTreeVo>();
        boolean modifyFlag = false;
        boolean addFlag = false;
        Long functionId = function.getId();
        FuncResMenuCheckTreeVo menuRoot = new FuncResMenuCheckTreeVo();
        String rootId = functionId + "-menu";
        menuRoot.setId((Serializable)((Object)rootId));
        menuRoot.setHasChildren(Boolean.valueOf(true));
        menuRoot.setParentId((Serializable)((Object)functionId.toString()));
        menuRoot.setLabel(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MENU.getMessage()));
        menuRoot.setIcon("tree-folder");
        menuRoot.setRowId(rootId);
        menuRoot.setTypeName(MigrateFuncResMenuEnum.MENU_FILE.getType());
        result.add(menuRoot);
        for (SysMenu menu : menuList) {
            FuncResMenuCheckTreeVo funcResMenuCheckTreeVo = new FuncResMenuCheckTreeVo();
            funcResMenuCheckTreeVo.setId((Serializable)((Object)menu.getId().toString()));
            funcResMenuCheckTreeVo.setParentId((Serializable)((Object)rootId));
            funcResMenuCheckTreeVo.setHasChildren(Boolean.valueOf(false));
            funcResMenuCheckTreeVo.setIcon("tree-menu");
            funcResMenuCheckTreeVo.setRowId(menu.getId().toString() + functionId);
            funcResMenuCheckTreeVo.setTypeName(MigrateFuncResMenuEnum.MENU.getType());
            String label = this.migrateMenuLabel(leafMenuAndMenu.get(menu.getId()));
            funcResMenuCheckTreeVo.setLabel(label);
            funcResMenuCheckTreeVo.setImportData((Object)this.migrationGetMenuDetail(menu, leafMenuAndMenu.get(menu.getId()), function.getFunctionName()));
            SysMenu localMenu = menuMap.get(menu.getId());
            if (HussarUtils.isNotEmpty((Object)localMenu)) {
                if (localMenu.equals((Object)menu)) {
                    funcResMenuCheckTreeVo.setSelfChange(PermitConstants.NO_CHANGE);
                } else {
                    funcResMenuCheckTreeVo.setSelfChange(PermitConstants.MODIFY);
                    modifyFlag = true;
                }
            } else {
                funcResMenuCheckTreeVo.setSelfChange(PermitConstants.ADD);
                addFlag = true;
            }
            result.add(funcResMenuCheckTreeVo);
        }
        int changeType = modifyFlag ? PermitConstants.MODIFY : (addFlag ? PermitConstants.ADD.intValue() : PermitConstants.NO_CHANGE.intValue());
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("menuCheckTree", result);
        resultMap.put("changType", changeType);
        return resultMap;
    }

    private List<FuncDumpTreeVo> menuToDumpTreeVo(List<SysMenu> menuList, Long functionId, Map<Long, List<SysMenu>> leafMenuAndMenu) {
        ArrayList<FuncDumpTreeVo> result = new ArrayList<FuncDumpTreeVo>();
        FuncDumpTreeVo root = new FuncDumpTreeVo();
        String rootId = functionId + "-menu";
        root.setId((Serializable)((Object)rootId));
        root.setHasChildren(Boolean.valueOf(true));
        root.setParentId((Serializable)((Object)functionId.toString()));
        root.setLabel(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MENU.getMessage()));
        root.setIcon("tree-folder");
        root.setRowId(rootId);
        root.setTypeName(MigrateFuncResMenuEnum.MENU_FILE.getType());
        result.add(root);
        for (SysMenu menu : menuList) {
            FuncDumpTreeVo funcDumpTreeVo = new FuncDumpTreeVo();
            funcDumpTreeVo.setId((Serializable)((Object)menu.getId().toString()));
            funcDumpTreeVo.setParentId((Serializable)((Object)rootId));
            funcDumpTreeVo.setHasChildren(Boolean.valueOf(false));
            funcDumpTreeVo.setIcon("tree-menu");
            funcDumpTreeVo.setTypeName(MigrateFuncResMenuEnum.MENU.getType());
            String label = this.migrateMenuLabel(leafMenuAndMenu.get(menu.getId()));
            funcDumpTreeVo.setLabel(label);
            funcDumpTreeVo.setRowId(menu.getId().toString() + functionId);
            result.add(funcDumpTreeVo);
        }
        return result;
    }

    private String migrateMenuLabel(List<SysMenu> menuList) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = menuList.size() - 1; i >= 0; --i) {
            stringBuilder.append(menuList.get(i).getText()).append('/');
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    private List<FuncDumpTreeVo> resToDumpTreeVo(List<SysResources> resourcesList, Long functionId, Long resId, Map<Long, List<SysResourceModules>> resModuleAssociation, Map<Long, String> errorResMap) {
        ArrayList<FuncDumpTreeVo> result = new ArrayList<FuncDumpTreeVo>();
        FuncDumpTreeVo root = new FuncDumpTreeVo();
        String rootId = functionId + "-res";
        root.setId((Serializable)((Object)rootId));
        root.setHasChildren(Boolean.valueOf(true));
        root.setParentId((Serializable)((Object)functionId.toString()));
        root.setLabel(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RESOURCE.getMessage()));
        root.setIcon("tree-folder");
        root.setRowId(rootId);
        root.setTypeName(MigrateFuncResMenuEnum.RES_FILE.getType());
        result.add(root);
        for (SysResources item : resourcesList) {
            List<SysResourceModules> resourceModulesList;
            FuncDumpTreeVo funcDumpTreeVo = new FuncDumpTreeVo();
            funcDumpTreeVo.setId((Serializable)((Object)item.getId().toString()));
            funcDumpTreeVo.setHasChildren(Boolean.valueOf(false));
            funcDumpTreeVo.setParentId((Serializable)((Object)rootId));
            funcDumpTreeVo.setIcon(MigrateFuncResMenuEnum.of((String)item.getResTypeId()) != null ? item.getResTypeId() : "my-res");
            funcDumpTreeVo.setRowId(item.getId().toString() + functionId);
            funcDumpTreeVo.setTypeName(item.getResTypeId());
            MigrateFuncResMenuEnum type = MigrateFuncResMenuEnum.of((String)item.getResTypeId());
            if (HussarUtils.isNotEmpty((Object)type)) {
                funcDumpTreeVo.setTypeLabel(type.getDescription());
            } else {
                funcDumpTreeVo.setTypeLabel(this.getResTypeDes(item.getResTypeId()));
            }
            if (item.getId().equals(resId)) {
                funcDumpTreeVo.setRemark(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FUNCTION_MAIN_RESOURCE.getMessage()));
            }
            if (HussarUtils.isEmpty(resourceModulesList = resModuleAssociation.get(item.getId()))) {
                errorResMap.put(item.getId(), item.getResourceName());
                continue;
            }
            String label = this.migrateResModuleLabel(resourceModulesList) + item.getResourceName();
            funcDumpTreeVo.setLabel(label);
            funcDumpTreeVo.setTreeType("res");
            result.add(funcDumpTreeVo);
        }
        return result;
    }

    private Map<String, Object> resToCheckTreeVo(List<ResourceDetailVo> resourcesList, Long functionId, Long resId, Map<Long, List<SysResourceModules>> resModuleAssociation, Map<Long, ResourceDetailVo> resourcesMap) {
        ArrayList<FuncResMenuCheckTreeVo> result = new ArrayList<FuncResMenuCheckTreeVo>();
        boolean modifyFlag = false;
        boolean addFlag = false;
        FuncResMenuCheckTreeVo root = new FuncResMenuCheckTreeVo();
        String rootId = functionId + "-res";
        root.setId((Serializable)((Object)rootId));
        root.setHasChildren(Boolean.valueOf(true));
        root.setParentId((Serializable)((Object)functionId.toString()));
        root.setLabel(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RESOURCE.getMessage()));
        root.setIcon("tree-folder");
        root.setRowId(rootId);
        root.setTypeName(MigrateFuncResMenuEnum.RES_FILE.getType());
        result.add(root);
        for (ResourceDetailVo item : resourcesList) {
            SysResources localRes;
            FuncResMenuCheckTreeVo funcResMenuCheckTreeVo = new FuncResMenuCheckTreeVo();
            funcResMenuCheckTreeVo.setId((Serializable)((Object)item.getId().toString()));
            funcResMenuCheckTreeVo.setHasChildren(Boolean.valueOf(false));
            funcResMenuCheckTreeVo.setParentId((Serializable)((Object)rootId));
            funcResMenuCheckTreeVo.setIcon(MigrateFuncResMenuEnum.of((String)item.getResTypeId()) != null ? item.getResTypeId() : "my-res");
            funcResMenuCheckTreeVo.setRowId(item.getId().toString() + functionId);
            funcResMenuCheckTreeVo.setImportData((Object)item);
            funcResMenuCheckTreeVo.setTreeType("res");
            MigrateFuncResMenuEnum type = MigrateFuncResMenuEnum.of((String)item.getResTypeId());
            if (HussarUtils.isNotEmpty((Object)type)) {
                funcResMenuCheckTreeVo.setTypeName(type.getType());
                funcResMenuCheckTreeVo.setTypeLabel(type.getDescription());
            } else {
                funcResMenuCheckTreeVo.setTypeName("my_res");
                String resTypeDes = this.getResTypeDes(item.getResTypeId());
                if (resTypeDes != null && !"".equals(resTypeDes)) {
                    funcResMenuCheckTreeVo.setTypeLabel(resTypeDes);
                } else {
                    funcResMenuCheckTreeVo.setTypeLabel(item.getSysResource().getResourceTypeName());
                }
            }
            if (item.getId().equals(resId)) {
                funcResMenuCheckTreeVo.setRemark(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FUNCTION_MAIN_RESOURCE.getMessage()));
            }
            if (HussarUtils.isNotEmpty((Object)(localRes = (SysResources)resourcesMap.get(item.getId())))) {
                if (localRes.equals((Object)item)) {
                    funcResMenuCheckTreeVo.setSelfChange(PermitConstants.NO_CHANGE);
                } else {
                    funcResMenuCheckTreeVo.setSelfChange(PermitConstants.MODIFY);
                    modifyFlag = true;
                }
            } else {
                funcResMenuCheckTreeVo.setSelfChange(PermitConstants.ADD);
                addFlag = true;
            }
            List<SysResourceModules> resourceModulesList = resModuleAssociation.get(item.getId());
            String label = this.migrateResModuleLabel(resourceModulesList) + item.getResourceName();
            funcResMenuCheckTreeVo.setLabel(label);
            SysResourceModules module = this.migrationGetResModuleName(item.getModuleId(), resourceModulesList);
            item.setResourceModules(module);
            result.add(funcResMenuCheckTreeVo);
        }
        int changeType = modifyFlag ? PermitConstants.MODIFY : (addFlag ? PermitConstants.ADD.intValue() : PermitConstants.NO_CHANGE.intValue());
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("funcCheckTree", result);
        resultMap.put("changType", changeType);
        return resultMap;
    }

    private String migrateResModuleLabel(List<SysResourceModules> resourceModulesList) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = resourceModulesList.size() - 1; i >= 0; --i) {
            stringBuilder.append(resourceModulesList.get(i).getModuleName()).append('/');
        }
        return stringBuilder.toString();
    }

    private SysModuleFunctionsVo migrationGetFunctionDetail(SysFunctions sysFunctions, Map<Long, SysFunctionModules> importFuncModuleMap, Map<Long, ResourceDetailVo> importResMap) {
        SysModuleFunctionsVo sysModuleFunctionsVo = new SysModuleFunctionsVo();
        sysModuleFunctionsVo.setId(sysFunctions.getId().toString());
        sysModuleFunctionsVo.setName(sysFunctions.getFunctionName());
        sysModuleFunctionsVo.setParentModuleId(sysFunctions.getFunctionModuleId().toString());
        SysFunctionModules parent = importFuncModuleMap.get(sysFunctions.getFunctionModuleId());
        if (HussarUtils.isNotEmpty((Object)parent)) {
            sysModuleFunctionsVo.setParentModuleName(parent.getFunctionModuleName());
        }
        if (HussarUtils.isNotEmpty((Object)sysFunctions.getDefaultResourceId())) {
            sysModuleFunctionsVo.setDefaultResourceId(sysFunctions.getDefaultResourceId().toString());
            SysResources defaultRes = (SysResources)importResMap.get(sysFunctions.getDefaultResourceId());
            if (HussarUtils.isNotEmpty((Object)defaultRes)) {
                sysModuleFunctionsVo.setDefaultResourceName(defaultRes.getResourceName());
            }
        }
        sysModuleFunctionsVo.setType(0);
        return sysModuleFunctionsVo;
    }

    private SysMenuVo migrationGetMenuDetail(SysMenu menu, List<SysMenu> parents, String functionName) {
        SysMenuVo sysMenuVo = new SysMenuVo();
        CopyPropertieUtils.copyProperties((Object)sysMenuVo, (Object)menu);
        String parentName = null;
        for (SysMenu parent : parents) {
            if (!parent.getId().equals(menu.getParentId())) continue;
            parentName = parent.getText();
        }
        sysMenuVo.setParentName(parentName);
        sysMenuVo.setFunctionName(functionName);
        return sysMenuVo;
    }

    private SysResourceModules migrationGetResModuleName(Long id, List<SysResourceModules> modulesList) {
        SysResourceModules resourceModule = new SysResourceModules();
        for (SysResourceModules module : modulesList) {
            if (!module.getId().equals(id)) continue;
            resourceModule.setModuleName(module.getModuleName());
            break;
        }
        return resourceModule;
    }

    public List<JSTreeModel> lazyLoadFuncModuleTree(ResTreeDto resTreeDto) {
        List<Object> list;
        Long newNodeId = resTreeDto.getNodeId();
        String nodeType = resTreeDto.getNodeType();
        if (HussarUtils.equals((Object)"app", (Object)nodeType)) {
            newNodeId = Constants.RES_NODE_ID;
        }
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        JSTreeModel root = new JSTreeModel();
        root.setText(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FUNCTION_MODULE_LIST.getMessage()));
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setIsLeaf("0");
        root.setIsModule("1");
        root.setType("isRoot");
        root.setConstant("0");
        root.setChildren("true");
        Long appId = resTreeDto.getApplicationId();
        boolean flag = this.existUnifyApp();
        if (flag) {
            root.setId(Constants.ROOT_NODE_ID);
            root.setCode(String.valueOf(Constants.ROOT_NODE_ID));
            root.setCanAddModule(Boolean.valueOf(false));
            root.setId(Constants.ROOT_NODE_ID);
            root.setCode(String.valueOf(Constants.ROOT_NODE_ID));
            if (HussarUtils.isEmpty((Object)appId)) {
                List applicationVos = this.sysApplicationService.getUserApplications(shiroUser.getId());
                List appIds = applicationVos.stream().map(SysApplication::getId).distinct().collect(Collectors.toList());
                List childrenList = this.sysResManageService.getAppTree("func", appIds);
                root.setChildrenList(childrenList);
                if (HussarUtils.isEmpty((Object)childrenList)) {
                    root.setIsLeaf("1");
                    root.setChildren("false");
                }
                result.add(root);
                return result;
            }
        } else {
            root.setId(Constants.RES_NODE_ID);
            root.setCode(String.valueOf(Constants.RES_NODE_ID));
            appId = 1L;
        }
        boolean isModule = ToolUtil.equals((Object)"isModule", (Object)nodeType) || ToolUtil.equals((Object)"app", (Object)nodeType);
        String isSys = "";
        if (this.cascadeProductionProperties.getEnable().booleanValue()) {
            isSys = "0";
        }
        if (ToolUtil.equals((Object)Constants.ROOT_NODE_PARENT, (Object)newNodeId)) {
            newNodeId = Constants.RES_NODE_ID;
            if (HussarUtils.isNotEmpty((Object)root.getId())) {
                result.add(root);
            }
            if (HussarUtils.isEmpty(list = this.sysFunctionsMapper.lazyLoadFuncModuleTree(newNodeId, appId, isSys))) {
                root.setChildren("false");
            }
        } else {
            list = isModule ? this.sysFunctionsMapper.lazyLoadFuncModuleTree(newNodeId, appId, isSys) : new ArrayList();
        }
        result.addAll(list);
        for (JSTreeModel model : result) {
            String isLeaf = model.getIsLeaf();
            String isModule1 = model.getType();
            if (!"isModule".equals(isModule1) || !"0".equals(isLeaf)) continue;
            model.getState().put("notLeafModule", true);
        }
        return TreeModelUtils.merge(result);
    }

    private boolean existUnifyApp() {
        SysApplication application = (SysApplication)this.sysApplicationService.getById((Serializable)Long.valueOf(1L));
        return HussarUtils.isNotEmpty((Object)application);
    }

    public SysFunctions getById(Serializable id) {
        return this.hussarBaseFunctionAdapter.getById((Long)id);
    }

    public boolean updateById(SysFunctions entity) {
        return this.hussarBaseFunctionAdapter.updateById(entity);
    }

    public boolean save(SysFunctions entity) {
        return this.hussarBaseFunctionAdapter.save(entity);
    }

    public List<SysFunctions> listByIds(Collection<? extends Serializable> idList) {
        return this.hussarBaseFunctionAdapter.listByIds(idList);
    }

    public Integer getMaxOrderByParentId(Long moduleId) {
        return this.hussarBaseFunctionAdapter.getMaxOrderByParentId(moduleId);
    }

    private String getResTypeDes(String typeCode) {
        return this.sysResourcesMapper.getResTypeDes(typeCode);
    }

    public Long saveOrUpdateFunctionByShortCut(ShortCutConfig shortCutConfig) {
        if (HussarUtils.isNotEmpty((Object)shortCutConfig.getId())) {
            Long functionId = shortCutConfig.getFunctionId();
            SysFunctions function = this.getById(functionId);
            function.setFunctionName(shortCutConfig.getName());
            SysResources resource = (SysResources)this.sysResourcesService.getById((Serializable)function.getDefaultResourceId());
            resource.setResourceName(shortCutConfig.getName());
            resource.setPath(shortCutConfig.getShortCutUrl());
            resource.setComponent(shortCutConfig.getShortCutUrl());
            resource.setUrlNames(shortCutConfig.getShortCutUrl());
            this.updateById(function);
            SysFunctionModules functionModules = (SysFunctionModules)this.sysFunctionModulesService.getById((Serializable)function.getFunctionModuleId());
            functionModules.setFunctionModuleName(function.getFunctionName());
            this.sysFunctionModulesService.updateById((Object)functionModules);
            this.sysResourcesService.updateById((Object)resource);
            SysResourceModules resourceModules = (SysResourceModules)this.sysResourceMosulesService.getById((Serializable)resource.getModuleId());
            resourceModules.setModuleName(resource.getResourceName());
            this.sysResourceMosulesService.updateById((Object)resourceModules);
            return functionId;
        }
        SysFunctionModules functionModule = new SysFunctionModules();
        functionModule.setId(Long.valueOf(IdWorker.getId((Object)new SysFunctionModules())));
        functionModule.setFunctionModuleName(shortCutConfig.getName());
        functionModule.setParentModuleId(Long.valueOf(1L));
        functionModule.setSeq(this.sysFunctionModulesService.getMaxOrderByParentIdAndAppId(Long.valueOf(1L), Long.valueOf(1L)));
        functionModule.setFunctionModuleCode(this.sysIdtableService.getCurrentCode("FUNCTION_MODULE_CODE", "SYS_FUNCTION_MODULES"));
        SysFunctions function = new SysFunctions();
        function.setId(Long.valueOf(IdWorker.getId((Object)new SysFunctions())));
        function.setFunctionName(shortCutConfig.getName());
        function.setFunctionModuleId(functionModule.getId());
        String functionCode = this.sysIdtableService.getCurrentCode("FUNCTION_CODE", "SYS_FUNCTIONS");
        function.setFunctionCode(functionCode);
        function.setIsSys("0");
        function.setSeq(Integer.valueOf(1));
        shortCutConfig.setFunctionId(function.getId());
        SysResourceModules resourceModule = new SysResourceModules();
        resourceModule.setId(Long.valueOf(IdWorker.getId((Object)new SysResourceModules())));
        resourceModule.setModuleName(shortCutConfig.getName());
        resourceModule.setParentModuleId(Long.valueOf(1L));
        resourceModule.setSeq(this.sysResourceMosulesService.getMaxOrderByParentIdAndAppId(Long.valueOf(1L), Long.valueOf(1L)));
        resourceModule.setModuleCode(this.sysIdtableService.getCurrentCode("MODULE_CODE", "SYS_RESOURCE_MODULES"));
        SysResources resource = new SysResources();
        resource.setId(Long.valueOf(IdWorker.getId((Object)new SysResources())));
        resource.setResourceName(shortCutConfig.getName());
        resource.setModuleId(resourceModule.getId());
        resource.setResTypeId("res_menu");
        resource.setIsSys("0");
        resource.setPath(shortCutConfig.getShortCutUrl());
        resource.setUrlNames(shortCutConfig.getShortCutUrl());
        resource.setKeepAlive("0");
        resource.setIsAudit("0");
        resource.setStrategy("0");
        resource.setIsRepeatAuthenticate("0");
        resource.setComponent(shortCutConfig.getShortCutUrl());
        resource.setSeq(Integer.valueOf(1));
        resource.setResourceCode(this.sysIdtableService.getCurrentCode("RESOURCE_CODE", "SYS_RESOURCES"));
        function.setDefaultResourceId(resource.getId());
        SysFunctionResources sysFunctionResources = new SysFunctionResources();
        sysFunctionResources.setFunctionId(function.getId());
        sysFunctionResources.setResourceId(resource.getId());
        ArrayList<SysRoleFunctions> roleFunctions = new ArrayList<SysRoleFunctions>();
        SysRoleFunctions roleFunction = new SysRoleFunctions();
        roleFunction.setRoleId(SysUserAndRole.SUPERADMIN_ROLE.getValue());
        roleFunction.setFunctionId(function.getId());
        SysRoleFunctions roleFunctionTenant = new SysRoleFunctions();
        roleFunctionTenant.setRoleId(TenantConstant.ADMIN_ROLE);
        roleFunctionTenant.setFunctionId(function.getId());
        roleFunctions.add(roleFunction);
        roleFunctions.add(roleFunctionTenant);
        ArrayList<SysRoleResource> roleResources = new ArrayList<SysRoleResource>();
        SysRoleResource roleResource = new SysRoleResource();
        roleResource.setRoleId(SysUserAndRole.SUPERADMIN_ROLE.getValue());
        roleResource.setResourceId(resource.getId());
        roleResource.setRelationSource("1");
        SysRoleResource roleResourceTenant = new SysRoleResource();
        roleResourceTenant.setRoleId(TenantConstant.ADMIN_ROLE);
        roleResourceTenant.setResourceId(resource.getId());
        roleResourceTenant.setRelationSource("1");
        roleResources.add(roleResource);
        roleResources.add(roleResourceTenant);
        this.sysFunctionModulesService.save((Object)functionModule);
        this.save(function);
        this.sysFunctionResourcesService.save((Object)sysFunctionResources);
        this.sysRoleFunctionsService.saveBatch(roleFunctions);
        this.sysRoleResourceService.saveBatch(roleResources);
        this.sysResourceMosulesService.save((Object)resourceModule);
        this.sysResourcesService.save((Object)resource);
        return function.getId();
    }

    public List<SysFunctions> getFunsByAllDefaultRes(Long appId) {
        return this.hussarBaseFunctionAdapter.getFunsByAllDefaultRes(appId);
    }
}

