/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.organ.dao.SysStaffMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruHtszMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.model.SysPostStru;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.HussarDsOrganHtszService;
import com.jxdinfo.hussar.authorization.organ.service.ILocalOrganizationHtszBoService;
import com.jxdinfo.hussar.authorization.organ.service.ISysPostStruService;
import com.jxdinfo.hussar.authorization.organ.vo.OrgUserNameVo;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.ForestNodeMerger;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class LocalHussarBaseOrganizationHtszBoServiceImpl
implements ILocalOrganizationHtszBoService {
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private SysStaffMapper sysStaffMapper;
    @Resource
    private ISysPostStruService postStruService;
    @Autowired
    private SysStruHtszMapper sysStruHtszMapper;
    @Autowired
    private HussarDsOrganHtszService hussarDsOrganHtszService;
    @Autowired
    private ISysUsersService sysUsersService;

    public List<JSTreeModel> getOrgTree(Map<String, Object> map) {
        HussarTenantDefinition tenant;
        String label = map.get("label") == null ? null : map.get("label").toString();
        Long parentId = map.get("struId") == null ? 0L : Long.parseLong(map.get("struId").toString());
        String flag = map.get("flag") == null ? "true" : map.get("flag").toString();
        List list = new ArrayList();
        ArrayList<Object> result = new ArrayList<Object>();
        JSTreeModel root = new JSTreeModel();
        root.setCode(Constants.ROOT_NODE_ID.toString());
        root.setText("\u7ec4\u7ec7\u673a\u6784");
        root.setIsLeaf("0");
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setStruLevel("0");
        root.setType("isRoot");
        String connName = "master";
        if ("platformLevel".equals(label)) {
            connName = "master";
        } else if ("factoryLevel".equals(label) && HussarUtils.isNotEmpty((Object)(tenant = HussarContextHolder.getHussarTenant()))) {
            connName = tenant.getConnName();
        }
        if (flag.equals("true")) {
            if (ToolUtil.equals((Object)Constants.ROOT_NODE_PARENT, (Object)parentId)) {
                root.setId(Constants.ROOT_NODE_ID);
                parentId = Constants.ROOT_NODE_ID;
                result.add(root);
            }
            list = this.hussarDsOrganHtszService.getJsTreeModelsLazy(connName, parentId);
        } else {
            root.setId(Constants.ROOT_NODE_ID);
            list = this.hussarDsOrganHtszService.getJsTreeModelsNoLazy(connName);
            result.add(root);
        }
        result.addAll(list);
        return ForestNodeMerger.merge(result);
    }

    public List<SysStaff> queryUserStaff(Map<String, Object> map) {
        String struId = map.get("struId") == null ? null : map.get("struId").toString();
        ArrayList<Long> idList = new ArrayList<Long>();
        SysStru depStru = (SysStru)this.sysStruMapper.selectById((Serializable)((Object)struId));
        if (ToolUtil.isNotEmpty((Object)depStru)) {
            List<JSTreeModel> orgList = this.sysStruMapper.getOrgTree(null);
            List<JSTreeModel> list = this.filterChildTreeNodeByStru(orgList, depStru);
            for (JSTreeModel jsTreeModel : list) {
                Long treeId = jsTreeModel.getId();
                idList.add(treeId);
            }
        } else {
            return new ArrayList<SysStaff>();
        }
        List<Long> staffIds = this.sysStaffMapper.selectBatchOrganStaffId(idList);
        if (HussarUtils.isEmpty(staffIds)) {
            return new ArrayList<SysStaff>();
        }
        return this.sysStaffMapper.queryUserStaff(staffIds);
    }

    @HussarDs(value="master")
    public List<OrgUserNameVo> getOrgUerInfo(Map<String, Object> map) {
        String type = map.get("type") == null ? null : map.get("type").toString();
        String ids = map.get("ids") == null ? null : map.get("ids").toString();
        AssertUtil.isNotEmpty((String)ids, (String)"\u53c2\u6570\u9519\u8bef");
        List<Long> struIdOrStaffIds = Arrays.stream(ids.split(",")).map(Long::parseLong).collect(Collectors.toList());
        ArrayList<OrgUserNameVo> result = new ArrayList<OrgUserNameVo>();
        switch (type) {
            case "1": {
                result.addAll(this.getOrganName(struIdOrStaffIds));
                break;
            }
            case "2": {
                result.addAll(this.getStaffName(struIdOrStaffIds));
                break;
            }
            case "3": {
                result.addAll(this.getStaffNameWithUserId(struIdOrStaffIds));
                break;
            }
            default: {
                result.addAll(this.getOrganName(struIdOrStaffIds));
                result.addAll(this.getStaffName(struIdOrStaffIds));
                result.addAll(this.getPostStruName(struIdOrStaffIds));
            }
        }
        return result;
    }

    public List<JSTreeModel> getSpecialOrgTree(String label, String orgName) {
        SecurityUser user = BaseSecurityUtil.getUser();
        Long permissionStruId = null;
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        if ("factoryLevel".equals(label)) {
            SysStru sysStru = (SysStru)this.sysStruMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getId, (Object)user.getDeptId()));
            permissionStruId = sysStru.getPermissionStruId();
        }
        JSTreeModel root = new JSTreeModel();
        root.setId(Constants.ROOT_NODE_ID);
        root.setCode(Constants.ROOT_NODE_ID.toString());
        root.setText("\u7ec4\u7ec7\u673a\u6784");
        root.setIsLeaf("0");
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setStruLevel("0");
        root.setType("isRoot");
        root.setState(false, false, true);
        result.add(root);
        List<JSTreeModel> allList = this.sysStruMapper.getOrgTree(null);
        List<JSTreeModel> orgList = this.sysStruHtszMapper.getSpecialOrgTree(SqlQueryUtil.transferSpecialChar((String)orgName), permissionStruId);
        if (!orgList.isEmpty()) {
            orgList.forEach(org -> {
                StringBuilder parentName = new StringBuilder();
                this.getTreeParentNames(allList, org.getParent(), parentName);
                org.setText(org.getText() + "(" + parentName + ")");
                org.setParent(Constants.ROOT_NODE_ID);
            });
        }
        result.addAll(orgList);
        return ForestNodeMerger.merge(result);
    }

    private void getTreeParentNames(List<JSTreeModel> allTreeList, Long struId, StringBuilder parentName) {
        for (JSTreeModel treeNode : allTreeList) {
            if (ToolUtil.isEmpty((Object)treeNode.getParent()) || !struId.equals(treeNode.getId())) continue;
            parentName.append("/" + treeNode.getText());
            this.getTreeParentNames(allTreeList, treeNode.getParent(), parentName);
        }
    }

    @HussarDs(value="master")
    private List<OrgUserNameVo> getOrganName(Collection<Long> struIds) {
        List<Map<String, Object>> orgStru = this.sysStruHtszMapper.queryOrgStru(struIds);
        ArrayList<OrgUserNameVo> result = new ArrayList<OrgUserNameVo>();
        if (HussarUtils.isNotEmpty(orgStru)) {
            this.sortByIds(orgStru, struIds);
            for (Map<String, Object> item : orgStru) {
                OrgUserNameVo orgUserNameVo = new OrgUserNameVo();
                orgUserNameVo.setId(Long.valueOf(Long.parseLong(item.get("id").toString())));
                orgUserNameVo.setOrganName(item.get("organName").toString());
                result.add(orgUserNameVo);
            }
        }
        return result;
    }

    private List<OrgUserNameVo> getPostStruName(Collection<Long> struIds) {
        List postStruList = this.postStruService.list((Wrapper)new LambdaQueryWrapper().in(SysPostStru::getStruId, struIds));
        ArrayList<OrgUserNameVo> result = new ArrayList<OrgUserNameVo>();
        if (HussarUtils.isNotEmpty((Object)postStruList)) {
            this.sortByIds(postStruList, struIds);
            for (SysPostStru item : postStruList) {
                OrgUserNameVo orgUserNameVo = new OrgUserNameVo();
                orgUserNameVo.setId(item.getStruId());
                orgUserNameVo.setOrganName(item.getOrganName());
                result.add(orgUserNameVo);
            }
        }
        return result;
    }

    private <T> void sortByIds(List<T> itemList, Collection<Long> ids) {
        ArrayList<Long> idList = new ArrayList<Long>(ids);
        itemList.sort(Comparator.comparingInt(item -> idList.indexOf(this.getId(item))));
    }

    private Long getId(Object o) {
        if (o instanceof SysPostStru) {
            return ((SysPostStru)o).getStruId();
        }
        if (o instanceof Map) {
            return Long.parseLong(((Map)o).get("id").toString());
        }
        if (o instanceof SysStaff) {
            return ((SysStaff)o).getId();
        }
        throw new BaseException("\u4f20\u5165\u53c2\u6570\u9519\u8bef");
    }

    private List<OrgUserNameVo> getStaffName(Collection<Long> staffIds) {
        List staffList = this.sysStaffMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysStaff::getId, staffIds));
        ArrayList<OrgUserNameVo> result = new ArrayList<OrgUserNameVo>();
        if (HussarUtils.isNotEmpty((Object)staffList)) {
            this.sortByIds(staffList, staffIds);
            for (SysStaff item : staffList) {
                OrgUserNameVo orgUserNameVo = new OrgUserNameVo();
                orgUserNameVo.setStruId(item.getId());
                orgUserNameVo.setName(item.getName());
                result.add(orgUserNameVo);
            }
        }
        return result;
    }

    private List<OrgUserNameVo> getStaffNameWithUserId(Collection<Long> staffIds) {
        List staffList;
        Map<Long, List<SysUsers>> employee;
        ArrayList<OrgUserNameVo> result = new ArrayList<OrgUserNameVo>();
        List usersList = this.sysUsersService.list((Wrapper)new LambdaQueryWrapper().in(SysUsers::getId, staffIds));
        if (HussarUtils.isNotEmpty((Object)usersList) && HussarUtils.isNotEmpty(employee = usersList.stream().filter(a -> HussarUtils.isNotEmpty((Object)a.getEmployeeId())).collect(Collectors.groupingBy(SysUsers::getEmployeeId))) && HussarUtils.isNotEmpty((Object)(staffList = this.sysStaffMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysStaff::getId, employee.keySet()))))) {
            this.sortByIds(staffList, staffIds);
            for (SysStaff item : staffList) {
                OrgUserNameVo orgUserNameVo = new OrgUserNameVo();
                orgUserNameVo.setStruId(item.getId());
                orgUserNameVo.setName(item.getName());
                orgUserNameVo.setUserId(employee.get(item.getId()).get(0).getId());
                result.add(orgUserNameVo);
            }
        }
        return result;
    }

    private List<JSTreeModel> filterChildTreeNodeByStru(List<JSTreeModel> allTreeList, SysStru depStru) {
        ArrayList returnTreeNodeList = Lists.newArrayList();
        HashMap<Long, Long> childStruIdMap = new HashMap<Long, Long>();
        for (JSTreeModel treeNode : allTreeList) {
            Long struId = treeNode.getId();
            Long parentStruId = treeNode.getParent();
            childStruIdMap.put(struId, parentStruId);
        }
        Long depStruId = depStru.getId();
        ArrayList<Long> childStrIdList = new ArrayList<Long>();
        this.getAllChilden(childStruIdMap, childStrIdList, depStruId);
        for (JSTreeModel treeModel : allTreeList) {
            if (depStru.getId().equals(treeModel.getId())) {
                treeModel.setParent(Constants.ROOT_NODE_ID);
                returnTreeNodeList.add(treeModel);
                continue;
            }
            if (!childStrIdList.contains(treeModel.getId())) continue;
            returnTreeNodeList.add(treeModel);
        }
        return returnTreeNodeList;
    }

    private void getAllChilden(Map<Long, Long> childIdMap, List<Long> childIdList, Long struId) {
        List<Long> tmpList;
        if (childIdMap.containsValue(struId) && (tmpList = this.getKey(childIdMap, struId)).size() > 0) {
            for (Long item : tmpList) {
                childIdList.add(item);
                this.getAllChilden(childIdMap, childIdList, item);
            }
        }
    }

    private List<Long> getKey(Map<Long, Long> map, Object value) {
        Set<Map.Entry<Long, Long>> set = map.entrySet();
        Iterator<Map.Entry<Long, Long>> iterator = set.iterator();
        ArrayList<Long> arrayList = new ArrayList<Long>();
        while (iterator.hasNext()) {
            Map.Entry<Long, Long> entry = iterator.next();
            if (!entry.getValue().equals(value)) continue;
            arrayList.add(entry.getKey());
        }
        return arrayList;
    }
}

