/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.model.UserVInfo;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseSysOrgManageService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserVInfoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.tenant.common.model.SysTenantStru;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantStruService;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.service.impl.hussarBaseSysOrgManageServiceImpl")
public class HussarBaseSysOrgManageServiceImpl
implements IHussarBaseSysOrgManageService {
    @Resource
    private ISysStruService iSysStruService;
    @Resource
    private SysUsersMapper oldUsersMapper;
    @Autowired(required=false)
    private ISysTenantStruService iSysTenantStruService;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private ISysUsersService sysUsersService;
    @Autowired
    private IHussarBaseUserVInfoService userVInfoService;

    public List<JSTreeModel> getTeamUserTree(Long parentId) {
        List struIdList;
        List userList;
        List<Object> list = new ArrayList();
        if (ToolUtil.equals((Object)Constants.ROOT_NODE_ID, (Object)parentId)) {
            SecurityUser securityUser = BaseSecurityUtil.getUser();
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysTenantStru::getTenantId, (Object)securityUser.getTenantId());
            List sysServerInfoList = this.iSysTenantStruService.list("master", (Wrapper)queryWrapper);
            List<Long> orgList = sysServerInfoList.stream().map(SysTenantStru::getStruId).collect(Collectors.toList());
            if (ToolUtil.isNotEmpty(orgList)) {
                list = this.sysStruMapper.getTeamUserTree(parentId, orgList);
            }
        } else {
            list = this.sysStruMapper.getTeamUserTree(parentId, null);
        }
        List leafModel = list.stream().filter(item -> "Y".equals(item.getIsLeaf())).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(leafModel) && HussarUtils.isNotEmpty((Object)(userList = this.sysUsersService.list((Wrapper)new LambdaQueryWrapper().in(SysUsers::getDepartmentId, struIdList = leafModel.stream().map(JSTreeModel::getId).collect(Collectors.toList())))))) {
            HashMap<Long, JSTreeModel> map = new HashMap<Long, JSTreeModel>();
            for (JSTreeModel item2 : leafModel) {
                map.put(item2.getId(), item2);
            }
            for (JSTreeModel item2 : userList) {
                JSTreeModel jsTreeModel = (JSTreeModel)map.get(item2.getDepartmentId());
                jsTreeModel.setIsLeaf("N");
            }
        }
        return list;
    }

    public List<UserVInfo> querySelectParts(BpmResponseResult bpmResponseResult, String processDefinitionKey, String taskId, String nodeId, String endEvent, String selectData, String filterCandidate) {
        JSONArray jsonArray;
        HashMap userMap = this.userVInfoService.querySelectParts(filterCandidate, selectData);
        ArrayList userResults = new ArrayList();
        ArrayList<UserVInfo> filterUserResults = new ArrayList<UserVInfo>();
        if (bpmResponseResult.getCode().equals("1") && ToolUtil.isNotEmpty((Object)(jsonArray = bpmResponseResult.getResult())) && jsonArray.size() > 0) {
            for (Object userObject : jsonArray) {
                HashMap user = (HashMap)JSON.parseObject((String)JSON.toJSONString(userObject), HashMap.class);
                userResults.add(userMap.get(user.get("id")));
            }
        }
        if (ToolUtil.isNotEmpty(userResults) && userResults.size() > 0) {
            for (UserVInfo userResult : userResults) {
                if (!ToolUtil.isNotEmpty((Object)userResult)) continue;
                filterUserResults.add(userResult);
            }
            filterUserResults.sort(Comparator.comparing(UserVInfo::getSort));
        }
        return filterUserResults;
    }

    public List<JSTreeModel> getSpecialUserTree(String userName, String sysType, String isSecurity) {
        SecurityUser user = BaseSecurityUtil.getUser();
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        Object permissionStruId = null;
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        JSTreeModel root = new JSTreeModel();
        root.setId(Long.valueOf(11L));
        root.setCode("organ");
        root.setText("\u7ec4\u7ec7\u673a\u6784");
        root.setIsLeaf("0");
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setStruLevel("0");
        root.setType("isRoot");
        root.setState(false, false, true);
        result.add(root);
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysTenantStru::getId, (Object)securityUser.getTenantId());
        List sysServerInfoList = this.iSysTenantStruService.list((Wrapper)queryWrapper);
        List orgList = sysServerInfoList.stream().map(SysTenantStru::getStruId).collect(Collectors.toList());
        List list = this.iSysStruService.list((Wrapper)Wrappers.lambdaQuery().in(SysStru::getId, orgList));
        List struFidList = list.stream().map(SysStru::getStruFid).collect(Collectors.toList());
        ArrayList<String> stringList = new ArrayList<String>();
        for (String s : struFidList) {
            stringList.add(s + "%");
        }
        if (!sysType.equals("1") && !sysType.equals("0")) {
            Integer securityLevel = null;
            if (isSecurity.equals("1")) {
                securityLevel = user.getSecurityLevel();
            }
            queryParams.put("securityLevel", securityLevel);
        }
        queryParams.put("orgList", stringList);
        queryParams.put("userName", userName);
        List<JSTreeModel> userList = this.oldUsersMapper.searchUsersEy(queryParams);
        if (!userList.isEmpty()) {
            userList.forEach(org -> {
                String[] name = org.getPath().split("/");
                StringBuilder parentAllName = new StringBuilder();
                for (int i = name.length - 1; i > 0; --i) {
                    parentAllName.append("/").append(name[i]);
                }
                org.setText(org.getText() + "(" + parentAllName + ")");
                org.setParent(Long.valueOf(11L));
                if (sysType.equals("0") && "1".equals(org.getIsSys())) {
                    org.setState(false, false, true);
                }
            });
        }
        result.addAll(userList);
        return result;
    }
}

