/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.service.impl;

import com.baomidou.dynamic.datasource.annotation.Master;
import com.jxdinfo.hussar.authorization.organ.dao.AssigneeEyMapper;
import com.jxdinfo.hussar.authorization.organ.service.AssigneeEyService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
@Master
public class AssigneeEyServiceImpl
implements AssigneeEyService {
    private static Logger logger = LogManager.getLogger(AssigneeEyServiceImpl.class);
    private static final Pattern REGEX = Pattern.compile("\\@\\{([^@]|[^}]\\@)*\\}\\@");
    private static final Pattern ORGAN_CONTAINS_CHILD_REGEX = Pattern.compile("O.PARENT_ID( NOT)? CONTAINSCHILD \\('([^)])*\\)");
    public static final String ORGAN = "organ";
    public static final String USER = "user";
    public static final String MASTERCODE = "000000";
    private static final String DEFAULT_PARENTID = "11";
    @Resource
    private AssigneeEyMapper assigneeEyMapper;

    public List<Map<String, Object>> userTree(String id) {
        String serverCode = BaseSecurityUtil.getUser().getExtendUserMap().get("serverCode") == null ? "" : BaseSecurityUtil.getUser().getExtendUserMap().get("serverCode").toString();
        Long newId = HussarUtils.isEmpty((Object)id) ? Long.parseLong(DEFAULT_PARENTID) : Long.parseLong(id);
        if (MASTERCODE.equals(serverCode)) {
            List<Map<String, Object>> result = this.assigneeEyMapper.userTree(newId, false, null, null);
            ArrayList<Long> parentIds = new ArrayList<Long>();
            for (Map<String, Object> bpmTreeModel : result) {
                if (!ORGAN.equals(bpmTreeModel.get("type"))) continue;
                parentIds.add(Long.valueOf(bpmTreeModel.get("id").toString()));
            }
            if (!parentIds.isEmpty()) {
                HashSet<Long> parentIdList = new HashSet<Long>(this.assigneeEyMapper.getNotLeafParentIds(this.getInListSqlCondition(parentIds), USER));
                for (Map map : result) {
                    if (!ORGAN.equals(map.get("type")) || !parentIdList.contains(Long.valueOf(map.get("id").toString()))) continue;
                    map.put("isleaf", "false");
                }
            }
            return result;
        }
        List<Long> organId = null;
        if (HussarUtils.isNotEmpty((Object)serverCode) && DEFAULT_PARENTID.equals(newId)) {
            newId = null;
            organId = this.assigneeEyMapper.getOrgIdByServerCode(serverCode);
        }
        List<Map<String, Object>> result = this.assigneeEyMapper.userTree(newId, false, organId, null);
        ArrayList<Long> parentIds = new ArrayList<Long>();
        for (Map<String, Object> map : result) {
            if (!ORGAN.equals(map.get("type"))) continue;
            parentIds.add(Long.valueOf(map.get("id").toString()));
        }
        if (!parentIds.isEmpty()) {
            HashSet<Long> parentIdList = new HashSet<Long>(this.assigneeEyMapper.getNotLeafParentIds(this.getInListSqlCondition(parentIds), USER));
            for (Map<String, Object> bpmTreeModel : result) {
                if (!ORGAN.equals(bpmTreeModel.get("type")) || !parentIdList.contains(Long.valueOf(bpmTreeModel.get("id").toString()))) continue;
                bpmTreeModel.put("isleaf", "false");
            }
        }
        return result;
    }

    public List<Map<String, Object>> userTree(String id, boolean isMainPost, String userId, boolean isSecurity) {
        String newId;
        String serverCode = BaseSecurityUtil.getUser().getExtendUserMap().get("serverCode") == null ? "" : BaseSecurityUtil.getUser().getExtendUserMap().get("serverCode").toString();
        Integer securityLevel = null;
        String string = newId = HussarUtils.isEmpty((Object)id) ? DEFAULT_PARENTID : id;
        if (ToolUtil.isNotEmpty((Object)isSecurity) && isSecurity) {
            securityLevel = ToolUtil.isNotEmpty((Object)userId) ? this.assigneeEyMapper.getSecurityLevelByEryuan(Long.parseLong(userId)) : BaseSecurityUtil.getUser().getSecurityLevel();
        }
        if (MASTERCODE.equals(serverCode)) {
            List<Map<String, Object>> result = this.assigneeEyMapper.userTree(Long.parseLong(newId), isMainPost, null, securityLevel);
            ArrayList<Long> parentIds = new ArrayList<Long>();
            for (Map<String, Object> bpmTreeModel : result) {
                if (!ORGAN.equals(bpmTreeModel.get("type"))) continue;
                parentIds.add(Long.valueOf(bpmTreeModel.get("id").toString()));
            }
            if (!parentIds.isEmpty()) {
                HashSet<Long> parentIdList = new HashSet<Long>(this.assigneeEyMapper.getNotLeafParentIds(this.getInListSqlCondition(parentIds), isMainPost ? "userWithMainPost" : USER));
                for (Map map : result) {
                    if (!ORGAN.equals(map.get("type")) || !parentIdList.contains(Long.valueOf(map.get("id").toString()))) continue;
                    map.put("isleaf", "false");
                }
            }
            return result;
        }
        List<Long> organId = null;
        if (HussarUtils.isNotEmpty((Object)serverCode) && DEFAULT_PARENTID.equals(newId)) {
            newId = null;
            organId = this.assigneeEyMapper.getOrgIdByServerCode(serverCode);
        }
        List<Map<String, Object>> result = this.assigneeEyMapper.userTree(newId == null ? null : Long.valueOf(Long.parseLong(newId)), isMainPost, organId, securityLevel);
        ArrayList<Long> parentIds = new ArrayList<Long>();
        for (Map<String, Object> map : result) {
            if (!ORGAN.equals(map.get("type"))) continue;
            parentIds.add(Long.valueOf(map.get("id").toString()));
        }
        if (!parentIds.isEmpty()) {
            HashSet<Long> parentIdList = new HashSet<Long>(this.assigneeEyMapper.getNotLeafParentIds(this.getInListSqlCondition(parentIds), isMainPost ? "userWithMainPost" : USER));
            for (Map<String, Object> bpmTreeModel : result) {
                if (!ORGAN.equals(bpmTreeModel.get("type")) || !parentIdList.contains(Long.valueOf(bpmTreeModel.get("id").toString()))) continue;
                bpmTreeModel.put("isleaf", "false");
            }
        }
        return result;
    }

    private List<List<Long>> getInListSqlCondition(List<Long> longList) {
        ArrayList<List<Long>> result = new ArrayList<List<Long>>();
        int size = longList.size();
        for (int i = 0; i < size; i += 1000) {
            List<Long> list = longList.subList(i, Math.min(i + 1000, size));
            result.add(list);
        }
        return result;
    }
}

