/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.authorization.audit.model.SysOrganAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysStruAudit;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.dto.AddOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.manager.AddOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.model.SysOffice;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.authorization.permit.model.SysStruRole;
import com.jxdinfo.hussar.authorization.permit.model.SysStruRoleAudit;
import com.jxdinfo.hussar.authorization.relational.model.SysStruPost;
import com.jxdinfo.hussar.authorization.relational.model.SysStruPostAudit;
import com.jxdinfo.hussar.common.constant.state.StruRoleStatus;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.pinyin.service.IConvertPinyinService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.organ.manager.impl.addOrganizationManagerImpl")
public class AddOrganizationManagerImpl
extends CommonOrganizationManager
implements AddOrganizationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AddOrganizationManagerImpl.class);
    @Autowired
    private IConvertPinyinService convertPinyinService;

    @Override
    public ApiResponse<String> addOrganization(AddOrganizationDto addOrganizationDto) {
        boolean flag;
        String validateMsg = this.validateService.validate((Object)addOrganizationDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        String organCode = addOrganizationDto.getOrganCode();
        String organName = addOrganizationDto.getOrganName();
        if (HussarUtils.isNotBlank((CharSequence)organCode)) {
            boolean bl = flag = !organCode.contains("/") && organCode.length() < 33;
            if (!flag) {
                LOGGER.error(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_CONSTANT_1.getMessage()), (Object)organCode);
                return ApiResponse.fail((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_CODE_OUTSIDE_CHECK.getMessage()));
            }
        }
        if (HussarUtils.isNotBlank((CharSequence)organName)) {
            boolean bl = flag = !organName.contains("/");
            if (!flag) {
                LOGGER.error(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_CONSTANT_2.getMessage()), (Object)organName);
                return ApiResponse.fail((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_NAME_OUTSIDE_CHECK.getMessage()));
            }
        }
        SysStru sysStru = new SysStru();
        SysOffice sysOffice = new SysOffice();
        SysOrgan sysOrgan = new SysOrgan();
        this.initialization(addOrganizationDto, sysStru, sysOrgan, sysOffice);
        ArrayList<SysStruPost> sysStruPosts = new ArrayList<SysStruPost>();
        ArrayList<SysStruRole> sysStruRoles = new ArrayList<SysStruRole>();
        this.initializationRelations(sysStru.getId(), addOrganizationDto, sysStruPosts, sysStruRoles);
        this.parentOrganizationAuditDataExists(addOrganizationDto.getParentId());
        this.wrapAddOrgan(sysStru, sysOrgan);
        this.beforeAddOrganization(sysStru, sysOrgan, sysOffice);
        String result = this.processAuditIfNecessary(sysStru, sysOrgan, sysOffice, sysStruPosts, sysStruRoles);
        this.afterAddOrganization(sysStru, sysOrgan, sysOffice);
        return ApiResponse.success((Object)String.valueOf(sysStru.getId()), (String)result);
    }

    @Override
    public void wrapAddOrgan(SysStru sysStru, SysOrgan sysOrgan) {
        LOGGER.debug(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_FILL_LEVEL_CODE_PROP.getMessage()));
        this.wrapAddOrgan(sysStru, sysOrgan, true);
    }

    @Override
    public void wrapAddOrgan(SysStru sysStru, SysOrgan sysOrgan, boolean updateStruSeq) {
        String organFcode = "/" + sysOrgan.getOrganCode();
        String organFname = "/" + sysOrgan.getOrganName();
        long struIdTemp = HussarUtils.isEmpty((Object)sysStru.getId()) ? IdWorker.getId((Object)sysStru) : sysStru.getId();
        String struFid = "/" + struIdTemp;
        String pSeq = "";
        String pFid = "/";
        int level = sysStru.getStruLevel();
        if (level > 1) {
            boolean needAudit;
            SysStru pSysStru = (SysStru)this.sysStruMapper.selectById(sysStru.getParentId());
            SysOrgan pSysOrgan = (SysOrgan)this.sysOrganMapper.selectById(pSysStru.getOrganId());
            pSeq = pSysStru.getStruSeq();
            pFid = pSysStru.getStruFid();
            sysOrgan.setParentTypeCode(pSysOrgan.getOrganType());
            organFcode = pSysOrgan.getOrganFcode() + organFcode;
            struFid = pFid + struFid;
            organFname = pSysOrgan.getOrganFname() + organFname;
            boolean bl = needAudit = this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isOrganAudit();
            if (!sysOrgan.getOrganType().equals("9") && !needAudit) {
                pSysStru.setIsLeaf("N");
                this.sysStruMapper.updateById(pSysStru);
            }
        }
        if (updateStruSeq) {
            if (!sysOrgan.getOrganType().equals("9")) {
                sysStru.setStruSeq(this.getStruSeq(pFid, pSeq, level));
            } else {
                sysStru.setStruSeq(pSeq);
            }
        }
        sysOrgan.setOrganFcode(OrganUtil.convert((String)organFcode));
        sysOrgan.setOrganFname(organFname);
        sysStru.setId(Long.valueOf(struIdTemp));
        sysStru.setStruFid(OrganUtil.convert((String)struFid));
        sysStru.setStruLevel(Integer.valueOf(sysStru.getStruFid().split("/").length - 1));
    }

    private String processAuditIfNecessary(SysStru sysStru, SysOrgan sysOrgan, SysOffice sysOffice, List<SysStruPost> sysStruPosts, List<SysStruRole> sysStruRoles) {
        boolean needAudit;
        StringBuilder stringBuilder = new StringBuilder("");
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_VERIFY_AUDIT_ADD_AUDIT_LIST.getMessage()));
        boolean bl = needAudit = this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isOrganAudit();
        if (needAudit) {
            Set organIds;
            List sysStruAuditList;
            LOGGER.debug(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_ADD_AUDIT_NECESSARY.getMessage()));
            List sysOrganAuditList = this.sysOrganAuditService.list((Wrapper)new LambdaQueryWrapper().eq(SysOrganAudit::getOrganCode, (Object)sysOrgan.getOrganCode()));
            if (HussarUtils.isNotEmpty((Object)sysOrganAuditList) && HussarUtils.isNotEmpty((Object)(sysStruAuditList = this.sysStruAuditService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStruAudit::getOrganId, organIds = sysOrganAuditList.stream().map(SysOrganAudit::getId).collect(Collectors.toSet()))).eq(SysStruAudit::getState, (Object)"0"))))) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL_EXIST_ORGAN_CODE_REVIEW.getMessage()));
            }
            this.auditAdd(sysOrgan, sysStru, null, sysOffice, "1");
            this.auditStruPost(sysStruPosts);
            this.auditStruRole(sysStruRoles);
            stringBuilder.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.ADD_SUCCESS_WAIT_REVIEW.getMessage()));
        } else {
            this.doSave(sysStru, sysOrgan, sysOffice);
            if (HussarUtils.isNotEmpty(sysStruPosts)) {
                this.sysStruPostService.saveBatch(sysStruPosts, sysStruPosts.size());
            }
            if (HussarUtils.isNotEmpty(sysStruRoles)) {
                this.sysStruRoleService.saveBatch(sysStruRoles, sysStruRoles.size());
            }
            stringBuilder.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_SUCCESS.getMessage()));
            this.organChangeNotify.notify(DataChangeType.INSERT, new Object[]{sysStru.getId(), sysOrgan, sysStruPosts});
        }
        return stringBuilder.toString();
    }

    private void beforeAddOrganization(SysStru sysStru, SysOrgan sysOrgan, SysOffice sysOffice) {
        LOGGER.debug(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_METHOD_BEFORE_ADD_ORG.getMessage()));
        this.sysOrgEventService.beforeAdd(sysStru, sysOrgan, sysOffice);
    }

    private void afterAddOrganization(SysStru sysStru, SysOrgan sysOrgan, SysOffice sysOffice) {
        LOGGER.debug(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_METHOD_AFTER_ADD_ORG.getMessage()));
        this.sysOrgEventService.afterAdd(sysStru, sysOrgan, sysOffice);
    }

    private void initialization(AddOrganizationDto addOrganizationDto, SysStru sysStru, SysOrgan sysOrgan, SysOffice sysOffice) {
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ACCORDING_PARAM_INITIALIZE_ADD.getMessage()), (Object)JSON.toJSONString((Object)addOrganizationDto));
        long sysStruId = IdWorker.getId((Object)sysStru);
        long sysOrganId = IdWorker.getId((Object)sysOrgan);
        long sysOfficeId = IdWorker.getId((Object)sysOffice);
        sysStru.setId(Long.valueOf(sysStruId));
        sysStru.setOrganId(Long.valueOf(sysOrganId));
        sysStru.setParentId(addOrganizationDto.getParentId());
        sysStru.setPrincipalId(addOrganizationDto.getPrincipalId());
        sysStru.setStruType(addOrganizationDto.getStruType());
        sysStru.setPrincipalId(addOrganizationDto.getPrincipalId());
        int level = 0;
        SysStru temp = (SysStru)this.sysStruMapper.selectById(sysStru.getParentId());
        level = HussarUtils.isEmpty((Object)temp) ? 1 : temp.getStruLevel() + 1;
        sysStru.setStruLevel(Integer.valueOf(level));
        Integer orderTree = 1;
        Integer maxOrder = this.sysStruMapper.getMaxOrderById(sysStru.getParentId());
        if (ToolUtil.isNotEmpty((Object)maxOrder)) {
            orderTree = maxOrder + 1;
        }
        Integer struOrder = orderTree;
        sysStru.setStruOrder(struOrder);
        sysOffice.setId(Long.valueOf(sysOfficeId));
        sysOffice.setStruId(Long.valueOf(sysStruId));
        sysOffice.setOfficeAddress(StringUtils.trimToEmpty((String)addOrganizationDto.getOfficeAddress()));
        sysOffice.setOfficeAlias(StringUtils.trimToEmpty((String)addOrganizationDto.getOfficeAlias()));
        sysOrgan.setId(Long.valueOf(sysOrganId));
        sysOrgan.setOrganCode(StringUtils.trimToEmpty((String)addOrganizationDto.getOrganCode()));
        sysOrgan.setOrganName(StringUtils.trimToEmpty((String)addOrganizationDto.getOrganName()));
        sysOrgan.setShortName(HussarUtils.isBlank((CharSequence)addOrganizationDto.getShortName()) ? sysOrgan.getOrganName() : StringUtils.trimToEmpty((String)addOrganizationDto.getShortName()));
        sysOrgan.setOrganType(addOrganizationDto.getStruType());
        String organProperty = StringUtils.trimToEmpty((String)addOrganizationDto.getOrganProperty());
        sysOrgan.setOrganProperty(HussarUtils.isEmpty((Object)organProperty) ? "0" : organProperty);
        String validTimeLimitType = StringUtils.trimToEmpty((String)addOrganizationDto.getValidTimeLimitType());
        sysOrgan.setValidTimeLimitType(HussarUtils.isEmpty((Object)validTimeLimitType) ? "0" : validTimeLimitType);
        sysStru.setOrganAlias(HussarUtils.isBlank((CharSequence)addOrganizationDto.getOrganAlias()) ? sysOrgan.getOrganName() : StringUtils.trimToEmpty((String)addOrganizationDto.getOrganAlias()));
        String newCode = this.getCode(sysOrgan);
        sysOrgan.setOrganCode(newCode);
        sysOrgan.setOrganNamePinyinFull(this.convertPinyinService.getFullPinyin(sysOrgan.getOrganName()));
        sysOrgan.setOrganNamePinyinInitial(this.convertPinyinService.getInitialsPinyin(sysOrgan.getOrganName()));
        sysStru.setIsLeaf("Y");
    }

    private void parentOrganizationAuditDataExists(Long parentId) {
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_PARENT_IS_AUDIT.getMessage()), (Object)parentId);
        if (!this.sysStruAuditService.checkCanOperate(parentId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAILED_PARENT_ORG_HAS_UNAPPROVED.getMessage()));
        }
    }

    private void initializationRelations(Long struId, AddOrganizationDto addOrganizationDto, List<SysStruPost> sysStruPosts, List<SysStruRole> sysStruRoles) {
        List postIds = addOrganizationDto.getPostIds();
        List roleIds = addOrganizationDto.getRoleIds();
        if (HussarUtils.isNotEmpty((Object)postIds)) {
            for (Long postId : postIds) {
                SysStruPost sysStruPost = new SysStruPost();
                sysStruPost.setStruId(struId);
                sysStruPost.setPostId(postId);
                sysStruPosts.add(sysStruPost);
            }
        }
        if (HussarUtils.isNotEmpty((Object)roleIds)) {
            for (Long roleId : roleIds) {
                SysStruRole sysStruRole = new SysStruRole();
                sysStruRole.setStruId(struId);
                sysStruRole.setGrantedRole(roleId);
                sysStruRoles.add(sysStruRole);
            }
        }
    }

    private void auditStruPost(List<SysStruPost> struPosts) {
        if (HussarUtils.isNotEmpty(struPosts)) {
            ArrayList<SysStruPostAudit> struPostAudits = new ArrayList<SysStruPostAudit>();
            for (SysStruPost struPost : struPosts) {
                SysStruPostAudit struPostAudit = new SysStruPostAudit();
                struPostAudit.setStruId(struPost.getStruId());
                struPostAudit.setPostId(struPost.getPostId());
                struPostAudit.setAuditStatus("0");
                struPostAudit.setOperateType("1");
                struPostAudits.add(struPostAudit);
            }
            this.sysStruPostAuditService.saveBatch(struPostAudits, struPostAudits.size());
        }
    }

    private void auditStruRole(List<SysStruRole> struRoles) {
        if (HussarUtils.isNotEmpty(struRoles)) {
            ArrayList<SysStruRoleAudit> struRoleAudits = new ArrayList<SysStruRoleAudit>();
            for (SysStruRole struRole : struRoles) {
                SysStruRoleAudit struRoleAudit = new SysStruRoleAudit();
                struRoleAudit.setStruId(struRole.getStruId());
                struRoleAudit.setRoleId(struRole.getGrantedRole());
                struRoleAudit.setStatus(StruRoleStatus.LOCKED.getCode());
                struRoleAudit.setOperationType("1");
                struRoleAudits.add(struRoleAudit);
            }
            this.sysStruRoleAuditService.saveBatch(struRoleAudits, struRoleAudits.size());
        }
    }

    private void doSave(SysStru sysStru, SysOrgan sysOrgan, SysOffice sysOffice) {
        this.sysOrganMapper.insert(sysOrgan);
        this.sysStruMapper.insert(sysStru);
        if (ToolUtil.isNotEmpty((Object)sysOffice)) {
            this.sysOfficeService.saveOrUpdate((Object)sysOffice);
        }
    }
}

