/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.menu.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Sets;
import com.jxdinfo.hussar.authorization.config.CascadeProductionProperties;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.menu.dao.SysMenuMapper;
import com.jxdinfo.hussar.authorization.menu.dto.MenuOrderDto;
import com.jxdinfo.hussar.authorization.menu.dto.MenuTreeChangeDto;
import com.jxdinfo.hussar.authorization.menu.model.MenuInfo;
import com.jxdinfo.hussar.authorization.menu.model.SysMenu;
import com.jxdinfo.hussar.authorization.menu.service.IExtendSelectUserMenu;
import com.jxdinfo.hussar.authorization.menu.service.ISysMenuManageService;
import com.jxdinfo.hussar.authorization.menu.vo.SysMenuVo;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceModules;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionModulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourceMosulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.authorization.permit.vo.SysModuleFunctionsVo;
import com.jxdinfo.hussar.base.config.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.base.config.shortcutconfig.model.ShortCutConfig;
import com.jxdinfo.hussar.common.base.HussarBaseServiceImpl;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.constant.tenant.TenantConstant;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.common.utils.SerializeUtils;
import com.jxdinfo.hussar.common.utils.TreeModelUtils;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.general.idtable.util.DataExportUtils;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysMenuManageServiceImpl
extends HussarBaseServiceImpl<SysMenuMapper, SysMenu>
implements ISysMenuManageService {
    private Logger logger = LoggerFactory.getLogger(SysMenuManageServiceImpl.class);
    @Value(value="${hussar-bpm.url:}")
    String url;
    private static final Long[] TENANT_DISABLE_NOT_DISPLAY = new Long[]{1450764807862095966L, 511224771913195520L, 1450764807862095977L};
    @Resource
    SysMenuMapper sysMenuMapper;
    @Resource
    private ISysFunctionModulesService iSysFunctionModulesService;
    @Resource
    private ISysFunctionsService iSysFunctionsService;
    @Resource
    private ISysResourcesService iSysResourcesService;
    @Resource
    private ISysFunctionResourcesService sysFunctionResourcesService;
    @Resource
    private ISysRoleFunctionsService sysRoleFunctionsService;
    @Resource
    private ISysIdtableService sysIdtableService;
    @Resource
    private ISysFunctionModulesService sysFunctionModulesService;
    @Resource
    private ISysFunctionsService sysFunctionsService;
    @Resource
    private ISysResourcesService sysResourcesService;
    @Resource
    private ISysResourceMosulesService sysResourceMosulesService;
    @Resource
    private ISysRoleResourceService sysRoleResourceService;
    @Resource
    private CascadeProductionProperties cascadeProductionProperties;
    @Value(value="${spring.profiles.active}")
    private String profiles;
    @Resource
    private HussarTenantProperties tenantProperties;
    @Resource
    private HussarThreadPoolConfiguration hussarThreadPoolConfiguration;
    @Autowired(required=false)
    private IExtendSelectUserMenu extendSelectUserMenu;
    @Value(value="${hussar.sdk-adapter.resource:default}")
    private String resource;
    @Resource
    private ISysBaseConfigService baseConfigService;

    public List<MenuInfo> queryUserMenu(String type) {
        List<Object> menus;
        if (ToolUtil.isEmpty((Object)type)) {
            type = "";
        }
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        List roleIdList = shiroUser.getRolesList();
        if (shiroUser == null) {
            throw new BaseException(TranslateUtil.getTranslateName((String)ResultCode.UN_AUTHORIZED.getMessage()));
        }
        if (HussarUtils.isNotEmpty((Object)roleIdList)) {
            ISysMenuManageService sysMenuManageService = (ISysMenuManageService)SpringContextHolder.getBean(ISysMenuManageService.class);
            String locale = LocaleContextHolder.getLocale().toString();
            menus = sysMenuManageService.getMenuByRoles(shiroUser.getId(), roleIdList, this.profiles, type, locale);
        } else {
            menus = new ArrayList<MenuInfo>();
        }
        if (this.extendSelectUserMenu == null) {
            return menus;
        }
        return this.extendSelectUserMenu.selectQueryUserMenu(menus);
    }

    public List<JSTreeModel> getAllUserMenuTree(List<String> menuId) {
        return this.sysMenuMapper.getAllUserMenuTree(menuId);
    }

    public List<JSTreeModel> getUserMenuTree(List<String> resourceIdList) {
        return this.sysMenuMapper.getUserMenuTree(resourceIdList);
    }

    public List<JSTreeModel> getMenuTree() {
        List<JSTreeModel> jsTreeModelList = this.sysMenuMapper.getMenuTree();
        JSTreeModel root = new JSTreeModel();
        root.setId(Constants.MENU_NODE_ID);
        root.setText(TranslateUtil.getTranslateName((String)"AUTHOR_MENU_LIST"));
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setIsLeaf("0");
        root.setType("isRoot");
        jsTreeModelList.add(root);
        TranslateUtil.translate(jsTreeModelList, JSTreeModel::getTextLangKey, JSTreeModel::setText);
        return jsTreeModelList;
    }

    public List<JSTreeModel> getMenuMergeTree() {
        return TreeModelUtils.merge(this.getMenuTree());
    }

    public List<JSTreeModel> getMenuStruTree() {
        SysBaseConfig protectStatus;
        String isSys = "";
        if (this.cascadeProductionProperties.getEnable().booleanValue()) {
            isSys = "0";
        }
        if (null != (protectStatus = this.baseConfigService.getSysBaseConfig("protection_status")) && "3".equals(protectStatus.getConfigValue())) {
            isSys = "0";
        }
        List<JSTreeModel> jsTreeModelList = this.sysMenuMapper.getMenuStruTree(isSys);
        TranslateUtil.translate(jsTreeModelList, JSTreeModel::getTextLangKey, JSTreeModel::setText);
        JSTreeModel root = new JSTreeModel();
        root.setId(Constants.MENU_NODE_ID);
        root.setText(TranslateUtil.getTranslateName((String)"AUTHOR_MENU_LIST"));
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setIsLeaf("0");
        root.setType("isRoot");
        jsTreeModelList.add(root);
        return TreeModelUtils.merge(jsTreeModelList);
    }

    public List<JSTreeModel> getShortCutMenuTree() {
        List<JSTreeModel> shortCutMenuTreeNoPath = this.getShortCutMenuTreeNoPath();
        List shortCutMenuTree = this.sysFunctionResourcesService.getShortCutMenuTree(shortCutMenuTreeNoPath);
        TranslateUtil.translate((List)shortCutMenuTree, JSTreeModel::getTextLangKey, JSTreeModel::setText);
        return shortCutMenuTree;
    }

    public List<JSTreeModel> getShortCutMenuTreeNoPath() {
        List<JSTreeModel> shortCutMenuTreeNoPath = this.sysMenuMapper.getShortCutMenuTreeNoPath();
        TranslateUtil.translate(shortCutMenuTreeNoPath, JSTreeModel::getTextLangKey, JSTreeModel::setText);
        return shortCutMenuTreeNoPath;
    }

    private void checkMenuOperate(SysMenu sysMenu) {
        AssertUtil.isNotNull((Object)sysMenu, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MENU_ENTITY_EMPTY.getMessage()));
        String isLeaf = sysMenu.getIsLeaf();
        if (StringUtils.isNotBlank((CharSequence)isLeaf) && "1".equals(isLeaf)) {
            Long functionId = sysMenu.getFunctionId();
            AssertUtil.isNotNull((Object)functionId, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MENU_FUNCTION_ID_ENTITY_EMPTY.getMessage()));
            SysFunctions referenceFunction = (SysFunctions)this.iSysFunctionsService.getById((Serializable)functionId);
            AssertUtil.isNotNull((Object)referenceFunction, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MENU_FUNCTION_ID_NO_FOUND_INFO.getMessage()));
            Long defaultResourceId = referenceFunction.getDefaultResourceId();
            AssertUtil.isNotNull((Object)defaultResourceId, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MENU_FUNCTION_ENTRY_EMPTY.getMessage()));
        }
    }

    public ApiResponse saveMenu(SysMenu sysMenu) {
        SysModuleFunctionsVo moduleFunctionVo;
        if (ToolUtil.isEmpty((Object)sysMenu)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MENU_ENTITY_EMPTY.getMessage()));
        }
        if ("1".equals(sysMenu.getIsLeaf()) && (moduleFunctionVo = this.iSysFunctionsService.getFunctionDetail(sysMenu.getFunctionId())).getDefaultResourceId() == null) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_CONFIGURE_FUNCTION_ENTRY.getMessage()));
        }
        if (!"inside".equals(sysMenu.getOpenType())) {
            sysMenu.setOpenMode("1");
        } else {
            sysMenu.setOpenMode("0");
        }
        this.setPathFromResource(sysMenu);
        Integer max = this.sysMenuMapper.getMaxOrderByParentId(sysMenu.getParentId());
        if (ToolUtil.isNotEmpty((Object)max)) {
            sysMenu.setSeq(Integer.valueOf(max + 1));
        } else {
            sysMenu.setSeq(Integer.valueOf(1));
        }
        sysMenu.setMenuType("1");
        this.checkMenuOperate(sysMenu);
        this.menuInterLangText(sysMenu);
        if (!this.save((BaseEntity)sysMenu)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL.getMessage()));
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_SUCCESS.getMessage()));
    }

    public ApiResponse updateMenu(SysMenu sysMenu) {
        SysModuleFunctionsVo moduleFunctionVo;
        if (ToolUtil.isEmpty((Object)sysMenu)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MENU_ENTITY_EMPTY.getMessage()));
        }
        if (ToolUtil.isEmpty((Object)sysMenu.getId())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MENU_ID_ENTITY_EMPTY.getMessage()));
        }
        if ("1".equals(sysMenu.getIsLeaf()) && (moduleFunctionVo = this.iSysFunctionsService.getFunctionDetail(sysMenu.getFunctionId())).getDefaultResourceId() == null) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_CONFIGURE_FUNCTION_ENTRY.getMessage()));
        }
        if (!"inside".equals(sysMenu.getOpenType())) {
            sysMenu.setOpenMode("1");
        } else {
            sysMenu.setOpenMode("0");
        }
        this.setPathFromResource(sysMenu);
        this.menuInterLangText(sysMenu);
        this.checkMenuOperate(sysMenu);
        if (!this.updateById((BaseEntity)sysMenu)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_FAIL.getMessage()));
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_SUCCESS.getMessage()));
    }

    public void menuInterLangText(SysMenu sysMenu) {
        if (TranslateUtil.getIsEnable()) {
            if (HussarUtils.isNotEmpty((Object)sysMenu.getAliasLangKey()) && HussarUtils.isNotEmpty((Object)TranslateUtil.getDefaultTranslateName((String)sysMenu.getAliasLangKey()))) {
                sysMenu.setMenuAlias(TranslateUtil.getDefaultTranslateName((String)sysMenu.getAliasLangKey()));
            }
            if (HussarUtils.isNotEmpty((Object)sysMenu.getTextLangKey()) && HussarUtils.isNotEmpty((Object)TranslateUtil.getDefaultTranslateName((String)sysMenu.getTextLangKey()))) {
                sysMenu.setText(TranslateUtil.getDefaultTranslateName((String)sysMenu.getTextLangKey()));
            }
        }
    }

    private void setPathFromResource(SysMenu sysMenu) {
        SysResources resources;
        if (ToolUtil.isEmpty((Object)sysMenu.getFunctionId())) {
            return;
        }
        SysFunctions functions = (SysFunctions)this.iSysFunctionsService.getById((Serializable)sysMenu.getFunctionId());
        if (ToolUtil.isNotEmpty((Object)functions) && ToolUtil.isNotEmpty((Object)(resources = (SysResources)this.iSysResourcesService.getById((Serializable)functions.getDefaultResourceId()))) && ToolUtil.isNotEmpty((Object)resources.getPath())) {
            sysMenu.setPath(resources.getPath());
        }
    }

    public ApiResponse deleteMenus(String menuIds) {
        if (ToolUtil.isEmpty((Object)menuIds)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MENU_ID_ENTITY_EMPTY.getMessage()));
        }
        List<String> idList = this.getAllChildMenuIds(new ArrayList<String>(Arrays.asList(menuIds.split(","))));
        List cdids = idList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        if (!this.removeByIds(cdids)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_FAIL.getMessage()));
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_SUCCESS.getMessage()));
    }

    private List<String> getAllChildMenuIds(List<String> menuIds) {
        if (menuIds.size() > 0) {
            this.getChildMenuIds(menuIds, menuIds);
        }
        return menuIds;
    }

    private void getChildMenuIds(List<String> menuIds, List<String> parentIds) {
        List parentIdls = parentIds.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        List childMenuList = this.sysMenuMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysMenu::getParentId, parentIdls));
        ArrayList<String> childIds = new ArrayList<String>();
        if (childMenuList.size() > 0) {
            childMenuList.forEach(child -> childIds.add(String.valueOf(child.getId())));
        }
        if (childIds.size() > 0) {
            menuIds.addAll(childIds);
            this.getChildMenuIds(menuIds, childIds);
        }
    }

    public SysMenuVo getMenuInfo(Long menuId) {
        SysFunctions function;
        if (ToolUtil.isEmpty((Object)menuId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MENU_ID_ENTITY_EMPTY.getMessage()));
        }
        SysMenuVo menuVo = this.sysMenuMapper.getMenuInfo(menuId);
        Long functionId = menuVo.getFunctionId();
        if (HussarUtils.isNotEmpty((Object)functionId) && HussarUtils.isNotEmpty((Object)(function = (SysFunctions)this.iSysFunctionsService.getById((Serializable)functionId)))) {
            menuVo.setFunctionName(function.getFunctionName());
            menuVo.setFunctionNameLangKey(function.getNameLangKey());
        }
        TranslateUtil.translate((Object)menuVo, SysMenu::getAliasLangKey, SysMenu::setMenuAlias);
        TranslateUtil.translate((Object)menuVo, SysMenu::getTextLangKey, SysMenu::setText);
        TranslateUtil.translate((Object)menuVo, SysMenuVo::getParentNameLangKey, SysMenuVo::setParentName);
        TranslateUtil.translate((Object)menuVo, SysMenuVo::getFunctionNameLangKey, SysMenuVo::setFunctionName);
        return menuVo;
    }

    public JSONObject delMenuById(String menuId) {
        List<Map<String, Object>> menuResult = this.sysMenuMapper.getMenuByParentId(menuId);
        boolean isDel = true;
        if (ToolUtil.isNotEmpty(menuResult)) {
            isDel = false;
        }
        if (isDel) {
            this.sysMenuMapper.deleteById((Serializable)((Object)menuId));
        }
        JSONObject json = new JSONObject();
        json.put("success", (Object)isDel);
        return json;
    }

    public List<JSTreeModel> menuTreeById(Long menuId, boolean isRoot) {
        if (ToolUtil.isEmpty((Object)menuId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MENU_ID_ENTITY_EMPTY.getMessage()));
        }
        if (ToolUtil.isEmpty((Object)isRoot)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NEED_SPECIFY_ROOT_NODE.getMessage()));
        }
        List<JSTreeModel> jsTreeModelList = this.sysMenuMapper.menuTreeById(menuId);
        if (isRoot) {
            JSTreeModel root = new JSTreeModel();
            root.setId(Constants.MENU_NODE_ID);
            root.setText(TranslateUtil.getTranslateName((String)"AUTHOR_MENU_LIST"));
            root.setParent(Constants.ROOT_NODE_PARENT);
            root.setIsLeaf("0");
            root.setType("isRoot");
            jsTreeModelList.add(root);
        }
        TranslateUtil.translate(jsTreeModelList, JSTreeModel::getTextLangKey, JSTreeModel::setText);
        return TreeModelUtils.merge(jsTreeModelList);
    }

    public List<JSTreeModel> menuTreeById(String menuId, boolean isRoot) {
        return this.menuTreeById(Long.parseLong(menuId), isRoot);
    }

    @Cacheable(value={"menu_info"}, key="'hussar_menus:'+#userId + ':' +#type + ':' + #locale")
    public List<MenuInfo> getMenuByRoles(Long userId, List<Long> list, String profiles, String type, String locale) {
        List<MenuInfo> totalResult = this.getMenuInfo(new ArrayList<Long>(), type);
        List<MenuInfo> lastResult = this.getMenuInfo(list, type);
        HashSet<MenuInfo> resultSet = new HashSet<MenuInfo>();
        for (MenuInfo lastMenu : lastResult) {
            this.getOwnMenus(lastMenu, totalResult, resultSet);
        }
        ArrayList<MenuInfo> result = new ArrayList<MenuInfo>(resultSet);
        result.addAll(lastResult);
        result.sort(Comparator.comparing(MenuInfo::getSeq));
        return this.getMenuListTree(result);
    }

    @Cacheable(value={"menu_info"}, key="'hussar_menus:'+#userId + #connName", condition="!'dev'.equals(#profiles)")
    public List<MenuInfo> getTenantMenuByRoles(Long userId, List<Long> list, String profiles, String connName, String type) {
        Object path;
        String component;
        int i;
        List<MenuInfo> totalResult = this.getMenuInfo(new ArrayList<Long>(), type);
        List<MenuInfo> lastResult = this.getMenuInfo(list, type);
        for (i = 0; i < lastResult.size(); ++i) {
            component = lastResult.get(i).getComponent_sr();
            path = lastResult.get(i).getPath_sr();
            lastResult.get(i).setPath((String)path);
            lastResult.get(i).setComponent(component);
            if (!ToolUtil.isEmpty((Object)path)) continue;
            lastResult.remove(i);
            --i;
        }
        for (i = 0; i < lastResult.size(); ++i) {
            component = lastResult.get(i).getComponent_sr();
            path = lastResult.get(i).getPath_sr();
            lastResult.get(i).setPath((String)path);
            lastResult.get(i).setComponent(component);
            if (!ToolUtil.isEmpty((Object)path)) continue;
            lastResult.remove(i);
            --i;
        }
        for (int i2 = 0; i2 < lastResult.size(); ++i2) {
            if (!lastResult.get(i2).getPath().contains("/static/bpm/index.html")) continue;
            path = lastResult.get(i2).getPath();
            MenuInfo menuInfo1 = lastResult.get(i2);
            lastResult.remove(i2);
            String string = this.url + (String)path;
            menuInfo1.setPath(string);
            lastResult.add(i2, menuInfo1);
            break;
        }
        HashSet<MenuInfo> resultSet = new HashSet<MenuInfo>();
        for (MenuInfo menuInfo2 : lastResult) {
            this.getOwnMenus(menuInfo2, totalResult, resultSet);
        }
        ArrayList<MenuInfo> result = new ArrayList<MenuInfo>(resultSet);
        result.addAll(lastResult);
        for (MenuInfo menu : result) {
            List l = result.stream().filter(menuInfo -> menuInfo.getParentId().equals(menu.getMenuId())).collect(Collectors.toList());
            l.sort((m1, m2) -> m1.getSeq().compareTo(m2.getSeq()));
            menu.setChildMenus(l);
        }
        List<MenuInfo> list2 = result.stream().filter(menuInfo -> menuInfo.getParentId().equals(1L)).collect(Collectors.toList());
        list2.sort((m1, m2) -> m1.getSeq().compareTo(m2.getSeq()));
        return list2;
    }

    public void getOwnMenus(MenuInfo menuInfo, List<MenuInfo> total, Set<MenuInfo> result) {
        for (MenuInfo menu : total) {
            if (!menuInfo.getParentId().equals(menu.getMenuId())) continue;
            result.add(menu);
            if (menu.getMenuId().equals(1L)) break;
            this.getOwnMenus(menu, total, result);
            break;
        }
    }

    public ApiResponse updateMenuTree(MenuTreeChangeDto menuTreeChangeDto) {
        boolean flag;
        Integer order = 1;
        Integer max = this.sysMenuMapper.getMaxOrderByParentId(menuTreeChangeDto.getParentId());
        if (ToolUtil.isNotEmpty((Object)max)) {
            order = max + 1;
        }
        if (!(flag = this.sysMenuMapper.menuTreeChange(menuTreeChangeDto.getMenuId(), menuTreeChangeDto.getParentId(), order))) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.SAVE_FAIL.getMessage()));
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.SAVE_SUCCESS.getMessage()));
    }

    @HussarTransactional
    public ApiResponse updateMoveNode(MenuOrderDto menuOrderDto) {
        SysMenu thatMenu;
        Long menuId = menuOrderDto.getMenuId();
        boolean isUp = menuOrderDto.getIsUp();
        if (ToolUtil.isEmpty((Object)menuId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MENU_ID_ENTITY_EMPTY.getMessage()));
        }
        SysMenuVo thisMenu = this.sysMenuMapper.getMenuInfo(menuId);
        List<SysMenu> thatMenuList = isUp ? this.sysMenuMapper.seletListLt(thisMenu.getParentId(), thisMenu.getSeq()) : this.sysMenuMapper.seletListGt(thisMenu.getParentId(), thisMenu.getSeq());
        if (thatMenuList.size() > 0 && (thatMenu = thatMenuList.get(0)) != null) {
            Integer temp = thisMenu.getSeq();
            thisMenu.setSeq(thatMenu.getSeq());
            thatMenu.setSeq(temp);
            this.updateById((BaseEntity)thisMenu);
            this.updateById((BaseEntity)thatMenu);
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_OPERATE_SUCCESS.getMessage()));
    }

    public SysMenu getMenuById(String menuId) {
        return (SysMenu)this.sysMenuMapper.selectById((Serializable)((Object)menuId));
    }

    public void exportMenu(String menuIds, HttpServletResponse response) {
        if (menuIds == null) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MENU_ID_ENTITY_EMPTY.getMessage()));
        }
        List<String> menuIdList = Arrays.asList(menuIds.split(","));
        List menuIdLong = menuIdList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        List menu = this.sysMenuMapper.selectList((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysMenu::getId, menuIdLong));
        ArrayList<Long> functionIds = new ArrayList<Long>();
        ArrayList<Long> functionModuleIds = new ArrayList<Long>();
        for (Object sysMenu : menu) {
            if (ToolUtil.isNotEmpty((Object)sysMenu.getFunctionId())) {
                functionIds.add(sysMenu.getFunctionId());
            }
            if (!ToolUtil.isNotEmpty((Object)sysMenu.getFunctionModuleId())) continue;
            functionModuleIds.add(sysMenu.getFunctionModuleId());
        }
        List functionsList = new ArrayList();
        if (ToolUtil.isNotEmpty(functionIds)) {
            functionsList = this.iSysFunctionsService.list((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysFunctions::getId, functionIds));
            for (SysFunctions functions : functionsList) {
                if (!ToolUtil.isNotEmpty((Object)functions.getFunctionModuleId())) continue;
                functionModuleIds.add(functions.getFunctionModuleId());
            }
        }
        List<Object> functionModulesList = new ArrayList();
        if (ToolUtil.isNotEmpty(functionModuleIds)) {
            functionModulesList = this.getExportFunctionModules(functionModuleIds);
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("menu", menu);
        data.put("function", functionsList);
        data.put("functionModule", functionModulesList);
        data.put("export_type", "menu");
        byte[] serializeData = new byte[]{};
        try {
            serializeData = SerializeUtils.serialize(data);
        }
        catch (Exception e) {
            this.logger.error(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_SERIALIZATION_ERROR.getMessage()), (Throwable)e);
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_SERIALIZATION_ERROR.getMessage()));
        }
        String fileName = "menu_" + DateUtil.format((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)"yyyyMMdd_HHmmss") + ".hussar";
        DataExportUtils.byteToFile((byte[])serializeData, (String)fileName, (HttpServletResponse)response);
    }

    private List<SysFunctionModules> getExportFunctionModules(List<Long> functionModuleIds) {
        List<Object> functionModulesList = new ArrayList<SysFunctionModules>();
        if (ToolUtil.isNotEmpty(functionModuleIds)) {
            functionModulesList = this.iSysFunctionModulesService.list((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysFunctionModules::getId, functionModuleIds));
        }
        if (functionModulesList.size() > 0) {
            ArrayList<Long> parentIdList = new ArrayList<Long>();
            for (SysFunctionModules sysFunctionModules : functionModulesList) {
                if (!ToolUtil.isNotEmpty((Object)sysFunctionModules.getParentModuleId())) continue;
                parentIdList.add(sysFunctionModules.getParentModuleId());
            }
            List<SysFunctionModules> parentList = this.getExportFunctionModules(parentIdList);
            if (parentList.size() > 0) {
                functionModulesList.addAll(parentList);
            }
        }
        return functionModulesList;
    }

    @HussarTransactional
    public JSONObject importMenuData(byte[] content) {
        Map data;
        JSONObject result = new JSONObject();
        try {
            data = (Map)SerializeUtils.deserialize((byte[])content);
        }
        catch (Exception e) {
            this.logger.error(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DESERIALIZATION_ERROR.getMessage()), (Throwable)e);
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_IMPORT_FAILED_PLATFORM.getMessage()));
        }
        if (ToolUtil.isEmpty((Object)data)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_IMPORT_FAILED_PLATFORM.getMessage()));
        }
        String export_type = (String)data.get("export_type");
        if (!"menu".equals(export_type)) {
            result.put("success", (Object)"false");
            result.put("importType", (Object)export_type);
            result.put("trueType", (Object)"menu");
            return result;
        }
        List menu = (List)data.get("menu");
        List functionsList = (List)data.get("function");
        List functionModulesList = (List)data.get("functionModule");
        Map<String, Integer> count = this.insertOrUpdateList(menu, functionsList, functionModulesList);
        result.put("success", (Object)"true");
        result.put("menuUpdate", (Object)count.get("menuUpdate"));
        result.put("menuInsert", (Object)count.get("menuInsert"));
        result.put("functionUpdate", (Object)count.get("functionUpdate"));
        result.put("functionInsert", (Object)count.get("functionInsert"));
        result.put("moduleUpdate", (Object)count.get("moduleUpdate"));
        result.put("moduleInsert", (Object)count.get("moduleInsert"));
        return result;
    }

    public Map<String, Integer> insertOrUpdateList(List<SysMenu> menuList, List<SysFunctions> functionsList, List<SysFunctionModules> functionModulesList) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Integer menuUpdate = 0;
        Integer menuInsert = 0;
        Integer functionUpdate = 0;
        Integer functionInsert = 0;
        Integer moduleUpdate = 0;
        Integer moduleInsert = 0;
        if (CollectionUtils.isEmpty(menuList)) {
            throw new IllegalArgumentException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ENTITY_LIST_EMPTY.getMessage()));
        }
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            Integer n;
            Integer n2;
            int size = menuList.size();
            for (int i = 0; i < size; ++i) {
                Integer n3;
                if (super.updateById((BaseEntity)menuList.get(i))) {
                    n3 = menuUpdate;
                    n2 = menuUpdate = Integer.valueOf(menuUpdate + 1);
                } else {
                    super.save((BaseEntity)menuList.get(i));
                    n3 = menuInsert;
                    n2 = menuInsert = Integer.valueOf(menuInsert + 1);
                }
                if (i < 1 || i % size != 0) continue;
                batchSqlSession.flushStatements();
            }
            int functionSize = functionsList.size();
            for (int i = 0; i < functionSize; ++i) {
                if (this.iSysFunctionsService.updateById((Object)functionsList.get(i))) {
                    n2 = functionUpdate;
                    n = functionUpdate = Integer.valueOf(functionUpdate + 1);
                } else {
                    this.iSysFunctionsService.save((Object)functionsList.get(i));
                    n2 = functionInsert;
                    n = functionInsert = Integer.valueOf(functionInsert + 1);
                }
                if (i < 1 || i % functionSize != 0) continue;
                batchSqlSession.flushStatements();
            }
            int functionModuleSize = functionModulesList.size();
            for (int i = 0; i < functionModuleSize; ++i) {
                Integer n4;
                if (this.iSysFunctionModulesService.updateById((Object)functionModulesList.get(i))) {
                    n = moduleUpdate;
                    n4 = moduleUpdate = Integer.valueOf(moduleUpdate + 1);
                } else {
                    this.iSysFunctionModulesService.save((Object)functionModulesList.get(i));
                    n = moduleInsert;
                    n4 = moduleInsert = Integer.valueOf(moduleInsert + 1);
                }
                if (i < 1 || i % functionModuleSize != 0) continue;
                batchSqlSession.flushStatements();
            }
            batchSqlSession.flushStatements();
        }
        catch (Throwable e) {
            throw new MybatisPlusException("Error: Cannot execute insertOrUpdateBatch Method. Cause", e);
        }
        result.put("menuUpdate", menuUpdate);
        result.put("menuInsert", menuInsert);
        result.put("functionUpdate", functionUpdate);
        result.put("functionInsert", functionInsert);
        result.put("moduleUpdate", moduleUpdate);
        result.put("moduleInsert", moduleInsert);
        return result;
    }

    public IPage<SysMenu> queryMenuInfoList(Page<SysMenu> page, Long parentNodeId) {
        if (ToolUtil.isEmpty(page) || ToolUtil.isEmpty((Object)parentNodeId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PAGING_INFO_OR_NODE_ID_EMPTY.getMessage()));
        }
        if (ToolUtil.equals((Object)Constants.ROOT_NODE_PARENT, (Object)parentNodeId)) {
            parentNodeId = Constants.MENU_NODE_ID;
        }
        Page resPage = (Page)this.page((IPage)page, (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysMenu::getParentId, (Object)parentNodeId)).orderByAsc(SysMenu::getSeq));
        SysBaseConfig protectStatus = this.baseConfigService.getSysBaseConfig("protection_status");
        if (this.cascadeProductionProperties.getEnable().booleanValue() || null != protectStatus && "3".equals(protectStatus.getConfigValue())) {
            resPage = (Page)this.page((IPage)page, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysMenu::getParentId, (Object)parentNodeId)).eq(SysMenu::getIsSys, (Object)"0")).orderByAsc(SysMenu::getSeq));
        }
        TranslateUtil.translate((Page)resPage, SysMenu::getTextLangKey, SysMenu::setText);
        TranslateUtil.translate((Page)resPage, SysMenu::getAliasLangKey, SysMenu::setMenuAlias);
        return resPage;
    }

    public ApiResponse deleteCascadeMenuId(Long menuId) {
        List<Long> idList = this.findCascadeMenuId(menuId);
        if (!this.removeByIds(idList)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_FAIL.getMessage()));
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_SUCCESS.getMessage()));
    }

    public List<Long> findCascadeMenuId(Long menuId) {
        if (ToolUtil.isEmpty((Object)menuId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MENU_ID_ENTITY_EMPTY.getMessage()));
        }
        HashSet deleteMenuIds = Sets.newHashSet((Object[])new Long[]{menuId});
        List<JSTreeModel> menuList = this.getMenuTree();
        this.getCascadeSubMenuIds(menuId, menuList, deleteMenuIds);
        return new ArrayList<Long>(deleteMenuIds);
    }

    @HussarTransactional
    public ApiResponse updateMenuOrder(List<SysMenu> sysMenus) {
        if (ToolUtil.isEmpty(sysMenus)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_SORTING_MENU_COLLECTION_EMPTY.getMessage()));
        }
        for (int i = 0; i < sysMenus.size(); ++i) {
            SysMenu sm = sysMenus.get(i);
            sm.setSeq(Integer.valueOf(i + 1));
        }
        if (!this.updateBatchById(sysMenus, sysMenus.size())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.SAVE_FAIL.getMessage()));
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.SAVE_SUCCESS.getMessage()));
    }

    private void getCascadeSubMenuIds(Long parentNodeId, List<JSTreeModel> struMenuList, Set<Long> parentMenuIds) {
        for (JSTreeModel subMenu : struMenuList) {
            if (!parentNodeId.equals(subMenu.getParent())) continue;
            parentMenuIds.add(subMenu.getId());
            if (!CollectionUtils.isNotEmpty((Collection)subMenu.getChildrenList())) continue;
            this.getCascadeSubMenuIds(subMenu.getId(), subMenu.getChildrenList(), parentMenuIds);
        }
    }

    private void removeMenus(List<MenuInfo> menus, Long menuId) {
        for (MenuInfo menuInfo : menus) {
            if (menuId.equals(menuInfo.getMenuId())) {
                menus.remove(menuInfo);
                break;
            }
            List childList = menuInfo.getChildMenus();
            if (!ToolUtil.isNotEmpty((Object)childList)) continue;
            this.removeMenus(menuInfo.getChildMenus(), menuId);
        }
    }

    private void updateComponentByType(List<MenuInfo> menus, String extra) {
        for (MenuInfo menuInfo : menus) {
            List childList;
            String component = menuInfo.getComponent();
            if (ToolUtil.isNotEmpty((Object)component) && !component.contains(extra)) {
                int index = component.indexOf("@");
                String pre = component.substring(0, index + 1);
                String suf = component.substring(index + 1);
                String newComponent = pre + extra + suf;
                menuInfo.setComponent(newComponent);
            }
            if (!ToolUtil.isNotEmpty((Object)(childList = menuInfo.getChildMenus()))) continue;
            this.updateComponentByType(menuInfo.getChildMenus(), extra);
        }
    }

    public void insertOrUpdateMenuList(List<SysMenu> sysMenuList) {
        if (CollectionUtils.isEmpty(sysMenuList)) {
            this.logger.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MENU_ADD_DATA.getMessage()), (Object)sysMenuList.size());
            this.logger.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MENU_EDIT_DATA.getMessage()), (Object)sysMenuList.size());
            return;
        }
        List allTableData = this.list();
        List allIds = allTableData.stream().map(SysMenu::getId).collect(Collectors.toList());
        ArrayList<SysMenu> insertData = new ArrayList<SysMenu>();
        ArrayList<SysMenu> updateData = new ArrayList<SysMenu>();
        Integer maxOrder = this.sysMenuMapper.getMaxOrder();
        for (SysMenu item : sysMenuList) {
            if (allIds.contains(item.getId())) {
                updateData.add(item);
                continue;
            }
            Integer n = maxOrder;
            Integer n2 = maxOrder = Integer.valueOf(maxOrder + 1);
            item.setSeq(maxOrder);
            insertData.add(item);
        }
        if (ToolUtil.isNotEmpty(insertData)) {
            this.saveBatch(insertData);
        }
        if (ToolUtil.isNotEmpty(updateData)) {
            this.updateBatchById(updateData);
        }
        this.logger.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MENU_ADD_DATA.getMessage()), (Object)insertData.size());
        this.logger.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MENU_EDIT_DATA.getMessage()), (Object)updateData.size());
    }

    public List<SysMenu> getMenus(List<SysMenu> allMenus, List<SysMenu> children, List<SysMenu> result) {
        if (ToolUtil.isEmpty(children)) {
            return result;
        }
        List parentIds = children.stream().map(SysMenu::getParentId).collect(Collectors.toList());
        if (ToolUtil.isEmpty(parentIds)) {
            return result;
        }
        ArrayList<SysMenu> parentMenus = new ArrayList<SysMenu>();
        ArrayList<SysMenu> tempMenus = new ArrayList<SysMenu>();
        for (SysMenu menu : allMenus) {
            if (parentIds.contains(menu.getId())) {
                parentMenus.add(menu);
                continue;
            }
            tempMenus.add(menu);
        }
        result.addAll(parentMenus);
        return this.getMenus(tempMenus, parentMenus, result);
    }

    public List<SysMenu> getMenuBranch(List<SysMenu> allMenus, SysMenu menu, List<SysMenu> result) {
        if (HussarUtils.isEmpty((Object)menu)) {
            return result;
        }
        Long parentId = menu.getParentId();
        SysMenu parentMenu = null;
        for (SysMenu item : allMenus) {
            if (!item.getId().equals(parentId)) continue;
            parentMenu = item;
            break;
        }
        if (HussarUtils.isNotEmpty(parentMenu)) {
            result.add(parentMenu);
            return this.getMenuBranch(allMenus, parentMenu, result);
        }
        return result;
    }

    public List<SysMenu> getMenusByFunctionIds(List<Long> functionIds) {
        if (HussarUtils.isEmpty(functionIds)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        LambdaQueryUtil.wrapperWithMultiQuery((LambdaQueryWrapper)lambdaQueryWrapper, SysMenu::getFunctionId, functionIds);
        return this.list((Wrapper)lambdaQueryWrapper);
    }

    public List<SysMenu> getMenusByMenuIds(List<Long> menuIds) {
        if (HussarUtils.isEmpty(menuIds)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        for (Long id : menuIds) {
            ((LambdaQueryWrapper)lambdaQueryWrapper.or()).eq(SysMenu::getId, (Object)id);
        }
        return this.list((Wrapper)lambdaQueryWrapper);
    }

    public Integer getMaxOrderByParentId(Long parentId) {
        return this.sysMenuMapper.getMaxOrderByParentId(parentId);
    }

    public Long saveOrUpdateMenuByShortCut(ShortCutConfig shortCutConfig) {
        if (HussarUtils.isNotEmpty((Object)shortCutConfig.getId())) {
            Long menuId = shortCutConfig.getMenuId();
            SysMenu menu = (SysMenu)this.sysMenuMapper.selectById(menuId);
            menu.setText(shortCutConfig.getName());
            SysFunctions function = (SysFunctions)this.sysFunctionsService.getById((Serializable)menu.getFunctionId());
            function.setFunctionName(shortCutConfig.getName());
            SysResources resource = (SysResources)this.sysResourcesService.getById((Serializable)function.getDefaultResourceId());
            resource.setPath(shortCutConfig.getShortCutUrl());
            resource.setComponent(shortCutConfig.getShortCutUrl());
            resource.setUrlNames(shortCutConfig.getShortCutUrl());
            this.updateById((BaseEntity)menu);
            this.sysFunctionsService.updateById((Object)function);
            this.sysResourcesService.updateById((Object)resource);
            return menu.getId();
        }
        SysMenu menu = new SysMenu();
        menu.setId(Long.valueOf(IdWorker.getId((Object)new SysMenu())));
        menu.setText(shortCutConfig.getName());
        menu.setFunctionModuleId(Long.valueOf(-1L));
        menu.setParentId(Long.valueOf(1L));
        menu.setOpenType("outside");
        menu.setOpenMode("1");
        menu.setIsLeaf("1");
        SysFunctionModules functionModule = new SysFunctionModules();
        functionModule.setId(Long.valueOf(IdWorker.getId((Object)new SysFunctionModules())));
        functionModule.setFunctionModuleName(shortCutConfig.getName());
        functionModule.setParentModuleId(Long.valueOf(1L));
        functionModule.setSeq(this.sysFunctionModulesService.getMaxOrderByParentIdAndAppId(Long.valueOf(1L), Long.valueOf(1L)));
        functionModule.setFunctionModuleCode(this.sysIdtableService.getCurrentCode("FUNCTION_MODULE_CODE", "SYS_FUNCTION_MODULES"));
        SysFunctions function = new SysFunctions();
        function.setFunctionName(shortCutConfig.getName());
        function.setId(Long.valueOf(IdWorker.getId((Object)new SysFunctions())));
        function.setFunctionModuleId(functionModule.getId());
        String functionCode = this.sysIdtableService.getCurrentCode("FUNCTION_CODE", "SYS_FUNCTIONS");
        function.setFunctionCode(functionCode);
        function.setIsSys("0");
        function.setSeq(Integer.valueOf(1));
        menu.setFunctionId(function.getId());
        SysResourceModules resourceModule = new SysResourceModules();
        resourceModule.setId(Long.valueOf(IdWorker.getId((Object)new SysResourceModules())));
        resourceModule.setModuleName(shortCutConfig.getName());
        resourceModule.setParentModuleId(Long.valueOf(1L));
        resourceModule.setSeq(this.sysResourceMosulesService.getMaxOrderByParentIdAndAppId(Long.valueOf(1L), Long.valueOf(1L)));
        resourceModule.setModuleCode(this.sysIdtableService.getCurrentCode("MODULE_CODE", "SYS_RESOURCE_MODULES"));
        SysResources resource = new SysResources();
        resource.setId(Long.valueOf(IdWorker.getId((Object)new SysResources())));
        resource.setResourceName(shortCutConfig.getName());
        resource.setModuleId(resourceModule.getId());
        resource.setResTypeId("res_menu");
        resource.setIsSys("0");
        resource.setPath(shortCutConfig.getShortCutUrl());
        resource.setUrlNames(shortCutConfig.getShortCutUrl());
        resource.setKeepAlive("0");
        resource.setIsAudit("0");
        resource.setStrategy("0");
        resource.setIsRepeatAuthenticate("0");
        resource.setComponent(shortCutConfig.getShortCutUrl());
        resource.setSeq(Integer.valueOf(1));
        resource.setResourceCode(this.sysIdtableService.getCurrentCode("RESOURCE_CODE", "SYS_RESOURCES"));
        function.setDefaultResourceId(resource.getId());
        SysFunctionResources sysFunctionResources = new SysFunctionResources();
        sysFunctionResources.setFunctionId(function.getId());
        sysFunctionResources.setResourceId(resource.getId());
        ArrayList<SysRoleFunctions> roleFunctions = new ArrayList<SysRoleFunctions>();
        SysRoleFunctions roleFunction = new SysRoleFunctions();
        roleFunction.setRoleId(SysUserAndRole.SUPERADMIN_ROLE.getValue());
        roleFunction.setFunctionId(function.getId());
        SysRoleFunctions roleFunctionTenant = new SysRoleFunctions();
        roleFunctionTenant.setRoleId(TenantConstant.ADMIN_ROLE);
        roleFunctionTenant.setFunctionId(function.getId());
        roleFunctions.add(roleFunction);
        roleFunctions.add(roleFunctionTenant);
        ArrayList<SysRoleResource> roleResources = new ArrayList<SysRoleResource>();
        SysRoleResource roleResource = new SysRoleResource();
        roleResource.setRoleId(SysUserAndRole.SUPERADMIN_ROLE.getValue());
        roleResource.setResourceId(resource.getId());
        roleResource.setRelationSource("1");
        SysRoleResource roleResourceTenant = new SysRoleResource();
        roleResourceTenant.setRoleId(TenantConstant.ADMIN_ROLE);
        roleResourceTenant.setResourceId(resource.getId());
        roleResourceTenant.setRelationSource("1");
        roleResources.add(roleResource);
        roleResources.add(roleResourceTenant);
        Integer max = this.sysMenuMapper.getMaxOrderByParentId(menu.getParentId());
        if (ToolUtil.isNotEmpty((Object)max)) {
            menu.setSeq(Integer.valueOf(max + 1));
        } else {
            menu.setSeq(Integer.valueOf(1));
        }
        this.save((BaseEntity)menu);
        this.sysFunctionModulesService.save((Object)functionModule);
        this.sysFunctionsService.save((Object)function);
        this.sysFunctionResourcesService.save((Object)sysFunctionResources);
        this.sysRoleFunctionsService.saveBatch(roleFunctions);
        this.sysRoleResourceService.saveBatch(roleResources);
        this.sysResourceMosulesService.save((Object)resourceModule);
        this.sysResourcesService.save((Object)resource);
        return menu.getId();
    }

    public boolean deleteMenuByShortCut(ShortCutConfig shortCutConfig) {
        if (HussarUtils.equals((Object)"2", (Object)shortCutConfig.getOpenType())) {
            SysMenu menu = (SysMenu)this.getById(shortCutConfig.getMenuId());
            SysFunctions function = (SysFunctions)this.sysFunctionsService.getById((Serializable)menu.getFunctionId());
            this.removeById((BaseEntity)menu);
            this.sysFunctionsService.removeById((Object)function);
            this.sysFunctionResourcesService.remove((Wrapper)new LambdaQueryWrapper().eq(SysFunctionResources::getFunctionId, (Object)function.getId()));
            this.sysResourcesService.removeById((Serializable)function.getDefaultResourceId());
            this.sysRoleResourceService.remove((Wrapper)new LambdaQueryWrapper().eq(SysRoleResource::getResourceId, (Object)function.getDefaultResourceId()));
            this.sysRoleFunctionsService.remove((Wrapper)new LambdaQueryWrapper().eq(SysRoleFunctions::getFunctionId, (Object)function.getId()));
        }
        return true;
    }

    private List<MenuInfo> getMenuInfo(List<Long> roleIds, String type) {
        List<Long> functionIds;
        if (HussarUtils.isEmpty(roleIds)) {
            List<MenuInfo> allMenu = this.sysMenuMapper.getAllMenu(type);
            TranslateUtil.translate(allMenu, MenuInfo::getAliasLangKey, MenuInfo::setMenuAlias);
            TranslateUtil.translate(allMenu, MenuInfo::getTextLangKey, MenuInfo::setText);
            return allMenu;
        }
        if (HussarUtils.isEmpty((Object)this.resource) || HussarUtils.equals((Object)"default", (Object)this.resource)) {
            List<MenuInfo> lastMenuByRoleIds = this.sysMenuMapper.getLastMenuByRoleIds(roleIds, type);
            TranslateUtil.translate(lastMenuByRoleIds, MenuInfo::getAliasLangKey, MenuInfo::setMenuAlias);
            TranslateUtil.translate(lastMenuByRoleIds, MenuInfo::getTextLangKey, MenuInfo::setText);
            return lastMenuByRoleIds;
        }
        List<Object> menuInfos = new ArrayList();
        List roleFunctions = this.sysRoleFunctionsService.listByRoleIds(roleIds);
        if (HussarUtils.isNotEmpty((Object)roleFunctions)) {
            functionIds = roleFunctions.stream().map(SysRoleFunctions::getFunctionId).distinct().collect(Collectors.toList());
            menuInfos = this.sysMenuMapper.getLastMenuByFunctionIds(functionIds);
            TranslateUtil.translate(menuInfos, MenuInfo::getAliasLangKey, MenuInfo::setMenuAlias);
            TranslateUtil.translate(menuInfos, MenuInfo::getTextLangKey, MenuInfo::setText);
        }
        if (HussarUtils.isEmpty(menuInfos)) {
            return Collections.emptyList();
        }
        functionIds = menuInfos.stream().map(m -> HussarUtils.toLong((Object)m.getFunctionId())).collect(Collectors.toList());
        List sysFunctions = this.iSysFunctionsService.listByIds(functionIds);
        Map<Long, SysFunctions> funcMap = sysFunctions.stream().collect(Collectors.toMap(SysFunctions::getId, f -> f));
        menuInfos.forEach(menu -> menu.setResourceId(HussarUtils.toStr((Object)((SysFunctions)funcMap.get(HussarUtils.toLong((Object)menu.getFunctionId()))).getDefaultResourceId())));
        return menuInfos;
    }

    public List<SysMenu> getMenusInConsole() {
        return this.sysMenuMapper.getMenusInConsole();
    }

    public List<SysMenu> getLeafMenusInConsole() {
        return this.sysMenuMapper.getLeafMenusInConsole();
    }

    public List<SysMenu> getLeafMenus() {
        return this.sysMenuMapper.getLeafMenus();
    }

    private List<MenuInfo> getMenuListTree(List<MenuInfo> menuInfoList) {
        MenuInfo temp;
        ArrayList<MenuInfo> roots = new ArrayList<MenuInfo>();
        if (HussarUtils.isEmpty(menuInfoList)) {
            return new ArrayList<MenuInfo>();
        }
        TranslateUtil.translate(menuInfoList, MenuInfo::getAliasLangKey, MenuInfo::setMenuAlias);
        TranslateUtil.translate(menuInfoList, MenuInfo::getTextLangKey, MenuInfo::setText);
        ArrayList<Long> parentIds = new ArrayList<Long>();
        LinkedHashMap<Long, MenuInfo> map = new LinkedHashMap<Long, MenuInfo>();
        for (MenuInfo item : menuInfoList) {
            map.put(item.getMenuId(), item);
        }
        for (MenuInfo item : menuInfoList) {
            temp = (MenuInfo)map.get(item.getParentId());
            if (temp != null) {
                temp.getChildMenus().add(item);
                continue;
            }
            parentIds.add(item.getMenuId());
        }
        for (Long id : parentIds) {
            temp = (MenuInfo)map.get(id);
            if (!HussarUtils.isNotEmpty((Object)temp)) continue;
            roots.add(temp);
        }
        return roots;
    }
}

