/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.jxdinfo.hussar.authorization.audit.model.SysStruAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysUsersAudit;
import com.jxdinfo.hussar.authorization.audit.service.ISysUsersAuditService;
import com.jxdinfo.hussar.authorization.bspinterface.service.ISysOrgEventService;
import com.jxdinfo.hussar.authorization.organ.constants.GlobalProperties;
import com.jxdinfo.hussar.authorization.organ.dao.SysFormerlyStruRuleMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrgBoService;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseStruAssistOrganBoService;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseStruBoService;
import com.jxdinfo.hussar.authorization.organ.service.ISysFormerlyOrgManageService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.common.handler.LogObjectHolder;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.bpm.messagepush.AbstractBpmPushMsgMatcher;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.general.messagepush.AbstractPushMsgMatcher;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.ibatis.logging.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysFormerlyOrgManageServiceImpl
extends HussarServiceImpl<SysStruMapper, SysStru>
implements ISysFormerlyOrgManageService {
    @Resource
    private ISysOrgEventService iSysOrgEventService;
    @Autowired
    private SysFormerlyStruRuleMapper sysStruRuleMapper;
    @Resource
    IHussarBaseStruBoService hussarBaseStruBoService;
    @Resource
    private ISysUsersAuditService iSysUsersAuditService;
    @Autowired
    private SysUsersMapper sysUsersMapper;
    @Autowired
    private SysStruMapper sysStruMapper;
    @Resource
    private GlobalProperties globalProperties;
    @Resource
    private IHussarBaseUserBoService hussarBaseUserBoService;
    @Resource
    private IHussarBaseOrgBoService hussarBaseOrgBoService;
    @Resource
    IHussarBaseStruAssistOrganBoService hussarBaseStruAssistOrganBoService;
    @Resource
    private AbstractBpmPushMsgMatcher bpmAbstractPushMsgMatcher;
    @Resource
    private AbstractPushMsgMatcher abstractPushMsgMatcher;
    @Resource
    private ISysIdtableService sysIdtableService;
    @Resource
    private ISysOrganService sysOrganService;

    @Transactional(rollbackFor={Exception.class})
    public JSONObject orgTreeChangeVue(Long orgId, Long parentId, String orgType, String isRoot, String changeLevel, Boolean ignoreFlag) {
        try {
            LogObjectHolder.me().set("transfer_before_parent", (Object)this.iSysOrgEventService.beforeOrgChange(orgId, parentId));
        }
        catch (Exception exception) {
            // empty catch block
        }
        List<Map<String, Object>> map = this.sysStruRuleMapper.getOrgRoleById(parentId, orgType);
        if (ToolUtil.isNotEmpty((Object)isRoot) && "1".equals(isRoot)) {
            map = this.sysStruRuleMapper.getOrgTypeByType(orgType, isRoot);
        }
        JSONObject json = new JSONObject();
        if (!this.hussarBaseStruBoService.checkCanOperate(orgId)) {
            json.put("success", (Object)false);
            json.put("msg", (Object)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u8f6c\u79fb\uff01");
            return json;
        }
        if (map.size() == 0) {
            json.put("success", (Object)false);
            json.put("msg", (Object)"\u8f6c\u79fb\u5931\u8d25\uff01\u8be5\u8f6c\u79fb\u4e0d\u7b26\u5408\u7ec4\u7ec7\u673a\u6784\u89c4\u5219\uff01");
        } else {
            SysUsers user = null;
            if ("9".equals(orgType) && (user = (SysUsers)SqlHelper.getObject((Log)this.log, (List)this.sysUsersMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"EMPLOYEE_ID", (Object)orgId)))) != null) {
                if (this.iSysUsersAuditService.adjustEdit(user.getId())) {
                    json.put("success", (Object)false);
                    json.put("msg", (Object)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u8f6c\u79fb\uff01");
                    return json;
                }
                user.setCorporationId(parentId);
                user.setDepartmentId(parentId);
            }
            Integer orderTree = 1;
            Integer maxOrder = this.sysStruMapper.getMaxOrderById(parentId);
            if (ToolUtil.isNotEmpty((Object)maxOrder)) {
                orderTree = maxOrder + 1;
            }
            Integer level = Integer.parseInt(changeLevel) + 1;
            if (this.globalProperties.isCriticalOperationsAudit() && this.globalProperties.isOrganAudit() && !ignoreFlag.booleanValue()) {
                SysStru sysStru = (SysStru)this.sysStruMapper.selectById(orgId);
                SysStruAudit sysStruAudit = new SysStruAudit();
                CopyPropertieUtils.copyProperties((Object)sysStruAudit, (Object)sysStru);
                sysStruAudit.setId(null);
                sysStruAudit.setInUse("4");
                sysStruAudit.setStruOrder(orderTree);
                sysStruAudit.setRealStruId(sysStru.getId());
                sysStruAudit.setState("0");
                sysStruAudit.setStruLevel(level);
                sysStruAudit.setParentId(parentId);
                this.hussarBaseStruBoService.saveAudit(sysStruAudit);
                if (user != null) {
                    SysUsersAudit sysUsersAudit = new SysUsersAudit();
                    CopyPropertieUtils.copyProperties((Object)sysUsersAudit, (Object)user);
                    sysUsersAudit.setIsAudit("0");
                    sysUsersAudit.setCreateTime(LocalDateTime.now());
                    sysUsersAudit.setCurrentStatus("3");
                    this.iSysUsersAuditService.save((Object)sysUsersAudit);
                }
                json.put("success", (Object)true);
                json.put("msg", (Object)"\u8f6c\u79fb\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01");
            } else {
                this.orgCodeChange(orgId, parentId, orgType, level);
                this.sysStruMapper.orgTreeChange(orgId, parentId, orderTree, level);
                this.hussarBaseStruAssistOrganBoService.removeByStruIdAndParentId(orgId, parentId);
                if (user != null) {
                    this.sysUsersMapper.updateById(user);
                    this.bpmAbstractPushMsgMatcher.pushUser(user, "update", null);
                } else {
                    this.bpmAbstractPushMsgMatcher.pushOrgan(this.hussarBaseOrgBoService.getOrganById(orgId), (SysStru)this.sysStruMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"organ_id", (Object)orgId)), "update");
                }
                json.put("success", (Object)true);
                json.put("msg", (Object)"\u8f6c\u79fb\u6210\u529f\uff01");
                SysStru sysStru = new SysStru();
                sysStru.setId(orgId);
                sysStru.setParentId(parentId);
                sysStru.setStruOrder(orderTree);
                sysStru.setStruLevel(level);
                JSONObject object = new JSONObject();
                object.put("sysStru", (Object)sysStru);
                this.abstractPushMsgMatcher.insertOperation("organ", "update", (Object)object, null);
            }
            this.iSysOrgEventService.afterOrgChangeVue(orgId, parentId);
            try {
                LogObjectHolder.me().set("transfer_after_parent", (Object)this.iSysOrgEventService.afterOrgChange(orgId, parentId));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return json;
    }

    public void orgCodeChange(Long orgId, Long parentId, String orgType, Integer level) {
        SysOrgan parentOrg = this.sysStruMapper.getOrganInfoByDeparmentId(parentId);
        SysOrgan sysOrgan = this.sysStruMapper.getOrganInfoByDeparmentId(orgId);
        if ("9".equals(orgType)) {
            String parentTypeCode = sysOrgan.getParentTypeCode();
            if (ToolUtil.isNotEmpty((Object)parentTypeCode)) {
                String newParentCode = parentOrg.getOrganCode();
                String filedName = "ORGAN_CODE_9";
                String currentCode = this.sysIdtableService.getCurrentCode(filedName, "SYS_STRU");
                currentCode = newParentCode + currentCode;
                sysOrgan.setOrganCode(currentCode);
                sysOrgan.setParentTypeCode(newParentCode);
                this.hussarBaseOrgBoService.updateOrganBatchById(Collections.singletonList(sysOrgan));
            }
        } else {
            SysStru sysStru = (SysStru)this.sysStruMapper.selectById(orgId);
            SysStru parentStru = (SysStru)this.sysStruMapper.selectById(parentId);
            Long newPermissionId = parentStru.getPermissionStruId();
            Integer oldLevel = sysStru.getStruLevel();
            Integer subLevel = level - oldLevel;
            String businessName = "STRU_CODE";
            String tableName = "SYS_STRU";
            String currentCode = this.sysIdtableService.getCurrentCodeEy(businessName, tableName, parentOrg.getOrganCode());
            sysOrgan.setParentTypeCode(parentOrg.getOrganCode());
            List oldOrganList = this.hussarBaseOrgBoService.getOrganByCode(sysOrgan.getOrganCode());
            ArrayList<SysOrgan> organList = new ArrayList<SysOrgan>();
            ArrayList<Long> organIdList = new ArrayList<Long>();
            if (ToolUtil.isNotEmpty((Object)oldOrganList)) {
                for (SysOrgan organ : oldOrganList) {
                    String newCode = organ.getOrganCode().replace(sysOrgan.getOrganCode(), currentCode);
                    organ.setOrganCode(newCode);
                    organ.setParentTypeCode(currentCode);
                    organList.add(organ);
                    organIdList.add(organ.getId());
                }
            }
            sysOrgan.setOrganCode(currentCode);
            organList.add(sysOrgan);
            this.sysOrganService.updateBatchById(organList);
            if (ToolUtil.isNotEmpty(organIdList)) {
                List oldStruList = this.sysStruMapper.selectList((Wrapper)new QueryWrapper().in((Object)"organ_id", organIdList));
                ArrayList<SysStru> sysStruList = new ArrayList<SysStru>();
                for (SysStru stru : oldStruList) {
                    Integer struLevel = stru.getStruLevel();
                    stru.setStruLevel(Integer.valueOf(struLevel + subLevel));
                    if (!sysStru.getId().equals(sysStru.getPermissionStruId())) {
                        stru.setPermissionStruId(newPermissionId);
                    }
                    sysStruList.add(stru);
                }
                this.hussarBaseStruBoService.updateStruBatchById(sysStruList);
            }
        }
    }
}

