/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.authorization.audit.dao.SysStruAssistOrganAuditMapper;
import com.jxdinfo.hussar.authorization.audit.model.SysStaffAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysStruAssistOrganAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysStruAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysUsersAudit;
import com.jxdinfo.hussar.authorization.bspinterface.service.ISysOrgEventService;
import com.jxdinfo.hussar.authorization.organ.manager.DeleteStaffManager;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonStaffManager;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.permit.dao.SysConfRolesetMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRolesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserroleAuditMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysStruAssistOrgan;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUserroleAudit;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserroleAuditService;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaff;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPost;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruPostAuditService;
import com.jxdinfo.hussar.authorization.relational.service.ISysUserPostService;
import com.jxdinfo.hussar.authorization.sysuserip.dao.SysUserIpMapper;
import com.jxdinfo.hussar.authorization.sysuserip.model.SysUserIp;
import com.jxdinfo.hussar.authorization.sysuserip.service.ISysUserIpService;
import com.jxdinfo.hussar.common.constant.enums.Whether;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.staffmanager.StaffChangeNotify;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.organ.manager.impl.deleteStaffManagerImpl")
public class DeleteStaffManagerImpl
extends CommonStaffManager
implements DeleteStaffManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteStaffManagerImpl.class);
    @Resource
    private SysUserroleAuditMapper sysUserroleAuditMapper;
    @Resource
    private SysUserIpMapper sysUserIpMapper;
    @Resource
    private SysRolesMapper sysRolesMapper;
    @Resource
    private SysConfRolesetMapper sysConfRolesetMapper;
    @Resource
    private SysStruAssistOrganAuditMapper sysStruAssistOrganAuditMapper;
    @Autowired
    private ISysOrgEventService sysOrgEventService;
    @Autowired
    private ISysUserroleAuditService sysUserroleAuditService;
    @Autowired
    private ISysUserRoleService sysUserRoleService;
    @Autowired
    private ISysUserIpService sysUserIpService;
    @Autowired
    private ISysUserPostService sysUserPostService;
    @Resource
    private ISysStruPostAuditService sysStruPostAuditService;
    @Autowired
    private StaffChangeNotify staffChangeNotify;

    @Override
    public String deleteStaff(Long id) {
        LOGGER.info("\u5220\u9664\u4eba\u5458\uff1a{}", (Object)id);
        AssertUtil.isNotNull((Object)id, (String)"\u8981\u5220\u9664\u7684\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a");
        if (this.createUserConfigService.isOperateStaffWithUser()) {
            return this.doDeleteStaffAndUser(id);
        }
        return this.doDeleteStaff(id);
    }

    private String doDeleteStaff(Long id) {
        String msg;
        this.sysOrgEventService.beforeDel(id);
        List<Map<String, Object>> orgList = this.sysStruMapper.getOrgListByParentId(id);
        List<Map<String, Object>> userList = this.sysUsersMapper.getUsersByOrgId(id);
        List<Map<String, Object>> roleList = this.sysRolesMapper.getRolesByOrgId(id);
        List<Map<String, Object>> noRoleList = this.sysConfRolesetMapper.getRolesByOrgId(id);
        List assistOrganChildrenList = this.sysStruAssistOrganService.getAssistOrganByParent(id);
        AssertUtil.isEmpty(orgList, (String)"\u65e0\u6cd5\u5220\u9664\uff01\u5b58\u5728\u4e0b\u7ea7\u7ec4\u7ec7\u673a\u6784\u6216\u4eba\u5458\uff01");
        AssertUtil.isEmpty(userList, (String)"\u65e0\u6cd5\u5220\u9664\uff01\u5b58\u5728\u5173\u8054\u7528\u6237\uff01");
        AssertUtil.isEmpty(roleList, (String)"\u65e0\u6cd5\u5220\u9664\uff01\u5b58\u5728\u5173\u8054\u89d2\u8272\uff01");
        AssertUtil.isEmpty(noRoleList, (String)"\u65e0\u6cd5\u5220\u9664\uff01\u5b58\u5728\u5173\u8054\u4e0d\u76f8\u5bb9\u89d2\u8272\uff01");
        AssertUtil.isEmpty((Collection)assistOrganChildrenList, (String)"\u65e0\u6cd5\u5220\u9664\uff01\u5b58\u5728\u4e0b\u7ea7\u517c\u4efb\u4eba\u5458\uff01");
        this.sysOrgEventService.afterDel(id);
        if (!this.sysStruAuditService.checkCanOperate(id)) {
            throw new BaseException("\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u5220\u9664\uff01");
        }
        SysStru sysStruById = (SysStru)this.sysStruMapper.selectById(id);
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        wrapper1.eq(SysStruAudit::getParentId, (Object)id);
        wrapper1.eq(SysStruAudit::getState, (Object)"0");
        ArrayList<String> inUseList = new ArrayList<String>();
        inUseList.add("1");
        inUseList.add("4");
        wrapper1.in(SysStruAudit::getInUse, inUseList);
        List list1 = this.sysStruAuditService.list((Wrapper)wrapper1);
        AssertUtil.isEmpty((Collection)list1, (String)"\u65e0\u6cd5\u5220\u9664\uff01\u5b58\u5728\u672a\u5ba1\u6838\u7684\u4e0b\u7ea7\u7ec4\u7ec7\u673a\u6784\u6216\u4eba\u5458\uff01");
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        wrapper2.eq(SysUsersAudit::getDepartmentId, (Object)id);
        wrapper2.eq(SysUsersAudit::getIsAudit, (Object)"0");
        ArrayList<String> currentStatusList1 = new ArrayList<String>();
        currentStatusList1.add("0");
        currentStatusList1.add("3");
        currentStatusList1.add("1");
        wrapper2.in(SysUsersAudit::getCurrentStatus, currentStatusList1);
        List list2 = this.sysUsersAuditService.list((Wrapper)wrapper2);
        AssertUtil.isEmpty((Collection)list2, (String)"\u65e0\u6cd5\u5220\u9664\uff01\u5b58\u5728\u672a\u5ba1\u6838\u7684\u5173\u8054\u7528\u6237\uff01");
        LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
        wrapper3.eq(SysUsersAudit::getEmployeeId, (Object)id);
        wrapper3.eq(SysUsersAudit::getIsAudit, (Object)"0");
        ArrayList<String> currentStatusList2 = new ArrayList<String>();
        currentStatusList2.add("0");
        currentStatusList2.add("1");
        wrapper3.in(SysUsersAudit::getCurrentStatus, currentStatusList2);
        List list3 = this.sysUsersAuditService.list((Wrapper)wrapper3);
        AssertUtil.isEmpty((Collection)list3, (String)"\u65e0\u6cd5\u5220\u9664\uff01\u5b58\u5728\u672a\u5ba1\u6838\u7684\u5173\u8054\u7528\u6237\uff01");
        LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
        wrapper4.eq(SysStruAssistOrganAudit::getAssistParentId, (Object)id);
        wrapper4.eq(SysStruAssistOrganAudit::getState, (Object)"0");
        List list4 = this.sysStruAssistOrganAuditMapper.selectList((Wrapper)wrapper4);
        AssertUtil.isEmpty((Collection)list4, (String)"\u65e0\u6cd5\u5220\u9664\uff01\u5b58\u5728\u672a\u5ba1\u6838\u7684\u5173\u8054\u7528\u6237\uff01");
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isOrganAudit()) {
            SysStru sysStru = (SysStru)this.sysStruMapper.selectById(id);
            SysStruAudit sysStruAudit = new SysStruAudit();
            CopyPropertieUtils.copyProperties((Object)sysStruAudit, (Object)sysStru);
            sysStruAudit.setId(null);
            sysStruAudit.setRealStruId(sysStru.getId());
            sysStruAudit.setState("0");
            sysStruAudit.setInUse("3");
            this.sysStruAuditService.save((Object)sysStruAudit);
            msg = "\u5220\u9664\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01";
        } else {
            boolean flag = this.delStaffByStru(sysStruById);
            msg = flag ? "\u5220\u9664\u6210\u529f\uff01" : "\u5220\u9664\u5931\u8d25\uff01";
        }
        return msg;
    }

    private String doDeleteStaffAndUser(Long id) {
        LambdaQueryWrapper wrapper;
        StringBuffer msg = new StringBuffer();
        AssertUtil.isTrue((boolean)this.sysStruAuditService.checkCanOperate(id), (String)"\u4eba\u5458\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u5220\u9664\uff01");
        SysStru sysStru = (SysStru)this.sysStruMapper.selectById(id);
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isOrganAudit()) {
            SysStruAudit sysStruAudit = new SysStruAudit();
            CopyPropertieUtils.copyProperties((Object)sysStruAudit, (Object)sysStru);
            sysStruAudit.setId(null);
            sysStruAudit.setRealStruId(sysStru.getId());
            sysStruAudit.setState("0");
            sysStruAudit.setInUse("3");
            this.sysStruAuditService.save((Object)sysStruAudit);
            msg.append("\u4eba\u5458\u5220\u9664\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01");
        } else {
            this.sysStruMapper.deleteById(id);
            wrapper = new LambdaQueryWrapper();
            wrapper.eq(SysStruAssistOrgan::getStruId, (Object)id);
            this.sysStruAssistOrganMapper.delete((Wrapper)wrapper);
            msg.append("\u4eba\u5458\u5220\u9664\u6210\u529f\uff01");
            if ("9".equals(sysStru.getStruType())) {
                Long organId = sysStru.getOrganId();
                this.sysOrganMapper.deleteById(organId);
                QueryWrapper sysStaffQueryWrapper = new QueryWrapper();
                sysStaffQueryWrapper.lambda().eq(SysStaff::getStruId, (Object)id);
                this.sysStaffMapper.delete((Wrapper)sysStaffQueryWrapper);
            }
        }
        wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysUsers::getEmployeeId, (Object)id);
        List sysUsersList = this.sysUsersMapper.selectList((Wrapper)wrapper);
        if (HussarUtils.isEmpty((Object)sysUsersList)) {
            msg.append("\u4eba\u5458\u672a\u5173\u8054\u7528\u6237\uff01");
        } else {
            SecurityUser shiroUser = BaseSecurityUtil.getUser();
            if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit()) {
                for (SysUsers sysUser : sysUsersList) {
                    AssertUtil.isFalse((boolean)Whether.YES.getValue().equals(sysUser.getIsSys()), (String)"\u5220\u9664\u5931\u8d25\uff01\u4e0d\u80fd\u5220\u9664\u7ba1\u7406\u5458\u7528\u6237\uff01");
                    AssertUtil.isFalse((boolean)shiroUser.getId().equals(sysUser.getId()), (String)"\u5220\u9664\u5931\u8d25\uff01\u4e0d\u80fd\u5220\u9664\u5f53\u524d\u7528\u6237\uff01");
                    AssertUtil.isFalse((boolean)this.sysUsersAuditService.adjustEdit(sysUser.getId()), (String)"\u7528\u6237\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u5220\u9664\uff01");
                    SysUsersAudit sysUsersAudit = new SysUsersAudit();
                    CopyPropertieUtils.copyProperties((Object)sysUsersAudit, (Object)sysUser);
                    sysUsersAudit.setId(null);
                    sysUsersAudit.setUserId(sysUser.getId());
                    sysUsersAudit.setIsAudit("0");
                    sysUsersAudit.setCurrentStatus("2");
                    this.sysUsersAuditService.save((Object)sysUsersAudit);
                }
                msg.append("\u540c\u6b65\u5220\u9664\u7528\u6237\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01");
            } else {
                for (SysUsers sysUser : sysUsersList) {
                    AssertUtil.isFalse((boolean)Whether.YES.getValue().equals(sysUser.getIsSys()), (String)"\u5220\u9664\u5931\u8d25\uff01\u4e0d\u80fd\u5220\u9664\u7ba1\u7406\u5458\u7528\u6237\uff01");
                    AssertUtil.isFalse((boolean)shiroUser.getId().equals(sysUser.getId()), (String)"\u5220\u9664\u5931\u8d25\uff01\u4e0d\u80fd\u5220\u9664\u5f53\u524d\u7528\u6237\uff01");
                    sysUser.setAccountStatus(UserStatus.DELETE.getCode());
                    sysUser.setEmployeeId(Long.valueOf(0L));
                    this.sysStruMapper.updatePrincipal(sysUser.getId());
                    this.sysUserroleAuditMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysUserroleAudit::getUserId, (Object)sysUser.getId()));
                    this.sysUserIpMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysUserIp::getUserId, (Object)sysUser.getId()));
                    this.sysUsersMapper.updateById(sysUser);
                }
                msg.append("\u5220\u9664\u7528\u6237\u6210\u529f\uff01");
            }
        }
        return msg.toString();
    }

    @Override
    public String delete(Long staffId) {
        SysStaff staff = (SysStaff)this.sysStaffService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysStaff::getId, (Object)staffId));
        if (HussarUtils.isEmpty((Object)staff)) {
            throw new BaseException("\u5220\u9664\u5931\u8d25\uff01\u8be5\u4eba\u5458\u4e0d\u5b58\u5728\uff01");
        }
        if (this.createUserConfigService.isOperateStaffWithUser()) {
            this.sysStaffService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStaff::getId, (Object)staffId));
            this.sysStruStaffService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruStaff::getStaffId, (Object)staffId));
            this.syncUser(staffId);
            this.staffChangeNotify.notify(DataChangeType.DELETE, new Object[]{staff});
        } else {
            List users = this.sysUsersService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUsers::getEmployeeId, (Object)staffId)).ne(SysUsers::getAccountStatus, (Object)"2"));
            if (HussarUtils.isNotEmpty((Object)users)) {
                throw new BaseException("\u5220\u9664\u5931\u8d25\uff01\u5b58\u5728\u5173\u8054\u7528\u6237\uff01");
            }
            if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isStaffAudit()) {
                List sysStaffAudits = this.sysStaffAuditService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStaffAudit::getRealStaffId, (Object)staff.getId())).eq(SysStaffAudit::getAuditStatus, (Object)"0"));
                if (HussarUtils.isNotEmpty((Object)sysStaffAudits)) {
                    throw new BaseException("\u5220\u9664\u5931\u8d25\uff01\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff01");
                }
                List sysUsersAudits = this.sysUsersAuditService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUsersAudit::getEmployeeId, (Object)staffId)).eq(SysUsersAudit::getIsAudit, (Object)"0"));
                if (HussarUtils.isNotEmpty((Object)sysUsersAudits)) {
                    throw new BaseException("\u5220\u9664\u5931\u8d25\uff01\u5b58\u5728\u672a\u5ba1\u6838\u7684\u5173\u8054\u7528\u6237\uff01");
                }
                SysStaffAudit sysStaffAudit = new SysStaffAudit();
                BeanUtil.copy((Object)staff, (Object)sysStaffAudit);
                long sysStaffAuditId = IdWorker.getId((Object)sysStaffAudit);
                sysStaffAudit.setId(Long.valueOf(sysStaffAuditId));
                sysStaffAudit.setRealStaffId(staff.getId());
                sysStaffAudit.setAuditStatus("0");
                sysStaffAudit.setOperateType("3");
                LocalDateTime now = LocalDateTime.now();
                sysStaffAudit.setCreateTime(now);
                sysStaffAudit.setLastTime(now);
                this.sysStaffAuditService.save((Object)sysStaffAudit);
            } else {
                this.sysStaffService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStaff::getId, (Object)staffId));
                this.sysStruStaffService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruStaff::getStaffId, (Object)staffId));
                this.staffChangeNotify.notify(DataChangeType.DELETE, new Object[]{staff});
            }
        }
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isStaffAudit()) {
            return "\u5220\u9664\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01";
        }
        return "\u5220\u9664\u6210\u529f\uff01";
    }

    private void syncUser(Long staffId) {
        SysUsers user = (SysUsers)this.sysUsersService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUsers::getEmployeeId, (Object)staffId)).ne(SysUsers::getAccountStatus, (Object)"2"));
        if (HussarUtils.isNotEmpty((Object)user)) {
            SecurityUser shiroUser = BaseSecurityUtil.getUser();
            AssertUtil.isFalse((boolean)Whether.YES.getValue().equals(user.getIsSys()), (String)"\u5220\u9664\u5931\u8d25\uff01\u4e0d\u80fd\u5220\u9664\u7ba1\u7406\u5458\u7528\u6237\uff01");
            AssertUtil.isFalse((boolean)shiroUser.getId().equals(user.getId()), (String)"\u5220\u9664\u5931\u8d25\uff01\u4e0d\u80fd\u5220\u9664\u5f53\u524d\u7528\u6237\uff01");
            user.setAccountStatus(UserStatus.DELETE.getCode());
            this.sysUsersService.updateById((Object)user);
            this.sysUserroleAuditService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserroleAudit::getUserId, (Object)user.getId()));
            this.sysUserRoleService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)user.getId()));
            this.sysUserIpService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserIp::getUserId, (Object)user.getId()));
            this.sysStruUserService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruUser::getUserId, (Object)user.getId()));
            this.sysUserPostService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserPost::getUserId, (Object)user.getId()));
            this.userChangeNotify.notify(DataChangeType.DELETE, new Object[]{user});
        }
    }
}

