/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.organ.dto.AddOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.dto.EditOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.dto.QueryOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.dto.QueryTransferOrganizationListDto;
import com.jxdinfo.hussar.authorization.organ.dto.QueryTransferOrganizationTreeDto;
import com.jxdinfo.hussar.authorization.organ.dto.TransferOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganizationService;
import com.jxdinfo.hussar.authorization.organ.vo.OrganTreeInitVo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganVo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationInfoVo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationPartialVo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationTreeVo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationVo;
import com.jxdinfo.hussar.authorization.organ.vo.ReadOnlyOrganizationTreeVo;
import com.jxdinfo.hussar.authorization.organ.vo.SearchOrganizationVo;
import com.jxdinfo.hussar.authorization.organ.vo.SysStruRuleVo;
import com.jxdinfo.hussar.authorization.permit.vo.SelectCustomOrgTreeVo;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysAuditConfigService;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import com.jxdinfo.hussar.support.security.core.annotation.CheckSafe;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u65b0\u7248\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4"})
@RestController(value="com.jxdinfo.hussar.authorization.organ.controller.HussarBaseOrganizationController")
@RequestMapping(value={"/hussarBase/authorization/organ"})
public class HussarBaseOrganizationController {
    @Resource
    private IHussarBaseOrganizationService organizationService;
    @Resource
    private ISysAuditConfigService sysAuditConfig;

    @ApiOperation(value="\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u65b0\u589e\u4fdd\u5b58", notes="\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u65b0\u589e\u4fdd\u5b58")
    @PostMapping(value={"/addOrganization"})
    @CacheEvict(value={"organ_staff_tree"}, allEntries=true)
    @CheckPermission(value={"hussarBase:authorization:organ:addOrganization"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784->\u673a\u6784\u7ef4\u62a4", eventDesc="\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u65b0\u589e\u4fdd\u5b58", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<String> addOrganization(@ApiParam(value="\u65b0\u589e\u7ec4\u7ec7\u673a\u6784DTO") @RequestBody AddOrganizationDto addOrganizationDto) {
        return this.organizationService.addOrganization(addOrganizationDto);
    }

    @ApiOperation(value="\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u4fee\u6539\u4fdd\u5b58", notes="\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u4fee\u6539\u4fdd\u5b58")
    @PostMapping(value={"/editOrganization"})
    @CacheEvict(value={"organ_staff_tree", "resource_info", "menu_info"}, allEntries=true)
    @CheckPermission(value={"hussarBase:authorization:organ:editOrganization"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u4fee\u6539\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> editOrganization(@ApiParam(value="\u7ec4\u7ec7\u673a\u6784\u4fdd\u5b58dto") @RequestBody EditOrganizationDto editOrganizationDto) {
        return this.organizationService.editOrganization(editOrganizationDto);
    }

    @ApiOperation(value="\u6839\u636eID\u5220\u9664\u7ec4\u7ec7\u673a\u6784", notes="\u6839\u636eID\u5220\u9664\u7ec4\u7ec7\u673a\u6784")
    @CheckPermission(value={"hussarBase:authorization:organ:deleteOrganization"})
    @PostMapping(value={"/deleteOrganization"})
    @CacheEvict(value={"organ_staff_tree"}, allEntries=true)
    @CheckSafe
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u5220\u9664\u7ec4\u7ec7\u673a\u6784", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<String> deleteOrganization(@ApiParam(value="\u7ec4\u7ec7\u673a\u6784id") @RequestBody Long id) {
        return this.organizationService.deleteOrganization(id);
    }

    @ApiOperation(value="\u4fdd\u5b58\u7ec4\u7ec7\u673a\u6784\u6811\u6392\u5e8f", notes="\u4fdd\u5b58\u7ec4\u7ec7\u673a\u6784\u6811\u6392\u5e8f")
    @PostMapping(value={"/sortOrganization"})
    @CheckPermission(value={"hussarBase:authorization:organ:sortOrganization"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u4fdd\u5b58\u7ec4\u7ec7\u673a\u6784\u6811\u6392\u5e8f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> sortOrganization(@ApiParam(value="\u4e0b\u7ea7\u7ec4\u7ec7\u673a\u6784id\u96c6\u5408") @RequestBody List<Long> idList) {
        return this.organizationService.sortOrganization(idList);
    }

    @ApiOperation(value="\u8f6c\u79fb\u7ec4\u7ec7\u673a\u6784", notes="\u8f6c\u79fb\u7ec4\u7ec7\u673a\u6784")
    @PostMapping(value={"/transferOrganization"})
    @CacheEvict(value={"organ_staff_tree"}, allEntries=true)
    @CheckPermission(value={"hussarBase:authorization:organ:transferOrganization"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u8f6c\u79fb\u7ec4\u7ec7\u673a\u6784\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> transferOrganization(@ApiParam(value="\u7ec4\u7ec7\u8f6c\u79fbdto") @RequestBody TransferOrganizationDto transferOrganizationDto) {
        return this.organizationService.transferOrganization(transferOrganizationDto);
    }

    @ApiOperation(value="\u6839\u636eID\u83b7\u53d6\u8f6c\u79fb\u5de6\u4fa7\u7ec4\u7ec7\u673a\u6784\u6811", notes="\u6839\u636eID\u83b7\u53d6\u8f6c\u79fb\u5de6\u4fa7\u7ec4\u7ec7\u673a\u6784\u6811")
    @CheckPermission(value={"hussarBase:authorization:organ:getTransferOrganizationTree"})
    @GetMapping(value={"/getTransferOrganizationTree"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u6839\u636eID\u83b7\u53d6\u8f6c\u79fb\u7ec4\u7ec7\u673a\u6784\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<OrganizationTreeVo>> getTransferOrganizationTree(@ApiParam(value="\u8f6c\u79fb\u7ec4\u7ec7\u673a\u6784dto") QueryTransferOrganizationTreeDto queryTransferOrganizationDto) {
        return this.organizationService.getTransferOrganizationTree(queryTransferOrganizationDto);
    }

    @ApiOperation(value="\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u67e5\u770b", notes="\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u67e5\u770b")
    @GetMapping(value={"/viewOrganization"})
    @CheckPermission(value={"hussarBase:authorization:organ:viewOrganization"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u67e5\u770b\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<OrganizationPartialVo> viewOrganization(@ApiParam(value="\u7ec4\u7ec7id") @RequestParam Long id) {
        return this.organizationService.viewOrganization(id);
    }

    @ApiOperation(value="\u6839\u636eID\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u8be6\u7ec6\u4fe1\u606f", notes="\u6839\u636eID\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u8be6\u7ec6\u4fe1\u606f")
    @GetMapping(value={"/loadOrganization"})
    @CheckPermission(value={"hussarBase:authorization:organ:loadOrganization"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u6839\u636eID\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u8be6\u7ec6\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<OrganizationInfoVo> loadOrganization(@ApiParam(value="\u7ec4\u7ec7id") @RequestParam Long id) {
        return this.organizationService.loadOrganization(id);
    }

    @ApiOperation(value="\u6a21\u7cca\u67e5\u8be2\u673a\u6784\u5217\u8868", notes="\u6a21\u7cca\u67e5\u8be2\u673a\u6784\u5217\u8868")
    @GetMapping(value={"/searchOrganization"})
    @CheckPermission(value={"hussarBase:authorization:organ:searchOrganization"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u6a21\u7cca\u67e5\u8be2\u673a\u6784\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<SearchOrganizationVo>> searchOrganization(@ApiParam(value="\u5206\u9875\u53c2\u6570") PageInfo pageInfo, @ApiParam(value="\u67e5\u8be2\u5173\u952e\u5b57") String name) {
        return this.organizationService.searchOrganization(pageInfo, name);
    }

    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u8282\u70b9\u4e0b\u7684\u6240\u6709\u8282\u70b9\u57fa\u672c\u4fe1\u606f\u5217\u8868", notes="\u83b7\u53d6\u6307\u5b9a\u8282\u70b9\u4e0b\u7684\u6240\u6709\u8282\u70b9\u57fa\u672c\u4fe1\u606f\u5217\u8868")
    @GetMapping(value={"/organizationList"})
    @CheckPermission(value={"hussarBase:authorization:organ:organizationList"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u83b7\u53d6\u6307\u5b9a\u8282\u70b9\u4e0b\u7684\u6240\u6709\u8282\u70b9\u57fa\u672c\u4fe1\u606f\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<OrganizationVo>> organizationList(@ApiParam(value="\u5206\u9875\u4fe1\u606f") PageInfo pageInfo, @ApiParam(value="\u7ec4\u7ec7\u67e5\u8be2dto") QueryOrganizationDto queryOrganizationDto) {
        return this.organizationService.queryOrganization(pageInfo, queryOrganizationDto);
    }

    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u8282\u70b9\u4e0b\u7684\u6240\u6709\u8f6c\u79fb\u8282\u70b9\u57fa\u672c\u4fe1\u606f\u5217\u8868", notes="\u83b7\u53d6\u6307\u5b9a\u8282\u70b9\u4e0b\u7684\u6240\u6709\u8f6c\u79fb\u8282\u70b9\u57fa\u672c\u4fe1\u606f\u5217\u8868")
    @GetMapping(value={"/transferOrganizationList"})
    @CheckPermission(value={"hussarBase:authorization:organ:transferOrganizationList"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u83b7\u53d6\u6307\u5b9a\u8282\u70b9\u4e0b\u7684\u6240\u6709\u8f6c\u79fb\u8282\u70b9\u57fa\u672c\u4fe1\u606f\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<OrganizationVo>> transferOrganizationList(@ApiParam(value="\u5206\u9875\u4fe1\u606f") PageInfo pageInfo, @ApiParam(value="\u7ec4\u7ec7\u67e5\u8be2dto") QueryTransferOrganizationListDto queryOrganizationDto) {
        return this.organizationService.transferOrganizationList(pageInfo, queryOrganizationDto);
    }

    @ApiOperation(value="\u7ec4\u7ec7\u6811\u83b7\u53d6\u5355\u4e2a", notes="\u7ec4\u7ec7\u6811\u83b7\u53d6\u5355\u4e2a")
    @CheckPermission(value={"hussarBase:authorization:organ:lazyOrganizationById"})
    @GetMapping(value={"/lazyOrganizationById"})
    @ResponseBody
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u7ec4\u7ec7\u6811\u7684\u7ea7\u8054\u52a0\u8f7d", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<OrganizationTreeVo> lazyOrganizationById(@ApiParam(value="\u8282\u70b9id") @RequestParam Long id) {
        return this.organizationService.lazyOrganizationById(id);
    }

    @ApiOperation(value="\u7ec4\u7ec7\u6811\u7684\u7ea7\u8054\u52a0\u8f7d", notes="\u7ec4\u7ec7\u6811\u7684\u7ea7\u8054\u52a0\u8f7d")
    @GetMapping(value={"/lazyLoadOrganTreeWithProperty"})
    @ResponseBody
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u7ec4\u7ec7\u6811\u7684\u7ea7\u8054\u52a0\u8f7d", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<OrganizationTreeVo>> lazyLoadOrganTreeWithProperty(@ApiParam(value="\u4e0a\u7ea7") @RequestParam Long parentId, @RequestParam String organProperty) {
        return this.organizationService.lazyLoadOrganizationTree(parentId, organProperty);
    }

    @ApiOperation(value="\u7ec4\u7ec7\u6811\u7684\u7ea7\u8054\u52a0\u8f7d", notes="\u7ec4\u7ec7\u6811\u7684\u7ea7\u8054\u52a0\u8f7d")
    @CheckPermission(value={"hussarBase:authorization:organ:lazyLoadingOrganizationTree"})
    @GetMapping(value={"/lazyLoadingOrganizationTree"})
    @ResponseBody
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u7ec4\u7ec7\u6811\u7684\u7ea7\u8054\u52a0\u8f7d", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<OrganizationTreeVo>> lazyLoadingOrganizationTree(@ApiParam(value="\u4e0a\u7ea7") @RequestParam Long parentId) {
        return this.organizationService.lazyLoadOrganizationTree(parentId);
    }

    @ApiOperation(value="\u7ec4\u7ec7\u6811\u7684\u7ea7\u8054\u52a0\u8f7d-\u65e0\u6743\u9650\u6570\u636e", notes="\u7ec4\u7ec7\u6811\u7684\u7ea7\u8054\u52a0\u8f7d-\u65e0\u6743\u9650\u6570\u636e")
    @CheckPermission(value={"hussarBase:authorization:organ:lazyLoadingOrganizationTreeNoPermissions"})
    @GetMapping(value={"/lazyLoadingOrganizationTreeNoPermissions"})
    @ResponseBody
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u7ec4\u7ec7\u6811\u7684\u7ea7\u8054\u52a0\u8f7d-\u65e0\u6743\u9650\u6570\u636e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<ReadOnlyOrganizationTreeVo>> lazyLoadingOrganizationTreeNoPermissions(@ApiParam(value="\u4e0a\u7ea7") @RequestParam Long parentId, @RequestParam String organProperty) {
        return this.organizationService.lazyLoadingOrganizationTreeNoPermissions(parentId, organProperty);
    }

    @ApiOperation(value="\u70b9\u51fb\u7ec4\u7ec7\u673a\u6784\u8fd4\u56de\u7ec4\u7ec7\u673a\u6784\u6811", notes="\u70b9\u51fb\u7ec4\u7ec7\u673a\u6784\u8fd4\u56de\u7ec4\u7ec7\u673a\u6784\u6811")
    @CheckPermission(value={"hussarBase:authorization:organ:backOrganizationTree"})
    @GetMapping(value={"/backOrganizationTree"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u70b9\u51fb\u7ec4\u7ec7\u673a\u6784\u8fd4\u56de\u7ec4\u7ec7\u673a\u6784\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<OrganizationTreeVo>> backOrganizationTree(@ApiParam(value="\u9009\u4e2d\u8282\u70b9") @RequestParam(value="id") Long id) {
        return this.organizationService.backOrganizationTree(id);
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b\u83b7\u53d6\u4e0b\u5c5e\u5355\u4f4d\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b", notes="\u6839\u636e\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b\u83b7\u53d6\u4e0b\u5c5e\u5355\u4f4d\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b")
    @CheckPermission(value={"hussarBase:authorization:organ:getOrganizationTypeByParentId"})
    @GetMapping(value={"/getOrganizationTypeByParentId"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u6839\u636e\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b\u83b7\u53d6\u4e0b\u5c5e\u5355\u4f4d\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysStruRuleVo>> getOrganizationTypeByParentId(@ApiParam(value="\u4e0a\u7ea7") @RequestParam Long parentId) {
        return this.organizationService.getOrganizationTypeByParentId(parentId);
    }

    @ApiOperation(value="\u67e5\u8be2\u9700\u8981\u6392\u5e8f\u7684\u7ec4\u7ec7\u673a\u6784\u6811", notes="\u67e5\u8be2\u9700\u8981\u6392\u5e8f\u7684\u7ec4\u7ec7\u673a\u6784\u6811")
    @CheckPermission(value={"hussarBase:authorization:organ:getOrderOrganizationTree"})
    @GetMapping(value={"/getOrderOrganizationTree"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u67e5\u8be2\u9700\u8981\u6392\u5e8f\u7684\u7ec4\u7ec7\u673a\u6784\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<OrganizationTreeVo>> getOrderOrganizationTree(@ApiParam(value="\u4e0a\u7ea7") @RequestParam Long parentId) {
        return this.organizationService.getOrderOrganizationTree(parentId);
    }

    @ApiOperation(value="\u7ec4\u7ec7\u673a\u6784\u662f\u5426\u5ba1\u6838", notes="\u7ec4\u7ec7\u673a\u6784\u662f\u5426\u5ba1\u6838")
    @CheckPermission(value={"hussarBase:authorization:organ:isAudit"})
    @GetMapping(value={"/isAudit"})
    public ApiResponse<Boolean> isAudit() {
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isOrganAudit()) {
            return ApiResponse.success((Object)true);
        }
        return ApiResponse.success((Object)false);
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7ec4\u7ec7\u673a\u6784\u5168\u8def\u5f84", notes="\u83b7\u53d6\u5f53\u524d\u7ec4\u7ec7\u673a\u6784\u5168\u8def\u5f84")
    @CheckPermission(value={"hussarBase:authorization:organ:getOrganFname"})
    @GetMapping(value={"/getOrganFname"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u83b7\u53d6\u5f53\u524d\u7ec4\u7ec7\u673a\u6784\u5168\u8def\u5f84", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<String> getOrganFname(@ApiParam(value="\u7ec4\u7ec7\u673a\u6784id") @RequestParam Long id) {
        return this.organizationService.getOrganFname(id);
    }

    @ApiOperation(value="\u83b7\u53d6\u81ea\u5b9a\u4e49\u7ec4\u7ec7\u673a\u6784\u6811", notes="\u83b7\u53d6\u81ea\u5b9a\u4e49\u7ec4\u7ec7\u673a\u6784\u6811")
    @GetMapping(value={"/getCustomOrgTree"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u83b7\u53d6\u81ea\u5b9a\u4e49\u7ec4\u7ec7\u673a\u6784\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<SelectCustomOrgTreeVo> getCustomOrgTree(@ApiParam(value="\u6570\u636e\u6743\u9650id") @RequestParam(required=false) Long dataRightsId) {
        return this.organizationService.getCustomOrgTree(dataRightsId);
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u7c7b\u578b\u5206\u9875\u67e5\u8be2\u7ec4\u7ec7\u5217\u8868", notes="\u6839\u636e\u7ec4\u7ec7\u7c7b\u578b\u5206\u9875\u67e5\u8be2\u7ec4\u7ec7\u5217\u8868")
    @GetMapping(value={"/getOrganListByType"})
    @AuditLog(moduleName="\u673a\u6784\u7ef4\u62a4", eventDesc="\u6839\u636e\u7ec4\u7ec7\u7c7b\u578b\u5206\u9875\u67e5\u8be2\u7ec4\u7ec7\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<OrganizationTreeVo>> getOrganListByType(@ApiParam(value="\u5206\u9875\u4fe1\u606f") PageInfo pageInfo, @ApiParam(value="\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b") @RequestParam(value="organType") String organType, @ApiParam(value="\u7ec4\u7ec7\u673a\u6784\u540d\u79f0") @RequestParam(value="organName") String organName) {
        return this.organizationService.getOrganListByType(pageInfo, organType, organName);
    }

    @ApiOperation(value="\u67e5\u8be2\u89d2\u8272\u7ec4\u7ec7\u4fe1\u606f", notes="\u67e5\u8be2\u89d2\u8272\u7ec4\u7ec7\u4fe1\u606f")
    @GetMapping(value={"/roleOrganView"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u67e5\u8be2\u89d2\u8272\u7ec4\u7ec7\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<OrganVo>> getRoleOrganView(@ApiParam(value="\u89d2\u8272id") @RequestParam String id) {
        return this.organizationService.getRoleOrgan(id);
    }

    @ApiOperation(value="\u521d\u59cb\u5316\u7ec4\u7ec7\u673a\u6784\u6811", notes="\u521d\u59cb\u5316\u7ec4\u7ec7\u673a\u6784\u6811")
    @GetMapping(value={"/getOrganTreeInitVos"})
    @AuditLog(moduleName="\u521d\u59cb\u5316\u7ec4\u7ec7\u673a\u6784\u6811", eventDesc="\u521d\u59cb\u5316\u7ec4\u7ec7\u673a\u6784\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<OrganTreeInitVo>> getOrganTreeInitVos(@RequestParam(value="parentId") Long parentId, @RequestParam(value="ifLazy") int ifLazy, @RequestParam(required=false, value="defaultLevel") Integer defaultLevel) {
        return ApiResponse.success((Object)this.organizationService.getOrganTreeInitVos(parentId, ifLazy, defaultLevel));
    }

    @ApiOperation(value="\u83b7\u53d6\u5230\u4e0b\u4e00\u7ea7\u7ec4\u7ec7\u673a\u6784\u6570\u636e", notes="\u83b7\u53d6\u5230\u4e0b\u4e00\u7ea7\u7ec4\u7ec7\u673a\u6784\u6570\u636e")
    @GetMapping(value={"/getChildrenOrgan"})
    @AuditLog(moduleName="\u83b7\u53d6\u5230\u4e0b\u4e00\u7ea7\u7ec4\u7ec7\u673a\u6784\u6570\u636e", eventDesc="\u83b7\u53d6\u5230\u4e0b\u4e00\u7ea7\u7ec4\u7ec7\u673a\u6784\u6570\u636e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<List<OrganTreeInitVo>> getChildrenOrgan(@RequestParam(value="parentId") Long parentId) {
        return ApiResponse.success((Object)this.organizationService.getChildrenOrgan(parentId));
    }

    @ApiOperation(value="\u6309\u7167\u7ec4\u7ec7\u673a\u6784\u540d\u79f0\u8fdb\u884c\u6a21\u7cca\u67e5\u8be2", notes="\u6309\u7167\u7ec4\u7ec7\u673a\u6784\u540d\u79f0\u8fdb\u884c\u6a21\u7cca\u67e5\u8be2")
    @GetMapping(value={"/getOrgansLikeName"})
    @AuditLog(moduleName="\u6309\u7167\u7ec4\u7ec7\u673a\u6784\u540d\u79f0\u8fdb\u884c\u6a21\u7cca\u67e5\u8be2", eventDesc="\u6309\u7167\u7ec4\u7ec7\u673a\u6784\u540d\u79f0\u8fdb\u884c\u6a21\u7cca\u67e5\u8be2", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<List<OrganTreeInitVo>> getOrgansLikeName(@RequestParam(value="searchValue") String searchValue) {
        return ApiResponse.success((Object)this.organizationService.getOrgansLikeName(searchValue));
    }

    @ApiOperation(value="\u5411\u4e0a\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u6811", notes="\u5411\u4e0a\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u6811")
    @GetMapping(value={"/getUpOrganTreeByOrganId"})
    @AuditLog(moduleName="\u5411\u4e0a\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u6811", eventDesc="\u5411\u4e0a\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<List<OrganTreeInitVo>> getUpOrganTreeByOrganId(@RequestParam(value="id") Long id) {
        return ApiResponse.success((Object)this.organizationService.getUpOrganTreeByOrganId(id));
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u673a\u6784Id\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f", notes="\u6839\u636e\u7ec4\u7ec7\u673a\u6784Id\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f")
    @GetMapping(value={"/getOrganInfoById"})
    @AuditLog(moduleName="\u6839\u636e\u7ec4\u7ec7\u673a\u6784Id\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f", eventDesc="\u6839\u636e\u7ec4\u7ec7\u673a\u6784Id\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<OrganTreeInitVo> getOrganInfoById(@RequestParam(value="id") Long id) {
        return ApiResponse.success((Object)this.organizationService.getOrganInfoById(id));
    }

    @ApiOperation(value="\u7ec4\u7ec7\u6811\u61d2\u52a0\u8f7d", notes="\u7ec4\u7ec7\u6811\u61d2\u52a0\u8f7d")
    @GetMapping(value={"/lazyLoadOrganTreeSearch"})
    @ResponseBody
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u7ec4\u7ec7\u6811\u7684\u7ea7\u8054\u52a0\u8f7d", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<OrganizationTreeVo>> lazyLoadOrganTreeSearch(@ApiParam(value="\u7ec4\u7ec7\u67e5\u8be2dto") QueryOrganizationDto queryOrganizationDto) {
        return this.organizationService.lazyLoadOrganTreeSearch(queryOrganizationDto);
    }

    @ApiOperation(value="\u67e5\u8be2\u540c\u7ea7\u4e0b\u662f\u5426\u5df2\u6709\u540c\u540d\u7ec4\u7ec7", notes="\u67e5\u8be2\u540c\u7ea7\u4e0b\u662f\u5426\u5df2\u6709\u540c\u540d\u7ec4\u7ec7")
    @GetMapping(value={"/checkSameOrganName"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u67e5\u8be2\u540c\u7ea7\u4e0b\u662f\u5426\u5df2\u6709\u540c\u540d\u7ec4\u7ec7", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Boolean> sameOrganName(@ApiParam(value="\u7ec4\u7ec7\u540d\u79f0") @RequestParam(value="organName") String organName, @ApiParam(value="\u7236\u7ea7\u7ec4\u7ec7id") @RequestParam(value="parentId") Long parentId, @ApiParam(value="\u7ec4\u7ec7id") @RequestParam(value="id", required=false) Long id) {
        return this.organizationService.checkSameOrganName(organName, parentId, id);
    }

    @GetMapping(value={"/exportOrganExcel"})
    @CheckPermission(value={"hussarBase:authorization:organ:exportOrganExcel"})
    @ApiOperation(value="\u5bfc\u51fa\u7ec4\u7ec7\u673a\u6784Excel\u6587\u4ef6", notes="\u5bfc\u51fa\u7ec4\u7ec7\u673a\u6784Excel\u6587\u4ef6")
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ba1\u7406", eventDesc="\u7ec4\u7ec7\u673a\u6784Excel\u6587\u4ef6\u5bfc\u51fa", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public void exportOrganExcel(@ApiParam(value="\u7ec4\u7ec7\u673a\u6784ids") @RequestParam String ids, @ApiParam(value="\u4efb\u52a1ids") @RequestParam Long taskId, @ApiParam(value="\u662f\u5426\u5bfc\u51fa\u4e3b\u952e") @RequestParam(required=false) Boolean exportKey) throws Exception {
        exportKey = HussarUtils.isNotEmpty((Object)exportKey) && exportKey != false;
        this.organizationService.exportOrganExcel(ids, taskId, exportKey.booleanValue());
    }

    @GetMapping(value={"/downloadOrganExcelImpTpl"})
    @CheckPermission(value={"hussarBase:authorization:organ:downloadOrganExcelImpTpl"})
    @ApiOperation(value="\u7ec4\u7ec7\u673a\u6784Excel\u5bfc\u5165\u6a21\u677f\u4e0b\u8f7d", notes="\u7ec4\u7ec7\u673a\u6784Excel\u5bfc\u5165\u6a21\u677f\u4e0b\u8f7d")
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ba1\u7406", eventDesc="\u7ec4\u7ec7\u673a\u6784Excel\u5bfc\u5165\u6a21\u677f\u4e0b\u8f7d", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public void downloadOrganExcelImpTpl(HttpServletResponse response, @RequestParam(value="fileKey", required=false) String fileKey) {
        this.organizationService.downloadOrganExcelImpTpl(response, fileKey);
    }

    @PostMapping(value={"/checkOrganExcel"})
    @CheckPermission(value={"hussarBase:authorization:organ:checkOrganExcel"})
    @ApiOperation(value="\u6821\u9a8c\u5bfc\u5165\u7ec4\u7ec7\u673a\u6784excel\u6587\u4ef6", notes="\u6821\u9a8c\u5bfc\u5165\u7ec4\u7ec7\u673a\u6784excel\u6587\u4ef6")
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ba1\u7406", eventDesc="\u6821\u9a8c\u5bfc\u5165\u7ec4\u7ec7\u673a\u6784excel\u6587\u4ef6", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public void checkOrganExcel(@RequestParam(value="file") MultipartFile file, @RequestParam(value="scenario") String scenario, @RequestParam(value="taskId") Long taskId) {
        this.organizationService.checkOrganExcel(file, scenario, taskId);
    }

    @PostMapping(value={"/importOrganExcel"})
    @CheckPermission(value={"hussarBase:authorization:organ:importOrganExcel"})
    @ApiOperation(value="\u5bfc\u5165\u7ec4\u7ec7\u673a\u6784excel\u6587\u4ef6", notes="\u5bfc\u5165\u7ec4\u7ec7\u673a\u6784excel\u6587\u4ef6")
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ba1\u7406", eventDesc="\u5bfc\u5165\u7ec4\u7ec7\u673a\u6784excel\u6587\u4ef6", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public void importOrganExcel(@RequestParam(value="scenario") String scenario, @RequestParam(value="taskId") Long taskId) {
        this.organizationService.importOrganExcel(scenario, taskId);
    }
}

