/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.relational.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.impl.RoleUserAuthorizationChangeReporter;
import com.jxdinfo.hussar.authorization.relational.dao.SysPostRoleMapper;
import com.jxdinfo.hussar.authorization.relational.dao.SysUserPostMapper;
import com.jxdinfo.hussar.authorization.relational.dto.RolePostRelationDto;
import com.jxdinfo.hussar.authorization.relational.model.SysPostRole;
import com.jxdinfo.hussar.authorization.relational.model.SysPostRoleAudit;
import com.jxdinfo.hussar.authorization.relational.service.ISysPostRoleAuditService;
import com.jxdinfo.hussar.authorization.relational.service.ISysPostRoleService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysAuditConfigService;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.rolemanager.RolePostChangeNotify;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.authorization.relational.service.impl.sysPostRoleServiceImpl")
public class SysPostRoleServiceImpl
extends HussarServiceImpl<SysPostRoleMapper, SysPostRole>
implements ISysPostRoleService {
    @Resource
    private SysPostRoleMapper sysPostRoleMapper;
    @Resource
    private SysUserPostMapper sysUserPostMapper;
    @Resource
    private ISysRolesService sysRolesService;
    @Autowired
    private ISysUserRoleService sysUserRoleService;
    @Autowired
    protected ISysPostRoleAuditService sysPostRoleAuditService;
    @Autowired
    protected ISysAuditConfigService sysAuditConfig;
    @Resource
    private RolePostChangeNotify rolePostChangeNotify;
    @Resource
    private RoleUserAuthorizationChangeReporter userAuthorizationChangeReporter;

    @HussarTransactional
    public String saveRolePost(RolePostRelationDto rolePostRelationDto) {
        List postRoleAudits = this.sysPostRoleAuditService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysPostRoleAudit::getRoleId, (Object)rolePostRelationDto.getRoleId())).eq(SysPostRoleAudit::getAuditStatus, (Object)"0"));
        AssertUtil.isEmpty((Collection)postRoleAudits, (String)"\u4fdd\u5b58\u5931\u8d25\uff01\u5b58\u5728\u672a\u5ba1\u6838\u7684\u5173\u8054\u5c97\u4f4d\uff01");
        StringBuilder stringBuilder = new StringBuilder();
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isPostAudit()) {
            this.doProcessPostRoleAudit(rolePostRelationDto);
            stringBuilder.append("\u4fdd\u5b58\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01");
        } else {
            Long roleId = rolePostRelationDto.getRoleId();
            SysRoles role = (SysRoles)this.sysRolesService.getById((Serializable)roleId);
            ArrayList postIdList = new ArrayList();
            if (HussarUtils.isEmpty((Object)role.getAppId()) || role.getAppId() == 1L) {
                List sysPostRoles = this.sysPostRoleMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysPostRole::getRoleId, (Object)roleId));
                List oldPostIds = sysPostRoles.stream().map(SysPostRole::getPostId).distinct().collect(Collectors.toList());
                String postIdStr = rolePostRelationDto.getPostIds();
                if (HussarUtils.isNotEmpty((Object)postIdStr)) {
                    List newPostIds = Arrays.asList(postIdStr.split(",")).stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                    List addPostIds = newPostIds.stream().filter(item -> !oldPostIds.contains(item)).collect(Collectors.toList());
                    List delPostIds = oldPostIds.stream().filter(item -> !newPostIds.contains(item)).collect(Collectors.toList());
                    postIdList.addAll(addPostIds);
                    postIdList.addAll(delPostIds);
                } else {
                    postIdList.addAll(oldPostIds);
                }
            }
            this.doProcessPostRole(rolePostRelationDto);
            if (HussarUtils.isNotEmpty((Object)role.getAppId()) && role.getAppId() != 1L) {
                this.rolePostChangeNotify.notify(DataChangeType.RELATE, new Object[]{roleId, null});
            }
            if (HussarUtils.isEmpty((Object)role.getAppId()) || role.getAppId() == 1L) {
                this.userAuthorizationChangeReporter.report(new Object[]{"post", postIdList});
            }
            stringBuilder.append("\u4fdd\u5b58\u6210\u529f\uff01");
        }
        return stringBuilder.toString();
    }

    @HussarTransactional
    public void saveAppPostRole(Long roleId, List<Long> postIds) {
        List sysPostRoles = this.sysPostRoleMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysPostRole::getRoleId, (Object)roleId));
        List<Object> oldPostIds = new ArrayList();
        List<Object> addPostIds = new ArrayList<Long>();
        List<Object> delPostIds = new ArrayList<Object>();
        if (HussarUtils.isNotEmpty((Object)sysPostRoles)) {
            oldPostIds = sysPostRoles.stream().map(SysPostRole::getPostId).distinct().collect(Collectors.toList());
        }
        if (HussarUtils.isNotEmpty(oldPostIds) && HussarUtils.isNotEmpty(postIds)) {
            ArrayList finalOldPostIds = oldPostIds;
            addPostIds = postIds.stream().filter(item -> !finalOldPostIds.contains(item)).collect(Collectors.toList());
            delPostIds = oldPostIds.stream().filter(item -> !postIds.contains(item)).collect(Collectors.toList());
        } else if (HussarUtils.isNotEmpty(oldPostIds) && HussarUtils.isEmpty(postIds)) {
            delPostIds.addAll(oldPostIds);
        } else if (HussarUtils.isEmpty(oldPostIds) && HussarUtils.isNotEmpty(postIds)) {
            addPostIds.addAll(postIds);
        } else {
            return;
        }
        if (HussarUtils.isNotEmpty(addPostIds)) {
            ArrayList<SysPostRole> sysPostRoleList = new ArrayList<SysPostRole>();
            for (Long l : addPostIds) {
                SysPostRole sysPostRole = new SysPostRole();
                sysPostRole.setRoleId(roleId);
                sysPostRole.setPostId(l);
                sysPostRoleList.add(sysPostRole);
            }
            if (ToolUtil.isNotEmpty(sysPostRoleList)) {
                super.saveBatch(sysPostRoleList, sysPostRoleList.size());
                this.userAuthorizationChangeReporter.report(new Object[]{"post", addPostIds});
            }
        }
    }

    private void doProcessPostRoleAudit(RolePostRelationDto rolePostRelationDto) {
        SysPostRoleAudit postRoleAudit;
        ArrayList<SysPostRoleAudit> postRoleAudits = new ArrayList<SysPostRoleAudit>();
        Long roleId = rolePostRelationDto.getRoleId();
        String postIds = rolePostRelationDto.getPostIds();
        List<Object> postIdList = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)postIds)) {
            postIdList = Arrays.stream(postIds.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        }
        ArrayList newPostIds = postIdList;
        List postRoles = this.sysPostRoleMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysPostRole::getRoleId, (Object)roleId)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
        List oldPostIds = postRoles.stream().map(SysPostRole::getPostId).collect(Collectors.toList());
        List<Object> addPostIds = new ArrayList();
        List<Object> delPostIds = new ArrayList();
        if (HussarUtils.isEmpty(oldPostIds) && HussarUtils.isNotEmpty(newPostIds)) {
            addPostIds = newPostIds;
        }
        if (HussarUtils.isEmpty(newPostIds) && HussarUtils.isNotEmpty(oldPostIds)) {
            delPostIds = oldPostIds;
        }
        if (HussarUtils.isNotEmpty(newPostIds) && HussarUtils.isNotEmpty(oldPostIds)) {
            addPostIds = newPostIds.stream().filter(item -> !oldPostIds.contains(item)).collect(Collectors.toList());
            delPostIds = oldPostIds.stream().filter(item -> !newPostIds.contains(item)).collect(Collectors.toList());
        }
        if (HussarUtils.isNotEmpty(addPostIds)) {
            for (Long postId : addPostIds) {
                postRoleAudit = new SysPostRoleAudit();
                postRoleAudit.setPostId(postId);
                postRoleAudit.setRoleId(roleId);
                postRoleAudit.setOperateType("1");
                postRoleAudit.setAuditStatus("0");
                postRoleAudits.add(postRoleAudit);
            }
        }
        if (HussarUtils.isNotEmpty(delPostIds)) {
            for (Long postId : delPostIds) {
                postRoleAudit = new SysPostRoleAudit();
                postRoleAudit.setPostId(postId);
                postRoleAudit.setRoleId(roleId);
                postRoleAudit.setOperateType("2");
                postRoleAudit.setAuditStatus("0");
                postRoleAudits.add(postRoleAudit);
            }
        }
        if (HussarUtils.isNotEmpty(postRoleAudits)) {
            this.sysPostRoleAuditService.saveBatch(postRoleAudits, postRoleAudits.size());
        }
    }

    private void doProcessPostRole(RolePostRelationDto rolePostRelationDto) {
        Long roleId = rolePostRelationDto.getRoleId();
        String postIds = rolePostRelationDto.getPostIds();
        this.sysPostRoleMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysPostRole::getRoleId, (Object)roleId));
        List<Object> postIdList = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)postIds)) {
            postIdList = Arrays.asList(postIds.split(","));
        }
        ArrayList<SysPostRole> sysPostRoleList = new ArrayList<SysPostRole>();
        for (String string : postIdList) {
            if (ToolUtil.isEmpty((Object)string)) continue;
            SysPostRole sysPostRole = new SysPostRole();
            sysPostRole.setRoleId(roleId);
            sysPostRole.setPostId(Long.valueOf(string));
            sysPostRoleList.add(sysPostRole);
        }
        if (ToolUtil.isNotEmpty(sysPostRoleList)) {
            super.saveBatch(sysPostRoleList, sysPostRoleList.size());
        }
        List userIds = this.sysRolesService.delCacheAuthInfo(roleId);
        for (Long userId : userIds) {
            this.sysRolesService.delAuthCacheInfo(userId);
        }
    }
}

