/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.post.manager.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.organ.dao.SysOrganTypeMapper;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationTypeBo;
import com.jxdinfo.hussar.authorization.post.dao.SysPostAuditMapper;
import com.jxdinfo.hussar.authorization.post.dao.SysPostMapper;
import com.jxdinfo.hussar.authorization.post.dto.QueryAuditPostDto;
import com.jxdinfo.hussar.authorization.post.manager.QueryAuditPostManager;
import com.jxdinfo.hussar.authorization.post.model.SysPost;
import com.jxdinfo.hussar.authorization.post.model.SysPostAudit;
import com.jxdinfo.hussar.authorization.post.vo.AuditPostDetail;
import com.jxdinfo.hussar.authorization.post.vo.AuditPostDetailVo;
import com.jxdinfo.hussar.authorization.post.vo.PostAuditVo;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.post.manager.impl.queryAuditPostManagerImpl")
public class QueryAuditPostManagerImpl
implements QueryAuditPostManager {
    @Resource
    private SysPostAuditMapper sysPostAuditMapper;
    @Resource
    private SysPostMapper sysPostMapper;
    @Resource
    private SysOrganTypeMapper sysOrganTypeMapper;

    @Override
    public Page<PostAuditVo> queryPostAudit(PageInfo pageInfo, QueryAuditPostDto queryAuditPostDto) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        queryParams.put("postName", SqlQueryUtil.transferSpecialChar((String)queryAuditPostDto.getPostName()));
        if (HussarUtils.isNotEmpty((Object)queryAuditPostDto.getAuditStatus())) {
            queryParams.put("auditStatus", String.valueOf(queryAuditPostDto.getAuditStatus()));
        }
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        List<PostAuditVo> auditPostVos = this.sysPostAuditMapper.queryPostAuditList((Page<PostAuditVo>)page, queryParams);
        page.setRecords(auditPostVos);
        return page;
    }

    @Override
    public AuditPostDetailVo getPostAuditDetail(Long auditId) {
        AuditPostDetailVo vo = new AuditPostDetailVo();
        AuditPostDetail oldData = vo.getOldData();
        AuditPostDetail newData = vo.getNewData();
        SysPostAudit sysPostAudit = (SysPostAudit)this.sysPostAuditMapper.selectById(auditId);
        AssertUtil.isNotNull((Object)sysPostAudit, (String)"\u672a\u67e5\u8be2\u5230\u5c97\u4f4d\u5ba1\u6838\u4fe1\u606f");
        String operateType = sysPostAudit.getOperateType();
        if ("1".equals(operateType)) {
            newData = this.sysPostAuditMapper.getPostAuditDetail(auditId);
        } else if ("2".equals(operateType)) {
            newData = this.sysPostAuditMapper.getPostAuditDetail(auditId);
            oldData = this.getPostDataById(sysPostAudit.getPostId());
        } else if ("3".equals(operateType)) {
            oldData = this.getPostDataById(sysPostAudit.getPostId());
        }
        vo.setNewData(newData);
        vo.setOldData(oldData);
        return vo;
    }

    private AuditPostDetail getPostDataById(Long postId) {
        AuditPostDetail data = new AuditPostDetail();
        SysPost post = (SysPost)this.sysPostMapper.selectById(postId);
        if (HussarUtils.isNotEmpty((Object)post)) {
            data.setPostName(post.getPostName());
            data.setOrganTypeCode(post.getOrganTypeCode());
            data.setPostDesc(post.getPostDesc());
            data.setPostCode(post.getPostCode());
            if (HussarUtils.isNotEmpty((Object)post.getOrganTypeCode())) {
                OrganizationTypeBo organType = this.sysOrganTypeMapper.getOrganizationTypeByOrganType(post.getOrganTypeCode());
                data.setOrganTypeName(organType.getTypeName());
            }
        }
        return data;
    }
}

