/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.post.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.authorization.post.dao.SysPostMapper;
import com.jxdinfo.hussar.authorization.post.dto.EditOutsidePostDto;
import com.jxdinfo.hussar.authorization.post.manager.EditOutsidePostManager;
import com.jxdinfo.hussar.authorization.post.model.SysPost;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.post.manager.impl.editOutsidePostManagerImpl")
public class EditOutsidePostManagerImpl
implements EditOutsidePostManager {
    @Autowired
    private SysPostMapper sysPostMapper;

    @Override
    public R<EditOutsidePostDto> editPost(EditOutsidePostDto editOutsidePostDto) {
        R result = new R();
        List errors = OrganUtil.validateOne((Object)editOutsidePostDto);
        String postCode = StringUtils.trimToEmpty((String)editOutsidePostDto.getPostCode());
        SysPost sysPostTemp = (SysPost)this.sysPostMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysPost::getPostCode, (Object)postCode)).ne(HussarDelflagEntity::getDelFlag, (Object)"1"));
        if (HussarUtils.isEmpty((Object)sysPostTemp)) {
            OrganUtil.addErrorMsg((List)errors, (Object)editOutsidePostDto, (String)"postCode", (String[])new String[]{"\u672a\u67e5\u8be2\u5230\u8be5\u5c97\u4f4d\u7f16\u7801"});
        }
        if (HussarUtils.isEmpty((Object)errors)) {
            SysPost sysPost = new SysPost();
            BeanUtils.copyProperties((Object)sysPostTemp, (Object)sysPost);
            this.initializationEdit(editOutsidePostDto, sysPost);
            this.sysPostMapper.updateById(sysPost);
            result.setSuccess(true);
            result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysPost.getId(), sysPost.getPostCode())}));
        } else {
            result.setSuccess(false);
            result.setErrorList(errors);
        }
        return result;
    }

    private void initializationEdit(EditOutsidePostDto editOutsidePostDto, SysPost sysPost) {
        String postName = StringUtils.trimToEmpty((String)editOutsidePostDto.getPostName());
        String postDesc = StringUtils.trimToEmpty((String)editOutsidePostDto.getPostDesc());
        Integer postOrder = editOutsidePostDto.getPostOrder();
        if (StringUtils.isNotBlank((CharSequence)postName)) {
            sysPost.setPostName(postName);
        }
        if (StringUtils.isNotBlank((CharSequence)postDesc)) {
            sysPost.setPostDesc(postDesc);
        }
        if (HussarUtils.isNotEmpty((Object)postOrder)) {
            sysPost.setPostOrder(postOrder);
        }
    }
}

