/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.jxdinfo.hussar.authorization.adapter.role.IHussarBaseRoleAdapter;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleGroupMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleGroup;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleGroupService;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysRoleGroupServiceImpl
extends HussarServiceImpl<SysRoleGroupMapper, SysRoleGroup>
implements ISysRoleGroupService {
    private static Logger logger = LoggerFactory.getLogger(SysRoleGroupServiceImpl.class);
    @Resource
    private SysRoleGroupMapper sysRoleGroupMapper;
    @Resource
    private IHussarBaseRoleAdapter hussarBaseRoleAdapter;

    public List<JSTreeModel> getLazyRoleTree(Long nodeId) {
        return this.hussarBaseRoleAdapter.getLazyRoleTree(nodeId);
    }

    public void insertOrUpdateRoleGroupList(List<SysRoleGroup> roleGroupList) {
        if (CollectionUtils.isEmpty(roleGroupList)) {
            logger.info("\u89d2\u8272\u5206\u7ec4\u65b0\u589e{}\u6761", (Object)roleGroupList.size());
            logger.info("\u89d2\u8272\u5206\u7ec4\u4fee\u6539{}\u6761", (Object)roleGroupList.size());
            return;
        }
        List allTableData = this.list();
        List allIds = allTableData.stream().map(SysRoleGroup::getId).collect(Collectors.toList());
        ArrayList<SysRoleGroup> insertData = new ArrayList<SysRoleGroup>();
        ArrayList<SysRoleGroup> updateData = new ArrayList<SysRoleGroup>();
        Integer maxOrder = this.sysRoleGroupMapper.getMaxOrder();
        for (SysRoleGroup item : roleGroupList) {
            if (allIds.contains(item.getId())) {
                updateData.add(item);
                continue;
            }
            Integer n = maxOrder;
            Integer n2 = maxOrder = Integer.valueOf(maxOrder + 1);
            item.setGroupOrder(maxOrder);
            insertData.add(item);
        }
        if (ToolUtil.isNotEmpty(insertData)) {
            this.saveBatch(insertData);
        }
        if (ToolUtil.isNotEmpty(updateData)) {
            this.updateBatchById(updateData);
        }
        logger.info("\u89d2\u8272\u5206\u7ec4\u65b0\u589e{}\u6761", (Object)insertData.size());
        logger.info("\u89d2\u8272\u5206\u7ec4\u4fee\u6539{}\u6761", (Object)updateData.size());
    }

    public List<SysRoleGroup> selectRoleGroupByIds(List<Long> roleGroupIds) {
        if (HussarUtils.isEmpty(roleGroupIds)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        for (Long id : roleGroupIds) {
            ((LambdaQueryWrapper)lambdaQueryWrapper.or()).eq(SysRoleGroup::getId, (Object)id);
        }
        lambdaQueryWrapper.orderByAsc(SysRoleGroup::getGroupOrder);
        return this.sysRoleGroupMapper.selectList((Wrapper)lambdaQueryWrapper);
    }
}

