/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleDataRightMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleDataRight;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleDataRightService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysRoleDataRightServiceImpl
extends HussarServiceImpl<SysRoleDataRightMapper, SysRoleDataRight>
implements ISysRoleDataRightService {
    private Logger logger = LoggerFactory.getLogger(SysRoleDataRightServiceImpl.class);

    public void insertOrUpdateRoleDataRightList(List<SysRoleDataRight> sysRoleDataRights) {
        if (CollectionUtils.isEmpty(sysRoleDataRights)) {
            this.logger.info("\u89d2\u8272\u6570\u636e\u6743\u9650\u65b0\u589e{}\u6761", (Object)sysRoleDataRights.size());
            this.logger.info("\u89d2\u8272\u6570\u636e\u6743\u9650\u4fee\u6539{}\u6761", (Object)sysRoleDataRights.size());
            return;
        }
        List allTableData = this.list();
        List allIds = allTableData.stream().map(SysRoleDataRight::getDataRightsId).collect(Collectors.toList());
        ArrayList<SysRoleDataRight> insertData = new ArrayList<SysRoleDataRight>();
        ArrayList<SysRoleDataRight> updateData = new ArrayList<SysRoleDataRight>();
        for (SysRoleDataRight item : sysRoleDataRights) {
            if (allIds.contains(item.getDataRightsId())) {
                updateData.add(item);
                continue;
            }
            insertData.add(item);
        }
        if (ToolUtil.isNotEmpty(insertData)) {
            this.saveBatch(insertData);
        }
        if (ToolUtil.isNotEmpty(updateData)) {
            this.updateBatchById(updateData);
        }
        this.logger.info("\u89d2\u8272\u6570\u636e\u6743\u9650\u65b0\u589e{}\u6761", (Object)insertData.size());
        this.logger.info("\u89d2\u8272\u6570\u636e\u6743\u9650\u4fee\u6539{}\u6761", (Object)updateData.size());
    }

    public List<SysRoleDataRight> selectRoleDataRightsByFuncIds(List<Long> funcIds) {
        if (HussarUtils.isEmpty(funcIds)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        for (Long funcId : funcIds) {
            ((LambdaQueryWrapper)lambdaQueryWrapper.or()).eq(SysRoleDataRight::getFunctionId, (Object)funcId);
        }
        return this.list((Wrapper)lambdaQueryWrapper);
    }
}

