/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.authorization.adapter.resource.IHussarBaseResourceAdapter;
import com.jxdinfo.hussar.authorization.permit.constants.PermitConstants;
import com.jxdinfo.hussar.authorization.permit.dao.SysResourceModulesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysResourcesMapper;
import com.jxdinfo.hussar.authorization.permit.dto.ResTreeDto;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceModules;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourceMosulesService;
import com.jxdinfo.hussar.authorization.permit.vo.ModuleTreeVo;
import com.jxdinfo.hussar.authorization.permit.vo.SearchModuleVo;
import com.jxdinfo.hussar.common.base.HussarBaseServiceImpl;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.HussarTreeParser;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.idtable.model.SysIdtable;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysResourceMosulesServiceImpl
extends HussarBaseServiceImpl<SysResourceModulesMapper, SysResourceModules>
implements ISysResourceMosulesService {
    private static Logger logger = LoggerFactory.getLogger(SysResourceMosulesServiceImpl.class);
    @Resource
    private SysResourceModulesMapper sysResourceModulesMapper;
    @Resource
    private SysResourcesMapper sysResourcesMapper;
    @Resource
    private ISysIdtableService sysIdtableService;
    @Resource
    private IHussarBaseResourceAdapter hussarBaseResourceAdapter;
    @Resource
    private ISysApplicationService sysApplicationService;

    public List<SysResourceModules> getGradeAdminResModuleId(List<Long> resourceIdList) {
        if (ToolUtil.isEmpty(resourceIdList)) {
            return new ArrayList<SysResourceModules>();
        }
        List resourceModulesList = this.sysResourceModulesMapper.selectList((Wrapper)new QueryWrapper());
        List resourcesList = this.sysResourcesMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysResources::getId, resourceIdList));
        ArrayList<Long> parentModuleIds = new ArrayList<Long>();
        resourcesList.forEach(resource -> parentModuleIds.add(resource.getModuleId()));
        ArrayList<SysResourceModules> parentModuleList = new ArrayList<SysResourceModules>();
        this.getParentModuleList(parentModuleList, parentModuleIds, resourceModulesList);
        return parentModuleList;
    }

    private void getParentModuleList(List<SysResourceModules> parentModuleList, List<Long> parentModuleIds, List<SysResourceModules> resourceModulesList) {
        ArrayList parentList = new ArrayList();
        ArrayList<Long> parentIdList = new ArrayList<Long>();
        for (int i = 0; i < resourceModulesList.size(); ++i) {
            SysResourceModules resourceModules = resourceModulesList.get(i);
            if (!parentModuleIds.contains(Long.parseLong(String.valueOf(resourceModules.getId())))) continue;
            parentModuleList.add(resourceModules);
            parentIdList.add(resourceModules.getParentModuleId());
            resourceModulesList.remove(i);
            --i;
        }
        if (parentIdList.size() > 0) {
            this.getParentModuleList(parentModuleList, parentIdList, resourceModulesList);
        }
    }

    public Map<String, Integer> insertOrUpdateList(List<SysResourceModules> modulesList) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        if (CollectionUtils.isEmpty(modulesList)) {
            result.put("update", modulesList.size());
            result.put("insert", modulesList.size());
            return result;
        }
        List<Long> moduleIds = modulesList.stream().map(SysResourceModules::getId).collect(Collectors.toList());
        List<SysResourceModules> existedResourceModules = this.getResModulesByModuleIds(moduleIds);
        List existedIds = existedResourceModules.stream().map(SysResourceModules::getId).distinct().collect(Collectors.toList());
        ArrayList<SysResourceModules> insertData = new ArrayList<SysResourceModules>();
        ArrayList<SysResourceModules> updateData = new ArrayList<SysResourceModules>();
        Integer maxOrder = this.sysResourceModulesMapper.getMaxOrder();
        SysIdtable sysIdtable = this.sysIdtableService.getIdtableByQuery("MODULE_CODE", "SYS_RESOURCE_MODULES");
        Integer maxCode = sysIdtable.getIdValue();
        for (SysResourceModules sysResourceModules : modulesList) {
            if (existedIds.contains(sysResourceModules.getId())) {
                updateData.add(sysResourceModules);
                continue;
            }
            Integer n = maxOrder;
            Integer n2 = maxOrder = Integer.valueOf(maxOrder + 1);
            sysResourceModules.setSeq(maxOrder);
            n = maxCode;
            n2 = maxCode = Integer.valueOf(maxCode + 1);
            int zerolength = sysIdtable.getIdLength() - maxCode.toString().length();
            if (zerolength < 0) {
                throw new BaseException("\u7f16\u7801\u8d85\u51fa\u89c4\u5b9a\u7684\u957f\u5ea6");
            }
            StringBuilder currentCode = new StringBuilder();
            for (int i = 0; i < zerolength; ++i) {
                currentCode.append("0");
            }
            currentCode.append(maxCode);
            sysResourceModules.setModuleCode(currentCode.toString());
            insertData.add(sysResourceModules);
        }
        if (ToolUtil.isNotEmpty(insertData)) {
            this.saveBatch(insertData);
            sysIdtable.setIdValue(maxCode);
            this.sysIdtableService.updateIdtable(sysIdtable);
        }
        if (ToolUtil.isNotEmpty(updateData)) {
            this.updateBatchById(updateData);
        }
        result.put("update", updateData.size());
        result.put("insert", insertData.size());
        return result;
    }

    public void insertOrUpdateResourcesModuleList(List<SysResourceModules> resourceModulesList) {
        if (CollectionUtils.isEmpty(resourceModulesList)) {
            logger.info("\u8d44\u6e90\u6a21\u5757\u65b0\u589e{}\u6761", (Object)resourceModulesList.size());
            logger.info("\u8d44\u6e90\u6a21\u5757\u4fee\u6539{}\u6761", (Object)resourceModulesList.size());
            return;
        }
        List allTableData = this.list();
        List allIds = allTableData.stream().map(SysResourceModules::getId).collect(Collectors.toList());
        ArrayList<SysResourceModules> insertData = new ArrayList<SysResourceModules>();
        ArrayList<SysResourceModules> updateData = new ArrayList<SysResourceModules>();
        Integer maxOrder = this.sysResourceModulesMapper.getMaxOrder();
        SysIdtable sysIdtable = this.sysIdtableService.getIdtableByQuery("MODULE_CODE", "SYS_RESOURCE_MODULES");
        Integer maxCode = sysIdtable.getIdValue();
        for (SysResourceModules item : resourceModulesList) {
            if (allIds.contains(item.getId())) {
                updateData.add(item);
                continue;
            }
            Integer n = maxOrder;
            Integer n2 = maxOrder = Integer.valueOf(maxOrder + 1);
            item.setSeq(maxOrder);
            n = maxCode;
            n2 = maxCode = Integer.valueOf(maxCode + 1);
            int zeroLength = sysIdtable.getIdLength() - maxCode.toString().length();
            if (zeroLength < 0) {
                throw new BaseException("\u7f16\u7801\u8d85\u51fa\u89c4\u5b9a\u7684\u957f\u5ea6");
            }
            StringBuilder currentCode = new StringBuilder();
            for (int i = 0; i < zeroLength; ++i) {
                currentCode.append("0");
            }
            currentCode.append(maxCode);
            item.setModuleCode(currentCode.toString());
            insertData.add(item);
        }
        if (ToolUtil.isNotEmpty(insertData)) {
            this.saveBatch(insertData);
            sysIdtable.setIdValue(maxCode);
            this.sysIdtableService.updateIdtable(sysIdtable);
        }
        if (ToolUtil.isNotEmpty(updateData)) {
            this.updateBatchById(updateData);
        }
        logger.info("\u8d44\u6e90\u6a21\u5757\u65b0\u589e{}\u6761", (Object)insertData.size());
        logger.info("\u8d44\u6e90\u6a21\u5757\u4fee\u6539{}\u6761", (Object)updateData.size());
    }

    public List<SysResourceModules> getResourceModulesByOneRes(List<SysResourceModules> result, SysResourceModules children, List<SysResourceModules> allModules) {
        if (ToolUtil.isEmpty((Object)children)) {
            return result;
        }
        Long parentId = children.getParentModuleId();
        SysResourceModules parentModules = null;
        for (SysResourceModules resourceModule : allModules) {
            if (!parentId.equals(resourceModule.getId())) continue;
            parentModules = resourceModule;
        }
        if (HussarUtils.isNotEmpty(parentModules)) {
            result.add(parentModules);
            return this.getResourceModulesByOneRes(result, parentModules, allModules);
        }
        return result;
    }

    public List<SysResourceModules> getResModulesByModuleIds(List<Long> moduleIds) {
        if (HussarUtils.isEmpty(moduleIds)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        for (Long moduleId : moduleIds) {
            ((LambdaQueryWrapper)lambdaQueryWrapper.or()).eq(SysResourceModules::getId, (Object)moduleId);
        }
        return this.sysResourceModulesMapper.selectList((Wrapper)lambdaQueryWrapper);
    }

    public Collection<SysResourceModules> recursiveGetResModule(List<Long> resModuleList, Collection<SysResourceModules> allResModuleList, Collection<SysResourceModules> result) {
        if (HussarUtils.isEmpty(resModuleList) || resModuleList.size() == 1 && PermitConstants.ROOT_ID.equals(resModuleList.get(0))) {
            return result;
        }
        HashSet<Long> parentModuleList = new HashSet<Long>();
        for (SysResourceModules item : allResModuleList) {
            if (!resModuleList.contains(item.getId())) continue;
            result.add(item);
            parentModuleList.add(item.getParentModuleId());
        }
        return this.recursiveGetResModule(new ArrayList<Long>(parentModuleList), allResModuleList, result);
    }

    public boolean save(SysResourceModules entity) {
        return this.hussarBaseResourceAdapter.saveModule(entity);
    }

    public List<SysResourceModules> listByNameAndParentId(String moduleName, Long parentModuleId, Long appId) {
        return this.hussarBaseResourceAdapter.moduleList(moduleName, parentModuleId, appId);
    }

    public Integer getMaxOrderByParentIdAndAppId(Long moduleId, Long appId) {
        return this.hussarBaseResourceAdapter.getMaxOrderByParentIdAndAppId(moduleId, appId);
    }

    public String getFullModuleNameById(Long moduleId, Long appId) {
        return this.hussarBaseResourceAdapter.getFullModuleNameById(moduleId, appId);
    }

    public Map<Long, String> getFullModuleNameMapByName(String moduleName, Long appId) {
        return this.hussarBaseResourceAdapter.getFullModuleNameMapByName(moduleName, appId);
    }

    public boolean updateById(SysResourceModules entity) {
        return this.hussarBaseResourceAdapter.updateModule(entity);
    }

    public SysResourceModules getById(Serializable id) {
        return this.hussarBaseResourceAdapter.getModuleByModuleId((Long)id);
    }

    public List<ModuleTreeVo> lazyLoadResModuleTree(ResTreeDto resTreeDto) {
        if (HussarUtils.isEmpty((Object)resTreeDto)) {
            throw new BaseException("\u8d44\u6e90\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long newNodeId = resTreeDto.getNodeId();
        String nodeType = resTreeDto.getNodeType();
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        ArrayList<ModuleTreeVo> result = new ArrayList<ModuleTreeVo>();
        List<Object> list1 = new ArrayList();
        Long appId = resTreeDto.getApplicationId();
        if (HussarUtils.isEmpty((Object)newNodeId)) {
            ModuleTreeVo root = new ModuleTreeVo();
            root.setCode(String.valueOf(Constants.ROOT_NODE_ID));
            root.setParentId((Serializable)Constants.ROOT_NODE_PARENT);
            root.setLabel("\u8d44\u6e90\u6a21\u5757\u5217\u8868");
            root.setIsModule("1");
            root.setType("isRoot");
            root.setConstant("0");
            root.setIsLeaf("0");
            root.setIcon("tree-com");
            boolean flag = this.existUnifyApp();
            if (flag) {
                root.setId((Serializable)Constants.ROOT_NODE_ID);
                root.setCanAddModule(Boolean.valueOf(false));
                if (HussarUtils.isEmpty((Object)appId)) {
                    List list = this.sysApplicationService.getUserApplications(shiroUser.getId());
                    List<Long> appIds = list.stream().map(SysApplication::getId).distinct().collect(Collectors.toList());
                    List<ModuleTreeVo> childrenList = this.getAppTree(appIds);
                    root.setChildren(childrenList);
                    if (HussarUtils.isNotEmpty(childrenList)) {
                        root.setHasChildren(Boolean.valueOf(true));
                    } else {
                        root.setIsLeaf("1");
                    }
                    result.add(root);
                    return result;
                }
            } else {
                root.setId((Serializable)Constants.RES_NODE_ID);
                root.setCanAddModule(Boolean.valueOf(true));
                root.setId((Serializable)Constants.RES_NODE_ID);
                appId = 1L;
                newNodeId = Constants.RES_NODE_ID;
                if (HussarUtils.isNotEmpty((Object)root.getId())) {
                    result.add(root);
                }
                list1 = this.sysResourceModulesMapper.lazyLoadModulesResTree(newNodeId, appId);
                root.setHasChildren(Boolean.valueOf(HussarUtils.isNotEmpty(list1)));
                result.addAll(list1);
            }
        } else {
            boolean isModule;
            boolean bl = isModule = ToolUtil.equals((Object)"isModule", (Object)nodeType) || ToolUtil.equals((Object)"app", (Object)nodeType);
            if (isModule) {
                if (HussarUtils.equals((Object)newNodeId, (Object)appId)) {
                    newNodeId = Constants.RES_NODE_ID;
                    list1 = this.sysResourceModulesMapper.lazyLoadModulesResTree(newNodeId, appId);
                    for (ModuleTreeVo moduleTreeVo : list1) {
                        moduleTreeVo.setParentId((Serializable)moduleTreeVo.getApplicationId());
                    }
                } else {
                    list1 = this.sysResourceModulesMapper.lazyLoadModulesResTree(newNodeId, appId);
                }
            }
            result.addAll(list1);
        }
        for (ModuleTreeVo module : result) {
            String string = module.getType();
            if (!"isModule".equals(string)) continue;
            module.getState().put("notLeafModule", true);
        }
        return HussarTreeParser.getTreeList(result);
    }

    public Page<SearchModuleVo> searchResModule(PageInfo pageInfo, String name) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("name", SqlQueryUtil.transferSpecialChar((String)name));
        queryParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        List<SearchModuleVo> result = this.sysResourceModulesMapper.searchResModule(page, queryParams);
        page.setRecords(result);
        return page;
    }

    public List<ModuleTreeVo> backResModuleTree(Long id) {
        ArrayList<ModuleTreeVo> result = new ArrayList<ModuleTreeVo>();
        ModuleTreeVo root = new ModuleTreeVo();
        root.setCode(String.valueOf(Constants.ROOT_NODE_ID));
        root.setParentId((Serializable)Constants.ROOT_NODE_PARENT);
        root.setLabel("\u8d44\u6e90\u6a21\u5757\u5217\u8868");
        root.setIsModule("1");
        root.setType("isRoot");
        root.setConstant("0");
        root.setIsLeaf("0");
        root.setIcon("tree-com");
        boolean flag = this.existUnifyApp();
        if (flag) {
            root.setId((Serializable)Constants.ROOT_NODE_ID);
            root.setCanAddModule(Boolean.valueOf(false));
            SecurityUser shiroUser = BaseSecurityUtil.getUser();
            List applicationVos = this.sysApplicationService.getUserApplications(shiroUser.getId());
            List<Long> appIds = applicationVos.stream().map(SysApplication::getId).distinct().collect(Collectors.toList());
            List<ModuleTreeVo> childrenList = this.getAppTree(appIds);
            if (HussarUtils.isNotEmpty(childrenList)) {
                root.setHasChildren(Boolean.valueOf(true));
            } else {
                root.setIsLeaf("1");
            }
            result.add(root);
            result.addAll((Collection<ModuleTreeVo>)childrenList);
        } else {
            root.setId((Serializable)Constants.RES_NODE_ID);
            root.setCanAddModule(Boolean.valueOf(true));
            root.setId((Serializable)Constants.RES_NODE_ID);
            result.add(root);
        }
        List<ModuleTreeVo> list = this.sysResourceModulesMapper.getAllResModule();
        if (HussarUtils.isEmpty(list)) {
            return result;
        }
        HashMap childMap = new HashMap();
        ModuleTreeVo module = null;
        for (ModuleTreeVo moduleTreeVo : list) {
            List<ModuleTreeVo> vos;
            if (flag && (Long)moduleTreeVo.getParentId() == 1L && moduleTreeVo.getApplicationId() != 1L) {
                moduleTreeVo.setParentId((Serializable)moduleTreeVo.getApplicationId());
            }
            if (id.equals(moduleTreeVo.getId())) {
                module = moduleTreeVo;
            }
            if (HussarUtils.isEmpty(childMap.get(moduleTreeVo.getParentId()))) {
                vos = new ArrayList<ModuleTreeVo>();
                vos.add(moduleTreeVo);
                childMap.put(moduleTreeVo.getParentId(), vos);
                continue;
            }
            vos = (List)childMap.get(moduleTreeVo.getParentId());
            vos.add(moduleTreeVo);
        }
        if (HussarUtils.isEmpty(module)) {
            throw new BaseException("\u672a\u67e5\u8be2\u5230\u8be5\u8d44\u6e90\u6a21\u5757");
        }
        ArrayList<ModuleTreeVo> parentModuleList = new ArrayList<ModuleTreeVo>();
        this.getParentModules(parentModuleList, module, list);
        parentModuleList.add(module);
        for (ModuleTreeVo treeVo : parentModuleList) {
            Long parentId = (Long)treeVo.getParentId();
            List child = (List)childMap.get(parentId);
            if (!HussarUtils.isNotEmpty((Object)child)) continue;
            for (ModuleTreeVo vo : child) {
                vo.setHasChildren(Boolean.valueOf(childMap.containsKey(vo.getId())));
            }
            result.addAll(child);
        }
        for (ModuleTreeVo treeVo : result) {
            String isModule = treeVo.getType();
            if (!"isModule".equals(isModule)) continue;
            treeVo.getState().put("notLeafModule", true);
        }
        return HussarTreeParser.getTreeList(result);
    }

    private void getParentModules(List<ModuleTreeVo> result, ModuleTreeVo module, List<ModuleTreeVo> list) {
        if (HussarUtils.isNotEmpty((Object)module)) {
            Long parentId = (Long)module.getParentId();
            ModuleTreeVo parentModules = null;
            for (ModuleTreeVo treeVo : list) {
                if (!parentId.equals(treeVo.getId())) continue;
                parentModules = treeVo;
            }
            if (HussarUtils.isNotEmpty(parentModules)) {
                result.add(parentModules);
                this.getParentModules(result, parentModules, list);
            }
        }
    }

    private boolean existUnifyApp() {
        SysApplication application = (SysApplication)this.sysApplicationService.getById((Serializable)Long.valueOf(1L));
        return HussarUtils.isNotEmpty((Object)application);
    }

    private List<ModuleTreeVo> getAppTree(List<Long> appIdList) {
        ArrayList<ModuleTreeVo> result = new ArrayList<ModuleTreeVo>();
        if (HussarUtils.isEmpty(appIdList)) {
            return Collections.emptyList();
        }
        List applications = this.sysApplicationService.list((Wrapper)new LambdaQueryWrapper().in(SysApplication::getId, appIdList));
        List<Object> relationAppIds = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)applications)) {
            List resourceModules = this.sysResourceModulesMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysResourceModules::getApplicationId, appIdList));
            if (HussarUtils.isNotEmpty((Object)resourceModules)) {
                relationAppIds = resourceModules.stream().map(SysResourceModules::getApplicationId).collect(Collectors.toList());
            }
            for (SysApplication application : applications) {
                ModuleTreeVo treeModel = new ModuleTreeVo();
                treeModel.setId((Serializable)application.getId());
                treeModel.setLabel(application.getAppName());
                treeModel.setCode(application.getAppCode());
                treeModel.setApplicationId(application.getId());
                treeModel.setType("app");
                treeModel.setParentId((Serializable)Constants.ROOT_NODE_ID);
                treeModel.setConstant("0");
                treeModel.setHasChildren(Boolean.valueOf(relationAppIds.contains(application.getId())));
                treeModel.setIsLeaf(relationAppIds.contains(application.getId()) ? "0" : "1");
                treeModel.setIcon("caidan_appManagement");
                result.add(treeModel);
            }
        }
        return result;
    }
}

