/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.dao.SysStruRoleAuditMapper;
import com.jxdinfo.hussar.authorization.permit.manager.AuditStruRoleManager;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysStruRole;
import com.jxdinfo.hussar.authorization.permit.model.SysStruRoleAudit;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruRoleService;
import com.jxdinfo.hussar.authorization.permit.service.impl.RoleUserAuthorizationChangeReporter;
import com.jxdinfo.hussar.common.constant.state.StruRoleStatus;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.rolemanager.RoleOrganChangeNotify;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.authorization.permit.service.impl.auditStruRoleManagerImpl")
public class AuditStruRoleManagerImpl
implements AuditStruRoleManager {
    @Resource
    private SysStruRoleAuditMapper sysStruRoleAuditMapper;
    @Autowired
    private ISysStruRoleService sysStruRoleService;
    @Autowired
    private ISysRolesService sysRolesService;
    @Autowired
    private ISysStruService sysStruService;
    @Autowired
    private RoleOrganChangeNotify roleOrganChangeNotify;
    @Resource
    private RoleUserAuthorizationChangeReporter userAuthorizationChangeReporter;

    @Override
    public Boolean pass(Long auditId) {
        boolean result;
        SysStruRoleAudit struRoleAudit = (SysStruRoleAudit)this.sysStruRoleAuditMapper.selectById(auditId);
        String operateType = struRoleAudit.getOperationType();
        if ("1".equals(operateType)) {
            result = this.doAuditAdd(struRoleAudit);
        } else if ("2".equals(operateType)) {
            result = this.doAuditDelete(struRoleAudit);
        } else {
            throw new BaseException("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7c7b\u578b");
        }
        return result;
    }

    @Override
    public Boolean reject(Long auditId) {
        SysStruRoleAudit struRoleAudit = (SysStruRoleAudit)this.sysStruRoleAuditMapper.selectById(auditId);
        struRoleAudit.setStatus(StruRoleStatus.REFUSE.getCode());
        return this.sysStruRoleAuditMapper.updateById(struRoleAudit) > 0;
    }

    private boolean doAuditDelete(SysStruRoleAudit struRoleAudit) {
        List struRoles = this.sysStruRoleService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruRole::getStruId, (Object)struRoleAudit.getStruId())).eq(SysStruRole::getGrantedRole, (Object)struRoleAudit.getRoleId())).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
        if (HussarUtils.isEmpty((Object)struRoles)) {
            throw new BaseException("\u5220\u9664\u5931\u8d25\uff01\u7ec4\u7ec7\u89d2\u8272\u5df2\u53d6\u6d88\u5173\u8054\uff01");
        }
        boolean remove = this.sysStruRoleService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruRole::getStruId, (Object)struRoleAudit.getStruId())).eq(SysStruRole::getGrantedRole, (Object)struRoleAudit.getRoleId()));
        struRoleAudit.setStatus(StruRoleStatus.OK.getCode());
        boolean updateFlag = this.sysStruRoleAuditMapper.updateById(struRoleAudit) > 0;
        Long roleId = struRoleAudit.getRoleId();
        SysRoles role = (SysRoles)this.sysRolesService.getById((Serializable)roleId);
        if (HussarUtils.isNotEmpty((Object)role.getAppId()) && role.getAppId() != 1L) {
            this.roleOrganChangeNotify.notify(DataChangeType.RELATE, new Object[]{roleId, null});
        }
        if (HussarUtils.isEmpty((Object)role.getAppId()) || role.getAppId() == 1L) {
            ArrayList<Long> struIdList = new ArrayList<Long>();
            struIdList.add(struRoleAudit.getStruId());
            this.userAuthorizationChangeReporter.report(new Object[]{"organ", struIdList});
        }
        return remove && updateFlag;
    }

    private boolean doAuditAdd(SysStruRoleAudit struRoleAudit) {
        List struList = this.sysStruService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStru::getId, (Object)struRoleAudit.getStruId())).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
        if (HussarUtils.isEmpty((Object)struList)) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\u7ec4\u7ec7\u673a\u6784\u4e0d\u5b58\u5728\uff01");
        }
        List rolesList = this.sysRolesService.list((Wrapper)new LambdaQueryWrapper().eq(SysRoles::getId, (Object)struRoleAudit.getRoleId()));
        if (HussarUtils.isEmpty((Object)rolesList)) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\u89d2\u8272\u4e0d\u5b58\u5728\uff01");
        }
        List struRoles = this.sysStruRoleService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruRole::getStruId, (Object)struRoleAudit.getStruId())).eq(SysStruRole::getGrantedRole, (Object)struRoleAudit.getRoleId())).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
        if (HussarUtils.isNotEmpty((Object)struRoles)) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\u7ec4\u7ec7\u89d2\u8272\u5df2\u5173\u8054\uff01");
        }
        SysStruRole struRole = new SysStruRole();
        struRole.setStruId(struRoleAudit.getStruId());
        struRole.setGrantedRole(struRoleAudit.getRoleId());
        boolean saveFlag = this.sysStruRoleService.save((Object)struRole);
        struRoleAudit.setStatus(StruRoleStatus.OK.getCode());
        boolean updateFlag = this.sysStruRoleAuditMapper.updateById(struRoleAudit) > 0;
        Long roleId = struRoleAudit.getRoleId();
        SysRoles role = (SysRoles)this.sysRolesService.getById((Serializable)roleId);
        if (HussarUtils.isNotEmpty((Object)role.getAppId()) && role.getAppId() != 1L) {
            this.roleOrganChangeNotify.notify(DataChangeType.RELATE, new Object[]{roleId, null});
        }
        if (HussarUtils.isEmpty((Object)role.getAppId()) || role.getAppId() == 1L) {
            ArrayList<Long> struIdList = new ArrayList<Long>();
            struIdList.add(struRoleAudit.getStruId());
            this.userAuthorizationChangeReporter.report(new Object[]{"organ", struIdList});
        }
        return saveFlag && updateFlag;
    }
}

