/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleGroupMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRolesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysStruRoleMapper;
import com.jxdinfo.hussar.authorization.permit.dto.AppRoleDto;
import com.jxdinfo.hussar.authorization.permit.dto.AppRoleMemberDto;
import com.jxdinfo.hussar.authorization.permit.manager.AddRoleManager;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleGroup;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysStruRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.impl.RoleUserAuthorizationChangeReporter;
import com.jxdinfo.hussar.authorization.relational.model.SysPostRole;
import com.jxdinfo.hussar.authorization.relational.service.ISysPostRoleService;
import com.jxdinfo.hussar.common.constant.state.UserRoleStatus;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.permit.manager.impl.addRoleManagerImpl")
public class AddRoleManagerImpl
implements AddRoleManager {
    @Resource
    private SysRolesMapper sysRolesMapper;
    @Resource
    private SysRoleGroupMapper sysRoleGroupMapper;
    @Resource
    private SysStruRoleMapper sysStruRoleMapper;
    @Resource
    private ISysStruRoleService sysStruRoleService;
    @Resource
    private ISysUserRoleService sysUserRoleService;
    @Resource
    private ISysPostRoleService sysPostRoleService;
    @Resource
    private RoleUserAuthorizationChangeReporter userAuthorizationChangeReporter;

    @Override
    @HussarTransactional
    public Long addAppRole(AppRoleDto appRoleDto) {
        Long groupId;
        if (ToolUtil.isEmpty((Object)appRoleDto)) {
            throw new BaseException("\u89d2\u8272\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.validateParam(appRoleDto);
        Long appId = appRoleDto.getAppId();
        List groups = this.sysRoleGroupMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysRoleGroup::getFromAppId, (Object)appId));
        if (HussarUtils.isEmpty((Object)groups)) {
            SysRoleGroup sysRoleGroup = new SysRoleGroup();
            groupId = IdWorker.getId((Object)sysRoleGroup);
            sysRoleGroup.setId(groupId);
            sysRoleGroup.setAppId(Long.valueOf(1L));
            sysRoleGroup.setFromAppId(appId);
            sysRoleGroup.setParentId(Long.valueOf(1L));
            sysRoleGroup.setGroupName(appRoleDto.getAppName());
            sysRoleGroup.setGroupAlias(appRoleDto.getAppName());
            int groupOrder = this.sysRoleGroupMapper.getMaxOrder() + 1;
            sysRoleGroup.setGroupOrder(Integer.valueOf(groupOrder));
            this.sysRoleGroupMapper.insert(sysRoleGroup);
        } else {
            groupId = ((SysRoleGroup)groups.get(0)).getId();
        }
        SysRoles sysRoles = new SysRoles();
        BeanUtils.copyProperties((Object)appRoleDto, (Object)sysRoles);
        Long roleId = IdWorker.getId((Object)sysRoles);
        sysRoles.setId(roleId);
        sysRoles.setIsSys("0");
        sysRoles.setCorporationId(Long.valueOf(0L));
        sysRoles.setGroupId(groupId);
        sysRoles.setAppId(Long.valueOf(1L));
        sysRoles.setFromAppId(appId);
        Integer order = this.sysRolesMapper.getMaxOrder();
        order = HussarUtils.isEmpty((Object)order) ? Integer.valueOf(1) : Integer.valueOf(order + 1);
        sysRoles.setRoleOrder(order);
        this.sysRolesMapper.insert(sysRoles);
        return roleId;
    }

    @Override
    @HussarTransactional
    public Long copyAppRole(Long roleId) {
        List postRoles;
        List userRoles;
        if (ToolUtil.isEmpty((Object)roleId)) {
            throw new BaseException("\u89d2\u8272id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SysRoles role = (SysRoles)this.sysRolesMapper.selectById(roleId);
        if (HussarUtils.isEmpty((Object)role)) {
            throw new BaseException("\u88ab\u590d\u5236\u89d2\u8272\u4e0d\u5b58\u5728");
        }
        List roles = this.sysRolesMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysRoles::getFromAppId, (Object)role.getFromAppId()));
        List roleNameList = roles.stream().map(SysRoles::getRoleName).collect(Collectors.toList());
        SysRoles sysRoles = new SysRoles();
        BeanUtils.copyProperties((Object)role, (Object)sysRoles);
        Long newRoleId = IdWorker.getId((Object)sysRoles);
        sysRoles.setId(newRoleId);
        Integer order = this.sysRolesMapper.getMaxOrder();
        order = HussarUtils.isEmpty((Object)order) ? Integer.valueOf(1) : Integer.valueOf(order + 1);
        sysRoles.setRoleOrder(order);
        String roleName = role.getRoleName();
        int num = 1;
        while (roleNameList.contains(roleName)) {
            roleName = num == 1 ? roleName + "-\u526f\u672c" : roleName + "-\u526f\u672c(" + num + ")";
            ++num;
        }
        sysRoles.setRoleName(roleName);
        this.sysRolesMapper.insert(sysRoles);
        List struRoles = this.sysStruRoleService.list((Wrapper)new LambdaQueryWrapper().eq(SysStruRole::getGrantedRole, (Object)roleId));
        if (HussarUtils.isNotEmpty((Object)struRoles)) {
            List struIds = struRoles.stream().map(SysStruRole::getStruId).distinct().collect(Collectors.toList());
            this.sysStruRoleService.saveAppRoleOrgan(newRoleId, struIds);
        }
        if (HussarUtils.isNotEmpty((Object)(userRoles = this.sysUserRoleService.list((Wrapper)new LambdaQueryWrapper().eq(SysUserRole::getGrantedRole, (Object)roleId))))) {
            List userIds = userRoles.stream().map(SysUserRole::getUserId).distinct().collect(Collectors.toList());
            this.sysUserRoleService.saveAppRoleUser(newRoleId, userIds);
        }
        if (HussarUtils.isNotEmpty((Object)(postRoles = this.sysPostRoleService.list((Wrapper)new LambdaQueryWrapper().eq(SysPostRole::getRoleId, (Object)roleId))))) {
            List postIds = postRoles.stream().map(SysPostRole::getPostId).distinct().collect(Collectors.toList());
            this.sysPostRoleService.saveAppPostRole(newRoleId, postIds);
        }
        this.userAuthorizationChangeReporter.report(new Object[]{"role", newRoleId});
        return newRoleId;
    }

    @Override
    @HussarTransactional
    public Boolean saveAppRoleWithMember(AppRoleMemberDto appRoleMemberDto) {
        if (ToolUtil.isEmpty((Object)appRoleMemberDto)) {
            throw new BaseException("\u89d2\u8272\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long roleId = appRoleMemberDto.getRoleId();
        if (HussarUtils.isEmpty((Object)roleId)) {
            roleId = this.insertAppRoleInfo(appRoleMemberDto);
            appRoleMemberDto.setRoleId(roleId);
        } else {
            this.updateAppRoleInfo(appRoleMemberDto);
            this.sysStruRoleService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruRole::getGrantedRole, (Object)roleId));
            this.sysPostRoleService.remove((Wrapper)new LambdaQueryWrapper().eq(SysPostRole::getRoleId, (Object)roleId));
            this.sysUserRoleService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserRole::getGrantedRole, (Object)roleId));
        }
        this.saveAppRoleMember(appRoleMemberDto);
        this.userAuthorizationChangeReporter.report(new Object[]{"role", roleId});
        return Boolean.TRUE;
    }

    @Override
    public Boolean saveAppRoleInfo(List<AppRoleMemberDto> appRoleMemberList) {
        if (ToolUtil.isEmpty(appRoleMemberList)) {
            return Boolean.TRUE;
        }
        List roleIds = appRoleMemberList.stream().map(AppRoleMemberDto::getRoleId).collect(Collectors.toList());
        List struRoleList = this.sysStruRoleService.list((Wrapper)new LambdaQueryWrapper().in(SysStruRole::getGrantedRole, roleIds));
        List userRoleList = this.sysUserRoleService.list((Wrapper)new LambdaQueryWrapper().in(SysUserRole::getGrantedRole, roleIds));
        Map<Long, List<Long>> struRoleMap = struRoleList.stream().collect(Collectors.groupingBy(SysStruRole::getGrantedRole, Collectors.mapping(SysStruRole::getStruId, Collectors.toList())));
        Map<Long, List<Long>> userRoleMap = userRoleList.stream().collect(Collectors.groupingBy(SysUserRole::getGrantedRole, Collectors.mapping(SysUserRole::getUserId, Collectors.toList())));
        this.sysStruRoleService.remove((Wrapper)new LambdaQueryWrapper().in(SysStruRole::getGrantedRole, roleIds));
        this.sysUserRoleService.remove((Wrapper)new LambdaQueryWrapper().in(SysUserRole::getGrantedRole, roleIds));
        this.saveAppRoleMemberBatch(appRoleMemberList, struRoleMap, userRoleMap);
        return Boolean.TRUE;
    }

    private void saveAppRoleMemberBatch(List<AppRoleMemberDto> appRoleMemberList, Map<Long, List<Long>> struRoleMap, Map<Long, List<Long>> userRoleMap) {
        ArrayList<SysStruRole> struRoleList = new ArrayList<SysStruRole>();
        ArrayList<SysUserRole> userRoleList = new ArrayList<SysUserRole>();
        ArrayList<Long> struChangeList = new ArrayList<Long>();
        ArrayList<Long> userChangeList = new ArrayList<Long>();
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        LocalDateTime now = LocalDateTime.now();
        for (AppRoleMemberDto appRoleMemberDto : appRoleMemberList) {
            Long roleId = appRoleMemberDto.getRoleId();
            List struIds = appRoleMemberDto.getStruIds();
            AddRoleManagerImpl.getChangeList(struRoleMap, roleId, struIds, struChangeList);
            if (HussarUtils.isNotEmpty((Object)struIds)) {
                for (Long struId : struIds) {
                    SysStruRole struRole = new SysStruRole();
                    struRole.setGrantedRole(roleId);
                    struRole.setStruId(struId);
                    struRoleList.add(struRole);
                }
            }
            List userIds = appRoleMemberDto.getUserIds();
            AddRoleManagerImpl.getChangeList(userRoleMap, roleId, userIds, userChangeList);
            if (!HussarUtils.isNotEmpty((Object)userIds)) continue;
            for (Long userId : userIds) {
                SysUserRole sysUserRole = new SysUserRole();
                sysUserRole.setUserId(userId);
                sysUserRole.setGrantedRole(roleId);
                sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
                sysUserRole.setLastTime(now);
                sysUserRole.setLastEditor(securityUser.getId());
                sysUserRole.setCreateTime(now);
                sysUserRole.setCreator(securityUser.getId());
                userRoleList.add(sysUserRole);
            }
        }
        if (ToolUtil.isNotEmpty(struRoleList)) {
            this.sysStruRoleService.saveBatch(struRoleList, struRoleList.size());
        }
        if (ToolUtil.isNotEmpty(userRoleList)) {
            this.sysUserRoleService.saveBatch(userRoleList, userRoleList.size());
        }
        if (HussarUtils.isNotEmpty(struChangeList)) {
            this.userAuthorizationChangeReporter.report(new Object[]{"organ", struChangeList});
        }
        if (HussarUtils.isNotEmpty(userChangeList)) {
            this.userAuthorizationChangeReporter.report(new Object[]{"user", userChangeList});
        }
    }

    private static void getChangeList(Map<Long, List<Long>> map, Long roleId, List<Long> newIds, List<Long> changeList) {
        List<Long> oldIds = map.get(roleId);
        if (HussarUtils.isEmpty(newIds) && HussarUtils.isNotEmpty(oldIds)) {
            changeList.addAll(oldIds);
        }
        if (HussarUtils.isNotEmpty(newIds) && HussarUtils.isEmpty(oldIds)) {
            changeList.addAll(newIds);
        }
        if (HussarUtils.isNotEmpty(newIds) && HussarUtils.isNotEmpty(oldIds)) {
            List addList = newIds.stream().filter(item -> !oldIds.contains(item)).collect(Collectors.toList());
            List delList = oldIds.stream().filter(item -> !newIds.contains(item)).collect(Collectors.toList());
            changeList.addAll(addList);
            changeList.addAll(delList);
        }
    }

    private Long insertAppRoleInfo(AppRoleMemberDto appRoleMemberDto) {
        Long groupId;
        if (StringUtils.isBlank((CharSequence)appRoleMemberDto.getRoleName())) {
            throw new BaseException("\u89d2\u8272\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)appRoleMemberDto.getRoleAlias())) {
            throw new BaseException("\u89d2\u8272\u542b\u4e49\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long appId = appRoleMemberDto.getAppId();
        SysRoleGroup group = (SysRoleGroup)this.sysRoleGroupMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysRoleGroup::getFromAppId, (Object)appId));
        if (HussarUtils.isEmpty((Object)group)) {
            SysRoleGroup sysRoleGroup = new SysRoleGroup();
            groupId = IdWorker.getId((Object)sysRoleGroup);
            sysRoleGroup.setId(groupId);
            sysRoleGroup.setAppId(Long.valueOf(1L));
            sysRoleGroup.setFromAppId(appId);
            sysRoleGroup.setParentId(Long.valueOf(1L));
            sysRoleGroup.setGroupName(appRoleMemberDto.getAppName());
            sysRoleGroup.setGroupAlias(appRoleMemberDto.getAppName());
            int groupOrder = this.sysRoleGroupMapper.getMaxOrder() + 1;
            sysRoleGroup.setGroupOrder(Integer.valueOf(groupOrder));
            this.sysRoleGroupMapper.insert(sysRoleGroup);
        } else {
            groupId = group.getId();
        }
        SysRoles sysRoles = new SysRoles();
        Long roleId = IdWorker.getId((Object)sysRoles);
        sysRoles.setId(roleId);
        sysRoles.setRoleName(appRoleMemberDto.getRoleName());
        sysRoles.setRoleAlias(appRoleMemberDto.getRoleAlias());
        sysRoles.setIsSys("0");
        sysRoles.setCorporationId(Long.valueOf(0L));
        sysRoles.setGroupId(groupId);
        sysRoles.setAppId(Long.valueOf(1L));
        sysRoles.setFromAppId(appId);
        Integer order = this.sysRolesMapper.getMaxOrder();
        order = HussarUtils.isEmpty((Object)order) ? Integer.valueOf(1) : Integer.valueOf(order + 1);
        sysRoles.setRoleOrder(order);
        this.sysRolesMapper.insert(sysRoles);
        return roleId;
    }

    private void updateAppRoleInfo(AppRoleMemberDto appRoleMemberDto) {
        SysRoles sysRoles = new SysRoles();
        String roleName = appRoleMemberDto.getRoleName();
        String roleAlias = appRoleMemberDto.getRoleAlias();
        Long roleId = appRoleMemberDto.getRoleId();
        if (HussarUtils.isNotBlank((CharSequence)roleName)) {
            sysRoles.setRoleName(appRoleMemberDto.getRoleName());
        }
        if (HussarUtils.isNotBlank((CharSequence)roleAlias)) {
            sysRoles.setRoleAlias(appRoleMemberDto.getRoleAlias());
        }
        if (HussarUtils.isNotBlank((CharSequence)roleName) || HussarUtils.isNotBlank((CharSequence)roleAlias)) {
            sysRoles.setId(roleId);
            this.sysRolesMapper.updateById(sysRoles);
        }
    }

    private void saveAppRoleMember(AppRoleMemberDto appRoleMemberDto) {
        List userIds;
        List postIds;
        Long roleId = appRoleMemberDto.getRoleId();
        List struIds = appRoleMemberDto.getStruIds();
        if (HussarUtils.isNotEmpty((Object)struIds)) {
            ArrayList<SysStruRole> struRoleList = new ArrayList<SysStruRole>();
            for (Object struId : struIds) {
                SysStruRole struRole = new SysStruRole();
                struRole.setGrantedRole(roleId);
                struRole.setStruId((Long)struId);
                struRoleList.add(struRole);
            }
            if (ToolUtil.isNotEmpty(struRoleList)) {
                this.sysStruRoleService.saveBatch(struRoleList, struRoleList.size());
            }
        }
        if (HussarUtils.isNotEmpty((Object)(postIds = appRoleMemberDto.getPostIds()))) {
            ArrayList<SysPostRole> sysPostRoleList = new ArrayList<SysPostRole>();
            for (Long postId : postIds) {
                SysPostRole sysPostRole = new SysPostRole();
                sysPostRole.setRoleId(roleId);
                sysPostRole.setPostId(postId);
                sysPostRoleList.add(sysPostRole);
            }
            if (ToolUtil.isNotEmpty(sysPostRoleList)) {
                this.sysPostRoleService.saveBatch(sysPostRoleList, sysPostRoleList.size());
            }
        }
        if (HussarUtils.isNotEmpty((Object)(userIds = appRoleMemberDto.getUserIds()))) {
            ArrayList<SysUserRole> userRoleList = new ArrayList<SysUserRole>();
            SecurityUser securityUser = BaseSecurityUtil.getUser();
            LocalDateTime now = LocalDateTime.now();
            for (Long userId : userIds) {
                SysUserRole sysUserRole = new SysUserRole();
                sysUserRole.setUserId(userId);
                sysUserRole.setGrantedRole(roleId);
                sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
                sysUserRole.setLastTime(now);
                sysUserRole.setLastEditor(securityUser.getId());
                sysUserRole.setCreateTime(now);
                sysUserRole.setCreator(securityUser.getId());
                userRoleList.add(sysUserRole);
            }
            if (ToolUtil.isNotEmpty(userRoleList)) {
                this.sysUserRoleService.saveBatch(userRoleList, userRoleList.size());
            }
        }
    }

    private void validateParam(AppRoleDto appRoleDto) {
        StringBuffer sBuffer = new StringBuffer();
        if (StringUtils.isBlank((CharSequence)appRoleDto.getRoleName())) {
            sBuffer.append(",");
            sBuffer.append("\u89d2\u8272\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotBlank((CharSequence)appRoleDto.getRoleName()) && 32 < appRoleDto.getRoleName().length()) {
            sBuffer.append(",");
            sBuffer.append("\u89d2\u8272\u540d\u79f0\u6700\u591a\u53ef\u8f93\u516532\u4e2a\u5b57\u7b26");
        }
        if (0 < sBuffer.length()) {
            String rspStr = sBuffer.substring(1);
            throw new BaseException(rspStr);
        }
    }
}

