/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.authorization.organ.vo.RoleOrgUserVo;
import com.jxdinfo.hussar.authorization.permit.dto.QueryUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.RoleFuncDto;
import com.jxdinfo.hussar.authorization.permit.dto.RoleResDto;
import com.jxdinfo.hussar.authorization.permit.dto.RoleResourceRelationDto;
import com.jxdinfo.hussar.authorization.permit.dto.RoleTreeDto;
import com.jxdinfo.hussar.authorization.permit.dto.RoleTreeQueryDto;
import com.jxdinfo.hussar.authorization.permit.dto.RoleUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.RoleUserQueryDto;
import com.jxdinfo.hussar.authorization.permit.dto.RoleUserRelationDto;
import com.jxdinfo.hussar.authorization.permit.dto.SysRolesDto;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleGroup;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.service.ISysResTypeService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleDataScopeService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleGroupService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.permit.vo.DataScopeVo;
import com.jxdinfo.hussar.authorization.permit.vo.RoleInfoVO;
import com.jxdinfo.hussar.authorization.permit.vo.RoleUserVo;
import com.jxdinfo.hussar.authorization.permit.vo.SysRoleResourceVo;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.mp.base.controller.HussarBaseController;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import com.jxdinfo.hussar.support.security.core.annotation.CheckSafe;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeanUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u89d2\u8272\u7ef4\u62a4"})
@RestController
@RequestMapping(value={"/roleManagerFront"})
public class RoleManagerFrontController
extends HussarBaseController<SysRoles, ISysRolesService> {
    @Resource
    private SysOrgManageService sysOrgManageService;
    @Resource
    private ISysResTypeService iSysResTypeService;
    @Resource
    private ISysRolesService iSysRolesService;
    @Resource
    private ISysRoleResourceService iSysRoleResourceService;
    @Resource
    private ISysUserRoleService iSysUserRoleService;
    @Resource
    private ISysRoleGroupService sysRoleGroupService;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private ISysRoleDataScopeService sysRoleDataScopeService;
    @Resource
    private ISysRoleFunctionsService iSysRoleFunctionsService;
    @Resource
    private SysOrgManageService orgMaintenanceService;

    @ApiOperation(value="\u52a0\u8f7d\u89d2\u8272\u6811", notes="\u52a0\u8f7d\u89d2\u8272\u6811")
    @GetMapping(value={"/roleTree"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u52a0\u8f7d\u89d2\u8272\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> roleTree(@ApiParam(value="\u89d2\u8272\u6811dto") RoleTreeDto roleTreeDto) {
        return ApiResponse.success((Object)this.iSysRolesService.getRoleMergeTree(roleTreeDto));
    }

    @ApiOperation(value="\u5224\u65ad\u7528\u6237\u662f\u5426\u6709\u7ec4\u7ec7\u89d2\u8272", notes="\u5224\u65ad\u7528\u6237\u662f\u5426\u6709\u7ec4\u7ec7\u89d2\u8272")
    @GetMapping(value={"/isContainOrganRole"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u5224\u65ad\u7528\u6237\u662f\u5426\u6709\u7ec4\u7ec7\u89d2\u8272", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Boolean> isContainOrganRole(@ApiParam(value="\u89d2\u8272\u6811dto") RoleTreeDto roleTreeDto) {
        return ApiResponse.success((Object)this.iSysRolesService.isContainsOrganRole(roleTreeDto));
    }

    @ApiOperation(value="\u89d2\u8272\u6811\u61d2\u52a0\u8f7d", notes="\u89d2\u8272\u6811\u61d2\u52a0\u8f7d")
    @GetMapping(value={"/lazyRoleTree"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u89d2\u8272\u6811\u61d2\u52a0\u8f7d", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> lazyRoleTree(@ApiParam(value="\u89d2\u8272\u6811dto") RoleTreeDto roleTreeDto) {
        return ApiResponse.success((Object)this.iSysRolesService.getRoleTreeByLazy(roleTreeDto));
    }

    @ApiOperation(value="\u89d2\u8272\u5206\u7ec4\u7684\u6811\u72b6\u6570\u636e\u52a0\u8f7d", notes="\u89d2\u8272\u5206\u7ec4\u7684\u6811\u72b6\u6570\u636e\u52a0\u8f7d")
    @GetMapping(value={"/roleGroupTree"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u83b7\u53d6\u89d2\u8272\u5206\u7ec4\u7684\u6811\u72b6\u7ed3\u6784", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> loadRoleGruopTree(@ApiParam(value="\u5e94\u7528id") Long appId) {
        return ApiResponse.success((Object)this.iSysRolesService.getRoleGroupTree(appId));
    }

    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u5217\u8868", notes="\u83b7\u53d6\u89d2\u8272\u5217\u8868")
    @GetMapping(value={"/roleInfoList"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u83b7\u53d6\u89d2\u8272\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @ApiOperationSupport(ignoreParameters={"records", "orders", "total", "optimizeCountSql", "searchCount", "optimizeJoinOfCountSql", "countId", "maxLimit", "pages"})
    public ApiResponse<IPage> roleInfoList(@ApiParam(value="\u5206\u9875\u4fe1\u606f") Page page, @ApiParam(value="\u89d2\u8272\u6811\u67e5\u8be2dto") RoleTreeQueryDto roleTreeQueryDto) {
        roleTreeQueryDto.setGroupName(roleTreeQueryDto.getGroupName().replace("%", "\\%").replace("_", "\\_"));
        roleTreeQueryDto.setRoleName(roleTreeQueryDto.getRoleName().replace("%", "\\%").replace("_", "\\_"));
        return ApiResponse.success((Object)this.iSysRolesService.getRoleInfoList(page, roleTreeQueryDto));
    }

    @ApiOperation(value="\u67e5\u8be2\u5206\u7ea7\u7ba1\u7406\u5458\u767b\u5f55\u65f6\u7684\u89d2\u8272\u5217\u8868", notes="\u67e5\u8be2\u5206\u7ea7\u7ba1\u7406\u5458\u767b\u5f55\u65f6\u7684\u89d2\u8272\u5217\u8868")
    @GetMapping(value={"/roleInfoListForGradeadmin"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u67e5\u8be2\u5206\u7ea7\u7ba1\u7406\u5458\u767b\u5f55\u65f6\u7684\u89d2\u8272\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @ApiOperationSupport(ignoreParameters={"records", "orders", "total", "optimizeCountSql", "searchCount", "optimizeJoinOfCountSql", "countId", "maxLimit", "pages"})
    public ApiResponse<IPage> roleInfoListForGradeadmin(@ApiParam(value="\u5206\u9875\u4fe1\u606f") Page page) {
        return ApiResponse.success((Object)this.iSysRolesService.getRoleInfoListForGradeadmin(page));
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u89d2\u8272", notes="\u83b7\u53d6\u7528\u6237\u89d2\u8272")
    @CheckPermission(value={"roleManager:getUserRole"})
    @GetMapping(value={"/getUserRole"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u67e5\u8be2\u7528\u6237\u89d2\u8272", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<Long>> getUserRole(@ApiParam(value="\u7528\u6237id") @RequestParam Long userId) {
        return ApiResponse.success((Object)this.iSysRolesService.getUserRoleList(userId));
    }

    @ApiOperation(value="\u52a0\u8f7d\u5f53\u524d\u7528\u6237\u7684\u89d2\u8272\u6811", notes="\u52a0\u8f7d\u5f53\u524d\u7528\u6237\u7684\u89d2\u8272\u6811")
    @PostMapping(value={"/selfRoleTree"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u67e5\u8be2\u5f53\u524d\u7528\u6237\u7684\u89d2\u8272\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> selfRoleTree(@ApiParam(value="\u89d2\u8272ids") @RequestBody String roleIds) {
        String[] ids = roleIds == null ? "".split(",") : roleIds.split(",");
        return ApiResponse.success((Object)this.iSysRolesService.getSelfRoleTree(ids));
    }

    @ApiOperation(value="\u52a0\u8f7d\u8d44\u6e90\u6811", notes="\u52a0\u8f7d\u8d44\u6e90\u6811")
    @GetMapping(value={"/resourceTree"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u67e5\u8be2\u8d44\u6e90\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> resourceTree() {
        return ApiResponse.success((Object)this.iSysResTypeService.getResourceTree());
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u7ba1\u7406\u7ec4\u7ec7\u4fe1\u606f", notes="\u83b7\u53d6\u7528\u6237\u7ba1\u7406\u7ec4\u7ec7\u4fe1\u606f")
    @GetMapping(value={"/getOrganAlias"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u83b7\u53d6\u7528\u6237\u7ba1\u7406\u7ec4\u7ec7\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Object> getOrganAlias(@ApiParam(value="\u8282\u70b9id") @RequestParam String nodeId) {
        SysStru stru = (SysStru)this.sysOrgManageService.getById((Serializable)Long.valueOf(Long.parseLong(nodeId)));
        return ApiResponse.success((String)(ToolUtil.isEmpty((Object)stru) ? "" : stru.getOrganAlias()));
    }

    @ApiOperation(value="\u6839\u636e\u89d2\u8272ID\u83b7\u53d6\u7528\u6237\u7ba1\u7406\u7ec4\u7ec7\u4fe1\u606f", notes="\u6839\u636e\u89d2\u8272ID\u83b7\u53d6\u7528\u6237\u7ba1\u7406\u7ec4\u7ec7\u4fe1\u606f")
    @GetMapping(value={"/getOrganAliasByRoleId"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u6839\u636e\u89d2\u8272ID\u83b7\u53d6\u7528\u6237\u7ba1\u7406\u7ec4\u7ec7\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Object> getOrganAliasByRoleId(@ApiParam(value="\u89d2\u8272id") @RequestParam String roleId) {
        this.orgMaintenanceService.checkOrganInfo((Object)roleId, "checkRoleId");
        SysRoles sysRoles = (SysRoles)this.iSysRolesService.getById((Serializable)Long.valueOf(Long.parseLong(roleId)));
        Long corporationId = sysRoles.getCorporationId();
        if (HussarUtils.isEmpty((Object)corporationId)) {
            return ApiResponse.success((String)"");
        }
        String depId = String.valueOf(corporationId);
        SysStru stru = (SysStru)this.sysOrgManageService.getById((Serializable)Long.valueOf(Long.parseLong(depId)));
        return ApiResponse.success((String)(ToolUtil.isEmpty((Object)stru) ? "" : stru.getOrganAlias()));
    }

    @ApiOperation(value="\u65b0\u589e\u89d2\u8272", notes="\u65b0\u589e\u89d2\u8272")
    @PostMapping(value={"/addRole"})
    @CheckPermission(value={"roleManagerFront:addRole"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u65b0\u589e\u89d2\u8272\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Long> addRole(@ApiParam(value="\u89d2\u8272dto") @RequestBody SysRolesDto sysRolesDto) {
        if (ToolUtil.isEmpty((Object)sysRolesDto.getId())) {
            Integer order = this.iSysRolesService.getMaxOrder();
            order = HussarUtils.isEmpty((Object)order) ? Integer.valueOf(1) : Integer.valueOf(order + 1);
            sysRolesDto.setRoleOrder(order);
            return ApiResponse.success((Object)this.iSysRolesService.saveRole(sysRolesDto), (String)"\u89d2\u8272\u57fa\u672c\u4fe1\u606f\u4fdd\u5b58\u6210\u529f\uff01");
        }
        SysRoles sysRole = new SysRoles();
        BeanUtils.copyProperties((Object)sysRolesDto, (Object)sysRole);
        this.iSysRolesService.updateRole(sysRole);
        return ApiResponse.success((Object)sysRolesDto.getId(), (String)"\u89d2\u8272\u57fa\u672c\u4fe1\u606f\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u4fee\u6539\u89d2\u8272", notes="\u4fee\u6539\u89d2\u8272")
    @PostMapping(value={"/editRole"})
    @CheckPermission(value={"roleManagerFront:editRole"})
    @CacheEvict(value={"authorization_info"}, allEntries=true)
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u4fee\u6539\u89d2\u8272\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse editRole(@ApiParam(value="\u89d2\u8272\u4fe1\u606f") @RequestBody SysRoles sysRoles) {
        this.iSysRolesService.updateRole(sysRoles);
        return ApiResponse.success((String)"\u89d2\u8272\u57fa\u672c\u4fe1\u606f\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u770b\u89d2\u8272\u4fe1\u606f", notes="\u67e5\u770b\u89d2\u8272\u4fe1\u606f")
    @GetMapping(value={"/roleView"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u67e5\u8be2\u89d2\u8272\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<RoleInfoVO> roleView(@ApiParam(value="\u89d2\u8272id") @RequestParam Long id) {
        return ApiResponse.success((Object)this.iSysRolesService.getRoleViewMap(id));
    }

    @ApiOperation(value="\u67e5\u770b\u89d2\u8272\u8d44\u6e90\u4fe1\u606f", notes="\u67e5\u770b\u89d2\u8272\u8d44\u6e90\u4fe1\u606f")
    @GetMapping(value={"/roleResourceView"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u67e5\u8be2\u89d2\u8272\u8d44\u6e90\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysRoleResource>> getRoleResourceView(@ApiParam(value="\u89d2\u8272id") @RequestParam String id) {
        return ApiResponse.success((Object)this.iSysRolesService.getRoleResource(id));
    }

    @ApiOperation(value="\u5220\u9664\u89d2\u8272", notes="\u5220\u9664\u89d2\u8272")
    @PostMapping(value={"/delRole"})
    @CheckPermission(value={"roleManagerFront:delRole"})
    @CheckSafe
    @CacheEvict(value={"authorization_info"}, allEntries=true)
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u5220\u9664\u89d2\u8272\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse delRole(@ApiParam(value="\u89d2\u8272id") @RequestBody Long id) {
        return this.iSysRolesService.deleteRole(id);
    }

    @ApiOperation(value="\u4fdd\u5b58\u89d2\u8272\u8d44\u6e90", notes="\u4fdd\u5b58\u89d2\u8272\u8d44\u6e90")
    @CheckPermission(value={"roleManager:saveResource"})
    @PostMapping(value={"/saveResource"})
    @CacheEvict(value={"authorization_info", "menu_info"}, allEntries=true)
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u65b0\u589e\u89d2\u8272\u8d44\u6e90\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse saveResource(@ApiParam(value="\u89d2\u8272\u8d44\u6e90dto") @RequestBody RoleResourceRelationDto roleResourceDto) {
        this.iSysRoleResourceService.saveRoleResource(roleResourceDto);
        return ApiResponse.success((String)"\u89d2\u8272\u5173\u8054\u8d44\u6e90\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u89d2\u8272\u56de\u6536\u6743\u9650", notes="\u89d2\u8272\u56de\u6536\u6743\u9650")
    @PostMapping(value={"/reclaimPerm"})
    @CheckPermission(value={"roleManagerFront:reclaimPerm"})
    @CacheEvict(value={"authorization_info"}, allEntries=true)
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u56de\u6536\u89d2\u8272\u6743\u9650", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse reclaimPerm(@ApiParam(value="\u89d2\u8272id") @RequestBody Long id) {
        this.iSysRolesService.reclaimPerm(id);
        return ApiResponse.success((String)"\u56de\u6536\u6743\u9650\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u89d2\u8272\u662f\u5426\u6709\u6743\u9650", notes="\u89d2\u8272\u662f\u5426\u6709\u6743\u9650")
    @GetMapping(value={"/queryPerm"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u67e5\u8be2\u89d2\u8272\u662f\u5426\u6709\u6743\u9650", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysRoleResource>> queryPerm(@ApiParam(value="\u89d2\u8272id") @RequestParam String id) {
        return ApiResponse.success((Object)this.iSysRoleResourceService.queryPerm(id));
    }

    @ApiOperation(value="\u6dfb\u52a0\u89d2\u8272\u5206\u7ec4\u4fe1\u606f", notes="\u6dfb\u52a0\u89d2\u8272\u5206\u7ec4\u4fe1\u606f")
    @PostMapping(value={"/saveGroup"})
    @CheckPermission(value={"roleManagerFront:saveGroup"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u65b0\u589e\u89d2\u8272\u5206\u7ec4\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse saveGroup(@ApiParam(value="\u89d2\u8272\u5206\u7ec4\u4fe1\u606f") @RequestBody SysRoleGroup sysRoleGroup) {
        return this.iSysRolesService.saveGroup(sysRoleGroup);
    }

    @ApiOperation(value="\u4fee\u6539\u89d2\u8272\u5206\u7ec4\u4fe1\u606f", notes="\u4fee\u6539\u89d2\u8272\u5206\u7ec4\u4fe1\u606f")
    @PostMapping(value={"/editGroup"})
    @CheckPermission(value={"roleManagerFront:editGroup"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u4fee\u6539\u89d2\u8272\u5206\u7ec4\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse editGroup(@ApiParam(value="\u89d2\u8272\u5206\u7ec4\u4fe1\u606f") @RequestBody SysRoleGroup sysRoleGroup) {
        return this.iSysRolesService.updateGroup(sysRoleGroup);
    }

    @ApiOperation(value="\u67e5\u8be2\u662f\u5426\u5df2\u6709\u89d2\u8272", notes="\u67e5\u8be2\u662f\u5426\u5df2\u6709\u89d2\u8272")
    @CheckPermission(value={"roleManagerFront:sameRoleName"})
    @GetMapping(value={"/sameRoleName"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u67e5\u8be2\u662f\u5426\u5df2\u6709\u89d2\u8272", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysRoles>> sameRoleName(@ApiParam(value="\u89d2\u8272\u540d\u79f0") @RequestParam String sameRoleName, @ApiParam(value="\u5e94\u7528id") @RequestParam(required=false) Long appId) {
        if (HussarUtils.isEmpty((Object)appId)) {
            appId = 1L;
        }
        List sysRoles = this.iSysRolesService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRoles::getRoleName, (Object)sameRoleName)).eq(SysRoles::getAppId, (Object)appId)).eq(SysRoles::getFromAppId, (Object)1L));
        return ApiResponse.success((Object)sysRoles);
    }

    @ApiOperation(value="\u67e5\u8be2\u662f\u5426\u5df2\u6709\u89d2\u8272", notes="\u67e5\u8be2\u662f\u5426\u5df2\u6709\u89d2\u8272")
    @GetMapping(value={"/sameRoleNameById"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u6839\u636e\u89d2\u8272ID\u67e5\u8be2\u662f\u5426\u5df2\u6709\u89d2\u8272", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysRoles>> sameRoleNameById(@ApiParam(value="\u89d2\u8272\u540d\u79f0") @RequestParam String sameRoleName, @ApiParam(value="\u89d2\u8272id") @RequestParam Long roleId, @ApiParam(value="\u5e94\u7528id") @RequestParam(required=false) Long appId) {
        if (HussarUtils.isEmpty((Object)appId)) {
            appId = 1L;
        }
        return ApiResponse.success((Object)this.iSysRolesService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRoles::getRoleName, (Object)sameRoleName)).ne(SysRoles::getId, (Object)roleId)).eq(SysRoles::getAppId, (Object)appId)).eq(SysRoles::getFromAppId, (Object)1L)));
    }

    @ApiOperation(value="\u67e5\u8be2\u662f\u5426\u5df2\u6709\u5206\u7ec4", notes="\u67e5\u8be2\u662f\u5426\u5df2\u6709\u5206\u7ec4")
    @CheckPermission(value={"roleManagerFront:sameGroupName"})
    @GetMapping(value={"/sameGroupName"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u6839\u636e\u540d\u79f0\u67e5\u8be2\u662f\u5426\u6709\u91cd\u590d\u5206\u7ec4", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysRoleGroup>> sameGroupName(@ApiParam(value="\u89d2\u8272\u5206\u7ec4\u540d\u79f0") @RequestParam String sameGroupName, @ApiParam(value="\u5e94\u7528id") @RequestParam(required=false) Long appId) {
        if (HussarUtils.isEmpty((Object)appId)) {
            appId = 1L;
        }
        return ApiResponse.success((Object)this.sysRoleGroupService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRoleGroup::getGroupName, (Object)sameGroupName)).eq(SysRoleGroup::getAppId, (Object)appId)));
    }

    @ApiOperation(value="\u67e5\u8be2\u89d2\u8272\u5206\u7ec4\u4e0b\u7684\u89d2\u8272", notes="\u67e5\u8be2\u89d2\u8272\u5206\u7ec4\u4e0b\u7684\u89d2\u8272")
    @CheckPermission(value={"roleManagerFront:searchRoleToGroup"})
    @GetMapping(value={"/searchRoleToGroup"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u6839\u636e\u5206\u7ec4ID\u67e5\u8be2\u89d2\u8272", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysRoles>> searchRoleToGroup(@ApiParam(value="\u89d2\u8272\u5206\u7ec4id") @RequestParam Long id) {
        return ApiResponse.success((Object)this.iSysRolesService.list((Wrapper)new LambdaQueryWrapper().eq(SysRoles::getGroupId, (Object)id)));
    }

    @ApiOperation(value="\u5220\u9664\u89d2\u8272\u5206\u7ec4", notes="\u5220\u9664\u89d2\u8272\u5206\u7ec4")
    @PostMapping(value={"/delGroup"})
    @CheckPermission(value={"roleManagerFront:delGroup"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u5220\u9664\u89d2\u8272\u5206\u7ec4", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse delGroup(@ApiParam(value="\u89d2\u8272\u5206\u7ec4id") @RequestBody Long id) {
        return this.iSysRolesService.deleteGroup(id);
    }

    @ApiOperation(value="\u89d2\u8272\u5206\u7ec4\u67e5\u770b\u9875\u9762", notes="\u89d2\u8272\u5206\u7ec4\u67e5\u770b\u9875\u9762")
    @GetMapping(value={"/roleGroupViewPage"})
    @CheckPermission(value={"roleManagerFront:roleGroupViewPage"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u67e5\u8be2\u89d2\u8272\u5206\u7ec4\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<SysRoleGroup> roleGroupViewPage(@ApiParam(value="\u89d2\u8272\u5206\u7ec4id") @RequestParam Long id) {
        return ApiResponse.success((Object)this.sysRoleGroupService.getById((Serializable)id));
    }

    @ApiOperation(value="\u89d2\u8272\u5173\u8054\u7528\u6237\u67e5\u770b\u6811", notes="\u89d2\u8272\u5173\u8054\u7528\u6237\u67e5\u770b\u6811")
    @CheckPermission(value={"roleManagerFront:roleUserTreeView"})
    @GetMapping(value={"/roleUserTreeView"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u67e5\u8be2\u89d2\u8272\u5173\u8054\u7528\u6237\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> getRoleUserTreeView(@ApiParam(value="\u89d2\u8272id") @RequestParam(required=false) Long roleId) {
        return ApiResponse.success((Object)this.iSysRolesService.getRoleUserTreeView(roleId));
    }

    @ApiOperation(value="\u61d2\u52a0\u8f7d\u83b7\u53d6\u89d2\u8272\u7528\u6237\u6811", notes="\u61d2\u52a0\u8f7d\u83b7\u53d6\u89d2\u8272\u7528\u6237\u6811")
    @CheckPermission(value={"roleManager:lazyRoleUserTreeView"})
    @GetMapping(value={"/lazyRoleUserTreeView"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u61d2\u52a0\u8f7d\u67e5\u8be2\u89d2\u8272\u7528\u6237\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> getLazyRoleUserTreeView(@ApiParam(value="\u89d2\u8272id") @RequestParam Long roleId, @ApiParam(value="\u8282\u70b9id") Long nodeId) {
        return ApiResponse.success((Object)this.sysUsersService.getLazyUserByRole(roleId, nodeId));
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u90e8\u95e8\u4e0b\u7684\u7528\u6237\u5173\u8054\u89d2\u8272\u7684\u4fe1\u606f", notes="\u83b7\u53d6\u5f53\u524d\u90e8\u95e8\u4e0b\u7684\u7528\u6237\u5173\u8054\u89d2\u8272\u7684\u4fe1\u606f")
    @CheckPermission(value={"roleManagerFront:getRoleOrgUser"})
    @GetMapping(value={"/getRoleOrgUser"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u67e5\u8be2\u5f53\u524d\u90e8\u95e8\u4e0b\u7684\u7528\u6237\u5173\u8054\u89d2\u8272\u7684\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @ApiOperationSupport(ignoreParameters={"records", "orders", "total", "optimizeCountSql", "searchCount", "optimizeJoinOfCountSql", "countId", "maxLimit", "pages"})
    public ApiResponse<IPage<RoleOrgUserVo>> getRoleOrgUsers(@ApiParam(value="\u5206\u9875\u4fe1\u606f") Page<RoleOrgUserVo> page, @ApiParam(value="\u89d2\u8272\u5173\u8054\u7528\u6237\u67e5\u8be2dto") RoleUserQueryDto roleUserQueryDto) {
        return ApiResponse.success((Object)this.sysOrgManageService.getRoleOrgUser(page, roleUserQueryDto));
    }

    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u5173\u8054\u7528\u6237\u65e0\u5206\u9875", notes="\u83b7\u53d6\u89d2\u8272\u5173\u8054\u7528\u6237\u65e0\u5206\u9875")
    @CheckPermission(value={"roleManagerFront:getRoleOrgUser"})
    @GetMapping(value={"/getAllUsers"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u83b7\u53d6\u89d2\u8272\u5173\u8054\u7528\u6237\u65e0\u5206\u9875", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<RoleOrgUserVo>> getAllUsers(@ApiParam(value="\u7528\u6237\u5173\u8054\u89d2\u8272\u67e5\u8be2dto") RoleUserQueryDto roleUserQueryDto) {
        return ApiResponse.success((Object)this.sysOrgManageService.getAllUserByRole(roleUserQueryDto));
    }

    @ApiOperation(value="\u6dfb\u52a0\u5220\u9664\u7528\u6237\u89d2\u8272", notes="\u6dfb\u52a0\u5220\u9664\u7528\u6237\u89d2\u8272")
    @CheckPermission(value={"roleManagerFront:addOrDelUserRole"})
    @PostMapping(value={"/addOrDelUserRole"})
    @CacheEvict(value={"authorization_info", "resource_info", "menu_info"}, allEntries=true)
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u65b0\u589e\u6216\u5220\u9664\u7528\u6237\u89d2\u8272\u6570\u636e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse getRoleOrgUser(@ApiParam(value="\u89d2\u8272\u5173\u8054\u7528\u6237dto") @RequestBody RoleUserDto roleUserDto) {
        return this.iSysUserRoleService.saveOrDelUserRole(roleUserDto);
    }

    @ApiOperation(value="\u89d2\u8272\u5173\u8054\u7528\u6237\u4fee\u6539\u6811", notes="\u89d2\u8272\u5173\u8054\u7528\u6237\u4fee\u6539\u6811")
    @CheckPermission(value={"roleManager:roleUserTreeEdit"})
    @GetMapping(value={"/roleUserTreeEdit"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u67e5\u8be2\u89d2\u8272\u5173\u8054\u7528\u6237\u4fee\u6539\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> getRoleUserTreeEdit(@ApiParam(value="\u89d2\u8272id") @RequestParam String roleId) {
        return ApiResponse.success((Object)this.iSysRolesService.getRoleUserTreeEdit(roleId));
    }

    @ApiOperation(value="\u89d2\u8272\u5173\u8054\u7528\u6237\u65b0\u589e\u6811", notes="\u89d2\u8272\u5173\u8054\u7528\u6237\u65b0\u589e\u6811")
    @CheckPermission(value={"roleManager:roleUserTreeAdd"})
    @GetMapping(value={"/roleUserTreeAdd"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u67e5\u8be2\u89d2\u8272\u5173\u8054\u7528\u6237\u65b0\u589e\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> getRoleUserTreeAdd() {
        return ApiResponse.success((Object)this.iSysRolesService.getRoleUserTreeAdd());
    }

    @ApiOperation(value="\u89d2\u8272\u65b0\u589e\u5173\u8054\u7528\u6237\u4fdd\u5b58", notes="\u89d2\u8272\u65b0\u589e\u5173\u8054\u7528\u6237\u4fdd\u5b58")
    @CheckPermission(value={"roleManager:saveRoleUserAdd"})
    @PostMapping(value={"/saveRoleUserAdd"})
    @CacheEvict(value={"authorization_info", "menu_info"}, allEntries=true)
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u65b0\u589e\u89d2\u8272\u5173\u8054\u7528\u6237", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse saveRoleUsersAdd(@ApiParam(value="\u7528\u6237\u89d2\u8272\u5173\u7cfbdto") @RequestBody RoleUserRelationDto roleUserRelationDto) {
        this.iSysRoleResourceService.saveRoleUserAdd(roleUserRelationDto);
        return ApiResponse.success((String)"\u89d2\u8272\u5173\u8054\u7528\u6237\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u89d2\u8272\u4fee\u6539\u5173\u8054\u7528\u6237edit", notes="\u89d2\u8272\u4fee\u6539\u5173\u8054\u7528\u6237edit")
    @CheckPermission(value={"roleManager:saveRoleUserEdit"})
    @PostMapping(value={"/saveRoleUserEdit"})
    @CacheEvict(value={"authorization_info", "menu_info"}, allEntries=true)
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u65b0\u589e\u89d2\u8272\u5173\u8054\u7528\u6237", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse saveRoleUsersEdit(@ApiParam(value="\u7528\u6237\u89d2\u8272\u5173\u7cfbdto") @RequestBody RoleUserRelationDto roleUserRelationDto) {
        this.iSysRoleResourceService.updateRoleUserEdit(roleUserRelationDto);
        return ApiResponse.success((String)"\u89d2\u8272\u5173\u8054\u7528\u6237\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u52a0\u8f7d\u89d2\u8272\u5206\u7ec4\u6392\u5e8f\u6811", notes="\u52a0\u8f7d\u89d2\u8272\u5206\u7ec4\u6392\u5e8f\u6811")
    @CheckPermission(value={"roleManager:groupOrderTree"})
    @GetMapping(value={"/groupOrderTree"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u52a0\u8f7d\u89d2\u8272\u5206\u7ec4\u6392\u5e8f\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> groupOrderTree(@ApiParam(value="\u5e94\u7528id") @RequestParam Long appId) {
        return ApiResponse.success((Object)this.iSysRolesService.getGroupOrderTree(appId));
    }

    @ApiOperation(value="\u4fdd\u5b58\u89d2\u8272\u5206\u7ec4\u6392\u5e8f", notes="\u4fdd\u5b58\u89d2\u8272\u5206\u7ec4\u6392\u5e8f")
    @PostMapping(value={"/saveGroupOrder"})
    @CheckPermission(value={"roleManagerFront:saveGroupOrder"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u4fee\u6539\u89d2\u8272\u5206\u7ec4\u6392\u5e8f\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse saveGroupOrder(@ApiParam(value="\u89d2\u8272\u5206\u7ec4id\u96c6\u5408") @RequestBody List<Long> idList) {
        this.iSysRolesService.updateGroupOrder(idList);
        return ApiResponse.success((String)"\u6392\u5e8f\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u52a0\u8f7d\u89d2\u8272\u6392\u5e8f\u6811", notes="\u52a0\u8f7d\u89d2\u8272\u6392\u5e8f\u6811")
    @CheckPermission(value={"roleManagerFront:roleOrderTree"})
    @GetMapping(value={"/roleOrderTree"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u83b7\u53d6\u89d2\u8272\u5206\u7ec4\u6392\u5e8f\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> roleOrderTree(@ApiParam(value="\u4e0a\u7ea7\u8282\u70b9id") @RequestParam Long parentId) {
        return ApiResponse.success((Object)this.iSysRolesService.getRoleOrderTree(parentId));
    }

    @ApiOperation(value="\u4fdd\u5b58\u89d2\u8272\u6392\u5e8f", notes="\u4fdd\u5b58\u89d2\u8272\u6392\u5e8f")
    @PostMapping(value={"/saveRoleOrder"})
    @CheckPermission(value={"roleManagerFront:saveRoleOrder"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u4fdd\u5b58\u89d2\u8272\u6392\u5e8f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse saveRoleOrder(@ApiParam(value="\u89d2\u8272id\u96c6\u5408") @RequestBody List<Long> idList) {
        this.iSysRolesService.updateRoleOrder(idList);
        return ApiResponse.success((String)"\u6392\u5e8f\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u89d2\u8272\u6570\u636e\u5bfc\u51fa", notes="\u89d2\u8272\u6570\u636e\u5bfc\u51fa")
    @PostMapping(value={"/exportData"})
    @CheckPermission(value={"roleManagerFront:exportData"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u89d2\u8272\u6570\u636e\u5bfc\u51fa", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public void exportData(@ApiParam(value="\u8981\u5bfc\u51fa\u7684\u89d2\u8272ids") @RequestBody String ids, HttpServletResponse response) {
        List<String> idList = Arrays.asList(ids == null ? "".split(",") : ids.split(","));
        this.iSysRolesService.exportData(idList, response);
    }

    @Deprecated
    @ApiOperation(value="\u89d2\u8272\u6570\u636e\u5bfc\u51fa", notes="\u89d2\u8272\u6570\u636e\u5bfc\u51fa")
    @PostMapping(path={"/checkResource"})
    @CheckPermission(value={"roleManagerFront:checkResource"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u68c0\u67e5\u8d44\u6e90\u6709\u6ca1\u6709\u8d4b\u4e88\u522b\u7684\u89d2\u8272", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysRoleResourceVo>> checkResource(@ApiParam(value="\u89d2\u8272\u8d44\u6e90\u4fdd\u5b58dto") @RequestBody RoleResDto roleResDto) {
        Long roleId = roleResDto.getRoleId();
        String resourceIds = roleResDto.getResourceId();
        return ApiResponse.success((Object)this.iSysRoleResourceService.selectResource(roleId, resourceIds));
    }

    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u6570\u636e\u6743\u9650", notes="\u83b7\u53d6\u89d2\u8272\u6570\u636e\u6743\u9650")
    @GetMapping(value={"/dataScope"})
    @CheckPermission(value={"roleManager:dataScope"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u83b7\u53d6\u89d2\u8272\u6570\u636e\u6743\u9650", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<DataScopeVo> getRoleDataScope(@ApiParam(value="\u89d2\u8272id") @RequestParam Long roleId) {
        return ApiResponse.success((Object)this.sysRoleDataScopeService.getRoleDateScope(roleId));
    }

    @ApiOperation(value="\u4fdd\u5b58\u89d2\u8272\u6570\u636e\u6743\u9650", notes="\u4fdd\u5b58\u89d2\u8272\u6570\u636e\u6743\u9650")
    @PostMapping(value={"/saveDataScope"})
    @CheckPermission(value={"roleManager:saveDataScope"})
    @CacheEvict(value={"data_scope_list"}, allEntries=true)
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u4fdd\u5b58\u89d2\u8272\u6570\u636e\u6743\u9650", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse saveDataScope(@ApiParam(value="\u6570\u636e\u6743\u9650vo") @RequestBody DataScopeVo dataScopeVo) {
        return this.sysRoleDataScopeService.saveDateScope(dataScopeVo);
    }

    @ApiOperation(value="\u4fdd\u5b58\u89d2\u8272\u529f\u80fd", notes="\u4fdd\u5b58\u89d2\u8272\u529f\u80fd")
    @PostMapping(value={"/saveFunction"})
    @CacheEvict(value={"authorization_info", "menu_info", "resource_info"}, allEntries=true)
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u4fdd\u5b58\u89d2\u8272\u529f\u80fd", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    @CheckPermission(value={"roleManagerFront:saveFunction"})
    public ApiResponse saveFunction(@ApiParam(value="\u89d2\u8272\u529f\u80fd\u4fdd\u5b58dto") @RequestBody RoleFuncDto roleFuncDto) {
        this.iSysRolesService.saveFunctions(roleFuncDto);
        return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u9009\u62e9\u8d44\u6e90tab\u4fdd\u5b58\u89d2\u8272\u5173\u8054\u8d44\u6e90", notes="\u9009\u62e9\u8d44\u6e90tab\u4fdd\u5b58\u89d2\u8272\u5173\u8054\u8d44\u6e90")
    @PostMapping(value={"/saveRealResource"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u4fdd\u5b58\u89d2\u8272\u8d44\u6e90", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    @CacheEvict(value={"resource_info"}, allEntries=true)
    @CheckPermission(value={"roleManagerFront:saveRealResource"})
    public ApiResponse saveResource(@ApiParam(value="\u89d2\u8272\u8d44\u6e90\u4fdd\u5b58dto") @RequestBody RoleResDto roleResDto) {
        this.iSysRolesService.saveResources(roleResDto);
        return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u5df2\u5173\u8054\u7684\u529f\u80fd", notes="\u83b7\u53d6\u89d2\u8272\u5df2\u5173\u8054\u7684\u529f\u80fd")
    @GetMapping(value={"/getRelaFunction"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u83b7\u53d6\u89d2\u8272\u5df2\u5173\u8054\u7684\u529f\u80fd", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysRoleFunctions>> getChooseAuthority(@ApiParam(value="\u89d2\u8272id") @RequestParam Long roleId) {
        return ApiResponse.success((Object)this.iSysRoleFunctionsService.getRoleFunctions(roleId));
    }

    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u5df2\u5173\u8054\u7684\u8d44\u6e90", notes="\u83b7\u53d6\u89d2\u8272\u5df2\u5173\u8054\u7684\u8d44\u6e90")
    @GetMapping(value={"/getRealResource"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u83b7\u53d6\u89d2\u8272\u5df2\u5173\u8054\u7684\u8d44\u6e90", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysRoleResource>> getRelaResource(@ApiParam(value="\u89d2\u8272id") @RequestParam String roleId) {
        return ApiResponse.success((Object)this.iSysRoleResourceService.getRealResource(roleId));
    }

    @ApiOperation(value="\u53ea\u52a0\u8f7d\u5f53\u524d\u89d2\u8272\u7684\u529f\u80fd\u6811", notes="\u53ea\u52a0\u8f7d\u5f53\u524d\u89d2\u8272\u7684\u529f\u80fd\u6811")
    @PostMapping(value={"/selfFunctionTree"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u83b7\u53d6\u5f53\u524d\u89d2\u8272\u7684\u529f\u80fd\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> selfResourceTree(@ApiParam(value="\u529f\u80fdid") @RequestBody JSONObject jsonObject) {
        String functionIds = jsonObject.getString("functionIds");
        List result = this.iSysRoleFunctionsService.selfFunctionTree(functionIds);
        return ApiResponse.success((Object)result);
    }

    @ApiOperation(value="\u53ea\u52a0\u8f7d\u5f53\u524d\u89d2\u8272\u7684\u8d44\u6e90\u6811", notes="\u53ea\u52a0\u8f7d\u5f53\u524d\u89d2\u8272\u7684\u8d44\u6e90\u6811")
    @PostMapping(value={"/selfResourceTree"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u83b7\u53d6\u5f53\u524d\u89d2\u8272\u7684\u8d44\u6e90\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> selfRealResourceTree(@ApiParam(value="\u8d44\u6e90id") @RequestBody JSONObject jsonObject) {
        String resourceIds = jsonObject.getString("resourceIds");
        List result = this.iSysRoleResourceService.selfResourceTree(resourceIds);
        return ApiResponse.success((Object)result);
    }

    @ApiOperation(value="\u89d2\u8272\u5173\u8054\u7528\u6237\u6279\u91cf\u67e5\u8be2", notes="\u89d2\u8272\u5173\u8054\u7528\u6237\u6279\u91cf\u67e5\u8be2")
    @GetMapping(path={"/searchUserListBatch"})
    @CheckPermission(value={"roleManagerFront:searchUserListBatch"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u89d2\u8272\u5173\u8054\u7528\u6237\u6279\u91cf\u67e5\u8be2", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<RoleUserVo>> searchUserListBatch(@ApiParam(value="\u5206\u9875\u4fe1\u606f") PageInfo pageInfo, @ApiParam(value="\u67e5\u8be2\u7528\u6237dto") QueryUserDto queryUserDto) {
        return ApiResponse.success((Object)this.iSysRolesService.searchUserListBatch(pageInfo, queryUserDto));
    }
}

