/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysOfficeMapper;
import com.jxdinfo.hussar.authorization.organ.model.SysOffice;
import com.jxdinfo.hussar.authorization.organ.service.ISysOfficeService;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysOfficeServiceImpl
extends HussarServiceImpl<SysOfficeMapper, SysOffice>
implements ISysOfficeService {
    public List<SysOffice> getSysOfficeByStruId(List<Long> struIds) {
        if (HussarUtils.isEmpty(struIds)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        for (Long struId : struIds) {
            ((LambdaQueryWrapper)lambdaQueryWrapper.or()).eq(SysOffice::getStruId, (Object)struId);
        }
        return this.list((Wrapper)lambdaQueryWrapper);
    }

    public Map<String, Integer> saveOrUpdateOfficeList(List<SysOffice> offices) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        List officeIds = offices.stream().map(SysOffice::getId).collect(Collectors.toList());
        List existedOffices = new ArrayList();
        if (ToolUtil.isNotEmpty(officeIds)) {
            existedOffices = this.list((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysOffice::getId, officeIds));
        }
        ArrayList<SysOffice> repeatOffices = new ArrayList<SysOffice>();
        ArrayList<SysOffice> newOffices = new ArrayList<SysOffice>();
        if (HussarUtils.isNotEmpty(existedOffices)) {
            List repeatIds = existedOffices.stream().map(SysOffice::getId).collect(Collectors.toList());
            for (SysOffice office : offices) {
                if (repeatIds.contains(office.getId())) {
                    repeatOffices.add(office);
                    continue;
                }
                newOffices.add(office);
            }
            map.put("insert", newOffices.size());
            map.put("update", repeatOffices.size());
            this.saveBatch(newOffices);
            this.updateBatchById(repeatOffices);
        } else {
            this.saveBatch(offices);
            map.put("insert", offices.size());
            map.put("update", 0);
        }
        return map;
    }
}

