/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.service.impl;

import com.jxdinfo.hussar.authorization.organ.dto.AddOnlyOutsideStaffDto;
import com.jxdinfo.hussar.authorization.organ.dto.EditOnlyOutsideStaffDto;
import com.jxdinfo.hussar.authorization.organ.manager.AddOutsideStaffManager;
import com.jxdinfo.hussar.authorization.organ.manager.DeleteOutsideStaffManager;
import com.jxdinfo.hussar.authorization.organ.manager.EditOutsideStaffManager;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseSyncStaffService;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.authorization.organ.service.impl.hussarBaseSyncStaffServiceImpl")
public class HussarBaseSyncStaffServiceImpl
implements IHussarBaseSyncStaffService {
    private static final Logger logger = LoggerFactory.getLogger(HussarBaseSyncStaffServiceImpl.class);
    private static final String CACHE = "hussarOrganizationJob";
    @Resource
    private AddOutsideStaffManager addOutsideStaffManager;
    @Resource
    private EditOutsideStaffManager editOutsideStaffManager;
    @Resource
    private DeleteOutsideStaffManager deleteOutsideStaffManager;

    @HussarTransactional
    public synchronized R<AddOnlyOutsideStaffDto> addOnlyStaff(AddOnlyOutsideStaffDto staff) {
        R<AddOnlyOutsideStaffDto> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error("\u65b0\u589e\u4eba\u5458\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
                throw new BaseException("\u65b0\u589e\u4eba\u5458\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE, (long)600L);
            r = this.addOutsideStaffManager.addOnlyStaff(staff);
        }
        catch (BaseException e) {
            throw new BaseException("\u65b0\u589e\u4eba\u5458\u51fa\u9519\uff1a" + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    @HussarTransactional
    public synchronized R<EditOnlyOutsideStaffDto> editOnlyStaff(EditOnlyOutsideStaffDto staff) {
        R<EditOnlyOutsideStaffDto> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error("\u4fee\u6539\u4eba\u5458\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
                throw new BaseException("\u4fee\u6539\u4eba\u5458\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE, (long)600L);
            r = this.editOutsideStaffManager.editOnlyStaff(staff);
        }
        catch (BaseException e) {
            throw new BaseException("\u4fee\u6539\u4eba\u5458\u51fa\u9519\uff1a" + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    @HussarTransactional
    public synchronized R<String> deleteOnlyStaff(String staffCode) {
        R<String> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error("\u5220\u9664\u4eba\u5458\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
                throw new BaseException("\u5220\u9664\u4eba\u5458\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE, (long)600L);
            r = this.deleteOutsideStaffManager.deleteOnlyStaff(staffCode);
        }
        catch (BaseException e) {
            throw new BaseException("\u5220\u9664\u4eba\u5458\u51fa\u9519\uff1a" + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }
}

