/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.authorization.audit.model.SysOrganAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysStruAudit;
import com.jxdinfo.hussar.authorization.organ.dto.TransferOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.manager.TransferOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.model.SysStruRule;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.authorization.permit.model.SysStruAssistOrgan;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.ConditionUtils;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.organ.manager.impl.transferOrganizationManagerImpl")
public class TransferOrganizationManagerImpl
extends CommonOrganizationManager
implements TransferOrganizationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransferOrganizationManagerImpl.class);

    @Override
    public String transferOrganization(TransferOrganizationDto transferOrganizationDto) {
        LOGGER.info("\u6267\u884c\u7ec4\u7ec7\u673a\u6784\u8f6c\u79fb,\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)transferOrganizationDto));
        String validateMsg = this.validateService.validate((Object)transferOrganizationDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        Long oldId = transferOrganizationDto.getOldId();
        Long newId = transferOrganizationDto.getNewId();
        SysStru oldSysStru = (SysStru)this.sysStruMapper.selectById(oldId);
        SysStru newSysStru = (SysStru)this.sysStruMapper.selectById(newId);
        AssertUtil.isNotNull((Object)oldSysStru, (String)"\u672a\u67e5\u8be2\u5230\u9700\u8981\u8f6c\u79fb\u7ec4\u7ec7\u673a\u6784");
        AssertUtil.isNotNull((Object)newSysStru, (String)"\u672a\u67e5\u8be2\u5230\u8981\u8f6c\u79fb\u5230\u7684\u7ec4\u7ec7\u673a\u6784");
        this.validateTransferOrganization(oldSysStru, newSysStru);
        this.sysOrgEventService.beforeOrgChange(oldId, newId);
        String msg = this.doTransfer(oldSysStru, newSysStru);
        this.sysOrgEventService.afterOrgChange(oldId, newId);
        return msg;
    }

    private String doTransfer(SysStru oldSysStru, SysStru newSysStru) {
        LOGGER.info("\u8c03\u7528\u771f\u6b63\u7684\u7ec4\u7ec7\u673a\u6784\u8f6c\u79fb\u903b\u8f91");
        String msg = "";
        String sourceOrgType = oldSysStru.getStruType();
        Long sourceStruId = oldSysStru.getId();
        Long targetStruId = newSysStru.getId();
        Integer changeLevel = newSysStru.getStruLevel();
        AtomicReference<Integer> orderTree = new AtomicReference<Integer>(1);
        Integer maxOrder = this.sysStruMapper.getMaxOrderById(targetStruId);
        ConditionUtils.isTrue((boolean)HussarUtils.isNotEmpty((Object)maxOrder)).handle(() -> orderTree.set(maxOrder + 1));
        Integer struOrder = orderTree.get();
        Integer level = changeLevel + 1;
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isOrganAudit()) {
            SysStru sysStru = (SysStru)this.sysStruMapper.selectById(sourceStruId);
            SysStruAudit sysStruAudit = new SysStruAudit();
            CopyPropertieUtils.copyProperties((Object)sysStruAudit, (Object)sysStru);
            sysStruAudit.setId(null);
            sysStruAudit.setOrganId(Long.valueOf(IdWorker.getId((Object)sysStruAudit)));
            sysStruAudit.setInUse("4");
            sysStruAudit.setStruOrder(struOrder);
            sysStruAudit.setRealStruId(sysStru.getId());
            sysStruAudit.setState("0");
            sysStruAudit.setStruLevel(level);
            sysStruAudit.setParentId(targetStruId);
            this.sysStruAuditService.save((Object)sysStruAudit);
            SysOrgan sysOrgan = (SysOrgan)this.sysOrganService.getById((Serializable)sysStru.getOrganId());
            SysOrganAudit sysOrganAudit = new SysOrganAudit();
            CopyPropertieUtils.copyProperties((Object)sysOrganAudit, (Object)sysOrgan);
            sysOrganAudit.setId(sysStruAudit.getOrganId());
            sysOrganAudit.setRealOrganId(sysOrgan.getId());
            sysOrganAudit.setInUse("4");
            this.sysOrganAuditService.save((Object)sysOrganAudit);
            msg = "\u8f6c\u79fb\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01";
        } else {
            this.organizationChange(sourceStruId, targetStruId, sourceOrgType, struOrder);
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper.eq(SysStruAssistOrgan::getStruId, (Object)sourceStruId)).eq(SysStruAssistOrgan::getAssistParentId, (Object)targetStruId);
            this.sysStruAssistOrganMapper.delete((Wrapper)wrapper);
            SysOrgan sysOrgan = this.sysStruMapper.getOrganInfoByDeparmentId(sourceStruId);
            this.organChangeNotify.notify(DataChangeType.UPDATE, new Object[]{sourceStruId, sysOrgan, null});
            msg = "\u8f6c\u79fb\u6210\u529f\uff01";
        }
        return msg;
    }

    private void validateTransferOrganization(SysStru oldSysStru, SysStru newSysStru) {
        LOGGER.info("\u6821\u9a8c\u7ec4\u7ec7\u673a\u6784\u662f\u5426\u53ef\u4ee5\u8f6c\u79fb");
        if (newSysStru.getStruFid().contains(oldSysStru.getStruFid())) {
            throw new BaseException("\u8f6c\u79fb\u5931\u8d25\uff01\u8be5\u8f6c\u79fb\u4e0d\u7b26\u5408\u7ec4\u7ec7\u673a\u6784\u89c4\u5219\uff01");
        }
        this.whetherComplianceWithOrganizationRule(oldSysStru, newSysStru);
        this.existsAuditData(oldSysStru.getId(), newSysStru.getId());
    }

    private void whetherComplianceWithOrganizationRule(SysStru oldSysStru, SysStru newSysStru) {
        String oldOrganType = oldSysStru.getStruType();
        String newOrganType = newSysStru.getStruType();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysStruRule::getSysOrganType, (Object)newOrganType);
        wrapper.eq(SysStruRule::getOrganType, (Object)oldOrganType);
        long count = this.sysStruRuleMapper.selectCount((Wrapper)wrapper);
        if (count == 0L) {
            throw new BaseException("\u8f6c\u79fb\u5931\u8d25\uff01\u8be5\u8f6c\u79fb\u4e0d\u7b26\u5408\u7ec4\u7ec7\u673a\u6784\u89c4\u5219\uff01");
        }
    }

    private void existsAuditData(Long oldId, Long newId) {
        if (!this.sysStruAuditService.checkCanOperate(oldId)) {
            throw new BaseException("\u8f6c\u79fb\u5931\u8d25\uff01\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff01");
        }
        if (!this.sysStruAuditService.checkCanOperate(newId)) {
            throw new BaseException("\u8f6c\u79fb\u5931\u8d25\uff01\u8f6c\u79fb\u540e\u7684\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784\u5b58\u5728\u672a\u5ba1\u6838\u7684\u6570\u636e\uff01");
        }
    }

    @Override
    public void organizationChange(Long sourceStruId, Long targetStruId, String sourceOrgType, Integer order) {
        String struSeq;
        LOGGER.info("\u66f4\u65b0\u7ec4\u7ec7\u673a\u6784\u7f16\u7801\u548c\u4e0b\u7ea7\u7ec4\u7ec7\u673a\u6784\u5c42\u7ea7");
        SysOrgan parentOrg = this.sysStruMapper.getOrganInfoByDeparmentId(targetStruId);
        SysOrgan sysOrgan = this.sysStruMapper.getOrganInfoByDeparmentId(sourceStruId);
        SysStru newSysStru = (SysStru)this.sysStruMapper.selectById(targetStruId);
        SysStru oldSysStru = (SysStru)this.sysStruMapper.selectById(sourceStruId);
        LambdaQueryWrapper wrapper2 = (LambdaQueryWrapper)new LambdaQueryWrapper().likeRight(SysStru::getStruFid, (Object)oldSysStru.getStruFid());
        wrapper2.orderByAsc(SysStru::getStruSeq);
        List strus = this.sysStruMapper.selectList((Wrapper)wrapper2);
        HashMap<String, Object> queryOrgParams = new HashMap<String, Object>();
        queryOrgParams.put("organFcode", SqlQueryUtil.transferSpecialChar((String)sysOrgan.getOrganFcode()));
        queryOrgParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        List<SysOrgan> organs = this.sysOrganMapper.getSubOrganByFcode(queryOrgParams);
        Map organsMap = organs.stream().collect(Collectors.toMap(SysOrgan::getId, Function.identity()));
        ((SysOrgan)organsMap.get(sysOrgan.getId())).setOrganFcode(parentOrg.getOrganFcode() + sysOrgan.getOrganCode() + "/");
        ((SysOrgan)organsMap.get(sysOrgan.getId())).setOrganFname(parentOrg.getOrganFname() + "/" + sysOrgan.getOrganName());
        String struFid = newSysStru.getStruFid() + oldSysStru.getId() + "/";
        String struSeqT = struSeq = this.getStruSeq(newSysStru.getStruFid(), newSysStru.getStruSeq(), OrganUtil.getLevel((SysStru)newSysStru) + 1);
        strus.stream().filter(organsEntity -> organsEntity.getParentId().equals(sourceStruId)).sorted(Comparator.comparing(SysStru::getStruSeq)).map(stru -> {
            SysOrgan sysOrganT = (SysOrgan)organsMap.get(stru.getOrganId());
            sysOrganT.setOrganFname(((SysOrgan)organsMap.get(sysOrgan.getId())).getOrganFname() + "/" + sysOrganT.getOrganName());
            sysOrganT.setOrganFcode(OrganUtil.convert((String)(((SysOrgan)organsMap.get(sysOrgan.getId())).getOrganFcode() + sysOrganT.getOrganCode() + "/")));
            sysOrganT.setOrganProperty(parentOrg.getOrganProperty());
            stru.setStruFid(OrganUtil.convert((String)(struFid + stru.getId() + "/")));
            stru.setStruSeq(struSeqT + stru.getStruSeq().substring(stru.getStruSeq().lastIndexOf("/")));
            stru.setStruLevel(Integer.valueOf(stru.getStruFid().split("/").length - 1));
            this.changeInfo((SysStru)stru, strus, organsMap);
            return stru;
        }).collect(Collectors.toList());
        for (SysStru temp : strus) {
            if (!Objects.equals(temp.getId(), sourceStruId)) continue;
            temp.setStruFid(OrganUtil.convert((String)struFid));
            temp.setStruLevel(Integer.valueOf(temp.getStruFid().split("/").length - 1));
            temp.setStruSeq(struSeq);
            temp.setStruOrder(order);
            temp.setParentId(targetStruId);
        }
        this.sysStruService.updateBatchById((Collection)strus);
        this.sysOrganService.updateBatchById(organsMap.values());
        this.updateLeaf(oldSysStru, newSysStru);
    }

    private void updateLeaf(SysStru oldSysStru, SysStru newSysStru) {
        if (!oldSysStru.getStruType().equals("9")) {
            newSysStru.setIsLeaf("N");
        }
        this.sysStruMapper.updateById(newSysStru);
        Long sourceStruId = oldSysStru.getParentId();
        int struLevel = oldSysStru.getStruLevel();
        if (!oldSysStru.getStruType().equals("9") && struLevel > 1) {
            SysStru pSysStru = (SysStru)this.sysStruMapper.selectById(sourceStruId);
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(SysStru::getParentId, (Object)sourceStruId);
            wrapper.ne(SysStru::getId, (Object)oldSysStru.getId());
            wrapper.ne(SysStru::getStruType, (Object)"9");
            Long count = this.sysStruMapper.selectCount((Wrapper)wrapper);
            pSysStru.setIsLeaf(count > 0L ? "N" : "Y");
            this.sysStruMapper.updateById(pSysStru);
        }
    }

    private void changeInfo(SysStru root, List<SysStru> all, Map<Long, SysOrgan> organsMap) {
        SysOrgan rootOrgan = organsMap.get(root.getOrganId());
        all.stream().filter(stru -> stru.getParentId().equals(root.getId())).sorted(Comparator.comparing(SysStru::getStruSeq)).map(stru -> {
            SysOrgan sysOrganT = (SysOrgan)organsMap.get(stru.getOrganId());
            sysOrganT.setOrganFname(rootOrgan.getOrganFname() + "/" + sysOrganT.getOrganName());
            sysOrganT.setOrganFcode(OrganUtil.convert((String)(rootOrgan.getOrganFcode() + sysOrganT.getOrganCode() + "/")));
            stru.setStruFid(OrganUtil.convert((String)(root.getStruFid() + stru.getId() + "/")));
            stru.setStruSeq(root.getStruSeq() + stru.getStruSeq().substring(stru.getStruSeq().lastIndexOf("/")));
            stru.setStruLevel(Integer.valueOf(stru.getStruFid().split("/").length - 1));
            if (Objects.equals(stru.getStruType(), "9")) {
                stru.setStruSeq(OrganUtil.getStruFidByLevel((String)stru.getStruSeq(), (int)(stru.getStruLevel() - 1)));
            }
            this.changeInfo((SysStru)stru, all, organsMap);
            return stru;
        }).collect(Collectors.toList());
    }
}

