/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.organ.dto.EditOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.manager.EditOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.model.SysOffice;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.model.SysStruRule;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.authorization.permit.model.SysStruRole;
import com.jxdinfo.hussar.authorization.permit.model.SysStruRoleAudit;
import com.jxdinfo.hussar.authorization.permit.vo.UserOrganPostVo;
import com.jxdinfo.hussar.authorization.post.model.SysPost;
import com.jxdinfo.hussar.authorization.relational.model.SysStruPost;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.constant.state.StruRoleStatus;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.pinyin.service.IConvertPinyinService;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.organ.manager.impl.editOrganizationManagerImpl")
public class EditOrganizationManagerImpl
extends CommonOrganizationManager
implements EditOrganizationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditOrganizationManagerImpl.class);
    @Autowired
    private IConvertPinyinService convertPinyinService;

    @Override
    public String editOrganization(EditOrganizationDto editOrganizationDto) {
        String validateMsg = this.validateService.validate((Object)editOrganizationDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        String organName = editOrganizationDto.getOrganName();
        if (HussarUtils.isNotBlank((CharSequence)organName)) {
            boolean flag;
            boolean bl = flag = !organName.contains("/");
            if (!flag) {
                LOGGER.error("\u7ec4\u7ec7\u673a\u6784\u540d\u79f0:{}\u4e0d\u80fd\u5305\u542b\u5b57\u7b26/", (Object)organName);
                return "\u7ec4\u7ec7\u673a\u6784\u540d\u79f0\u4e0d\u80fd\u5305\u542b\u5b57\u7b26/";
            }
        }
        SysStru sysStru = new SysStru();
        SysOffice sysOffice = new SysOffice();
        SysOrgan sysOrgan = new SysOrgan();
        this.initialization(editOrganizationDto, sysStru, sysOrgan, sysOffice);
        ArrayList<SysStruPost> sysStruPosts = new ArrayList<SysStruPost>();
        ArrayList<SysStruRole> sysStruRoles = new ArrayList<SysStruRole>();
        this.initializationRelations(editOrganizationDto, sysStruPosts, sysStruRoles);
        this.organizationAuditDataExists(editOrganizationDto.getId());
        this.beforeEditOrganization(sysStru, sysOrgan, sysOffice);
        String result = this.processAuditIfNecessary(sysStru, sysOrgan, sysOffice, sysStruPosts, sysStruRoles);
        this.afterEditOrganization(sysStru, sysOrgan, sysOffice);
        return result;
    }

    @Override
    public synchronized void refreshOrgan() {
        List strus = this.sysStruMapper.selectList(null);
        List organs = this.sysOrganMapper.selectList(null);
        Map organsMap = organs.stream().collect(Collectors.toMap(SysOrgan::getId, Function.identity()));
        AtomicInteger index = new AtomicInteger(1);
        strus.stream().filter(organsEntity -> organsEntity.getParentId().equals(Constants.ROOT_NODE_ID)).sorted(Comparator.comparing(SysStru::getIsEmployee, Comparator.nullsLast(String::compareTo)).thenComparing(SysStru::getStruLevel, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getStruOrder, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getGlobalOrder, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getId)).map(stru -> {
            SysOrgan sysOrgan = (SysOrgan)organsMap.get(stru.getOrganId());
            sysOrgan.setOrganFname("/" + sysOrgan.getOrganName());
            sysOrgan.setOrganFcode(sysOrgan.getOrganCode().equals("1") ? "/1/" : OrganUtil.convert((String)sysOrgan.getOrganCode()));
            stru.setStruSeq("/" + String.format("%04d", index.getAndIncrement()));
            stru.setStruFid(Objects.equals(stru.getId(), 1L) ? "/1/" : OrganUtil.convert((Long)stru.getId()));
            stru.setStruLevel(Integer.valueOf(stru.getStruFid().split("/").length - 1));
            stru.setIsLeaf("Y");
            this.setInfo((SysStru)stru, strus, organsMap);
            return stru;
        }).collect(Collectors.toList());
        boolean updateStruFlag = this.sysStruService.updateBatchById((Collection)strus);
        boolean updateOrganFlag = this.sysOrganService.updateBatchById(organsMap.values());
        if (Boolean.TRUE.equals(updateStruFlag) && Boolean.TRUE.equals(updateOrganFlag)) {
            strus.stream().forEach(sysStru -> {
                if (MapUtils.isNotEmpty((Map)organsMap) && organsMap.containsKey(sysStru.getOrganId())) {
                    SysOrgan sysOrgan = (SysOrgan)organsMap.get(sysStru.getOrganId());
                    this.organChangeNotify.notify(DataChangeType.UPDATE, new Object[]{sysStru.getId(), sysOrgan, null});
                }
            });
        }
    }

    private void setInfo(SysStru root, List<SysStru> all, Map<Long, SysOrgan> organsMap) {
        AtomicInteger index = new AtomicInteger(1);
        root.setIsLeaf("Y");
        SysOrgan rootOrgan = organsMap.get(root.getOrganId());
        all.stream().filter(stru -> stru.getParentId().equals(root.getId())).sorted(Comparator.comparing(SysStru::getIsEmployee, Comparator.nullsLast(String::compareTo)).thenComparing(SysStru::getStruLevel, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getStruOrder, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getGlobalOrder, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getId)).map(stru -> {
            SysOrgan sysOrgan = (SysOrgan)organsMap.get(stru.getOrganId());
            AssertUtil.isNotNull((Object)sysOrgan, (String)("\u6570\u636e\u5e93\u6570\u636e\u9519\u4e71\uff0c\u6839\u636eSYS_STRU\u67e5\u8be2\u5230ORGAN_ID:" + stru.getOrganId() + ",\u4f46\u662f\u5728SYS_ORGAN\u4e2d\u672a\u67e5\u8be2\u5230\u6570\u636e"));
            sysOrgan.setOrganFname(rootOrgan.getOrganFname() + "/" + sysOrgan.getOrganName());
            sysOrgan.setOrganFcode(OrganUtil.convert((String)(rootOrgan.getOrganFcode() + sysOrgan.getOrganCode())));
            stru.setStruFid(OrganUtil.convert((String)(root.getStruFid() + stru.getId())));
            stru.setStruLevel(Integer.valueOf(stru.getStruFid().split("/").length - 1));
            if (!Objects.equals("9", stru.getStruType())) {
                root.setIsLeaf("N");
                stru.setStruSeq(root.getStruSeq() + "/" + String.format("%04d", index.getAndIncrement()));
            } else {
                stru.setStruSeq(root.getStruSeq());
            }
            this.setInfo((SysStru)stru, all, organsMap);
            return stru;
        }).collect(Collectors.toList());
    }

    private String processAuditIfNecessary(SysStru sysStru, SysOrgan sysOrgan, SysOffice sysOffice, List<SysStruPost> sysStruPosts, List<SysStruRole> sysStruRoles) {
        boolean needAudit;
        StringBuilder stringBuilder = new StringBuilder("");
        LOGGER.info("\u5224\u65ad\u9700\u4e0d\u9700\u8981\u5ba1\u6838,\u5982\u679c\u9700\u8981\u5ba1\u6838\uff0c\u5219\u5148\u52a0\u5165\u5ba1\u6838\u8868");
        boolean flag = this.compareBaseInfo(sysStru, sysOrgan, sysOffice);
        boolean bl = needAudit = this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isOrganAudit();
        if (needAudit) {
            LOGGER.debug("\u4fee\u6539\u7ec4\u7ec7\u673a\u6784\u9700\u8981\u5ba1\u6838");
            if (!flag) {
                this.auditAdd(sysOrgan, sysStru, null, sysOffice, "2");
            }
            this.sysStruPostService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruPost::getStruId, (Object)sysStru.getId()));
            if (HussarUtils.isNotEmpty(sysStruPosts)) {
                this.sysStruPostService.saveBatch(sysStruPosts);
            }
            boolean struFlag = this.auditStruRole(sysStru.getId(), sysStruRoles);
            if (flag && !struFlag) {
                stringBuilder.append("\u4fee\u6539\u6210\u529f\uff01");
            } else {
                stringBuilder.append("\u4fee\u6539\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01");
            }
            SysOrgan oldOrgan = (SysOrgan)this.sysOrganService.getById((Serializable)sysOrgan.getId());
            this.organChangeNotify.notify(DataChangeType.UPDATE, new Object[]{sysStru.getId(), oldOrgan, sysStruPosts});
        } else {
            LOGGER.debug("\u4fee\u6539\u7ec4\u7ec7\u673a\u6784\u4e0d\u9700\u8981\u5ba1\u6838");
            if (!flag) {
                this.sysStruMapper.updateById(sysStru);
                this.sysOrganMapper.updateById(sysOrgan);
                if (ToolUtil.isNotEmpty((Object)sysOffice)) {
                    this.sysOfficeService.saveOrUpdate((Object)sysOffice);
                }
            }
            this.sysStruPostService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruPost::getStruId, (Object)sysStru.getId()));
            this.sysStruRoleService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruRole::getStruId, (Object)sysStru.getId()));
            if (HussarUtils.isNotEmpty(sysStruPosts)) {
                this.sysStruPostService.saveBatch(sysStruPosts, sysStruPosts.size());
            }
            if (HussarUtils.isNotEmpty(sysStruRoles)) {
                this.sysStruRoleService.saveBatch(sysStruRoles, sysStruRoles.size());
            }
            stringBuilder.append("\u4fee\u6539\u6210\u529f\uff01");
            this.organChangeNotify.notify(DataChangeType.UPDATE, new Object[]{sysStru.getId(), sysOrgan, sysStruPosts});
            this.editOrganizationAuthorizationChangeReporter.report(new Object[]{sysStru.getId()});
        }
        return stringBuilder.toString();
    }

    private boolean compareBaseInfo(SysStru sysStru, SysOrgan sysOrgan, SysOffice sysOffice) {
        SysStru oldStru = (SysStru)this.sysStruMapper.selectById(sysStru.getId());
        SysOrgan oldOrgan = (SysOrgan)this.sysOrganMapper.selectById(sysOrgan.getId());
        SysOffice oldOffice = (SysOffice)this.sysOfficeService.getById((Serializable)sysOffice.getId());
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)sysOrgan.getOrganName()), (Object)StringUtils.trimToEmpty((String)oldOrgan.getOrganName()))) {
            return false;
        }
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)sysOrgan.getShortName()), (Object)StringUtils.trimToEmpty((String)oldOrgan.getShortName()))) {
            return false;
        }
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)sysStru.getOrganAlias()), (Object)StringUtils.trimToEmpty((String)oldStru.getOrganAlias()))) {
            return false;
        }
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)sysOffice.getOfficeAlias()), (Object)StringUtils.trimToEmpty((String)oldOffice.getOfficeAlias()))) {
            return false;
        }
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)sysOffice.getOfficeAddress()), (Object)StringUtils.trimToEmpty((String)oldOffice.getOfficeAddress()))) {
            return false;
        }
        if (!HussarUtils.equals((Object)sysStru.getPrincipalId(), (Object)oldStru.getPrincipalId())) {
            return false;
        }
        if (!HussarUtils.equals((Object)sysOrgan.getValidTimeLimitType(), (Object)oldOrgan.getValidTimeLimitType())) {
            return false;
        }
        return HussarUtils.equals((Object)sysStru.getStruType(), (Object)oldStru.getStruType());
    }

    private boolean auditStruRole(Long struId, List<SysStruRole> sysStruRoles) {
        SysStruRoleAudit struRoleAudit;
        ArrayList<SysStruRoleAudit> struRoleAudits = new ArrayList<SysStruRoleAudit>();
        List newRoleIds = sysStruRoles.stream().map(SysStruRole::getGrantedRole).distinct().collect(Collectors.toList());
        List struRoles = this.sysStruRoleService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruRole::getStruId, (Object)struId)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
        List oldRoleIds = struRoles.stream().map(SysStruRole::getGrantedRole).collect(Collectors.toList());
        List<Object> addRoleIds = new ArrayList();
        List<Object> delRoleIds = new ArrayList();
        if (HussarUtils.isEmpty(oldRoleIds) && HussarUtils.isNotEmpty(newRoleIds)) {
            addRoleIds = newRoleIds;
        }
        if (HussarUtils.isEmpty(newRoleIds) && HussarUtils.isNotEmpty(oldRoleIds)) {
            delRoleIds = oldRoleIds;
        }
        if (HussarUtils.isNotEmpty(newRoleIds) && HussarUtils.isNotEmpty(oldRoleIds)) {
            addRoleIds = newRoleIds.stream().filter(item -> !oldRoleIds.contains(item)).collect(Collectors.toList());
            delRoleIds = oldRoleIds.stream().filter(item -> !newRoleIds.contains(item)).collect(Collectors.toList());
        }
        if (HussarUtils.isNotEmpty(addRoleIds) || HussarUtils.isNotEmpty(delRoleIds)) {
            List list = this.sysStruRoleAuditService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruRoleAudit::getStatus, (Object)StruRoleStatus.LOCKED.getCode())).eq(SysStruRoleAudit::getStruId, (Object)struId));
            AssertUtil.isTrue((boolean)HussarUtils.isEmpty((Object)list), (String)"\u4fee\u6539\u5931\u8d25\uff01\u5b58\u5728\u672a\u5ba1\u6838\u7684\u5173\u8054\u89d2\u8272\uff01");
        }
        if (HussarUtils.isNotEmpty(addRoleIds)) {
            for (Long roleId : addRoleIds) {
                struRoleAudit = new SysStruRoleAudit();
                struRoleAudit.setStruId(struId);
                struRoleAudit.setRoleId(roleId);
                struRoleAudit.setStatus(StruRoleStatus.LOCKED.getCode());
                struRoleAudit.setOperationType("1");
                struRoleAudits.add(struRoleAudit);
            }
        }
        if (HussarUtils.isNotEmpty(delRoleIds)) {
            for (Long roleId : delRoleIds) {
                struRoleAudit = new SysStruRoleAudit();
                struRoleAudit.setStruId(struId);
                struRoleAudit.setRoleId(roleId);
                struRoleAudit.setStatus(StruRoleStatus.LOCKED.getCode());
                struRoleAudit.setOperationType("2");
                struRoleAudits.add(struRoleAudit);
            }
        }
        if (HussarUtils.isNotEmpty(struRoleAudits)) {
            this.sysStruRoleAuditService.saveBatch(struRoleAudits, struRoleAudits.size());
            return true;
        }
        return false;
    }

    private void afterEditOrganization(SysStru sysStru, SysOrgan sysOrgan, SysOffice sysOffice) {
        LOGGER.debug("\u8c03\u7528\u7ec4\u7ec7\u673a\u6784\u4fee\u6539\u540e\u7684\u65b9\u6cd5");
        this.sysOrgEventService.afterEdit(sysStru, sysOrgan, sysOffice);
    }

    private void beforeEditOrganization(SysStru sysStru, SysOrgan sysOrgan, SysOffice sysOffice) {
        LOGGER.debug("\u8c03\u7528\u7ec4\u7ec7\u673a\u6784\u4fee\u6539\u524d\u7684\u65b9\u6cd5");
        this.sysOrgEventService.beforeEdit(sysStru, sysOrgan, sysOffice);
    }

    private void organizationAuditDataExists(Long struId) {
        LOGGER.debug("\u5224\u65ad\u65b0\u589e\u7ec4\u7ec7\u673a\u6784\u6240\u5728\u7684\u7236\u7ec4\u7ec7\u673a\u6784\uff1a{}\u662f\u5426\u5b58\u5728\u5ba1\u6838\u6570\u636e", (Object)struId);
        if (!this.sysStruAuditService.checkCanOperate(struId)) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff01");
        }
    }

    private void initialization(EditOrganizationDto editOrganizationDto, SysStru sysStru, SysOrgan sysOrgan, SysOffice sysOffice) {
        boolean needAudit;
        LOGGER.info("\u6839\u636eEditOrganizationDto\u521d\u59cb\u5316SysStru,SysOrgan,SysOffice,\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)editOrganizationDto));
        Long struId = editOrganizationDto.getId();
        SysStru sysStruT = (SysStru)this.sysStruMapper.selectById(struId);
        SysOrgan sysOrganT = (SysOrgan)this.sysOrganMapper.selectById(sysStruT.getOrganId());
        SysStru sysStruP = (SysStru)this.sysStruMapper.selectById(sysStruT.getParentId());
        if (HussarUtils.isNotEmpty((Object)sysStruP)) {
            AssertUtil.isTrue((boolean)this.sysStruRuleService.judgeRelationshipOfTypeCascade(sysStruT.getStruType(), sysStruP.getStruType()), (String)"\u4fee\u6539\u5931\u8d25\uff01\u4e0a\u4e0b\u7ea7\u7c7b\u578b\u5173\u7cfb\u4e0d\u5408\u89c4\uff01");
        }
        this.checkDownStruType(editOrganizationDto);
        if (!HussarUtils.equals((Object)sysStruT.getStruType(), (Object)editOrganizationDto.getStruType())) {
            this.checkExistRelatePost(sysStruT, editOrganizationDto);
        }
        String currentFname = sysOrganT.getOrganFname();
        String newFname = currentFname.substring(0, currentFname.lastIndexOf("/")) + "/" + editOrganizationDto.getOrganName().trim();
        boolean bl = needAudit = this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isOrganAudit();
        if (!Objects.equals(editOrganizationDto.getOrganName().trim(), sysOrganT.getOrganName()) && !needAudit) {
            LOGGER.debug("\u5982\u679c\u4e0d\u9700\u8981\u5ba1\u6838\uff0c\u800c\u4e14\u4fee\u6539\u4e86\u7ec4\u7ec7\u673a\u6784\u540d\u79f0\uff0c\u5219\u9700\u8981\u66f4\u65b0\u4e0b\u7ea7\u7684\u7ec4\u7ec7\u673a\u6784\u5168\u8def\u5f84");
            HashMap<String, Object> queryOrgParams = new HashMap<String, Object>();
            queryOrgParams.put("organFcode", SqlQueryUtil.transferSpecialChar((String)sysOrganT.getOrganFcode()));
            queryOrgParams.put("organId", sysOrganT.getId());
            queryOrgParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
            List<SysOrgan> sysOrgans = this.sysOrganMapper.getSubOrganByFcode(queryOrgParams);
            for (SysOrgan temp : sysOrgans) {
                String tempFname = temp.getOrganFname();
                tempFname = newFname + tempFname.substring(tempFname.lastIndexOf("/"));
                temp.setOrganFname(tempFname);
            }
            this.sysOrganService.updateBatchById(sysOrgans);
        }
        SysOffice sysOfficeT = (SysOffice)this.sysOfficeMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysOffice::getStruId, (Object)struId));
        BeanUtils.copyProperties((Object)sysOrganT, (Object)sysOrgan);
        BeanUtils.copyProperties((Object)sysStruT, (Object)sysStru);
        BeanUtils.copyProperties((Object)sysOfficeT, (Object)sysOffice);
        sysStru.setOrganAlias(StringUtils.trimToEmpty((String)editOrganizationDto.getOrganAlias()));
        sysStru.setPrincipalId(editOrganizationDto.getPrincipalId());
        sysStru.setStruType(editOrganizationDto.getStruType());
        sysOrgan.setOrganName(StringUtils.trimToEmpty((String)editOrganizationDto.getOrganName()));
        sysOrgan.setOrganFname(newFname);
        sysOrgan.setShortName(StringUtils.trimToEmpty((String)editOrganizationDto.getShortName()));
        sysOrgan.setOrganType(editOrganizationDto.getStruType());
        sysOffice.setOfficeAddress(StringUtils.trimToEmpty((String)editOrganizationDto.getOfficeAddress()));
        sysOffice.setOfficeAlias(StringUtils.trimToEmpty((String)editOrganizationDto.getOfficeAlias()));
        sysOrgan.setOrganProperty(editOrganizationDto.getOrganProperty());
        sysOrgan.setOrganNamePinyinFull(this.convertPinyinService.getFullPinyin(sysOrgan.getOrganName()));
        sysOrgan.setOrganNamePinyinInitial(this.convertPinyinService.getInitialsPinyin(sysOrgan.getOrganName()));
        sysOrgan.setValidTimeLimitType(editOrganizationDto.getValidTimeLimitType());
    }

    private void initializationRelations(EditOrganizationDto editOrganizationDto, List<SysStruPost> sysStruPosts, List<SysStruRole> sysStruRoles) {
        Long struId = editOrganizationDto.getId();
        List postIds = editOrganizationDto.getPostIds();
        List roleIds = editOrganizationDto.getRoleIds();
        List<UserOrganPostVo> userPostByOrgan = this.sysStruPostMapper.getUserPostByOrgan(struId, postIds);
        AssertUtil.isEmpty(userPostByOrgan, (String)"\u4fee\u6539\u5931\u8d25\uff01\u53d6\u6d88\u5173\u8054\u7684\u5c97\u4f4d\u5b58\u5728\u4e0e\u8be5\u7ec4\u7ec7\u4e0b\u7528\u6237\u5173\u8054\uff01");
        if (HussarUtils.isNotEmpty((Object)postIds)) {
            for (Long postId : postIds) {
                SysStruPost sysStruPost = new SysStruPost();
                sysStruPost.setStruId(struId);
                sysStruPost.setPostId(postId);
                sysStruPosts.add(sysStruPost);
            }
        }
        if (HussarUtils.isNotEmpty((Object)roleIds)) {
            for (Long roleId : roleIds) {
                SysStruRole sysStruRole = new SysStruRole();
                sysStruRole.setStruId(struId);
                sysStruRole.setGrantedRole(roleId);
                sysStruRoles.add(sysStruRole);
            }
        }
    }

    private List<Long> subList(List<Long> list, List<Long> secondList) {
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        for (Long id : secondList) {
            map.put(id, id);
        }
        LinkedList<Long> resList = new LinkedList<Long>();
        for (Long id : list) {
            if (map.containsKey(id)) continue;
            resList.add(id);
        }
        return resList;
    }

    private void checkDownStruType(EditOrganizationDto editOrganizationDto) {
        Long id = editOrganizationDto.getId();
        String parentType = editOrganizationDto.getStruType();
        List strus = this.sysStruMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysStru::getParentId, (Object)id));
        if (HussarUtils.isNotEmpty((Object)strus)) {
            Set struTypes = strus.stream().map(SysStru::getStruType).collect(Collectors.toSet());
            List struRules = this.sysStruRuleService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStruRule::getOrganType, struTypes)).eq(SysStruRule::getSysOrganType, (Object)parentType));
            if (!HussarUtils.equals((Object)struTypes.size(), (Object)struRules.size())) {
                throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01\u4e0a\u4e0b\u7ea7\u7c7b\u578b\u5173\u7cfb\u4e0d\u5408\u89c4\uff01");
            }
        }
    }

    private void checkExistRelatePost(SysStru sysStru, EditOrganizationDto editOrganizationDto) {
        List postIds = editOrganizationDto.getPostIds();
        if (HussarUtils.isEmpty((Object)postIds)) {
            return;
        }
        String struType = sysStru.getStruType();
        List posts = this.hussarBasePostService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysPost::getId, (Collection)postIds)).eq(SysPost::getOrganTypeCode, (Object)struType));
        if (HussarUtils.isNotEmpty((Object)posts)) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01\u5b58\u5728\u5f53\u524d\u7c7b\u578b\u7684\u5c97\u4f4d\u5173\u8054\u8be5\u7ec4\u7ec7\uff01");
        }
    }
}

