/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.authorization.audit.model.SysOrganAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysStruAudit;
import com.jxdinfo.hussar.authorization.organ.manager.DeleteOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaff;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaffAudit;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUserAudit;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.pinyin.service.IPinyinSysAsyncEventService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.organ.manager.impl.deleteOrganizationManagerImpl")
public class DeleteOrganizationManagerImpl
extends CommonOrganizationManager
implements DeleteOrganizationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteOrganizationManagerImpl.class);
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;
    @Autowired
    private IPinyinSysAsyncEventService pinyinSysAsyncEventService;

    @Override
    public String deleteOrganization(Long struId) {
        LOGGER.info("\u5220\u9664\u7ec4\u7ec7\u673a\u6784\uff1a{}", (Object)struId);
        if (struId == null) {
            throw new BaseException("\u8981\u5220\u9664\u7684\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.beforeDeleteOrganization(struId);
        this.judgeWhetherItCanBeDelete(struId);
        String result = this.doDelete(struId);
        this.afterDeleteOrganization(struId);
        return result;
    }

    private void afterDeleteOrganization(Long struId) {
        LOGGER.info("\u8c03\u7528\u7ec4\u7ec7\u673a\u6784\u5220\u9664\u4e4b\u540e\u7684\u65b9\u6cd5");
        this.sysOrgEventService.afterDel(struId);
    }

    private String doDelete(Long struId) {
        LOGGER.info("\u6267\u884c\u5220\u9664\u6570\u636e");
        String msg = "";
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isOrganAudit()) {
            LOGGER.debug("\u5220\u9664\u7ec4\u7ec7\u673a\u6784\u9700\u8981\u5ba1\u6838");
            SysStru sysStru = (SysStru)this.sysStruMapper.selectById(struId);
            SysStruAudit sysStruAudit = new SysStruAudit();
            CopyPropertieUtils.copyProperties((Object)sysStruAudit, (Object)sysStru);
            sysStruAudit.setId(null);
            sysStruAudit.setOrganId(Long.valueOf(IdWorker.getId((Object)sysStruAudit)));
            sysStruAudit.setRealStruId(sysStru.getId());
            sysStruAudit.setState("0");
            sysStruAudit.setInUse("3");
            LocalDateTime now = LocalDateTime.now();
            sysStruAudit.setCreateTime(now);
            sysStruAudit.setLastTime(now);
            this.sysStruAuditService.save((Object)sysStruAudit);
            SysOrgan sysOrgan = (SysOrgan)this.sysOrganService.getById((Serializable)sysStru.getOrganId());
            SysOrganAudit sysOrganAudit = new SysOrganAudit();
            CopyPropertieUtils.copyProperties((Object)sysOrganAudit, (Object)sysOrgan);
            sysOrganAudit.setId(sysStruAudit.getOrganId());
            sysOrganAudit.setRealOrganId(sysOrgan.getId());
            sysOrganAudit.setInUse("3");
            sysOrganAudit.setCreateTime(now);
            sysOrganAudit.setLastTime(now);
            this.sysOrganAuditService.save((Object)sysOrganAudit);
            msg = "\u5220\u9664\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01";
        } else {
            SysStru sysStru = (SysStru)this.sysStruMapper.selectById(struId);
            SysOrgan sysOrgan = null;
            if (Objects.nonNull(sysStru)) {
                sysOrgan = (SysOrgan)this.sysOrganService.getById((Serializable)sysStru.getOrganId());
            }
            LOGGER.debug("\u5220\u9664\u7ec4\u7ec7\u673a\u6784\u4e0d\u9700\u8981\u5ba1\u6838");
            boolean flag = this.delOrganByStruId(struId);
            String string = msg = flag ? "\u5220\u9664\u6210\u529f\uff01" : "\u5220\u9664\u5931\u8d25\uff01";
            if (Boolean.TRUE.equals(flag)) {
                this.organChangeNotify.notify(DataChangeType.DELETE, new Object[]{struId, sysOrgan, null});
            }
        }
        return msg;
    }

    private void judgeWhetherItCanBeDelete(Long struId) {
        List<Map<String, Object>> orgList = this.sysStruMapper.getOrgListByParentId(struId);
        if (HussarUtils.isNotEmpty(orgList)) {
            throw new BaseException("\u5220\u9664\u5931\u8d25\uff01\u5b58\u5728\u4e0b\u7ea7\u7ec4\u7ec7\u673a\u6784\uff01");
        }
        List sysStruStaffs = this.sysStruStaffService.list((Wrapper)new LambdaQueryWrapper().eq(SysStruStaff::getStruId, (Object)struId));
        if (HussarUtils.isNotEmpty((Object)sysStruStaffs)) {
            throw new BaseException("\u5220\u9664\u5931\u8d25\uff01\u5b58\u5728\u5173\u8054\u4eba\u5458\uff01");
        }
        List sysStruUsers = this.sysStruUserService.list((Wrapper)new LambdaQueryWrapper().eq(SysStruUser::getStruId, (Object)struId));
        AssertUtil.isEmpty((Collection)sysStruUsers, (String)"\u5220\u9664\u5931\u8d25\uff01\u5b58\u5728\u5173\u8054\u7528\u6237\uff01");
        List assistOrganChildrenList = this.sysStruAssistOrganService.getAssistOrganByParent(struId);
        if (HussarUtils.isNotEmpty((Object)assistOrganChildrenList)) {
            throw new BaseException("\u5220\u9664\u5931\u8d25\uff01\u5b58\u5728\u4e0b\u7ea7\u517c\u4efb\u4eba\u5458\uff01");
        }
        if (!this.sysStruAuditService.checkCanOperate(struId)) {
            throw new BaseException("\u5220\u9664\u5931\u8d25\uff01\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff01");
        }
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        wrapper1.eq(SysStruAudit::getParentId, (Object)struId);
        wrapper1.eq(SysStruAudit::getState, (Object)"0");
        ArrayList<String> inUseList = new ArrayList<String>();
        inUseList.add("1");
        inUseList.add("4");
        wrapper1.in(SysStruAudit::getInUse, inUseList);
        List list1 = this.sysStruAuditService.list((Wrapper)wrapper1);
        if (HussarUtils.isNotEmpty((Object)list1)) {
            throw new BaseException("\u5220\u9664\u5931\u8d25\uff01\u5b58\u5728\u672a\u5ba1\u6838\u7684\u4e0b\u7ea7\u7ec4\u7ec7\u673a\u6784\uff01");
        }
        LambdaQueryWrapper wrapper6 = new LambdaQueryWrapper();
        wrapper6.eq(SysStruUserAudit::getStruId, (Object)struId);
        wrapper6.eq(SysStruUserAudit::getAuditStatus, (Object)"0");
        List list6 = this.sysStruUserAuditService.list((Wrapper)wrapper6);
        if (HussarUtils.isNotEmpty((Object)list6)) {
            throw new BaseException("\u5220\u9664\u5931\u8d25\uff01\u5b58\u5728\u672a\u5ba1\u6838\u7684\u5173\u8054\u7528\u6237\uff01");
        }
        LambdaQueryWrapper wrapper7 = new LambdaQueryWrapper();
        wrapper7.eq(SysStruStaffAudit::getStruId, (Object)struId);
        wrapper7.eq(SysStruStaffAudit::getAuditStatus, (Object)"0");
        List list7 = this.sysStruStaffAuditService.list((Wrapper)wrapper7);
        if (HussarUtils.isNotEmpty((Object)list7)) {
            throw new BaseException("\u5220\u9664\u5931\u8d25\uff01\u5b58\u5728\u672a\u5ba1\u6838\u7684\u5173\u8054\u4eba\u5458\uff01");
        }
    }

    private void beforeDeleteOrganization(Long struId) {
        LOGGER.info("\u8c03\u7528\u7ec4\u7ec7\u673a\u6784\u5220\u9664\u4e4b\u524d\u7684\u65b9\u6cd5");
        this.sysOrgEventService.beforeDel(struId);
    }
}

