/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.organ.manager.DeleteBatchOutsideOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonOutsideOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.model.SysOffice;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.authorization.permit.model.SysStruRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.relational.model.SysStruPost;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaff;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPost;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.organ.manager.impl.deleteBatchOutsideOrganizationManagerImpl")
public class DeleteBatchOutsideOrganizationManagerImpl
extends CommonOutsideOrganizationManager
implements DeleteBatchOutsideOrganizationManager {
    @Override
    public R<String> deleteBatchOrganizations(List<String> organCodes) {
        boolean canDelete = false;
        if (HussarUtils.isNotEmpty(organCodes) && organCodes.size() <= 50) {
            canDelete = true;
        }
        if (!canDelete) {
            throw new BaseException("\u6279\u91cf\u64cd\u4f5c\u6700\u591a\u53ea\u5141\u8bb8\u4e00\u6b21\u64cd\u4f5c50");
        }
        R result = new R();
        ArrayList errors = new ArrayList();
        for (String organCode : organCodes) {
            if (!HussarUtils.isBlank((CharSequence)organCode)) continue;
            OrganUtil.addErrorMsg(errors, (Object)organCode, (String)"organCode", (String[])new String[]{"\u7ec4\u7ec7\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"});
        }
        if (HussarUtils.isNotEmpty(errors)) {
            result.setErrorList(errors);
            result.setSuccess(false);
            return result;
        }
        ArrayList<DataMapping> dataMappings = new ArrayList<DataMapping>();
        LinkedHashMap<Long, OragnMapping> map = new LinkedHashMap<Long, OragnMapping>();
        ArrayList<SysStru> update = new ArrayList<SysStru>();
        List collect = organCodes.stream().filter(item -> HussarUtils.isNotBlank((CharSequence)item)).collect(Collectors.toList());
        AssertUtil.isNotEmpty(collect, (String)"\u6279\u91cf\u5220\u9664\u7ec4\u7ec7\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List organs = this.organService.list((Wrapper)new LambdaQueryWrapper().in(SysOrgan::getOrganCode, collect));
        if (HussarUtils.isEmpty((Object)organs)) {
            result.setSuccess(true);
            result.setErrorList(null);
            return result;
        }
        List organIds = organs.stream().map(item -> item.getId()).collect(Collectors.toList());
        List strus = this.struService.list((Wrapper)new LambdaQueryWrapper().in(SysStru::getOrganId, organIds));
        List<String> struFids = strus.stream().map(item -> item.getStruFid()).filter(item -> HussarUtils.isNotBlank((CharSequence)item)).collect(Collectors.toList());
        Map<Long, String> struMap = this.getSubStruIdsByStruFids(struFids);
        Map<Long, List<Long>> childMap = this.getChildByStruFids(struFids, struMap);
        Set<Long> struIds = struMap.keySet();
        List<Long> userStruIds = this.sysStruUserMapper.getDuplicateStruIdByStruIds(new ArrayList<Long>(struIds));
        List<Long> postStruIds = this.sysStruPostMapper.getDuplicateStruIdByStruIds(new ArrayList<Long>(struIds));
        List<Long> roleStruIds = this.sysStruRoleMapper.getDuplicateStruIdByStruIds(new ArrayList<Long>(struIds));
        List<Long> staffStruIds = this.sysStruStaffMapper.getDuplicateStruIdByStruIds(new ArrayList<Long>(struIds));
        Map<Long, String> organMap = organs.stream().collect(Collectors.toMap(SysOrgan::getId, SysOrgan::getOrganCode));
        for (SysStru stru : strus) {
            Long struId = stru.getId();
            String organCode = organMap.get(stru.getOrganId());
            List<Long> child = childMap.get(struId);
            if (CollectionUtils.containsAny(userStruIds, child)) {
                OrganUtil.addErrorMsg(errors, (Object)organCode, (String)"organCode", (String[])new String[]{"\u8be5\u7ec4\u7ec7\u673a\u6784\u53ca\u5176\u4e0b\u7ea7\u7ec4\u7ec7\u5b58\u5728\u5173\u8054\u7528\u6237"});
            }
            if (CollectionUtils.containsAny(staffStruIds, child)) {
                OrganUtil.addErrorMsg(errors, (Object)organCode, (String)"organCode", (String[])new String[]{"\u8be5\u7ec4\u7ec7\u673a\u6784\u53ca\u5176\u4e0b\u7ea7\u7ec4\u7ec7\u5b58\u5728\u5173\u8054\u4eba\u5458"});
            }
            if (CollectionUtils.containsAny(postStruIds, child)) {
                OrganUtil.addErrorMsg(errors, (Object)organCode, (String)"organCode", (String[])new String[]{"\u8be5\u7ec4\u7ec7\u673a\u6784\u53ca\u5176\u4e0b\u7ea7\u7ec4\u7ec7\u5b58\u5728\u5173\u8054\u5c97\u4f4d"});
            }
            if (!CollectionUtils.containsAny(roleStruIds, child)) continue;
            OrganUtil.addErrorMsg(errors, (Object)organCode, (String)"organCode", (String[])new String[]{"\u8be5\u7ec4\u7ec7\u673a\u6784\u53ca\u5176\u4e0b\u7ea7\u7ec4\u7ec7\u5b58\u5728\u5173\u8054\u89d2\u8272"});
        }
        if (HussarUtils.isEmpty(errors)) {
            result.setSuccess(true);
            result.setErrorList(null);
        } else {
            result.setErrorList(errors);
            result.setSuccess(false);
        }
        if (result.isSuccess()) {
            this.sysOfficeMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysOffice::getStruId, struIds));
            for (SysStru sysStru : strus) {
                Long parentId = sysStru.getParentId();
                SysStru parentSysStru = (SysStru)this.struService.getById((Serializable)parentId);
                Long count = this.struService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStru::getParentId, (Object)parentId)).ne(SysStru::getId, (Object)sysStru.getId()));
                if (count == null || count < 1L) {
                    parentSysStru.setIsLeaf("Y");
                    update.add(parentSysStru);
                }
                map.put(sysStru.getOrganId(), new OragnMapping(sysStru.getId(), sysStru.getOrganId()));
                this.sysStruMapper.delete((Wrapper)new LambdaQueryWrapper().likeRight(SysStru::getStruFid, (Object)sysStru.getStruFid()));
            }
            for (SysOrgan sysOrgan : organs) {
                OragnMapping oragnMapping = (OragnMapping)map.get(sysOrgan.getId());
                if (oragnMapping != null) {
                    dataMappings.add(new DataMapping(oragnMapping.getStruId(), sysOrgan.getOrganCode()));
                }
                HashMap<String, Object> queryOrgParams = new HashMap<String, Object>();
                queryOrgParams.put("organFcode", SqlQueryUtil.transferSpecialChar((String)sysOrgan.getOrganFcode()));
                queryOrgParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
                this.sysOrganMapper.deleteSubOrganByFcode(queryOrgParams);
            }
            if (HussarUtils.isNotEmpty(update)) {
                this.struService.updateBatchById(update);
            }
            result.setSuccessList(dataMappings);
        }
        return result;
    }

    @Override
    public R<String> deleteBatchOrganUserRelations(List<String> organCodes) {
        boolean canDelete;
        boolean bl = canDelete = HussarUtils.isNotEmpty(organCodes) && organCodes.size() <= 50;
        if (!canDelete) {
            throw new BaseException("\u6279\u91cf\u64cd\u4f5c\u6700\u591a\u53ea\u5141\u8bb8\u4e00\u6b21\u64cd\u4f5c50");
        }
        R result = new R();
        ArrayList errors = new ArrayList();
        for (String organCode : organCodes) {
            if (!HussarUtils.isBlank((CharSequence)organCode)) continue;
            OrganUtil.addErrorMsg(errors, (Object)organCode, (String)"organCode", (String[])new String[]{"\u7ec4\u7ec7\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"});
        }
        if (HussarUtils.isNotEmpty(errors)) {
            result.setErrorList(errors);
            result.setSuccess(false);
            return result;
        }
        ArrayList<DataMapping> dataMappings = new ArrayList<DataMapping>();
        LinkedHashMap<Long, OragnMapping> map = new LinkedHashMap<Long, OragnMapping>();
        List collect = organCodes.stream().filter(item -> HussarUtils.isNotBlank((CharSequence)item)).collect(Collectors.toList());
        List organs = this.organService.list((Wrapper)new LambdaQueryWrapper().in(SysOrgan::getOrganCode, collect));
        if (HussarUtils.isEmpty((Object)organs)) {
            result.setSuccess(true);
            result.setErrorList(null);
            return result;
        }
        List organIds = organs.stream().map(item -> item.getId()).collect(Collectors.toList());
        List strus = this.struService.list((Wrapper)new LambdaQueryWrapper().in(SysStru::getOrganId, organIds));
        List<String> struFids = strus.stream().map(item -> item.getStruFid()).filter(item -> HussarUtils.isNotBlank((CharSequence)item)).collect(Collectors.toList());
        Map<Long, String> struMap = this.getSubStruIdsByStruFids(struFids);
        Set<Long> struIds = struMap.keySet();
        List struUsers = this.sysStruUserMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysStruUser::getStruId, struIds));
        if (HussarUtils.isNotEmpty((Object)struUsers)) {
            Map<Long, List<Long>> userStruMap = this.getUserStruMap(struUsers);
            Set<Long> userIds = userStruMap.keySet();
            List struUserT = this.sysStruUserMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysStruUser::getUserId, userIds));
            Map<Long, List<Long>> userStruMapT = this.getUserStruMap(struUserT);
            ArrayList<Long> delUserIds = new ArrayList<Long>();
            for (Long userId : userIds) {
                List<Long> struIdList;
                List<Long> delStruIds = userStruMap.get(userId);
                if (!delStruIds.containsAll(struIdList = userStruMapT.get(userId))) continue;
                delUserIds.add(userId);
            }
            this.sysStruUserMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysStruUser::getStruId, struIds));
            if (HussarUtils.isNotEmpty(delUserIds)) {
                this.sysUserRoleMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysUserRole::getUserId, userIds));
                this.sysUserPostMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysUserPost::getUserId, userIds));
                this.sysUsersMapper.deleteBatchIds(userIds);
            }
            for (SysStru sysStru : strus) {
                map.put(sysStru.getOrganId(), new OragnMapping(sysStru.getId(), sysStru.getOrganId()));
            }
            for (SysOrgan sysOrgan : organs) {
                OragnMapping oragnMapping = (OragnMapping)map.get(sysOrgan.getId());
                if (oragnMapping == null) continue;
                dataMappings.add(new DataMapping(oragnMapping.getStruId(), sysOrgan.getOrganCode()));
            }
            result.setSuccessList(dataMappings);
        }
        return result;
    }

    @Override
    public R<String> deleteBatchOrganStaffRelations(List<String> organCodes) {
        boolean canDelete;
        boolean bl = canDelete = HussarUtils.isNotEmpty(organCodes) && organCodes.size() <= 50;
        if (!canDelete) {
            throw new BaseException("\u6279\u91cf\u64cd\u4f5c\u6700\u591a\u53ea\u5141\u8bb8\u4e00\u6b21\u64cd\u4f5c50");
        }
        R result = new R();
        ArrayList errors = new ArrayList();
        for (String organCode : organCodes) {
            if (!HussarUtils.isBlank((CharSequence)organCode)) continue;
            OrganUtil.addErrorMsg(errors, (Object)organCode, (String)"organCode", (String[])new String[]{"\u7ec4\u7ec7\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"});
        }
        if (HussarUtils.isNotEmpty(errors)) {
            result.setErrorList(errors);
            result.setSuccess(false);
            return result;
        }
        ArrayList<DataMapping> dataMappings = new ArrayList<DataMapping>();
        LinkedHashMap<Long, OragnMapping> map = new LinkedHashMap<Long, OragnMapping>();
        List collect = organCodes.stream().filter(item -> HussarUtils.isNotBlank((CharSequence)item)).collect(Collectors.toList());
        List organs = this.organService.list((Wrapper)new LambdaQueryWrapper().in(SysOrgan::getOrganCode, collect));
        if (HussarUtils.isEmpty((Object)organs)) {
            result.setSuccess(true);
            result.setErrorList(null);
            return result;
        }
        List organIds = organs.stream().map(item -> item.getId()).collect(Collectors.toList());
        List strus = this.struService.list((Wrapper)new LambdaQueryWrapper().in(SysStru::getOrganId, organIds));
        List<String> struFids = strus.stream().map(item -> item.getStruFid()).filter(item -> HussarUtils.isNotBlank((CharSequence)item)).collect(Collectors.toList());
        Map<Long, String> struMap = this.getSubStruIdsByStruFids(struFids);
        Set<Long> struIds = struMap.keySet();
        List srtuStaffs = this.sysStruStaffMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysStruStaff::getStruId, struIds));
        if (HussarUtils.isNotEmpty((Object)srtuStaffs)) {
            Map<Long, List<Long>> staffStruMap = this.getStaffStruMap(srtuStaffs);
            Set<Long> staffIds = staffStruMap.keySet();
            List srtuStaffT = this.sysStruStaffMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysStruStaff::getStaffId, staffIds));
            Map<Long, List<Long>> staffStruMapT = this.getStaffStruMap(srtuStaffT);
            ArrayList<Long> delStaffIds = new ArrayList<Long>();
            for (Long staffId : staffIds) {
                List<Long> struIdList;
                List<Long> delStruIds = staffStruMap.get(staffId);
                if (!delStruIds.containsAll(struIdList = staffStruMapT.get(staffId))) continue;
                delStaffIds.add(staffId);
            }
            this.sysStruStaffMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysStruStaff::getStruId, struIds));
            if (HussarUtils.isNotEmpty(delStaffIds)) {
                List users = this.sysUsersMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysUsers::getEmployeeId, delStaffIds));
                if (HussarUtils.isNotEmpty((Object)users)) {
                    List userIds = users.stream().map(SysUsers::getId).distinct().collect(Collectors.toList());
                    this.sysUserRoleMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysUserRole::getUserId, userIds));
                    this.sysUserPostMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysUserPost::getUserId, userIds));
                    this.sysStruUserMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysStruUser::getUserId, userIds));
                    this.sysUsersMapper.deleteBatchIds(userIds);
                }
                this.sysStaffMapper.deleteBatchIds(delStaffIds);
            }
            for (SysStru sysStru : strus) {
                map.put(sysStru.getOrganId(), new OragnMapping(sysStru.getId(), sysStru.getOrganId()));
            }
            for (SysOrgan sysOrgan : organs) {
                OragnMapping oragnMapping = (OragnMapping)map.get(sysOrgan.getId());
                if (oragnMapping == null) continue;
                dataMappings.add(new DataMapping(oragnMapping.getStruId(), sysOrgan.getOrganCode()));
            }
            result.setSuccessList(dataMappings);
        }
        return result;
    }

    @Override
    public R<String> deleteBatchOrganPostRelations(List<String> organCodes) {
        boolean canDelete;
        boolean bl = canDelete = HussarUtils.isNotEmpty(organCodes) && organCodes.size() <= 50;
        if (!canDelete) {
            throw new BaseException("\u6279\u91cf\u64cd\u4f5c\u6700\u591a\u53ea\u5141\u8bb8\u4e00\u6b21\u64cd\u4f5c50");
        }
        R result = new R();
        ArrayList errors = new ArrayList();
        for (String organCode : organCodes) {
            if (!HussarUtils.isBlank((CharSequence)organCode)) continue;
            OrganUtil.addErrorMsg(errors, (Object)organCode, (String)"organCode", (String[])new String[]{"\u7ec4\u7ec7\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"});
        }
        if (HussarUtils.isEmpty(errors)) {
            result.setSuccess(true);
            result.setErrorList(null);
        } else {
            result.setErrorList(errors);
            result.setSuccess(false);
        }
        if (result.isSuccess()) {
            ArrayList<DataMapping> dataMappings = new ArrayList<DataMapping>();
            LinkedHashMap<Long, OragnMapping> map = new LinkedHashMap<Long, OragnMapping>();
            List collect = organCodes.stream().filter(item -> HussarUtils.isNotBlank((CharSequence)item)).collect(Collectors.toList());
            List organs = this.organService.list((Wrapper)new LambdaQueryWrapper().in(SysOrgan::getOrganCode, collect));
            if (HussarUtils.isNotEmpty((Object)organs)) {
                List organIds = organs.stream().map(item -> item.getId()).collect(Collectors.toList());
                List strus = this.struService.list((Wrapper)new LambdaQueryWrapper().in(SysStru::getOrganId, organIds));
                List<String> struFids = strus.stream().map(item -> item.getStruFid()).filter(item -> HussarUtils.isNotBlank((CharSequence)item)).collect(Collectors.toList());
                Map<Long, String> struMap = this.getSubStruIdsByStruFids(struFids);
                Set<Long> struIds = struMap.keySet();
                this.sysStruPostMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysStruPost::getStruId, struIds));
                for (SysStru sysStru : strus) {
                    map.put(sysStru.getOrganId(), new OragnMapping(sysStru.getId(), sysStru.getOrganId()));
                }
                for (SysOrgan sysOrgan : organs) {
                    OragnMapping oragnMapping = (OragnMapping)map.get(sysOrgan.getId());
                    if (oragnMapping == null) continue;
                    dataMappings.add(new DataMapping(oragnMapping.getStruId(), sysOrgan.getOrganCode()));
                }
                result.setSuccessList(dataMappings);
            }
        }
        return result;
    }

    @Override
    public R<String> deleteBatchOrganRoleRelations(List<String> organCodes) {
        boolean canDelete;
        boolean bl = canDelete = HussarUtils.isNotEmpty(organCodes) && organCodes.size() <= 50;
        if (!canDelete) {
            throw new BaseException("\u6279\u91cf\u64cd\u4f5c\u6700\u591a\u53ea\u5141\u8bb8\u4e00\u6b21\u64cd\u4f5c50");
        }
        R result = new R();
        ArrayList errors = new ArrayList();
        for (String organCode : organCodes) {
            if (!HussarUtils.isBlank((CharSequence)organCode)) continue;
            OrganUtil.addErrorMsg(errors, (Object)organCode, (String)"organCode", (String[])new String[]{"\u7ec4\u7ec7\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"});
        }
        if (HussarUtils.isEmpty(errors)) {
            result.setSuccess(true);
            result.setErrorList(null);
        } else {
            result.setErrorList(errors);
            result.setSuccess(false);
        }
        if (result.isSuccess()) {
            ArrayList<DataMapping> dataMappings = new ArrayList<DataMapping>();
            LinkedHashMap<Long, OragnMapping> map = new LinkedHashMap<Long, OragnMapping>();
            List collect = organCodes.stream().filter(item -> HussarUtils.isNotBlank((CharSequence)item)).collect(Collectors.toList());
            List organs = this.organService.list((Wrapper)new LambdaQueryWrapper().in(SysOrgan::getOrganCode, collect));
            if (HussarUtils.isNotEmpty((Object)organs)) {
                List organIds = organs.stream().map(item -> item.getId()).collect(Collectors.toList());
                List strus = this.struService.list((Wrapper)new LambdaQueryWrapper().in(SysStru::getOrganId, organIds));
                List<String> struFids = strus.stream().map(item -> item.getStruFid()).filter(item -> HussarUtils.isNotBlank((CharSequence)item)).collect(Collectors.toList());
                Map<Long, String> struMap = this.getSubStruIdsByStruFids(struFids);
                Set<Long> struIds = struMap.keySet();
                this.sysStruRoleMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysStruRole::getStruId, struIds));
                for (SysStru sysStru : strus) {
                    map.put(sysStru.getOrganId(), new OragnMapping(sysStru.getId(), sysStru.getOrganId()));
                }
                for (SysOrgan sysOrgan : organs) {
                    OragnMapping oragnMapping = (OragnMapping)map.get(sysOrgan.getId());
                    if (oragnMapping == null) continue;
                    dataMappings.add(new DataMapping(oragnMapping.getStruId(), sysOrgan.getOrganCode()));
                }
                result.setSuccessList(dataMappings);
            }
        }
        return result;
    }

    static class OragnMapping {
        private Long organId;
        private Long struId;

        public OragnMapping() {
        }

        public OragnMapping(Long struId, Long organId) {
            this.organId = organId;
            this.struId = struId;
        }

        public Long getOrganId() {
            return this.organId;
        }

        public void setOrganId(Long organId) {
            this.organId = organId;
        }

        public Long getStruId() {
            return this.struId;
        }

        public void setStruId(Long struId) {
            this.struId = struId;
        }
    }
}

