/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.organ.dao.SysStaffMapper;
import com.jxdinfo.hussar.authorization.organ.dto.AddOnlyOutsideStaffDto;
import com.jxdinfo.hussar.authorization.organ.manager.AddOutsideStaffManager;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaff;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruStaffService;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.organ.manager.impl.addOutsideStaffManagerImpl")
public class AddOutsideStaffManagerImpl
implements AddOutsideStaffManager {
    @Resource
    private SysStaffMapper sysStaffMapper;
    @Resource
    private ISysStruStaffService sysStruStaffService;

    @Override
    public R<AddOnlyOutsideStaffDto> addOnlyStaff(AddOnlyOutsideStaffDto staff) {
        R result = new R();
        List errors = OrganUtil.validateOne((Object)staff);
        String staffCode = StringUtils.trimToEmpty((String)staff.getStaffCode());
        long count = this.sysStaffMapper.selectCount((Wrapper)new LambdaQueryWrapper().eq(SysStaff::getStaffCode, (Object)staffCode));
        if (count > 0L) {
            OrganUtil.addErrorMsg((List)errors, (Object)staff, (String)"staffCode", (String[])new String[]{"\u4eba\u5458\u7f16\u7801\u91cd\u590d"});
        }
        if (HussarUtils.isEmpty((Object)errors)) {
            SysStaff sysStaff = new SysStaff();
            ArrayList<SysStruStaff> struStaffList = new ArrayList<SysStruStaff>();
            this.initializationAdd(staff, struStaffList, sysStaff);
            if (HussarUtils.isNotEmpty(struStaffList)) {
                this.sysStruStaffService.saveBatch(struStaffList);
            }
            this.sysStaffMapper.insert(sysStaff);
            result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysStaff.getId(), sysStaff.getStaffCode())}));
        } else {
            result.setSuccess(false);
            result.setErrorList(errors);
        }
        return result;
    }

    private void initializationAdd(AddOnlyOutsideStaffDto staff, List<SysStruStaff> struStaffList, SysStaff sysStaff) {
        long sysStaffId = HussarUtils.isNotEmpty((Object)staff.getStaffId()) ? staff.getStaffId() : IdWorker.getId((Object)sysStaff);
        List struIds = staff.getOrganIds();
        String staffCode = StringUtils.trimToEmpty((String)staff.getStaffCode());
        String staffName = StringUtils.trimToEmpty((String)staff.getStaffName());
        String staffPosition = StringUtils.trimToEmpty((String)staff.getStaffPosition());
        String sex = StringUtils.trimToEmpty((String)staff.getSex());
        String birthday = StringUtils.trimToEmpty((String)staff.getBirthday());
        String idcard = StringUtils.trimToEmpty((String)staff.getIdcard());
        String address = StringUtils.trimToEmpty((String)staff.getAddress());
        String workId = StringUtils.trimToEmpty((String)staff.getWorkId());
        String workDate = StringUtils.trimToEmpty((String)staff.getWorkDate());
        String graduateDate = StringUtils.trimToEmpty((String)staff.getGraduateDate());
        String graduateSchool = StringUtils.trimToEmpty((String)staff.getGraduateSchool());
        String staffRemark = StringUtils.trimToEmpty((String)staff.getStaffRemark());
        sysStaff.setId(Long.valueOf(sysStaffId));
        sysStaff.setName(staffName);
        sysStaff.setAddress(address);
        sysStaff.setBirthday(birthday);
        sysStaff.setSex(sex);
        sysStaff.setIdcard(idcard);
        sysStaff.setGraduateDate(graduateDate);
        sysStaff.setGraduateSchool(graduateSchool);
        sysStaff.setWorkDate(workDate);
        sysStaff.setWorkId(workId);
        sysStaff.setStaffPosition(staffPosition);
        sysStaff.setStaffCode(staffCode);
        sysStaff.setRemark(staffRemark);
        int staffOrder = 1;
        Integer maxStaffOrder = this.sysStaffMapper.getMaxOrder();
        staffOrder = HussarUtils.isEmpty((Object)maxStaffOrder) ? staffOrder : maxStaffOrder + 1;
        sysStaff.setStaffOrder(Integer.valueOf(staffOrder));
        if (HussarUtils.isNotEmpty((Object)struIds)) {
            struIds = struIds.stream().distinct().collect(Collectors.toList());
            for (Long struId : struIds) {
                SysStruStaff sysStruStaff = new SysStruStaff();
                sysStruStaff.setStruId(struId);
                sysStruStaff.setStaffId(Long.valueOf(sysStaffId));
                struStaffList.add(sysStruStaff);
            }
        }
    }
}

