/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.adapter.role.IHussarBaseRoleAdapter;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.permit.dao.SysStruRoleMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysStruRole;
import com.jxdinfo.hussar.authorization.permit.model.SysStruRoleAudit;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruRoleAuditService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.impl.RoleUserAuthorizationChangeReporter;
import com.jxdinfo.hussar.authorization.relational.dao.SysStruUserMapper;
import com.jxdinfo.hussar.authorization.relational.dto.QueryOrganPostRoleDto;
import com.jxdinfo.hussar.authorization.relational.dto.RoleOrganRelationDto;
import com.jxdinfo.hussar.authorization.relational.vo.OrganPostRoleVo;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysAuditConfigService;
import com.jxdinfo.hussar.common.constant.state.StruRoleStatus;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.rolemanager.RoleOrganChangeNotify;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysStruRoleServiceImpl
extends HussarServiceImpl<SysStruRoleMapper, SysStruRole>
implements ISysStruRoleService {
    @Resource
    private SysStruRoleMapper sysStruRoleMapper;
    @Resource
    private SysStruUserMapper sysStruUserMapper;
    @Resource
    private ISysRolesService sysRolesService;
    @Autowired
    private ISysUserRoleService sysUserRoleService;
    @Autowired
    private ISysAuditConfigService sysAuditConfig;
    @Autowired
    private ISysStruRoleAuditService sysStruRoleAuditService;
    @Resource
    private IHussarBaseRoleAdapter hussarBaseRoleAdapter;
    @Autowired
    private RoleOrganChangeNotify roleOrganChangeNotify;
    @Resource
    private RoleUserAuthorizationChangeReporter userAuthorizationChangeReporter;

    public List<Long> getRolesByStruId(Long struId) {
        return this.hussarBaseRoleAdapter.getRolesByStruId(struId);
    }

    @HussarTransactional
    public String saveRoleOrgan(RoleOrganRelationDto roleOrganRelationDto) {
        StringBuilder stringBuilder = new StringBuilder();
        List struRoleAudits = this.sysStruRoleAuditService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruRoleAudit::getRoleId, (Object)roleOrganRelationDto.getRoleId())).eq(SysStruRoleAudit::getStatus, (Object)"0"));
        AssertUtil.isEmpty((Collection)struRoleAudits, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_SAVE_FAILE_EXIST_UNAPPROVED_ASSOCIATED_ORGAN.getMessage()));
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isOrganAudit()) {
            this.doProcessStruRoleAudit(roleOrganRelationDto);
            stringBuilder.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.SAVE_SUCCESS_WAIT_REVIEW.getMessage()));
        } else {
            Long roleId = roleOrganRelationDto.getRoleId();
            SysRoles role = (SysRoles)this.sysRolesService.getById((Serializable)roleId);
            ArrayList struIdList = new ArrayList();
            if (HussarUtils.isEmpty((Object)role.getAppId()) || role.getAppId() == 1L) {
                List sysStruRoles = this.sysStruRoleMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysStruRole::getGrantedRole, (Object)roleId));
                List oldStruIds = sysStruRoles.stream().map(SysStruRole::getStruId).distinct().collect(Collectors.toList());
                String struIdStr = roleOrganRelationDto.getStruIds();
                if (HussarUtils.isNotEmpty((Object)struIdStr)) {
                    List newStruIds = Arrays.asList(struIdStr.split(",")).stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                    List addStruIds = newStruIds.stream().filter(item -> !oldStruIds.contains(item)).collect(Collectors.toList());
                    List delStruIds = oldStruIds.stream().filter(item -> !newStruIds.contains(item)).collect(Collectors.toList());
                    struIdList.addAll(addStruIds);
                    struIdList.addAll(delStruIds);
                } else {
                    struIdList.addAll(oldStruIds);
                }
            }
            this.doProcessStruRole(roleOrganRelationDto);
            if (HussarUtils.isNotEmpty((Object)role.getAppId()) && role.getAppId() != 1L) {
                this.roleOrganChangeNotify.notify(DataChangeType.RELATE, new Object[]{roleId, null});
            }
            if (HussarUtils.isEmpty((Object)role.getAppId()) || role.getAppId() == 1L) {
                this.userAuthorizationChangeReporter.report(new Object[]{"organ", struIdList});
            }
            stringBuilder.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.SAVE_SUCCESS.getMessage()));
        }
        return stringBuilder.toString();
    }

    private void doProcessStruRoleAudit(RoleOrganRelationDto roleOrganRelationDto) {
        SysStruRoleAudit struRoleAudit;
        ArrayList<SysStruRoleAudit> struRoleAudits = new ArrayList<SysStruRoleAudit>();
        Long roleId = roleOrganRelationDto.getRoleId();
        String struIds = roleOrganRelationDto.getStruIds();
        List<Object> struIdList = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)struIds)) {
            struIdList = Arrays.stream(struIds.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        }
        ArrayList newStruIds = struIdList;
        List struRoles = this.sysStruRoleMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruRole::getGrantedRole, (Object)roleId)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
        List oldStruIds = struRoles.stream().map(SysStruRole::getStruId).collect(Collectors.toList());
        List<Object> addStruIds = new ArrayList();
        List<Object> delStruIds = new ArrayList();
        if (HussarUtils.isEmpty(oldStruIds) && HussarUtils.isNotEmpty(newStruIds)) {
            addStruIds = newStruIds;
        }
        if (HussarUtils.isEmpty(newStruIds) && HussarUtils.isNotEmpty(oldStruIds)) {
            delStruIds = oldStruIds;
        }
        if (HussarUtils.isNotEmpty(newStruIds) && HussarUtils.isNotEmpty(oldStruIds)) {
            addStruIds = newStruIds.stream().filter(item -> !oldStruIds.contains(item)).collect(Collectors.toList());
            delStruIds = oldStruIds.stream().filter(item -> !newStruIds.contains(item)).collect(Collectors.toList());
        }
        if (HussarUtils.isNotEmpty(addStruIds)) {
            for (Long struId : addStruIds) {
                struRoleAudit = new SysStruRoleAudit();
                struRoleAudit.setStruId(struId);
                struRoleAudit.setRoleId(roleId);
                struRoleAudit.setStatus(StruRoleStatus.LOCKED.getCode());
                struRoleAudit.setOperationType("1");
                struRoleAudits.add(struRoleAudit);
            }
        }
        if (HussarUtils.isNotEmpty(delStruIds)) {
            for (Long struId : delStruIds) {
                struRoleAudit = new SysStruRoleAudit();
                struRoleAudit.setStruId(struId);
                struRoleAudit.setRoleId(roleId);
                struRoleAudit.setStatus(StruRoleStatus.LOCKED.getCode());
                struRoleAudit.setOperationType("2");
                struRoleAudits.add(struRoleAudit);
            }
        }
        if (HussarUtils.isNotEmpty(struRoleAudits)) {
            this.sysStruRoleAuditService.saveBatch(struRoleAudits, struRoleAudits.size());
        }
    }

    private void doProcessStruRole(RoleOrganRelationDto roleOrganRelationDto) {
        Long roleId = roleOrganRelationDto.getRoleId();
        String struIds = roleOrganRelationDto.getStruIds();
        this.sysStruRoleMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysStruRole::getGrantedRole, (Object)roleId));
        List<Object> struIdList = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)struIds)) {
            struIdList = Arrays.asList(struIds.split(","));
        }
        ArrayList<SysStruRole> sysOrganRoleList = new ArrayList<SysStruRole>();
        for (String string : struIdList) {
            if (ToolUtil.isEmpty((Object)string)) continue;
            SysStruRole sysOrganRole = new SysStruRole();
            sysOrganRole.setGrantedRole(roleId);
            sysOrganRole.setStruId(Long.valueOf(string));
            sysOrganRoleList.add(sysOrganRole);
        }
        if (ToolUtil.isNotEmpty(sysOrganRoleList)) {
            super.saveBatch(sysOrganRoleList, sysOrganRoleList.size());
        }
        List userIds = this.sysRolesService.delCacheAuthInfo(roleId);
        for (Long userId : userIds) {
            this.sysRolesService.delAuthCacheInfo(userId);
        }
    }

    public List<OrganPostRoleVo> getOrganPostRoleList(QueryOrganPostRoleDto queryOrganPostRoleDto) {
        Long[] temp;
        String struIds = StringUtils.trimToEmpty((String)queryOrganPostRoleDto.getStruIds());
        String postIds = StringUtils.trimToEmpty((String)queryOrganPostRoleDto.getPostIds());
        ArrayList<Long> struIdList = new ArrayList<Long>();
        ArrayList<Long> postIdList = new ArrayList<Long>();
        if (HussarUtils.isNotBlank((CharSequence)struIds)) {
            temp = (Long[])ConvertUtils.convert((String[])struIds.split(","), Long.class);
            struIdList.addAll(Arrays.asList(temp));
        }
        if (HussarUtils.isNotBlank((CharSequence)postIds)) {
            temp = (Long[])ConvertUtils.convert((String[])postIds.split(","), Long.class);
            postIdList.addAll(Arrays.asList(temp));
        }
        struIdList.add(-1L);
        postIdList.add(-1L);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        queryParams.put("sourceName", SqlQueryUtil.transferSpecialChar((String)queryOrganPostRoleDto.getSourceName()));
        queryParams.put("roleName", SqlQueryUtil.transferSpecialChar((String)queryOrganPostRoleDto.getRoleName()));
        queryParams.put("struIds", struIdList);
        queryParams.put("postIds", postIdList);
        List<OrganPostRoleVo> organPostRoleVos = this.sysStruRoleMapper.queryOrganPostRoleList(queryParams);
        if (HussarUtils.isEmpty(organPostRoleVos)) {
            return Collections.emptyList();
        }
        return organPostRoleVos;
    }

    @HussarTransactional
    public void saveAppRoleOrgan(Long roleId, List<Long> struIds) {
        List sysStruRoles = this.sysStruRoleMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysStruRole::getGrantedRole, (Object)roleId));
        List<Object> oldStruIds = new ArrayList();
        List<Object> addStruIds = new ArrayList<Long>();
        List<Object> delStruIds = new ArrayList<Object>();
        if (HussarUtils.isNotEmpty((Object)sysStruRoles)) {
            oldStruIds = sysStruRoles.stream().map(SysStruRole::getStruId).distinct().collect(Collectors.toList());
        }
        if (HussarUtils.isNotEmpty(oldStruIds) && HussarUtils.isNotEmpty(struIds)) {
            ArrayList finalOldStruIds = oldStruIds;
            addStruIds = struIds.stream().filter(item -> !finalOldStruIds.contains(item)).collect(Collectors.toList());
            delStruIds = oldStruIds.stream().filter(item -> !struIds.contains(item)).collect(Collectors.toList());
        } else if (HussarUtils.isNotEmpty(oldStruIds) && HussarUtils.isEmpty(struIds)) {
            delStruIds.addAll(oldStruIds);
        } else if (HussarUtils.isEmpty(oldStruIds) && HussarUtils.isNotEmpty(struIds)) {
            addStruIds.addAll(struIds);
        } else {
            return;
        }
        if (HussarUtils.isNotEmpty(addStruIds)) {
            ArrayList<SysStruRole> struRoleList = new ArrayList<SysStruRole>();
            for (Long l : addStruIds) {
                SysStruRole struRole = new SysStruRole();
                struRole.setGrantedRole(roleId);
                struRole.setStruId(l);
                struRoleList.add(struRole);
            }
            if (ToolUtil.isNotEmpty(struRoleList)) {
                super.saveBatch(struRoleList, struRoleList.size());
                this.userAuthorizationChangeReporter.report(new Object[]{"organ", addStruIds});
            }
        }
    }
}

