/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleResourceMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysStruFunctionsMapper;
import com.jxdinfo.hussar.authorization.permit.dto.FuncPermitDto;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysStruFunctions;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruFunctionsService;
import com.jxdinfo.hussar.authorization.permit.vo.StruFunVo;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysStruFunctionsServiceImpl
extends HussarServiceImpl<SysStruFunctionsMapper, SysStruFunctions>
implements ISysStruFunctionsService {
    @Autowired
    private ISysFunctionResourcesService iSysFunctionResourcesService;
    @Resource
    private SysRoleResourceMapper sysRoleResourceMapper;
    @Resource
    private SysStruFunctionsMapper sysStruFunctionsMapper;

    public List<Long> getStruFunctionCountMap(List<JSTreeModel> list, List<Long> functionIdList) {
        ArrayList<Long> struIdList = new ArrayList<Long>();
        for (JSTreeModel jsTreeModel : list) {
            Long struId = jsTreeModel.getId();
            struIdList.add(struId);
        }
        int maxSize = functionIdList.size();
        ArrayList<Long> rtnList = new ArrayList<Long>();
        ArrayList<List<Long>> array = new ArrayList<List<Long>>();
        int size = struIdList.size();
        for (int i = 0; i < size; i += 999) {
            if (i + 999 < size) {
                array.add(struIdList.subList(i, i + 999));
                continue;
            }
            array.add(struIdList.subList(i, size));
        }
        List<StruFunVo> result = this.sysStruFunctionsMapper.getStruFunctionCountMap(array, functionIdList);
        for (StruFunVo struFunVo : result) {
            Long struId = struFunVo.getStruId();
            String countStr = struFunVo.getStruCount();
            Long count = Long.parseLong(countStr);
            if (count.intValue() != maxSize) continue;
            rtnList.add(struId);
        }
        return rtnList;
    }

    @HussarTransactional
    public ApiResponse saveDelegateFunction(FuncPermitDto funcPermitDto) {
        String functionId = funcPermitDto.getFunctionIdHidden();
        if (ToolUtil.isEmpty((Object)functionId)) {
            throw new HussarException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_DROPDOWN_FUNCTION_ID_EMPTY.getMessage()));
        }
        String[] struIdArr = funcPermitDto.getStruIdHidden() == null ? "".split(",") : funcPermitDto.getStruIdHidden().split(",");
        ArrayList<String> struIdList = new ArrayList<String>(Arrays.asList(struIdArr));
        ArrayList struIds = new ArrayList();
        struIdList.forEach(struId -> struIds.add(Long.valueOf(struId)));
        ArrayList<List<Long>> struIdDoubleList = new ArrayList<List<Long>>();
        int size = struIds.size();
        for (int i = 0; i < struIds.size(); i += 999) {
            if (i + 999 < size) {
                struIdDoubleList.add(struIds.subList(i, i + 999));
                continue;
            }
            struIdDoubleList.add(struIds.subList(i, size));
        }
        ArrayList<Long> funtionIdList = new ArrayList<Long>();
        funtionIdList.add(Long.valueOf(functionId));
        this.sysStruFunctionsMapper.deleteStruFuncton(struIdDoubleList, funtionIdList);
        ArrayList<SysStruFunctions> functionsList = new ArrayList<SysStruFunctions>();
        for (String tmpStruId : struIdList) {
            for (Long tmpFunctionId : funtionIdList) {
                SysStruFunctions sysStruFunctions = new SysStruFunctions();
                sysStruFunctions.setStruId(Long.valueOf(tmpStruId));
                sysStruFunctions.setFunctionId(tmpFunctionId);
                functionsList.add(sysStruFunctions);
            }
        }
        if (ToolUtil.isEmpty(functionsList)) {
            throw new HussarException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_SELECTED_FUNCTIONS_DEPLOYED_ORG.getMessage()));
        }
        if (!super.saveBatch(functionsList, functionsList.size())) {
            throw new HussarException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DECENTRALIZE_FAILED.getMessage()));
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.DELEGATE_SUCCESS.getMessage()));
    }

    @HussarTransactional
    public ApiResponse saveRetrieveFunction(FuncPermitDto funcPermitDto) {
        String functionId = funcPermitDto.getFunctionIdHidden();
        if (ToolUtil.isEmpty((Object)functionId)) {
            throw new HussarException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_RECYCLING_FUNCTION_ID_EMPTY.getMessage()));
        }
        String[] struIdArr = funcPermitDto.getStruIdHidden() == null ? "".split(",") : funcPermitDto.getStruIdHidden().split(",");
        String[] orginalIds = funcPermitDto.getOriginal() == null ? "".split(",") : funcPermitDto.getOriginal().split(",");
        List<String> originalIdList = Arrays.asList(orginalIds);
        ArrayList originalIds = new ArrayList();
        originalIdList.forEach(id -> originalIds.add(Long.valueOf(id)));
        ArrayList<List<Long>> originalIdDoubleList = new ArrayList<List<Long>>();
        int size = originalIds.size();
        for (int i = 0; i < originalIdList.size(); i += 999) {
            if (i + 999 < size) {
                originalIdDoubleList.add(originalIds.subList(i, i + 999));
                continue;
            }
            originalIdDoubleList.add(originalIds.subList(i, size));
        }
        ArrayList<String> struIdList = new ArrayList<String>(Arrays.asList(struIdArr));
        ArrayList<Long> funtionIdList = new ArrayList<Long>();
        funtionIdList.add(Long.valueOf(functionId));
        QueryWrapper sysFunctionResourcesQueryWrapper = new QueryWrapper();
        sysFunctionResourcesQueryWrapper.lambda().in(SysFunctionResources::getFunctionId, funtionIdList);
        List sysFunctionResourcesList = this.iSysFunctionResourcesService.list((Wrapper)sysFunctionResourcesQueryWrapper);
        ArrayList<Long> resourceIdList = ToolUtil.isNotEmpty((Object)sysFunctionResourcesList) ? sysFunctionResourcesList.stream().map(SysFunctionResources::getResourceId).collect(Collectors.toList()) : new ArrayList<Long>();
        this.sysStruFunctionsMapper.deleteStruFuncton(originalIdDoubleList, funtionIdList);
        this.sysStruFunctionsMapper.deleteStruRoleFunction(originalIdDoubleList, funtionIdList);
        if (ToolUtil.isNotEmpty(resourceIdList)) {
            this.sysRoleResourceMapper.deleteStruRoleResource(originalIdDoubleList, resourceIdList);
        }
        ArrayList<SysStruFunctions> functionsList = new ArrayList<SysStruFunctions>();
        for (String tmpStruId : struIdList) {
            if ("".equals(tmpStruId)) continue;
            for (Long tmpFunctionId : funtionIdList) {
                SysStruFunctions sysStruFunctions = new SysStruFunctions();
                sysStruFunctions.setStruId(Long.valueOf(tmpStruId));
                sysStruFunctions.setFunctionId(tmpFunctionId);
                functionsList.add(sysStruFunctions);
            }
        }
        if (ToolUtil.isNotEmpty(functionsList) && !super.saveBatch(functionsList, functionsList.size())) {
            throw new HussarException(TranslateUtil.getTranslateName((String)TipConstantsEnum.RETRIEVE_FAIL.getMessage()));
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.RETRIEVE_SUCCESS.getMessage()));
    }
}

