/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.permit.dao.SysResourceTypeMapper;
import com.jxdinfo.hussar.authorization.permit.dto.QueryResourceTypeDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResourceTypeDto;
import com.jxdinfo.hussar.authorization.permit.manager.ResourceTypeManager;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceType;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceTypeExpand;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseResTypeExpandService;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseResourceTypeService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.authorization.permit.vo.ResourceTypeVo;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import com.jxdinfo.hussar.validator.service.IHussarValidateService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.permit.manager.impl.resourceTypeManagerImpl")
public class ResourceTypeManagerImpl
implements ResourceTypeManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceTypeManagerImpl.class);
    @Autowired
    private IHussarValidateService hussarValidateService;
    @Resource
    private SysResourceTypeMapper sysResourceTypeMapper;
    @Autowired
    private IHussarBaseResourceTypeService hussarBaseResourceTypeService;
    @Autowired
    private ISysIdtableService sysIdtableService;
    @Autowired
    private IHussarBaseResTypeExpandService hussarBaseResTypeExpandService;
    @Autowired
    private ISysResourcesService sysResourcesService;

    @Override
    public Page<ResourceTypeVo> searchResTypes(PageInfo pageInfo, QueryResourceTypeDto queryResourceTypeDto) {
        String validateMsg = this.hussarValidateService.validate((Object)queryResourceTypeDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("resourceTypeName", SqlQueryUtil.transferSpecialChar((String)StringUtil.trimToEmpty((CharSequence)queryResourceTypeDto.getResourceTypeName())));
        queryParams.put("status", queryResourceTypeDto.getStatus());
        queryParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        List<ResourceTypeVo> resourceTypeVos = this.sysResourceTypeMapper.searchResTypes((Page<ResourceTypeVo>)page, queryParams);
        TranslateUtil.translate(resourceTypeVos, ResourceTypeVo::getResourceTypeNameLangKey, ResourceTypeVo::setResourceTypeName);
        TranslateUtil.translate(resourceTypeVos, ResourceTypeVo::getRemarkLangKey, ResourceTypeVo::setRemark);
        page.setRecords(resourceTypeVos);
        return page;
    }

    @Override
    public List<ResourceTypeVo> availableList() {
        List resourceTypes = this.hussarBaseResourceTypeService.list((Wrapper)new LambdaQueryWrapper().eq(SysResourceType::getTypeStatus, (Object)1));
        if (HussarUtils.isEmpty((Object)resourceTypes)) {
            return Collections.emptyList();
        }
        ArrayList<ResourceTypeVo> resourceTypeVos = new ArrayList<ResourceTypeVo>();
        for (SysResourceType type : resourceTypes) {
            ResourceTypeVo vo = new ResourceTypeVo();
            vo.setId(type.getId());
            vo.setRemark(TranslateUtil.getTranslateName((String)type.getRemarkLangKey()));
            vo.setResourceTypeName(TranslateUtil.getTranslateName((String)type.getNameLangKey()));
            vo.setStatus(type.getTypeStatus());
            vo.setResourceTypeCode(type.getResourceTypeCode());
            vo.setIsSys(type.getIsSys());
            resourceTypeVos.add(vo);
        }
        return resourceTypeVos;
    }

    @Override
    public SysResourceType addResourceType(ResourceTypeDto resourceTypeDto) {
        String validateMsg = this.hussarValidateService.validate((Object)resourceTypeDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        SysResourceType resourceType = new SysResourceType();
        String resourceTypeCode = resourceTypeDto.getResourceTypeCode();
        if (HussarUtils.isNotBlank((CharSequence)resourceTypeCode)) {
            boolean flag;
            boolean bl = flag = !resourceTypeCode.contains("/") && resourceTypeCode.length() < 33;
            if (!flag) {
                LOGGER.warn(resourceTypeCode + ":" + TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RES_TYPE_CODE_CHARACTER_LENGTH_32.getMessage()));
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RES_TYPE_CODE_CHARACTER_LENGTH_32.getMessage()));
            }
        }
        resourceType.setResourceTypeCode(resourceTypeCode);
        Long id = IdWorker.getId((Object)resourceType);
        resourceType.setId(id);
        resourceType.setResourceTypeName(resourceTypeDto.getResourceTypeName());
        resourceType.setResourceTypeCode(this.getCode(resourceType));
        resourceType.setTypeStatus(Integer.valueOf(1));
        resourceType.setRemark(resourceTypeDto.getRemark());
        resourceType.setIsSys(Integer.valueOf(0));
        this.hussarBaseResourceTypeService.save((Object)resourceType);
        return resourceType;
    }

    @Override
    public String editResourceType(ResourceTypeDto resourceTypeDto) {
        String validateMsg = this.hussarValidateService.validate((Object)resourceTypeDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        Long id = resourceTypeDto.getId();
        if (HussarUtils.isEmpty((Object)id)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RES_TYPE_ID_NOT_NULL.getMessage()));
        }
        SysResourceType resourceType = (SysResourceType)this.hussarBaseResourceTypeService.getById((Serializable)id);
        if (HussarUtils.isEmpty((Object)resourceType)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_THIS_RES_TYPE_INFO.getMessage()));
        }
        resourceType.setResourceTypeName(resourceTypeDto.getResourceTypeName());
        resourceType.setRemark(resourceTypeDto.getRemark());
        this.hussarBaseResourceTypeService.updateById((Object)resourceType);
        return TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_SUCCESS.getMessage());
    }

    @Override
    public String updateStatus(Long id) {
        if (HussarUtils.isEmpty((Object)id)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RES_TYPE_ID_NOT_NULL.getMessage()));
        }
        SysResourceType resourceType = (SysResourceType)this.hussarBaseResourceTypeService.getById((Serializable)id);
        if (HussarUtils.isEmpty((Object)resourceType)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_THIS_RES_TYPE_INFO.getMessage()));
        }
        Integer status = resourceType.getTypeStatus();
        resourceType.setTypeStatus(Integer.valueOf(HussarUtils.equals((Object)1, (Object)status) ? 0 : 1));
        this.hussarBaseResourceTypeService.updateById((Object)resourceType);
        return TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_OPERATE_SUCCESS.getMessage());
    }

    @Override
    public ResourceTypeVo loadResType(Long id) {
        if (HussarUtils.isEmpty((Object)id)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RES_TYPE_ID_NOT_NULL.getMessage()));
        }
        SysResourceType resourceType = (SysResourceType)this.hussarBaseResourceTypeService.getById((Serializable)id);
        if (HussarUtils.isEmpty((Object)resourceType)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_THIS_RES_TYPE_INFO.getMessage()));
        }
        ResourceTypeVo vo = new ResourceTypeVo();
        vo.setId(resourceType.getId());
        vo.setIsSys(resourceType.getIsSys());
        vo.setRemark(resourceType.getRemark());
        vo.setResourceTypeName(resourceType.getResourceTypeName());
        vo.setResourceTypeCode(resourceType.getResourceTypeCode());
        vo.setStatus(resourceType.getTypeStatus());
        TranslateUtil.translate((Object)vo, ResourceTypeVo::getResourceTypeNameLangKey, ResourceTypeVo::setResourceTypeName);
        TranslateUtil.translate((Object)vo, ResourceTypeVo::getRemarkLangKey, ResourceTypeVo::setRemark);
        return vo;
    }

    @Override
    public String deleteResourceType(List<Long> ids) {
        if (HussarUtils.isEmpty(ids)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RES_TYPE_ID_NOT_NULL.getMessage()));
        }
        List resourceTypes = this.hussarBaseResourceTypeService.listByIds(ids);
        if (HussarUtils.isEmpty((Object)resourceTypes)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_THIS_RES_TYPE_INFO.getMessage()));
        }
        List resTypeCodes = resourceTypes.stream().map(SysResourceType::getResourceTypeCode).collect(Collectors.toList());
        List resource = this.sysResourcesService.list((Wrapper)new LambdaQueryWrapper().in(SysResources::getResTypeId, resTypeCodes));
        if (HussarUtils.isNotEmpty((Object)resource)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_FAIL_EXIST_RESOURCE.getMessage()));
        }
        this.hussarBaseResourceTypeService.removeByIds(ids);
        this.hussarBaseResTypeExpandService.remove((Wrapper)new LambdaQueryWrapper().in(SysResourceTypeExpand::getResourceTypeId, ids));
        return TranslateUtil.getTranslateName((String)TipConstantsEnum.DELETE_SUCCESS_WAIT_REVIEW.getMessage());
    }

    @Override
    public boolean checkCanEditOrDel(Long resourceTypeId) {
        if (HussarUtils.isEmpty((Object)resourceTypeId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RES_TYPE_ID_NOT_NULL.getMessage()));
        }
        SysResourceType resourceType = (SysResourceType)this.hussarBaseResourceTypeService.getById((Serializable)resourceTypeId);
        List resources = this.sysResourcesService.list((Wrapper)new LambdaQueryWrapper().eq(SysResources::getResTypeId, (Object)resourceType.getResourceTypeCode()));
        return HussarUtils.isEmpty((Object)resources);
    }

    @Override
    public boolean getIsSysResType(String resTypeCode) {
        if (HussarUtils.isBlank((CharSequence)resTypeCode)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RES_TYPE_CODE_NO_PASSED.getMessage()));
        }
        SysResourceType resourceType = (SysResourceType)this.hussarBaseResourceTypeService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysResourceType::getResourceTypeCode, (Object)resTypeCode));
        if (HussarUtils.isEmpty((Object)resourceType)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_THIS_RES_TYPE_INFO.getMessage()));
        }
        Integer isSys = resourceType.getIsSys();
        return HussarUtils.equals((Object)1, (Object)isSys);
    }

    private String getCode(SysResourceType sysResourceType) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        long currentCount = 1L;
        String code = StringUtils.trimToEmpty((String)sysResourceType.getResourceTypeCode());
        if (HussarUtils.isBlank((CharSequence)code)) {
            while (currentCount != 0L) {
                lambdaQueryWrapper.clear();
                code = this.sysIdtableService.getCurrentCode("RESOURCE_TYPE_CODE", "SYS_RESOURCE_TYPE");
                lambdaQueryWrapper.eq(SysResourceType::getResourceTypeCode, (Object)code);
                currentCount = this.sysResourceTypeMapper.selectCount((Wrapper)lambdaQueryWrapper);
            }
        } else {
            lambdaQueryWrapper.eq(SysResourceType::getResourceTypeCode, (Object)code);
            currentCount = this.sysResourceTypeMapper.selectCount((Wrapper)lambdaQueryWrapper);
            if (currentCount > 0L) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL_EXIST_RESOURCE_TYPE_CODE.getMessage()));
            }
        }
        return code;
    }
}

