/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.manager.impl;

import com.alibaba.excel.write.handler.WriteHandler;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.permit.enums.AccountTypeEnum;
import com.jxdinfo.hussar.authorization.permit.enums.GenderEnum;
import com.jxdinfo.hussar.authorization.permit.enums.UserExcelEnum;
import com.jxdinfo.hussar.authorization.permit.manager.ExportUserManager;
import com.jxdinfo.hussar.authorization.permit.manager.impl.CommonUserManager;
import com.jxdinfo.hussar.authorization.permit.model.ExcelExportDesc;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.model.UserExcel;
import com.jxdinfo.hussar.authorization.permit.vo.UserOrganPostVo;
import com.jxdinfo.hussar.authorization.relational.dao.SysStruUserMapper;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.excel.builder.ConcreteExcelBuilder;
import com.jxdinfo.hussar.excel.builder.ExcelProduct;
import com.jxdinfo.hussar.excel.handler.CustomSheetWriteHandler;
import com.jxdinfo.hussar.excel.handler.DataValidationSheetWriteHandler;
import com.jxdinfo.hussar.excel.model.ClassSheetMsg;
import com.jxdinfo.hussar.excel.service.IHussarBaseExcelService;
import com.jxdinfo.hussar.excel.service.ISysExcelTaskService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.beanutils.ConvertUtils;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class ExportUserManagerImpl
extends CommonUserManager
implements ExportUserManager {
    @Resource
    private IHussarBaseExcelService hussarBaseExcelServiceImpl;
    @Resource
    private SysStruUserMapper sysStruUserMapper;
    @Resource
    private ISysExcelTaskService sysExcelTaskServiceImpl;
    @Resource
    private HussarThreadPoolConfiguration hussarThreadPoolConfiguration;

    @Override
    public void exportUserExcel(String ids, Long taskId, boolean exportKey) {
        AssertUtil.isNotEmpty((String)StringUtil.trimToEmpty((CharSequence)ids), (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_PARAM.getMessage()));
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        AssertUtil.isNotNull((Object)securityUser, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_CURRENT_LOGIN_USER.getMessage()));
        Long[] struIds = (Long[])ConvertUtils.convert((String[])ids.split(","), Long.class);
        List<Long> struIdList = Arrays.asList(struIds);
        List struUserList = this.sysStruUserMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysStruUser::getStruId, struIdList));
        ArrayList userExcels = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)struUserList)) {
            List<Long> userIdList = struUserList.stream().map(SysStruUser::getUserId).distinct().collect(Collectors.toList());
            Map<Long, String> userOrganMap = this.getOrganInfos(userIdList);
            LambdaQueryWrapper multiQueryWrapper = (LambdaQueryWrapper)LambdaQueryUtil.getMultiQueryWrapper(SysUsers::getId, userIdList).orderByAsc(SysUsers::getUserOrder);
            List users = this.sysUsersMapper.selectList((Wrapper)multiQueryWrapper);
            List staffIds = users.stream().map(SysUsers::getEmployeeId).collect(Collectors.toList());
            LambdaQueryWrapper multiStaffQueryWrapper = LambdaQueryUtil.getMultiQueryWrapper(SysStaff::getId, staffIds);
            List staffs = this.sysStaffService.list((Wrapper)multiStaffQueryWrapper);
            Map<Long, SysStaff> staffMap = staffs.stream().collect(Collectors.toMap(SysStaff::getId, s -> s));
            List dicVos = this.sysDicRefService.getDicListByType("staff_position");
            Map<String, String> dicMap = dicVos.stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel));
            List keyList = HussarCacheUtil.getKeysLike((String)"Login_Lock", (String)"?");
            users.forEach(u -> {
                SysStaff staff;
                UserExcel userExcel = new UserExcel();
                userExcel.setDepartment((String)userOrganMap.get(u.getId()));
                BeanUtil.copyProperties((Object)u, (Object)userExcel);
                userExcel.setMail(u.geteMail());
                userExcel.setUserOrder(String.valueOf(u.getUserOrder()));
                userExcel.setMaxSessions(String.valueOf(u.getMaxSessions()));
                if (exportKey) {
                    userExcel.setUserId(String.valueOf(u.getId()));
                }
                if (HussarUtils.equals((Object)"0", (Object)u.getTypeProperty())) {
                    userExcel.setStartTime(Java8DateUtils.convertLocalDateTimeToString((LocalDateTime)u.getStartTime()));
                    userExcel.setExpiredTime(Java8DateUtils.convertLocalDateTimeToString((LocalDateTime)u.getExpiredTime()));
                }
                if (HussarUtils.isNotEmpty((Object)keyList) && keyList.contains(String.valueOf(u.getId()))) {
                    userExcel.setAccountStatus(UserStatus.LOCKED.getCode());
                }
                if (HussarUtils.isNotEmpty((Object)(staff = (SysStaff)staffMap.get(u.getEmployeeId())).getStaffPosition())) {
                    staff.setStaffPosition((String)dicMap.get(staff.getStaffPosition()));
                }
                BeanUtil.copyProperties((Object)staff, (Object)userExcel);
                userExcels.add(userExcel);
            });
        }
        Executor hussarBaseExcelExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        hussarBaseExcelExecutor.execute(() -> {
            ClassSheetMsg classSheetMsg = new ClassSheetMsg(UserExcel.class, userExcels, "\u7528\u6237\u4eba\u5458\u5bfc\u51fa\u4fe1\u606f", 0);
            if (!exportKey) {
                classSheetMsg.setExcludeColumnIndexes(Collections.singletonList(24));
            }
            classSheetMsg.addHandler((WriteHandler)new DataValidationSheetWriteHandler(this.getUserExcelOptions()));
            classSheetMsg.addHandler((WriteHandler)new CustomSheetWriteHandler(this.getUserExcelStyle()));
            ExcelExportDesc exportDesc = new ExcelExportDesc();
            exportDesc.setExportOperator(securityUser.getUserName());
            String exportTime = Java8DateUtils.getCurrentDateTimeStr();
            exportDesc.setExportTime(exportTime);
            ArrayList<ExcelExportDesc> exportDescs = new ArrayList<ExcelExportDesc>();
            exportDescs.add(exportDesc);
            ClassSheetMsg classSheetDescMsg = new ClassSheetMsg(ExcelExportDesc.class, exportDescs, "\u5bfc\u51fa\u63cf\u8ff0", 1);
            try {
                ExcelProduct excelProduct = new ConcreteExcelBuilder("\u7528\u6237\u4eba\u5458\u5bfc\u51fa\u4fe1\u606f" + Java8DateUtils.getCurrentDateDTimeStr() + ".xlsx", taskId, this.hussarBaseExcelServiceImpl).makeClassSheet(classSheetMsg).makeClassSheet(classSheetDescMsg).buildExcelProduct();
                this.sysExcelTaskServiceImpl.updateById((Object)excelProduct.getTask());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    private Map<Integer, Short> getUserExcelStyle() {
        HashMap<Integer, Short> styleMap = new HashMap<Integer, Short>();
        styleMap.put(UserExcelEnum.USER_ACCOUNT.getIndex(), (short)49);
        styleMap.put(UserExcelEnum.USER_NAME.getIndex(), (short)49);
        styleMap.put(UserExcelEnum.WORK_ID.getIndex(), (short)49);
        styleMap.put(UserExcelEnum.WECHAT.getIndex(), (short)49);
        styleMap.put(UserExcelEnum.START_TIME.getIndex(), (short)49);
        styleMap.put(UserExcelEnum.EXPIRED_TIME.getIndex(), (short)49);
        styleMap.put(UserExcelEnum.STAFF_CODE.getIndex(), (short)49);
        styleMap.put(UserExcelEnum.ID_CARD.getIndex(), (short)49);
        styleMap.put(UserExcelEnum.BIRTHDAY.getIndex(), (short)49);
        styleMap.put(UserExcelEnum.ADDRESS.getIndex(), (short)49);
        styleMap.put(UserExcelEnum.WORK_DATE.getIndex(), (short)49);
        styleMap.put(UserExcelEnum.GRADUATE_DATE.getIndex(), (short)49);
        styleMap.put(UserExcelEnum.GRADUATE_SCHOOL.getIndex(), (short)49);
        styleMap.put(UserExcelEnum.REMARK.getIndex(), (short)49);
        styleMap.put(UserExcelEnum.USER_ID.getIndex(), (short)49);
        return styleMap;
    }

    private Map<Long, String> getOrganInfos(List<Long> userIdList) {
        if (HussarUtils.isEmpty(userIdList)) {
            return new HashMap<Long, String>();
        }
        List<UserOrganPostVo> organByUserIds = this.sysStruUserMapper.getOrganByUserIds(LambdaQueryUtil.getSplitList(userIdList), null);
        return organByUserIds.stream().collect(Collectors.groupingBy(UserOrganPostVo::getUserId, Collectors.mapping(UserOrganPostVo::getOrganFname, Collectors.joining(","))));
    }

    @Override
    public Map<Integer, List<String>> getUserExcelOptions() {
        HashMap<Integer, List<String>> selectParamMap = new HashMap<Integer, List<String>>();
        List dicVos = this.sysDicRefService.getDicListByType("staff_position");
        selectParamMap.put(UserExcelEnum.STAFF_POSITION.getIndex(), dicVos.stream().map(DicVo::getLabel).collect(Collectors.toList()));
        selectParamMap.put(UserExcelEnum.SEX.getIndex(), Arrays.stream(GenderEnum.values()).map(GenderEnum::getDescription).collect(Collectors.toList()));
        List<String> status = Arrays.asList(UserStatus.OK.getMessage(), UserStatus.DORMANCY.getMessage());
        selectParamMap.put(UserExcelEnum.ACCOUNT_STATUS.getIndex(), status);
        selectParamMap.put(UserExcelEnum.TYPE_PROPERTY.getIndex(), Arrays.stream(AccountTypeEnum.values()).map(AccountTypeEnum::getDescription).collect(Collectors.toList()));
        return selectParamMap;
    }
}

