/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.permit.dto.FuncDumpDto;
import com.jxdinfo.hussar.authorization.permit.dto.QueryGradeAdminRoleDto;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleGroup;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruRoleService;
import com.jxdinfo.hussar.authorization.permit.vo.FuncDataRightTreeVo;
import com.jxdinfo.hussar.authorization.permit.vo.GradeRoleListVo;
import com.jxdinfo.hussar.authorization.permit.vo.LoadRelatedRoleVo;
import com.jxdinfo.hussar.authorization.permit.vo.ReadOnlyRoleTreeVo;
import com.jxdinfo.hussar.authorization.relational.dto.RoleOrganRelationDto;
import com.jxdinfo.hussar.authorization.relational.dto.RolePostRelationDto;
import com.jxdinfo.hussar.authorization.relational.service.ISysPostRoleService;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u65b0\u7248\u89d2\u8272\u7ef4\u62a4"})
@RestController(value="com.jxdinfo.hussar.authorization.permit.controller.hussarBaseRoleController")
@RequestMapping(value={"/hussarBase/authorization/permit/role"})
public class HussarBaseRoleController {
    @Autowired
    IHussarBaseRoleService baseRoleService;
    @Resource
    private ISysRolesService sysRolesService;
    @Resource
    private ISysPostRoleService sysPostRoleService;
    @Resource
    private ISysStruRoleService sysStruRoleService;

    @ApiOperation(value="\u89d2\u8272\u6811\u5168\u52a0\u8f7d", notes="\u89d2\u8272\u6811\u5168\u52a0\u8f7d")
    @GetMapping(value={"/roleTree"})
    @CheckPermission(value={"hussarBase:authorization:permit:role:roleTree"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u89d2\u8272\u6811\u5168\u52a0\u8f7d", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> allRoleTree(@RequestParam(required=false) Long appId) {
        return this.baseRoleService.allRoleTree(appId);
    }

    @ApiOperation(value="\u52a0\u8f7d\u89d2\u8272\u6811", notes="\u52a0\u8f7d\u89d2\u8272\u6811")
    @GetMapping(value={"/getRoleTree"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u52a0\u8f7d\u89d2\u8272\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<ReadOnlyRoleTreeVo>> getRoleTree() {
        return this.baseRoleService.getRoleTree();
    }

    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u6743\u9650\u6811\u8be6\u60c5", notes="\u83b7\u53d6\u6570\u636e\u6743\u9650\u6811\u8be6\u60c5")
    @GetMapping(value={"/getFuncDataRightDetail"})
    @AuditLog(moduleName="\u65b0\u7248\u89d2\u8272\u7ef4\u62a4", eventDesc="\u83b7\u53d6\u6570\u636e\u6743\u9650\u6811\u8be6\u60c5", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<FuncDataRightTreeVo>> getFuncDataRightDetail(@ApiParam(value="\u89d2\u8272id") @RequestParam Long roleId) {
        return this.baseRoleService.getFuncDataRightDetail(roleId);
    }

    @ApiOperation(value="\u67e5\u8be2\u5206\u7ea7\u7ba1\u7406\u5458\u7684\u89d2\u8272\u5217\u8868", notes="\u67e5\u8be2\u5206\u7ea7\u7ba1\u7406\u5458\u7684\u89d2\u8272\u5217\u8868")
    @GetMapping(value={"/getGradeAdminRoleTree"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u67e5\u8be2\u5206\u7ea7\u7ba1\u7406\u5458\u7684\u89d2\u8272\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<GradeRoleListVo>> getGradeAdminRoleTree(@ApiParam(value="\u5206\u9875\u4fe1\u606f") PageInfo pageInfo, @ApiParam(value="\u6839\u57fa\u7ba1\u7406\u89d2\u8272\u67e5\u8be2DTO") QueryGradeAdminRoleDto queryGradeAdminRoleDto) {
        return this.baseRoleService.getGradeAdminRoleTree(pageInfo, queryGradeAdminRoleDto);
    }

    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u6743\u9650\u6811", notes="\u83b7\u53d6\u6570\u636e\u6743\u9650\u6811")
    @GetMapping(value={"/getFuncDataRightByRoleId"})
    @AuditLog(moduleName="\u65b0\u7248\u89d2\u8272\u7ef4\u62a4", eventDesc="\u83b7\u53d6\u6570\u636e\u6743\u9650\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<FuncDataRightTreeVo>> getFuncDataRightByRoleId(@ApiParam(value="\u89d2\u8272id") @RequestParam Long roleId) {
        return this.baseRoleService.getFuncDataRightByRoleId(roleId);
    }

    @ApiOperation(value="\u8f7d\u5165\u5173\u8054\u89d2\u8272", notes="\u8f7d\u5165\u5173\u8054\u89d2\u8272")
    @PostMapping(value={"/loadRelatedRole"})
    @CheckPermission(value={"hussarBase:authorization:permit:role:loadRelatedRole"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u8f7d\u5165\u5173\u8054\u89d2\u8272", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<LoadRelatedRoleVo>> loadRelatedRole(@ApiParam(value="\u8f7d\u5165\u5173\u8054\u89d2\u8272Dto") @RequestBody List<FuncDumpDto> funcDumpDtoList) {
        return this.baseRoleService.loadRelatedRole(funcDumpDtoList);
    }

    @ApiOperation(value="\u67e5\u8be2\u89d2\u8272\u5206\u7ec4\u4e0b\u7684\u89d2\u8272", notes="\u67e5\u8be2\u89d2\u8272\u5206\u7ec4\u4e0b\u7684\u89d2\u8272")
    @GetMapping(value={"/searchRoleToGroupWithRoleName"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u6839\u636e\u5206\u7ec4ID\u67e5\u8be2\u89d2\u8272", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysRoles>> searchRoleToGroup(@ApiParam(value="\u89d2\u8272\u5206\u7ec4id") @RequestParam Long id, @ApiParam(value="\u89d2\u8272\u540d\u79f0") @RequestParam String roleName) {
        return ApiResponse.success((Object)this.sysRolesService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRoles::getGroupId, (Object)id)).like(SysRoles::getRoleName, (Object)roleName)).orderByAsc(SysRoles::getRoleOrder)));
    }

    @ApiOperation(value="\u4fdd\u5b58\u89d2\u8272\u5c97\u4f4d", notes="\u4fdd\u5b58\u89d2\u8272\u5c97\u4f4d")
    @PostMapping(value={"/savePost"})
    @CacheEvict(value={"authorization_info", "menu_info", "resource_info"}, allEntries=true)
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u65b0\u589e\u89d2\u8272\u5c97\u4f4d\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    @CheckPermission(value={"hussarBase:authorization:permit:role:savePost"})
    public ApiResponse<String> savePost(@ApiParam(value="\u89d2\u8272\u5c97\u4f4ddto") @RequestBody RolePostRelationDto rolePostRelationDto) {
        return ApiResponse.success((String)this.sysPostRoleService.saveRolePost(rolePostRelationDto));
    }

    @ApiOperation(value="\u4fdd\u5b58\u89d2\u8272\u7ec4\u7ec7", notes="\u4fdd\u5b58\u89d2\u8272\u7ec4\u7ec7")
    @PostMapping(value={"/saveOrgan"})
    @CacheEvict(value={"authorization_info", "menu_info", "resource_info"}, allEntries=true)
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u65b0\u589e\u89d2\u8272\u7ec4\u7ec7\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    @CheckPermission(value={"hussarBase:authorization:permit:role:saveOrgan"})
    public ApiResponse<String> saveOrgan(@ApiParam(value="\u89d2\u8272\u7ec4\u7ec7dto") @RequestBody RoleOrganRelationDto roleOrganRelationDto) {
        return ApiResponse.success((String)this.sysStruRoleService.saveRoleOrgan(roleOrganRelationDto));
    }

    @ApiOperation(value="\u67e5\u8be2\u7ec4\u7ec7\u5173\u8054\u7684\u89d2\u8272\u4fe1\u606f", notes="\u67e5\u8be2\u7ec4\u7ec7\u5173\u8054\u7684\u89d2\u8272\u4fe1\u606f")
    @GetMapping(value={"/organRoleList"})
    @AuditLog(moduleName="\u89d2\u8272\u9009\u62e9\u7ec4\u4ef6", eventDesc="\u67e5\u8be2\u7ec4\u7ec7\u5173\u8054\u7684\u89d2\u8272\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysRoles>> getOrganRoleList(@ApiParam(value="\u7ec4\u7ec7id\u96c6\u5408") @RequestParam List<Long> organIds) {
        return this.baseRoleService.getOrganRoleList(organIds);
    }

    @ApiOperation(value="\u6839\u636e\u5e94\u7528id\u67e5\u8be2\u89d2\u8272\u5206\u7ec4", notes="\u6839\u636e\u5e94\u7528id\u67e5\u8be2\u89d2\u8272\u5206\u7ec4")
    @GetMapping(value={"/getRoleGroupByAppId"})
    @AuditLog(moduleName="\u89d2\u8272\u9009\u62e9\u7ec4\u4ef6", eventDesc="\u6839\u636e\u5e94\u7528id\u67e5\u8be2\u89d2\u8272\u5206\u7ec4", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysRoleGroup>> getRoleGroupByAppId(@ApiParam(value="\u5e94\u7528id") @RequestParam Long appId) {
        return this.baseRoleService.getRoleGroupByAppId(appId);
    }
}

