/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.dto.EditOutsideOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.manager.EditOutsideOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonOutsideOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.model.SysOffice;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.model.SysStruRule;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.ConditionUtils;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.organ.manager.impl.editOutsideOrganizationManagerImpl")
public class EditOutsideOrganizationManagerImpl
extends CommonOutsideOrganizationManager
implements EditOutsideOrganizationManager {
    @Override
    public R<EditOutsideOrganizationDto> editOrganization(EditOutsideOrganizationDto editOrganizationDto) {
        long count;
        R result = new R();
        List errors = OrganUtil.validateOne((Object)editOrganizationDto);
        String organCode = StringUtils.trimToEmpty((String)editOrganizationDto.getOrganCode());
        String newOrganCode = StringUtils.trimToEmpty((String)editOrganizationDto.getNewOrganCode());
        SysOrgan sysOrganTemp = (SysOrgan)this.organService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysOrgan::getOrganCode, (Object)organCode));
        if (sysOrganTemp == null) {
            OrganUtil.addErrorMsg((List)errors, (Object)editOrganizationDto, (String)"organCode", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_ORG_CODE_FOUND.getMessage())});
        }
        if (HussarUtils.isNotBlank((CharSequence)newOrganCode) && !organCode.equals(newOrganCode) && (count = this.organService.count((Wrapper)new LambdaQueryWrapper().eq(SysOrgan::getOrganCode, (Object)newOrganCode))) > 0L) {
            OrganUtil.addErrorMsg((List)errors, (Object)editOrganizationDto, (String)"newOrganCode", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGANIZATION_CODE_DUPLICATION.getMessage())});
        }
        if (HussarUtils.isEmpty((Object)errors)) {
            SysOffice sysOffice = new SysOffice();
            SysOrgan sysOrgan = new SysOrgan();
            BeanUtils.copyProperties((Object)sysOrganTemp, (Object)sysOrgan);
            SysStru sysStru = new SysStru();
            this.initializationEdit(editOrganizationDto, sysStru, sysOrgan, sysOffice);
            this.sysStruMapper.updateById(sysStru);
            this.organService.updateById((Object)sysOrgan);
            if (HussarUtils.isNotEmpty((Object)sysOffice)) {
                this.sysOfficeService.updateById((Object)sysOffice);
            }
            this.refreshStruSeq();
            result.setSuccess(true);
            result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysStru.getId(), sysOrgan.getOrganCode())}));
        } else {
            result.setSuccess(false);
            result.setErrorList(errors);
        }
        return result;
    }

    private void initializationEdit(EditOutsideOrganizationDto editOrganizationDto, SysStru sysStru, SysOrgan sysOrgan, SysOffice sysOffice) {
        String organName = StringUtils.trimToEmpty((String)editOrganizationDto.getOrganName());
        String organAlias = StringUtils.trimToEmpty((String)editOrganizationDto.getOrganAlias());
        String userAccount = StringUtils.trimToEmpty((String)editOrganizationDto.getUserAccount());
        String organShortName = StringUtils.trimToEmpty((String)editOrganizationDto.getOrganShortName());
        String organDescription = StringUtils.trimToEmpty((String)editOrganizationDto.getOrganDescription());
        String organAddress = StringUtils.trimToEmpty((String)editOrganizationDto.getOrganAddress());
        String parentOrganCode = editOrganizationDto.getParentOrganCode();
        String newOrganCode = StringUtils.trimToEmpty((String)editOrganizationDto.getNewOrganCode());
        Integer struOrder = editOrganizationDto.getStruOrder();
        Long parentId = this.getOrganId(parentOrganCode);
        SysStru sysStruT = (SysStru)this.sysStruMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getOrganId, (Object)sysOrgan.getId()));
        Long struId = sysStruT.getId();
        SysOffice sysOfficeT = (SysOffice)this.sysOfficeService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysOffice::getStruId, (Object)struId));
        BeanUtils.copyProperties((Object)sysStruT, (Object)sysStru);
        BeanUtils.copyProperties((Object)sysOfficeT, (Object)sysOffice);
        if (HussarUtils.isNotEmpty((Object)struOrder)) {
            sysStru.setStruOrder(struOrder);
        }
        if (HussarUtils.equals((Object)parentId, (Object)sysStru.getParentId()) || HussarUtils.isBlank((CharSequence)parentOrganCode)) {
            String currentFname = sysOrgan.getOrganFname();
            String currentFCode = sysOrgan.getOrganFcode();
            String newFname = currentFname.substring(0, currentFname.lastIndexOf("/")) + "/" + editOrganizationDto.getOrganName().trim();
            String newFCode = currentFCode;
            if (HussarUtils.isNotBlank((CharSequence)newOrganCode) && !sysOrgan.getOrganCode().equals(newOrganCode)) {
                SysOrgan parentOrg = this.sysStruMapper.getOrganInfoByDeparmentId(sysStru.getParentId());
                newFCode = parentOrg.getOrganFcode() + newOrganCode + "/";
                sysOrgan.setOrganCode(newOrganCode);
            }
            if (!Objects.equals(editOrganizationDto.getOrganName().trim(), sysOrgan.getOrganName()) || HussarUtils.isNotBlank((CharSequence)newOrganCode) && !currentFCode.equals(newOrganCode)) {
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                wrapper.likeRight(SysOrgan::getOrganFcode, (Object)sysOrgan.getOrganFcode());
                wrapper.ne(SysOrgan::getId, (Object)sysOrgan.getId());
                List sysOrgans = this.organService.list((Wrapper)wrapper);
                for (SysOrgan temp : sysOrgans) {
                    temp.setOrganFname(temp.getOrganFname().replaceFirst(currentFname, newFname));
                    temp.setOrganFcode(temp.getOrganFcode().replace(currentFCode, newFCode));
                }
                this.organService.updateBatchById((Collection)sysOrgans);
            }
            sysOrgan.setOrganFname(currentFname.replaceFirst(currentFname, newFname));
            sysOrgan.setOrganFcode(newFCode);
        } else if (!parentId.equals(Constants.ROOT_NODE_ID) && !parentId.equals(Constants.OUT_STRU_NODE_ID)) {
            SysStru newSysStru = (SysStru)this.sysStruMapper.selectById(parentId);
            SysOrgan sysOrganTemp = (SysOrgan)this.organService.getById((Serializable)newSysStru.getOrganId());
            if (!sysOrganTemp.getOrganProperty().equals(sysOrgan.getOrganProperty())) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_FAIL_THIS_ORGANIZATION_NOT_ALLOW.getMessage()));
            }
            this.validateTransferOrganization(sysStruT, newSysStru);
            if (HussarUtils.isEmpty((Object)struOrder)) {
                sysStru.setStruOrder(null);
            }
            this.doTransfer(sysOrgan, sysStru, newSysStru, newOrganCode);
        } else {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_FAIL_THIS_ORGANIZATION_NOT_ALLOW.getMessage()));
        }
        sysStru.setOrganAlias(organAlias);
        sysOrgan.setShortName(organShortName);
        sysOffice.setOfficeAddress(organAddress);
        sysOffice.setOfficeAlias(organDescription);
        if (StringUtils.isNotBlank((CharSequence)userAccount)) {
            Long userId = this.getUserId(userAccount);
            sysStru.setPrincipalId(userId);
        } else {
            sysStru.setPrincipalId(null);
        }
        if (StringUtils.isNotBlank((CharSequence)organName)) {
            sysOrgan.setOrganName(organName);
        }
    }

    private void validateTransferOrganization(SysStru oldSysStru, SysStru newSysStru) {
        if (newSysStru.getStruFid().contains(oldSysStru.getStruFid())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_FAIL_THIS_ORGANIZATION_NOT_ALLOW.getMessage()));
        }
        this.whetherComplianceWithOrganizationRule(oldSysStru, newSysStru);
    }

    private void whetherComplianceWithOrganizationRule(SysStru oldSysStru, SysStru newSysStru) {
        String oldOrganType = oldSysStru.getStruType();
        String newOrganType = newSysStru.getStruType();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysStruRule::getSysOrganType, (Object)newOrganType);
        wrapper.eq(SysStruRule::getOrganType, (Object)oldOrganType);
        long count = this.sysStruRuleMapper.selectCount((Wrapper)wrapper);
        if (count == 0L) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ORGAN_MOVE_FAIL_THIS_ORGANIZATION_NOT_ALLOW.getMessage()));
        }
    }

    private void doTransfer(SysOrgan sysOrgan, SysStru sysStru, SysStru newSysStru, String newOrganCode) {
        Long targetStruId = newSysStru.getId();
        AtomicReference<Integer> orderTree = new AtomicReference<Integer>(1);
        Integer struOrder = sysStru.getStruOrder();
        if (HussarUtils.isEmpty((Object)struOrder)) {
            Integer maxOrder = this.sysStruMapper.getMaxOrderById(targetStruId);
            ConditionUtils.isTrue((boolean)HussarUtils.isNotEmpty((Object)maxOrder)).handle(() -> orderTree.set(maxOrder + 1));
            struOrder = orderTree.get();
        }
        this.organizationChange(sysOrgan, sysStru, newSysStru, struOrder, newOrganCode);
    }

    private void organizationChange(SysOrgan sysOrgan, SysStru sysStru, SysStru newSysStru, Integer order, String newOrganCode) {
        String struSeq;
        Long sourceStruId = sysStru.getId();
        Long targetStruId = newSysStru.getId();
        SysStru oldSysStru = (SysStru)this.sysStruMapper.selectById(sourceStruId);
        SysOrgan parentOrg = this.sysStruMapper.getOrganInfoByDeparmentId(targetStruId);
        LambdaQueryWrapper wrapper2 = (LambdaQueryWrapper)new LambdaQueryWrapper().likeRight(SysStru::getStruFid, (Object)oldSysStru.getStruFid());
        wrapper2.orderByAsc(SysStru::getStruSeq);
        List strus = this.sysStruMapper.selectList((Wrapper)wrapper2);
        List organs = this.organService.list((Wrapper)new LambdaQueryWrapper().likeRight(SysOrgan::getOrganFcode, (Object)sysOrgan.getOrganFcode()));
        Map organsMap = organs.stream().collect(Collectors.toMap(SysOrgan::getId, Function.identity()));
        if (HussarUtils.isNotBlank((CharSequence)newOrganCode) && !sysOrgan.getOrganCode().equals(newOrganCode)) {
            ((SysOrgan)organsMap.get(sysOrgan.getId())).setOrganCode(newOrganCode);
            ((SysOrgan)organsMap.get(sysOrgan.getId())).setOrganFcode(parentOrg.getOrganFcode() + newOrganCode + "/");
        } else {
            ((SysOrgan)organsMap.get(sysOrgan.getId())).setOrganFcode(parentOrg.getOrganFcode() + sysOrgan.getOrganCode() + "/");
        }
        ((SysOrgan)organsMap.get(sysOrgan.getId())).setOrganFname(parentOrg.getOrganFname() + "/" + sysOrgan.getOrganName());
        String struFid = newSysStru.getStruFid() + oldSysStru.getId() + "/";
        String struSeqT = struSeq = this.getStruSeq(newSysStru.getStruFid(), newSysStru.getStruSeq(), OrganUtil.getLevel((SysStru)newSysStru) + 1);
        strus.stream().filter(organsEntity -> organsEntity.getParentId().equals(sourceStruId)).sorted(Comparator.comparing(SysStru::getStruSeq)).map(stru -> {
            SysOrgan sysOrganT = (SysOrgan)organsMap.get(stru.getOrganId());
            sysOrganT.setOrganFname(((SysOrgan)organsMap.get(sysOrgan.getId())).getOrganFname() + "/" + sysOrganT.getOrganName());
            sysOrganT.setOrganFcode(OrganUtil.convert((String)(((SysOrgan)organsMap.get(sysOrgan.getId())).getOrganFcode() + sysOrganT.getOrganCode() + "/")));
            sysOrganT.setOrganProperty(parentOrg.getOrganProperty());
            stru.setStruFid(OrganUtil.convert((String)(struFid + stru.getId() + "/")));
            stru.setStruSeq(struSeqT + stru.getStruSeq().substring(stru.getStruSeq().lastIndexOf("/")));
            stru.setStruLevel(Integer.valueOf(stru.getStruFid().split("/").length - 1));
            this.changeInfo((SysStru)stru, strus, organsMap);
            return stru;
        }).collect(Collectors.toList());
        for (SysStru temp : strus) {
            if (!Objects.equals(temp.getId(), sourceStruId)) continue;
            temp.setStruFid(OrganUtil.convert((String)struFid));
            temp.setStruLevel(Integer.valueOf(temp.getStruFid().split("/").length - 1));
            temp.setStruSeq(struSeq);
            temp.setStruOrder(order);
            temp.setParentId(targetStruId);
        }
        SysOrgan organ = (SysOrgan)organsMap.get(sysOrgan.getId());
        SysStru stru2 = strus.stream().filter(item -> HussarUtils.equals((Object)item.getId(), (Object)oldSysStru.getId())).findFirst().get();
        BeanUtils.copyProperties((Object)organ, (Object)sysOrgan);
        BeanUtils.copyProperties((Object)stru2, (Object)sysStru);
        this.struService.updateBatchById((Collection)strus);
        this.organService.updateBatchById(organsMap.values());
        this.updateLeaf(oldSysStru, newSysStru);
    }

    private void changeInfo(SysStru root, List<SysStru> all, Map<Long, SysOrgan> organsMap) {
        SysOrgan rootOrgan = organsMap.get(root.getOrganId());
        all.stream().filter(stru -> stru.getParentId().equals(root.getId())).sorted(Comparator.comparing(SysStru::getStruSeq)).map(stru -> {
            SysOrgan sysOrganT = (SysOrgan)organsMap.get(stru.getOrganId());
            sysOrganT.setOrganFname(rootOrgan.getOrganFname() + "/" + sysOrganT.getOrganName());
            sysOrganT.setOrganFcode(OrganUtil.convert((String)(rootOrgan.getOrganFcode() + sysOrganT.getOrganCode() + "/")));
            stru.setStruFid(OrganUtil.convert((String)(root.getStruFid() + stru.getId() + "/")));
            stru.setStruSeq(root.getStruSeq() + stru.getStruSeq().substring(stru.getStruSeq().lastIndexOf("/")));
            stru.setStruLevel(Integer.valueOf(stru.getStruFid().split("/").length - 1));
            if (Objects.equals(stru.getStruType(), "9")) {
                stru.setStruSeq(OrganUtil.getStruFidByLevel((String)stru.getStruSeq(), (int)(stru.getStruLevel() - 1)));
            }
            this.changeInfo((SysStru)stru, all, organsMap);
            return stru;
        }).collect(Collectors.toList());
    }

    private void updateLeaf(SysStru oldSysStru, SysStru newSysStru) {
        newSysStru.setIsLeaf("N");
        this.sysStruMapper.updateById(newSysStru);
        Long sourceStruId = oldSysStru.getParentId();
        int struLevel = oldSysStru.getStruLevel();
        if (!oldSysStru.getStruType().equals("9") && struLevel > 1) {
            SysStru pSysStru = (SysStru)this.sysStruMapper.selectById(sourceStruId);
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(SysStru::getParentId, (Object)sourceStruId);
            wrapper.ne(SysStru::getId, (Object)oldSysStru.getId());
            wrapper.ne(SysStru::getStruType, (Object)"9");
            Long count = this.sysStruMapper.selectCount((Wrapper)wrapper);
            pSysStru.setIsLeaf(count > 0L ? "N" : "Y");
            this.sysStruMapper.updateById(pSysStru);
        }
    }
}

